/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.auth;

import de.alpharogroup.auth.api.Session;
import de.alpharogroup.auth.api.SessionContext;
import java.util.LinkedHashMap;
import java.util.Map;

public class UserSessionContext
implements SessionContext<String, String, String> {
    private static final SessionContext<String, String, String> instance = new UserSessionContext();
    private static final long serialVersionUID = -7176164226848814834L;
    private final Map<String, Session<String, String>> onlineSessions = new LinkedHashMap<String, Session<String, String>>();

    public static SessionContext<String, String, String> getInstance() {
        return instance;
    }

    private UserSessionContext() {
    }

    public synchronized void addSession(Session<String, String> session) {
        this.onlineSessions.put(session.getId(), session);
    }

    public synchronized Session<String, String> getSession(String id) {
        if (this.onlineSessions.containsKey(id)) {
            return this.onlineSessions.get(id);
        }
        return null;
    }

    public synchronized void removeSession(String id) {
        if (this.onlineSessions.containsKey(id)) {
            this.onlineSessions.remove(id);
        }
    }
}

