/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.auth;

import de.alpharogroup.auth.api.Permission;
import de.alpharogroup.auth.api.Role;
import de.alpharogroup.auth.api.Session;
import de.alpharogroup.auth.api.User;
import de.alpharogroup.collections.map.InsertionOrderMap;
import de.alpharogroup.random.object.RandomObjectsExtensions;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class UserSession
implements Session<String, String> {
    private static final long serialVersionUID = -5792522256514467537L;
    private Map<String, String> attributtes;
    private String id;
    private Date lastAccess;
    private Locale locale;
    private int maxInactiveTime;
    private Date startTime;
    private User<Permission, Role<Permission>> user;

    public UserSession(User<Permission, Role<Permission>> user) {
        if (null == user) {
            throw new IllegalArgumentException("User can't be null.");
        }
        this.user = user;
        this.initialize();
    }

    public String getAttributte(String key) {
        return this.attributtes.get(key);
    }

    private void initialize() {
        this.id = RandomObjectsExtensions.newRandomId();
        this.startTime = new Date(System.currentTimeMillis());
        this.lastAccess = (Date)this.startTime.clone();
        this.maxInactiveTime = 180000;
        this.attributtes = new InsertionOrderMap();
        this.locale = Locale.getDefault();
    }

    public String setAttribute(String key, String value) {
        return this.attributtes.put(key, value);
    }

    public static UserSessionBuilder builder() {
        return new UserSessionBuilder();
    }

    public UserSessionBuilder toBuilder() {
        return new UserSessionBuilder().attributtes(this.attributtes).id(this.id).lastAccess(this.lastAccess).locale(this.locale).maxInactiveTime(this.maxInactiveTime).startTime(this.startTime).user(this.user);
    }

    public Map<String, String> getAttributtes() {
        return this.attributtes;
    }

    public String getId() {
        return this.id;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public User<Permission, Role<Permission>> getUser() {
        return this.user;
    }

    public void setAttributtes(Map<String, String> attributtes) {
        this.attributtes = attributtes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMaxInactiveTime(int maxInactiveTime) {
        this.maxInactiveTime = maxInactiveTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setUser(User<Permission, Role<Permission>> user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserSession)) {
            return false;
        }
        UserSession other = (UserSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$attributtes = this.getAttributtes();
        Map<String, String> other$attributtes = other.getAttributtes();
        if (this$attributtes == null ? other$attributtes != null : !((Object)this$attributtes).equals(other$attributtes)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Date this$lastAccess = this.getLastAccess();
        Date other$lastAccess = other.getLastAccess();
        if (this$lastAccess == null ? other$lastAccess != null : !((Object)this$lastAccess).equals(other$lastAccess)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        if (this.getMaxInactiveTime() != other.getMaxInactiveTime()) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        User<Permission, Role<Permission>> this$user = this.getUser();
        User<Permission, Role<Permission>> other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserSession;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $attributtes = this.getAttributtes();
        result = result * 59 + ($attributtes == null ? 43 : ((Object)$attributtes).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Date $lastAccess = this.getLastAccess();
        result = result * 59 + ($lastAccess == null ? 43 : ((Object)$lastAccess).hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        result = result * 59 + this.getMaxInactiveTime();
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        User<Permission, Role<Permission>> $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "UserSession(attributtes=" + this.getAttributtes() + ", id=" + this.getId() + ", lastAccess=" + this.getLastAccess() + ", locale=" + this.getLocale() + ", maxInactiveTime=" + this.getMaxInactiveTime() + ", startTime=" + this.getStartTime() + ", user=" + this.getUser() + ")";
    }

    public UserSession() {
    }

    public UserSession(Map<String, String> attributtes, String id, Date lastAccess, Locale locale, int maxInactiveTime, Date startTime, User<Permission, Role<Permission>> user) {
        this.attributtes = attributtes;
        this.id = id;
        this.lastAccess = lastAccess;
        this.locale = locale;
        this.maxInactiveTime = maxInactiveTime;
        this.startTime = startTime;
        this.user = user;
    }

    public static class UserSessionBuilder {
        private Map<String, String> attributtes;
        private String id;
        private Date lastAccess;
        private Locale locale;
        private int maxInactiveTime;
        private Date startTime;
        private User<Permission, Role<Permission>> user;

        UserSessionBuilder() {
        }

        public UserSessionBuilder attributtes(Map<String, String> attributtes) {
            this.attributtes = attributtes;
            return this;
        }

        public UserSessionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public UserSessionBuilder lastAccess(Date lastAccess) {
            this.lastAccess = lastAccess;
            return this;
        }

        public UserSessionBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public UserSessionBuilder maxInactiveTime(int maxInactiveTime) {
            this.maxInactiveTime = maxInactiveTime;
            return this;
        }

        public UserSessionBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public UserSessionBuilder user(User<Permission, Role<Permission>> user) {
            this.user = user;
            return this;
        }

        public UserSession build() {
            return new UserSession(this.attributtes, this.id, this.lastAccess, this.locale, this.maxInactiveTime, this.startTime, this.user);
        }

        public String toString() {
            return "UserSession.UserSessionBuilder(attributtes=" + this.attributtes + ", id=" + this.id + ", lastAccess=" + this.lastAccess + ", locale=" + this.locale + ", maxInactiveTime=" + this.maxInactiveTime + ", startTime=" + this.startTime + ", user=" + this.user + ")";
        }
    }
}

