/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.auth;

import de.alpharogroup.auth.api.Permission;
import de.alpharogroup.auth.api.Role;
import de.alpharogroup.auth.api.User;
import de.alpharogroup.collections.set.SetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class SimpleUser
implements User<Permission, Role<Permission>> {
    private static final long serialVersionUID = -5529415990423317979L;
    private Boolean active;
    private String id;
    private Boolean locked;
    private String pw;
    private Set<Role<Permission>> roles;
    private String username;

    public void addRole(Role<Permission> role) {
        if (this.roles == null) {
            this.roles = SetFactory.newLinkedHashSet((Object[])new Role[0]);
        }
        this.roles.add(role);
    }

    public Boolean isActive() {
        return this.active;
    }

    public Boolean isLocked() {
        return this.locked;
    }

    public boolean removeRole(Role<Permission> role) {
        return this.roles.remove(role);
    }

    public static SimpleUserBuilder builder() {
        return new SimpleUserBuilder();
    }

    public SimpleUserBuilder toBuilder() {
        SimpleUserBuilder builder = new SimpleUserBuilder().active(this.active).id(this.id).locked(this.locked).pw(this.pw).username(this.username);
        if (this.roles != null) {
            builder.roles(this.roles);
        }
        return builder;
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public String getPw() {
        return this.pw;
    }

    public Set<Role<Permission>> getRoles() {
        return this.roles;
    }

    public String getUsername() {
        return this.username;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public void setRoles(Set<Role<Permission>> roles) {
        this.roles = roles;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleUser)) {
            return false;
        }
        SimpleUser other = (SimpleUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$locked = this.getLocked();
        Boolean other$locked = other.getLocked();
        if (this$locked == null ? other$locked != null : !((Object)this$locked).equals(other$locked)) {
            return false;
        }
        String this$pw = this.getPw();
        String other$pw = other.getPw();
        if (this$pw == null ? other$pw != null : !this$pw.equals(other$pw)) {
            return false;
        }
        Set<Role<Permission>> this$roles = this.getRoles();
        Set<Role<Permission>> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $locked = this.getLocked();
        result = result * 59 + ($locked == null ? 43 : ((Object)$locked).hashCode());
        String $pw = this.getPw();
        result = result * 59 + ($pw == null ? 43 : $pw.hashCode());
        Set<Role<Permission>> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleUser(active=" + this.getActive() + ", id=" + this.getId() + ", locked=" + this.getLocked() + ", pw=" + this.getPw() + ", roles=" + this.getRoles() + ", username=" + this.getUsername() + ")";
    }

    public SimpleUser() {
    }

    public SimpleUser(Boolean active, String id, Boolean locked, String pw, Set<Role<Permission>> roles, String username) {
        this.active = active;
        this.id = id;
        this.locked = locked;
        this.pw = pw;
        this.roles = roles;
        this.username = username;
    }

    public static class SimpleUserBuilder {
        private Boolean active;
        private String id;
        private Boolean locked;
        private String pw;
        private ArrayList<Role<Permission>> roles;
        private String username;

        SimpleUserBuilder() {
        }

        public SimpleUserBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public SimpleUserBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SimpleUserBuilder locked(Boolean locked) {
            this.locked = locked;
            return this;
        }

        public SimpleUserBuilder pw(String pw) {
            this.pw = pw;
            return this;
        }

        public SimpleUserBuilder role(Role<Permission> role) {
            if (this.roles == null) {
                this.roles = new ArrayList();
            }
            this.roles.add(role);
            return this;
        }

        public SimpleUserBuilder roles(Collection<? extends Role<Permission>> roles) {
            if (this.roles == null) {
                this.roles = new ArrayList();
            }
            this.roles.addAll(roles);
            return this;
        }

        public SimpleUserBuilder clearRoles() {
            if (this.roles != null) {
                this.roles.clear();
            }
            return this;
        }

        public SimpleUserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SimpleUser build() {
            Set<Object> roles;
            switch (this.roles == null ? 0 : this.roles.size()) {
                case 0: {
                    roles = Collections.emptySet();
                    break;
                }
                case 1: {
                    roles = Collections.singleton(this.roles.get(0));
                    break;
                }
                default: {
                    roles = new LinkedHashSet(this.roles.size() < 0x40000000 ? 1 + this.roles.size() + (this.roles.size() - 3) / 3 : Integer.MAX_VALUE);
                    roles.addAll(this.roles);
                    roles = Collections.unmodifiableSet(roles);
                }
            }
            return new SimpleUser(this.active, this.id, this.locked, this.pw, roles, this.username);
        }

        public String toString() {
            return "SimpleUser.SimpleUserBuilder(active=" + this.active + ", id=" + this.id + ", locked=" + this.locked + ", pw=" + this.pw + ", roles=" + this.roles + ", username=" + this.username + ")";
        }
    }
}

