/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.auth.jpa.entities;

import de.alpharogroup.db.entity.uniqueable.UUIDEntity;
import de.alpharogroup.user.auth.jpa.entities.Applications;
import de.alpharogroup.user.auth.jpa.entities.Roles;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Email;

@Entity
@Table(name="users", indexes={@Index(name="idx_users_application_application", columnList="application,username", unique=true)}, uniqueConstraints={@UniqueConstraint(name="uk_users_application_username", columnNames={"application", "username"}), @UniqueConstraint(name="uk_users_username", columnNames={"username"}), @UniqueConstraint(name="uk_users_email", columnNames={"email"}), @UniqueConstraint(name="uk_users_application_email", columnNames={"application", "email"})})
public class Users
extends UUIDEntity {
    static final String SINGULAR_ENTITY_NAME = "user";
    static final String TABLE_NAME = "users";
    static final String COLUMN_NAME_USERNAME = "username";
    static final String COLUMN_NAME_EMAIL = "email";
    static final String JOIN_COLUMN_NAME_APPLICATION = "application";
    static final String JOIN_TABLE_NAME_USER_ROLES = "user_roles";
    static final String JOIN_TABLE_USER_ROLES_COLUMN_NAME_USER_ID = "user_id";
    static final String JOIN_TABLE_USER_ROLES_COLUMN_NAME_ROLE_ID = "role_id";
    static final String JOIN_TABLE_FOREIGN_KEY_USER_ROLES_USER_ID = "fk_user_roles_user_id";
    static final String JOIN_TABLE_FOREIGN_KEY_USER_ROLES_ROLE_ID = "fk_user_roles_role_id";
    static final String JOIN_COLUMN_FOREIGN_KEY_USERS_APPLICATION_ID = "fk_users_application_id";
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="application", nullable=false, referencedColumnName="id", foreignKey=@ForeignKey(name="fk_users_application_id"))
    private Applications applications;
    @Column
    private boolean active;
    @Column
    private boolean locked;
    @Column(length=1024)
    private String password;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="user_roles", joinColumns={@JoinColumn(name="user_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_user_roles_user_id"))}, inverseJoinColumns={@JoinColumn(name="role_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_user_roles_role_id"))})
    private Set<Roles> roles;
    @Column(length=8)
    private String salt;
    @Column(name="username", length=256)
    private String username;
    @Column(name="email", length=512)
    @Email
    private String email;

    public boolean addRole(Roles role) {
        return this.roles.add(role);
    }

    public boolean removeRole(Roles role) {
        return this.roles.remove((Object)role);
    }

    private static Set<Roles> $default$roles() {
        return new HashSet<Roles>();
    }

    protected Users(UsersBuilder<?, ?> b) {
        super(b);
        this.applications = b.applications;
        this.active = b.active;
        this.locked = b.locked;
        this.password = b.password;
        this.roles = b.roles$set ? b.roles$value : Users.$default$roles();
        this.salt = b.salt;
        this.username = b.username;
        this.email = b.email;
    }

    public static UsersBuilder<?, ?> builder() {
        return new UsersBuilderImpl();
    }

    public Applications getApplications() {
        return this.applications;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<Roles> getRoles() {
        return this.roles;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setApplications(Applications applications) {
        this.applications = applications;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRoles(Set<Roles> roles) {
        this.roles = roles;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String toString() {
        return "Users(super=" + super.toString() + ", applications=" + this.getApplications() + ", active=" + this.isActive() + ", locked=" + this.isLocked() + ", password=" + this.getPassword() + ", roles=" + this.getRoles() + ", salt=" + this.getSalt() + ", username=" + this.getUsername() + ", email=" + this.getEmail() + ")";
    }

    public Users() {
        this.roles = Users.$default$roles();
    }

    public Users(Applications applications, boolean active, boolean locked, String password, Set<Roles> roles, String salt, String username, String email) {
        this.applications = applications;
        this.active = active;
        this.locked = locked;
        this.password = password;
        this.roles = roles;
        this.salt = salt;
        this.username = username;
        this.email = email;
    }

    private static final class UsersBuilderImpl
    extends UsersBuilder<Users, UsersBuilderImpl> {
        private UsersBuilderImpl() {
        }

        @Override
        protected UsersBuilderImpl self() {
            return this;
        }

        @Override
        public Users build() {
            return new Users(this);
        }
    }

    public static abstract class UsersBuilder<C extends Users, B extends UsersBuilder<C, B>>
    extends UUIDEntity.UUIDEntityBuilder<C, B> {
        private Applications applications;
        private boolean active;
        private boolean locked;
        private String password;
        private boolean roles$set;
        private Set<Roles> roles$value;
        private String salt;
        private String username;
        private String email;

        protected abstract B self();

        public abstract C build();

        public B applications(Applications applications) {
            this.applications = applications;
            return (B)this.self();
        }

        public B active(boolean active) {
            this.active = active;
            return (B)this.self();
        }

        public B locked(boolean locked) {
            this.locked = locked;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B roles(Set<Roles> roles) {
            this.roles$value = roles;
            this.roles$set = true;
            return (B)this.self();
        }

        public B salt(String salt) {
            this.salt = salt;
            return (B)this.self();
        }

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B email(String email) {
            this.email = email;
            return (B)this.self();
        }

        public String toString() {
            return "Users.UsersBuilder(super=" + super.toString() + ", applications=" + this.applications + ", active=" + this.active + ", locked=" + this.locked + ", password=" + this.password + ", roles$value=" + this.roles$value + ", salt=" + this.salt + ", username=" + this.username + ", email=" + this.email + ")";
        }
    }
}

