/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.auth.jpa.entities;

import de.alpharogroup.db.entity.uniqueable.UUIDEntity;
import de.alpharogroup.db.postgres.usertype.PGEnumUserType;
import de.alpharogroup.user.auth.enums.GenderType;
import de.alpharogroup.user.auth.jpa.entities.Contactmethods;
import de.alpharogroup.user.auth.jpa.entities.Users;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

@Entity
@Table(name="user_infos")
@TypeDefs(value={@TypeDef(name="genderConverter", typeClass=PGEnumUserType.class, parameters={@Parameter(name="enumClassName", value="de.alpharogroup.user.auth.enums.GenderType")})})
public class UserInfos
extends UUIDEntity {
    static final String SINGULAR_ENTITY_NAME = "user_info";
    static final String TABLE_NAME = "user_infos";
    static final String COLUMN_NAME_OWNER = "owner";
    static final String COLUMN_NAME_IP_ADDRESS = "ip_address";
    static final String COLUMN_NAME_STRIPE_CUSTOMER_ID = "stripe_customer_id";
    static final String CONVERTER_NAME_GENDER = "genderConverter";
    static final String JOIN_COLUMN_NAME_USER_INFOS_ID = "user_infos_id";
    static final String JOIN_COLUMN_NAME_CONTACTMETHODS_ID = "contactmethods_id";
    static final String JOIN_TABLE_NAME_USER_CONTACTMETHODS = "user_contactmethods";
    static final String JOIN_TABLE_FOREIGN_KEY_USER_INFOS_USER_INFOS_ID = "fk_user_infos_user_infos_id";
    static final String JOIN_TABLE_FOREIGN_KEY_USER_INFOS_CONTACTMETHODS_ID = "fk_user_infos_contactmethods_id";
    static final String JOIN_COLUMN_FOREIGN_KEY_USER_INFOS_USER_ID = "fk_user_infos_user_id";
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="owner", foreignKey=@ForeignKey(name="fk_user_infos_user_id"))
    private Users owner;
    @Column(length=64)
    private String birthname;
    @ManyToMany(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.DELETE})
    @JoinTable(name="user_contactmethods", joinColumns={@JoinColumn(name="user_infos_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_user_infos_user_infos_id"))}, inverseJoinColumns={@JoinColumn(name="contactmethods_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_user_infos_contactmethods_id"))})
    private Set<Contactmethods> contactmethods;
    private Date dateofbirth;
    @Column(length=64)
    private String firstname;
    @Enumerated(value=EnumType.STRING)
    @Column
    @Type(type="genderConverter")
    private GenderType gender;
    @Column(name="ip_address", length=16)
    private String ipAddress;
    @Column(length=64)
    private String lastname;
    @Column(length=12)
    private String locale;
    @Column(nullable=true)
    private Long credits;
    @Column(name="stripe_customer_id", length=64)
    private String stripeCustomerId;

    private static Set<Contactmethods> $default$contactmethods() {
        return new HashSet<Contactmethods>();
    }

    protected UserInfos(UserInfosBuilder<?, ?> b) {
        super(b);
        this.owner = b.owner;
        this.birthname = b.birthname;
        this.contactmethods = b.contactmethods$set ? b.contactmethods$value : UserInfos.$default$contactmethods();
        this.dateofbirth = b.dateofbirth;
        this.firstname = b.firstname;
        this.gender = b.gender;
        this.ipAddress = b.ipAddress;
        this.lastname = b.lastname;
        this.locale = b.locale;
        this.credits = b.credits;
        this.stripeCustomerId = b.stripeCustomerId;
    }

    public static UserInfosBuilder<?, ?> builder() {
        return new UserInfosBuilderImpl();
    }

    public Users getOwner() {
        return this.owner;
    }

    public String getBirthname() {
        return this.birthname;
    }

    public Set<Contactmethods> getContactmethods() {
        return this.contactmethods;
    }

    public Date getDateofbirth() {
        return this.dateofbirth;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public GenderType getGender() {
        return this.gender;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getLocale() {
        return this.locale;
    }

    public Long getCredits() {
        return this.credits;
    }

    public String getStripeCustomerId() {
        return this.stripeCustomerId;
    }

    public void setOwner(Users owner) {
        this.owner = owner;
    }

    public void setBirthname(String birthname) {
        this.birthname = birthname;
    }

    public void setContactmethods(Set<Contactmethods> contactmethods) {
        this.contactmethods = contactmethods;
    }

    public void setDateofbirth(Date dateofbirth) {
        this.dateofbirth = dateofbirth;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setGender(GenderType gender) {
        this.gender = gender;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public void setStripeCustomerId(String stripeCustomerId) {
        this.stripeCustomerId = stripeCustomerId;
    }

    public String toString() {
        return "UserInfos(super=" + super.toString() + ", owner=" + this.getOwner() + ", birthname=" + this.getBirthname() + ", contactmethods=" + this.getContactmethods() + ", dateofbirth=" + this.getDateofbirth() + ", firstname=" + this.getFirstname() + ", gender=" + this.getGender() + ", ipAddress=" + this.getIpAddress() + ", lastname=" + this.getLastname() + ", locale=" + this.getLocale() + ", credits=" + this.getCredits() + ", stripeCustomerId=" + this.getStripeCustomerId() + ")";
    }

    public UserInfos() {
        this.contactmethods = UserInfos.$default$contactmethods();
    }

    public UserInfos(Users owner, String birthname, Set<Contactmethods> contactmethods, Date dateofbirth, String firstname, GenderType gender, String ipAddress, String lastname, String locale, Long credits, String stripeCustomerId) {
        this.owner = owner;
        this.birthname = birthname;
        this.contactmethods = contactmethods;
        this.dateofbirth = dateofbirth;
        this.firstname = firstname;
        this.gender = gender;
        this.ipAddress = ipAddress;
        this.lastname = lastname;
        this.locale = locale;
        this.credits = credits;
        this.stripeCustomerId = stripeCustomerId;
    }

    private static final class UserInfosBuilderImpl
    extends UserInfosBuilder<UserInfos, UserInfosBuilderImpl> {
        private UserInfosBuilderImpl() {
        }

        @Override
        protected UserInfosBuilderImpl self() {
            return this;
        }

        @Override
        public UserInfos build() {
            return new UserInfos(this);
        }
    }

    public static abstract class UserInfosBuilder<C extends UserInfos, B extends UserInfosBuilder<C, B>>
    extends UUIDEntity.UUIDEntityBuilder<C, B> {
        private Users owner;
        private String birthname;
        private boolean contactmethods$set;
        private Set<Contactmethods> contactmethods$value;
        private Date dateofbirth;
        private String firstname;
        private GenderType gender;
        private String ipAddress;
        private String lastname;
        private String locale;
        private Long credits;
        private String stripeCustomerId;

        protected abstract B self();

        public abstract C build();

        public B owner(Users owner) {
            this.owner = owner;
            return (B)this.self();
        }

        public B birthname(String birthname) {
            this.birthname = birthname;
            return (B)this.self();
        }

        public B contactmethods(Set<Contactmethods> contactmethods) {
            this.contactmethods$value = contactmethods;
            this.contactmethods$set = true;
            return (B)this.self();
        }

        public B dateofbirth(Date dateofbirth) {
            this.dateofbirth = dateofbirth;
            return (B)this.self();
        }

        public B firstname(String firstname) {
            this.firstname = firstname;
            return (B)this.self();
        }

        public B gender(GenderType gender) {
            this.gender = gender;
            return (B)this.self();
        }

        public B ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return (B)this.self();
        }

        public B lastname(String lastname) {
            this.lastname = lastname;
            return (B)this.self();
        }

        public B locale(String locale) {
            this.locale = locale;
            return (B)this.self();
        }

        public B credits(Long credits) {
            this.credits = credits;
            return (B)this.self();
        }

        public B stripeCustomerId(String stripeCustomerId) {
            this.stripeCustomerId = stripeCustomerId;
            return (B)this.self();
        }

        public String toString() {
            return "UserInfos.UserInfosBuilder(super=" + super.toString() + ", owner=" + this.owner + ", birthname=" + this.birthname + ", contactmethods$value=" + this.contactmethods$value + ", dateofbirth=" + this.dateofbirth + ", firstname=" + this.firstname + ", gender=" + this.gender + ", ipAddress=" + this.ipAddress + ", lastname=" + this.lastname + ", locale=" + this.locale + ", credits=" + this.credits + ", stripeCustomerId=" + this.stripeCustomerId + ")";
        }
    }
}

