/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.auth.jpa.entities;

import de.alpharogroup.db.entity.uniqueable.UUIDEntity;
import de.alpharogroup.user.auth.jpa.entities.Permissions;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="roles", uniqueConstraints={@UniqueConstraint(name="uk_roles_name", columnNames={"name"})})
public class Roles
extends UUIDEntity {
    static final String SINGULAR_ENTITY_NAME = "role";
    static final String TABLE_NAME = "roles";
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_DESCRIPTION = "description";
    static final String JOIN_TABLE_NAME_ROLE_PERMISSIONS = "role_permissions";
    static final String JOIN_TABLE_ROLE_PERMISSIONS_COLUMN_NAME_ROLE_ID = "role_id";
    static final String JOIN_TABLE_ROLE_PERMISSIONS_COLUMN_NAME_PERMISSION_ID = "permission_id";
    static final String JOIN_TABLE_FOREIGN_KEY_ROLE_PERMISSIONS_ROLE_ID = "fk_role_permissions_role_id";
    static final String JOIN_TABLE_FOREIGN_KEY_ROLE_PERMISSIONS_PERMISSION_ID = "fk_role_permissions_permission_id";
    @Column(name="description", length=64)
    private String description;
    @Column(name="name", length=64)
    private String name;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="role_permissions", joinColumns={@JoinColumn(name="role_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_role_permissions_role_id"))}, inverseJoinColumns={@JoinColumn(name="permission_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_role_permissions_permission_id"))})
    private Set<Permissions> permissions;

    public boolean addPermission(Permissions permission) {
        return this.permissions.add(permission);
    }

    public boolean removePermission(Permissions permission) {
        return this.permissions.remove((Object)permission);
    }

    private static Set<Permissions> $default$permissions() {
        return new HashSet<Permissions>();
    }

    protected Roles(RolesBuilder<?, ?> b) {
        super(b);
        this.description = b.description;
        this.name = b.name;
        this.permissions = b.permissions$set ? b.permissions$value : Roles.$default$permissions();
    }

    public static RolesBuilder<?, ?> builder() {
        return new RolesBuilderImpl();
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Set<Permissions> getPermissions() {
        return this.permissions;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPermissions(Set<Permissions> permissions) {
        this.permissions = permissions;
    }

    public String toString() {
        return "Roles(super=" + super.toString() + ", description=" + this.getDescription() + ", name=" + this.getName() + ", permissions=" + this.getPermissions() + ")";
    }

    public Roles() {
        this.permissions = Roles.$default$permissions();
    }

    public Roles(String description, String name, Set<Permissions> permissions) {
        this.description = description;
        this.name = name;
        this.permissions = permissions;
    }

    private static final class RolesBuilderImpl
    extends RolesBuilder<Roles, RolesBuilderImpl> {
        private RolesBuilderImpl() {
        }

        @Override
        protected RolesBuilderImpl self() {
            return this;
        }

        @Override
        public Roles build() {
            return new Roles(this);
        }
    }

    public static abstract class RolesBuilder<C extends Roles, B extends RolesBuilder<C, B>>
    extends UUIDEntity.UUIDEntityBuilder<C, B> {
        private String description;
        private String name;
        private boolean permissions$set;
        private Set<Permissions> permissions$value;

        protected abstract B self();

        public abstract C build();

        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B permissions(Set<Permissions> permissions) {
            this.permissions$value = permissions;
            this.permissions$set = true;
            return (B)this.self();
        }

        public String toString() {
            return "Roles.RolesBuilder(super=" + super.toString() + ", description=" + this.description + ", name=" + this.name + ", permissions$value=" + this.permissions$value + ")";
        }
    }
}

