/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.auth.jpa.entities;

import de.alpharogroup.db.entity.nameable.versionable.VersionableNameUUIDEntity;
import de.alpharogroup.user.auth.jpa.entities.Permissions;
import de.alpharogroup.user.auth.jpa.entities.Roles;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="applications", uniqueConstraints={@UniqueConstraint(name="uc_applications_name", columnNames={"name"}), @UniqueConstraint(name="uc_applications_domain_name", columnNames={"domain_name"}), @UniqueConstraint(name="uc_applications_email", columnNames={"email"})}, indexes={@Index(name="idx_applications_name", columnList="name", unique=true)})
public class Applications
extends VersionableNameUUIDEntity {
    static final String SINGULAR_ENTITY_NAME = "application";
    static final String TABLE_NAME = "applications";
    static final String COLUMN_NAME_DOMAIN_NAME = "domain_name";
    static final String COLUMN_NAME_EMAIL = "email";
    static final String JOIN_TABLE_NAME_APPLICATION_ROLES = "application_roles";
    static final String JOIN_TABLE_APPLICATION_ROLES_COLUMN_NAME_APPLICATION_ID = "application_id";
    static final String JOIN_TABLE_APPLICATION_ROLES_COLUMN_NAME_ROLE_ID = "role_id";
    static final String JOIN_TABLE_FOREIGN_KEY_APPLICATION_ROLES_APPLICATION_ID = "fk_application_roles_application_id";
    static final String JOIN_TABLE_FOREIGN_KEY_APPLICATION_ROLES_ROLE_ID = "fk_application_roles_role_id";
    static final String JOIN_TABLE_NAME_APPLICATION_PERMISSIONS = "application_permissions";
    static final String JOIN_TABLE_APPLICATION_PERMISSIONS_COLUMN_NAME_APPLICATION_ID = "application_id";
    static final String JOIN_TABLE_APPLICATION_PERMISSIONS_COLUMN_NAME_PERMISSION_ID = "permission_id";
    static final String JOIN_TABLE_FOREIGN_KEY_APPLICATION_PERMISSIONS_APPLICATION_ID = "fk_application_permissions_application_id";
    static final String JOIN_TABLE_FOREIGN_KEY_APPLICATION_PERMISSIONS_PERMISSION_ID = "fk_application_permissions_permission_id";
    @Column(name="domain_name", length=1024)
    private String domainName;
    @Column(length=1024)
    private String email;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="application_roles", joinColumns={@JoinColumn(name="application_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_application_roles_application_id"))}, inverseJoinColumns={@JoinColumn(name="role_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_application_roles_role_id"))})
    private Set<Roles> roles;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="application_permissions", joinColumns={@JoinColumn(name="application_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_application_permissions_application_id"))}, inverseJoinColumns={@JoinColumn(name="permission_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_application_permissions_permission_id"))})
    private Set<Permissions> permissions;

    private static Set<Roles> $default$roles() {
        return new HashSet<Roles>();
    }

    private static Set<Permissions> $default$permissions() {
        return new HashSet<Permissions>();
    }

    protected Applications(ApplicationsBuilder<?, ?> b) {
        super(b);
        this.domainName = b.domainName;
        this.email = b.email;
        this.roles = b.roles$set ? b.roles$value : Applications.$default$roles();
        this.permissions = b.permissions$set ? b.permissions$value : Applications.$default$permissions();
    }

    public static ApplicationsBuilder<?, ?> builder() {
        return new ApplicationsBuilderImpl();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getEmail() {
        return this.email;
    }

    public Set<Roles> getRoles() {
        return this.roles;
    }

    public Set<Permissions> getPermissions() {
        return this.permissions;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setRoles(Set<Roles> roles) {
        this.roles = roles;
    }

    public void setPermissions(Set<Permissions> permissions) {
        this.permissions = permissions;
    }

    public String toString() {
        return "Applications(super=" + super.toString() + ", domainName=" + this.getDomainName() + ", email=" + this.getEmail() + ", roles=" + this.getRoles() + ", permissions=" + this.getPermissions() + ")";
    }

    public Applications() {
        this.roles = Applications.$default$roles();
        this.permissions = Applications.$default$permissions();
    }

    private static final class ApplicationsBuilderImpl
    extends ApplicationsBuilder<Applications, ApplicationsBuilderImpl> {
        private ApplicationsBuilderImpl() {
        }

        @Override
        protected ApplicationsBuilderImpl self() {
            return this;
        }

        @Override
        public Applications build() {
            return new Applications(this);
        }
    }

    public static abstract class ApplicationsBuilder<C extends Applications, B extends ApplicationsBuilder<C, B>>
    extends VersionableNameUUIDEntity.VersionableNameUUIDEntityBuilder<C, B> {
        private String domainName;
        private String email;
        private boolean roles$set;
        private Set<Roles> roles$value;
        private boolean permissions$set;
        private Set<Permissions> permissions$value;

        protected abstract B self();

        public abstract C build();

        public B domainName(String domainName) {
            this.domainName = domainName;
            return (B)this.self();
        }

        public B email(String email) {
            this.email = email;
            return (B)this.self();
        }

        public B roles(Set<Roles> roles) {
            this.roles$value = roles;
            this.roles$set = true;
            return (B)this.self();
        }

        public B permissions(Set<Permissions> permissions) {
            this.permissions$value = permissions;
            this.permissions$set = true;
            return (B)this.self();
        }

        public String toString() {
            return "Applications.ApplicationsBuilder(super=" + super.toString() + ", domainName=" + this.domainName + ", email=" + this.email + ", roles$value=" + this.roles$value + ", permissions$value=" + this.permissions$value + ")";
        }
    }
}

