/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.auth.filter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alpharogroup.auth.beans.AuthenticationResult;
import de.alpharogroup.collections.map.MapFactory;
import de.alpharogroup.collections.pairs.KeyValuePair;
import de.alpharogroup.json.JsonStringToObjectExtensions;
import de.alpharogroup.json.factory.ObjectMapperFactory;
import de.alpharogroup.servlet.extensions.HttpServletRequestExtensions;
import de.alpharogroup.user.auth.configuration.ApplicationProperties;
import de.alpharogroup.user.auth.dto.JwtRequest;
import de.alpharogroup.user.auth.service.JwtTokenService;
import de.alpharogroup.user.auth.service.api.AuthenticationsService;
import de.alpharogroup.user.auth.service.jwt.JwtUserDetailsService;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtRequestFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtUserDetailsService jwtUserDetailsService;
    @Autowired
    private JwtTokenService jwtTokenService;
    @Autowired
    private AuthenticationsService authenticationsService;
    @Autowired
    ApplicationProperties applicationProperties;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!request.isSecure() || this.isPublicRequest(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Optional<String> optionalToken = this.getJwtToken(request);
        if (optionalToken.isPresent()) {
            String jwtToken = optionalToken.get();
            this.validateToken(request, response, jwtToken);
        } else if (this.isSigninRequest(request)) {
            String password;
            String username;
            String payloadRequest = HttpServletRequestExtensions.getBody((HttpServletRequest)request);
            if (payloadRequest.isEmpty()) {
                username = request.getParameter("username");
                password = request.getParameter("password");
                if (StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            } else {
                ObjectMapper mapper = ObjectMapperFactory.newObjectMapper((Map)MapFactory.newHashMap((KeyValuePair[])new KeyValuePair[]{KeyValuePair.builder().key((Object)JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES).value((Object)true).build()}));
                JwtRequest jwtRequest = (JwtRequest)JsonStringToObjectExtensions.toObject((String)payloadRequest, JwtRequest.class, (ObjectMapper)mapper);
                username = jwtRequest.getUsername();
                password = jwtRequest.getPassword();
            }
            this.setNewToken(request, response, username, password);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void validateToken(HttpServletRequest request, HttpServletResponse response, String jwtToken) {
        UserDetails userDetails;
        String username = this.jwtTokenService.getUsername(jwtToken);
        if (username != null && SecurityContextHolder.getContext().getAuthentication() == null && this.jwtTokenService.validate(jwtToken, userDetails = this.jwtUserDetailsService.loadUserByUsername(username)).booleanValue()) {
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            usernamePasswordAuthenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
            response.addHeader("Authorization", "Bearer " + jwtToken);
        }
    }

    private void setNewToken(HttpServletRequest request, HttpServletResponse response, String username, String password) {
        UserDetails userDetails = this.jwtUserDetailsService.loadUserByUsername(username);
        AuthenticationResult authenticationResult = this.authenticationsService.authenticate(username, password);
        if (authenticationResult.isValid()) {
            String jwtToken = this.jwtTokenService.newJwtToken(userDetails);
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            usernamePasswordAuthenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
            response.addHeader("Authorization", "Bearer " + jwtToken);
        }
    }

    protected Optional<String> getJwtToken(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Optional authorizationHeader = HttpServletRequestExtensions.getAuthorizationHeader((HttpServletRequest)request);
        return authorizationHeader;
    }

    protected boolean isPublicRequest(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        boolean isPublicRequest = false;
        if (this.isPublicPath(this.getPath(request))) {
            isPublicRequest = true;
        }
        return isPublicRequest;
    }

    protected boolean isSigninRequest(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        boolean isSigninRequest = false;
        if (this.isSigninPath(this.getPath(request))) {
            isSigninRequest = true;
        }
        return isSigninRequest;
    }

    protected boolean isSigninPath(String path) {
        return this.applicationProperties.getSigninPathPatterns().contains(path);
    }

    protected boolean isPublicPath(String path) {
        return this.applicationProperties.getPublicPathPatterns().contains(path);
    }

    public String getPath(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return HttpServletRequestExtensions.getPath((HttpServletRequest)request);
    }
}

