/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.auth.controller;

import de.alpharogroup.auth.beans.AuthenticationResult;
import de.alpharogroup.auth.enums.ValidationErrors;
import de.alpharogroup.user.auth.configuration.ApplicationProperties;
import de.alpharogroup.user.auth.dto.JwtRequest;
import de.alpharogroup.user.auth.dto.JwtResponse;
import de.alpharogroup.user.auth.dto.MessageBox;
import de.alpharogroup.user.auth.dto.Signup;
import de.alpharogroup.user.auth.jpa.entities.Users;
import de.alpharogroup.user.auth.service.JwtTokenService;
import de.alpharogroup.user.auth.service.api.AuthenticationsService;
import de.alpharogroup.user.auth.service.api.RolesService;
import de.alpharogroup.user.auth.service.api.UsersService;
import de.alpharogroup.user.auth.service.jwt.JwtUserDetailsService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auth"})
public class AuthenticationController {
    public static final String REST_PATH = "/auth";
    public static final String SIGN_IN = "/signin";
    public static final String SIGN_UP = "/signup";
    private final ApplicationProperties applicationProperties;
    private final AuthenticationsService authenticationsService;
    private final JwtTokenService jwtTokenService;
    private final JwtUserDetailsService userDetailsService;
    private final RolesService rolesService;
    private final UsersService usersService;
    private final PasswordEncoder encoder;

    @CrossOrigin(origins={"*"})
    @RequestMapping(value={"/signin"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ApiOperation(value="authenticate with the given JwtRequest that contains the username and password")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jwtRequest", value="The username", dataType="JwtRequest", paramType="body")})
    public ResponseEntity<?> signIn(@Valid @RequestBody JwtRequest jwtRequest) {
        AuthenticationResult authenticate = this.authenticationsService.authenticate(jwtRequest.getUsername(), jwtRequest.getPassword());
        if (authenticate.isValid()) {
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(jwtRequest.getUsername());
            String token = this.jwtTokenService.newJwtToken(userDetails);
            Set roles = ((Users)authenticate.getUser()).getRoles().stream().map(roles1 -> roles1.getName()).collect(Collectors.toSet());
            JwtResponse jwtResponse = JwtResponse.builder().token(token).type("Bearer").username(jwtRequest.getUsername()).roles(roles).build();
            return ResponseEntity.status((int)HttpStatus.OK.value()).body((Object)jwtResponse);
        }
        String unauthorizedRedirectPath = "redirect:" + this.applicationProperties.getContextPath() + "/v1/jwt/unauthorized";
        return ResponseEntity.status((int)HttpStatus.UNAUTHORIZED.value()).body((Object)unauthorizedRedirectPath);
    }

    @RequestMapping(value={"/signup"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<?> signUp(@Valid @RequestBody Signup signUpRequest) {
        Set roles;
        Optional validationErrors = this.usersService.validate(signUpRequest);
        if (validationErrors.isPresent()) {
            ValidationErrors error = (ValidationErrors)validationErrors.get();
            if (ValidationErrors.EMAIL_EXISTS_ERROR.equals((Object)error)) {
                return ResponseEntity.status((int)HttpStatus.BAD_REQUEST.value()).body((Object)"Email already exists");
            }
            if (ValidationErrors.USERNAME_EXISTS_ERROR.equals((Object)error)) {
                return ResponseEntity.status((int)HttpStatus.BAD_REQUEST.value()).body((Object)"Username already exists");
            }
        }
        if (signUpRequest.getRoles() != null && !signUpRequest.getRoles().isEmpty()) {
            roles = this.rolesService.getRoles(signUpRequest.getRoles());
        } else {
            HashSet<String> stringRoles = new HashSet<String>();
            stringRoles.add("member");
            roles = this.rolesService.getRoles(stringRoles);
        }
        Users savedUser = this.usersService.signUpUser(signUpRequest, roles);
        return ResponseEntity.ok((Object)MessageBox.builder().message("User with id" + savedUser.getId() + " successfully created and signed up").build());
    }

    public AuthenticationController(ApplicationProperties applicationProperties, AuthenticationsService authenticationsService, JwtTokenService jwtTokenService, JwtUserDetailsService userDetailsService, RolesService rolesService, UsersService usersService, PasswordEncoder encoder) {
        this.applicationProperties = applicationProperties;
        this.authenticationsService = authenticationsService;
        this.jwtTokenService = jwtTokenService;
        this.userDetailsService = userDetailsService;
        this.rolesService = rolesService;
        this.usersService = usersService;
        this.encoder = encoder;
    }
}

