/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.auth.configuration;

import de.alpharogroup.collections.list.ListExtensions;
import de.alpharogroup.user.auth.configuration.ApplicationProperties;
import de.alpharogroup.user.auth.entrypoint.RestAuthenticationEntryPoint;
import de.alpharogroup.user.auth.filter.JwtRequestFilter;
import de.alpharogroup.user.auth.service.UserDetailsServiceImpl;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
public class SpringSecurityWebAppConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    @Qualifier(value="authenticationManagerBean")
    AuthenticationManager authenticationManager;
    @Autowired
    ApplicationProperties applicationProperties;
    @Autowired
    RestAuthenticationEntryPoint authenticationEntryPoint;
    @Autowired
    UserDetailsServiceImpl userDetailsService;
    @Autowired
    private JwtRequestFilter jwtRequestFilter;

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public DaoAuthenticationProvider authenticationProvider() {
        DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider();
        authProvider.setUserDetailsService((UserDetailsService)this.userDetailsService);
        authProvider.setPasswordEncoder(this.encoder());
        return authProvider;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.parentAuthenticationManager(this.authenticationManagerBean()).userDetailsService((UserDetailsService)this.userDetailsService);
    }

    protected void configure(HttpSecurity http) throws Exception {
        List<String> signinPaths = this.applicationProperties.getSigninPathPatterns();
        List<String> ignorePathPatterns = this.applicationProperties.getIgnorePathPatterns();
        signinPaths.addAll(ignorePathPatterns);
        String[] allPublicPaths = (String[])ListExtensions.toArray(signinPaths);
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.addFilterBefore((Filter)this.jwtRequestFilter, UsernamePasswordAuthenticationFilter.class).csrf().disable()).authorizeRequests().antMatchers(allPublicPaths)).permitAll().anyRequest()).authenticated().and()).csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint);
    }

    public void configure(WebSecurity web) {
        List<String> publicPaths = this.applicationProperties.getPublicPathPatterns();
        String[] allIgnorePatterns = (String[])ListExtensions.toArray(publicPaths);
        web.ignoring().antMatchers(allIgnorePatterns);
    }

    @Bean
    public PasswordEncoder encoder() {
        return new BCryptPasswordEncoder(11);
    }
}

