/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.auth.configuration;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.alpharogroup.user.auth.configuration.ApplicationProperties;
import java.util.List;
import lombok.NonNull;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MarshallingHttpMessageConverter;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.xstream.XStreamMarshaller;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages={"de.alpharogroup.user.auth"})
@EntityScan(basePackages={"de.alpharogroup.user.auth.jpa.entities"})
@EnableJpaRepositories(basePackages={"de.alpharogroup.user.auth.jpa.repositories"})
@EnableTransactionManagement
public class ApplicationConfiguration
implements WebMvcConfigurer {
    public static final String VERSION_API_1 = "v1";
    public static final String REST_VERSION = "/v1";
    private final ApplicationProperties applicationProperties;
    private final Environment env;

    public static ObjectMapper initialize(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        SimpleModule module = new SimpleModule("user-auth", Version.unknownVersion());
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver();
        module.setAbstractTypes(resolver);
        objectMapper.registerModule((Module)module);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        objectMapper.registerModule((Module)javaTimeModule);
        return objectMapper;
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedMethods(new String[]{"GET", "POST", "PUT", "DELETE", "OPTIONS"}).allowedOrigins(new String[]{"*"});
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(this.createXmlHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)this.newMappingJackson2HttpMessageConverter());
    }

    private MappingJackson2HttpMessageConverter newMappingJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        return mappingJackson2HttpMessageConverter;
    }

    private HttpMessageConverter<Object> createXmlHttpMessageConverter() {
        MarshallingHttpMessageConverter xmlConverter = new MarshallingHttpMessageConverter();
        XStreamMarshaller xstreamMarshaller = new XStreamMarshaller();
        xmlConverter.setMarshaller((Marshaller)xstreamMarshaller);
        xmlConverter.setUnmarshaller((Unmarshaller)xstreamMarshaller);
        return xmlConverter;
    }

    @Bean
    public MessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"messages/errors"});
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean
    public ObjectMapper objectMapper() {
        return ApplicationConfiguration.initialize(new ObjectMapper());
    }

    public ApplicationConfiguration(ApplicationProperties applicationProperties, Environment env) {
        this.applicationProperties = applicationProperties;
        this.env = env;
    }
}

