/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.address.book.service;

import de.alpharogroup.address.book.daos.ZipcodesDao;
import de.alpharogroup.address.book.domain.Country;
import de.alpharogroup.address.book.domain.Zipcode;
import de.alpharogroup.address.book.entities.Countries;
import de.alpharogroup.address.book.entities.Zipcodes;
import de.alpharogroup.address.book.mapper.ZipcodesMapper;
import de.alpharogroup.address.book.service.api.ZipcodeService;
import de.alpharogroup.address.book.service.api.ZipcodesService;
import de.alpharogroup.address.book.service.util.HqlStringCreator;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.service.domain.AbstractDomainService;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="zipcodesDomainService")
public class ZipcodesDomainService
extends AbstractDomainService<Integer, Zipcode, Zipcodes, ZipcodesDao, ZipcodesMapper>
implements ZipcodeService {
    @Autowired
    private ZipcodesService zipcodesService;

    @Autowired
    public void setZipcodesDao(ZipcodesDao zipcodesDao) {
        this.setDao((EntityManagerDao)zipcodesDao);
    }

    @Override
    public List<Zipcode> find(String country, String zipcode, String city) {
        String hqlString = HqlStringCreator.forZipcodes((String)country, (String)zipcode, (String)city);
        Query query = ((ZipcodesDao)this.getDao()).getQuery(hqlString);
        if (country != null) {
            query.setParameter("country", (Object)country);
        }
        if (zipcode != null && !zipcode.isEmpty()) {
            query.setParameter("zipcode", (Object)zipcode);
        }
        if (city != null && !city.isEmpty()) {
            query.setParameter("city", (Object)city);
        }
        List entities = query.getResultList();
        List bos = ((ZipcodesMapper)this.getMapper()).toDomainObjects(entities);
        return bos;
    }

    @Override
    public List<Zipcode> findAll(Country country, String zipcode, String city) {
        Countries c = (Countries)((ZipcodesMapper)this.getMapper()).map((Object)country, Countries.class);
        return ((ZipcodesMapper)this.getMapper()).toDomainObjects(this.zipcodesService.findAll(c, zipcode, city));
    }

    @Override
    public void deleteAllZipcodes() {
        this.zipcodesService.deleteAllZipcodes();
    }

    @Override
    public boolean existsZipcode(String zipcode) {
        return this.zipcodesService.existsZipcode(zipcode);
    }

    @Override
    public List<Zipcode> findZipcodes(String zipcode) {
        return ((ZipcodesMapper)this.getMapper()).toDomainObjects(this.zipcodesService.findZipcodes(zipcode));
    }

    @Override
    public Zipcode getZipcode(String zipcode, String city) {
        return (Zipcode)((ZipcodesMapper)this.getMapper()).toDomainObject((BaseEntity)this.zipcodesService.getZipcode(zipcode, city));
    }

    @Override
    public List<Zipcode> find(Country country) {
        return ((ZipcodesMapper)this.getMapper()).toDomainObjects(this.zipcodesService.find((Countries)((ZipcodesMapper)this.getMapper()).map((Object)country, Countries.class)));
    }

    @Override
    public Zipcode findCityFromZipcode(Country country, String zipcode) {
        return (Zipcode)((ZipcodesMapper)this.getMapper()).toDomainObject((BaseEntity)this.zipcodesService.findCityFromZipcode((Countries)((ZipcodesMapper)this.getMapper()).map((Object)country, Countries.class), zipcode));
    }

    public ZipcodesService getZipcodesService() {
        return this.zipcodesService;
    }

    public void setZipcodesService(ZipcodesService zipcodesService) {
        this.zipcodesService = zipcodesService;
    }
}

