/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.address.book.service;

import de.alpharogroup.address.book.daos.FederalstatesDao;
import de.alpharogroup.address.book.domain.Country;
import de.alpharogroup.address.book.domain.Federalstate;
import de.alpharogroup.address.book.entities.Countries;
import de.alpharogroup.address.book.entities.Federalstates;
import de.alpharogroup.address.book.mapper.FederalstatesMapper;
import de.alpharogroup.address.book.service.api.FederalstateService;
import de.alpharogroup.address.book.service.api.FederalstatesService;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.service.domain.AbstractDomainService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="federalstatesDomainService")
public class FederalstatesDomainService
extends AbstractDomainService<Integer, Federalstate, Federalstates, FederalstatesDao, FederalstatesMapper>
implements FederalstateService {
    @Autowired
    private FederalstatesService federalstatesService;

    @Autowired
    public void setFederalstatesDao(FederalstatesDao federalstatesDao) {
        this.setDao((EntityManagerDao)federalstatesDao);
    }

    @Override
    public Federalstate findFederalstateFromIso3166A2code(String iso3166a2code) {
        return (Federalstate)((FederalstatesMapper)this.getMapper()).toDomainObject((BaseEntity)this.federalstatesService.findFederalstateFromIso3166A2code(iso3166a2code));
    }

    @Override
    public String findFederalstateNameFromIso3166A2code(String iso3166a2code) {
        return this.federalstatesService.findFederalstateNameFromIso3166A2code(iso3166a2code);
    }

    @Override
    public List<Federalstate> findFederalstatesFromCountry(Country country) {
        Countries c = (Countries)((FederalstatesMapper)this.getMapper()).getMapper().map((Object)country, Countries.class);
        return ((FederalstatesMapper)this.getMapper()).toDomainObjects(this.federalstatesService.findFederalstatesFromCountry(c));
    }

    @Override
    public List<Federalstate> findFederalstatesFromCountry(Country country, String name) {
        Countries c = (Countries)((FederalstatesMapper)this.getMapper()).getMapper().map((Object)country, Countries.class);
        return ((FederalstatesMapper)this.getMapper()).toDomainObjects(this.federalstatesService.findFederalstatesFromCountry(c, name));
    }

    @Override
    public Federalstate findFederalstate(Country country, String name) {
        return (Federalstate)((FederalstatesMapper)this.getMapper()).toDomainObject((BaseEntity)this.federalstatesService.findFederalstate((Countries)((FederalstatesMapper)this.getMapper()).getMapper().map((Object)country, Countries.class), name));
    }

    @Override
    public Federalstate getFederalstate(String string) {
        return (Federalstate)((FederalstatesMapper)this.getMapper()).toDomainObject((BaseEntity)this.federalstatesService.getFederalstate(string));
    }

    public FederalstatesService getFederalstatesService() {
        return this.federalstatesService;
    }

    public void setFederalstatesService(FederalstatesService federalstatesService) {
        this.federalstatesService = federalstatesService;
    }
}

