/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.address.book.service;

import de.alpharogroup.address.book.application.model.LocationModel;
import de.alpharogroup.address.book.daos.CountriesDao;
import de.alpharogroup.address.book.domain.Address;
import de.alpharogroup.address.book.domain.Country;
import de.alpharogroup.address.book.domain.Federalstate;
import de.alpharogroup.address.book.domain.Zipcode;
import de.alpharogroup.address.book.entities.Countries;
import de.alpharogroup.address.book.mapper.CountriesMapper;
import de.alpharogroup.address.book.service.api.CountriesService;
import de.alpharogroup.address.book.service.api.CountryService;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.service.domain.AbstractDomainService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="countriesDomainService")
public class CountriesDomainService
extends AbstractDomainService<Integer, Country, Countries, CountriesDao, CountriesMapper>
implements CountryService {
    @Autowired
    private CountriesService countriesService;
    private Map<Country, List<Zipcode>> countryToZipcodeMap;
    private Map<Country, List<Federalstate>> countryToFederalstateMap;
    private Map<Country, List<Zipcode>> germanCountryToZipcodeMap;

    @Autowired
    public void setCountriesDao(CountriesDao countriesDao) {
        this.setDao((EntityManagerDao)countriesDao);
    }

    @Override
    public Map<Country, List<Federalstate>> getCountriesToFederalstatesMap() {
        if (this.countryToFederalstateMap == null) {
            this.countryToFederalstateMap = new LinkedHashMap<Country, List<Federalstate>>();
            Map countriesToFederalstatesMap = this.countriesService.getCountriesToFederalstatesMap();
            CountriesMapper mapper = (CountriesMapper)this.getMapper();
            for (Map.Entry entry : countriesToFederalstatesMap.entrySet()) {
                Countries countries = (Countries)entry.getKey();
                List fss = (List)entry.getValue();
                if (countries != null) {
                    Country country = (Country)mapper.toDomainObject((BaseEntity)countries);
                    List federalstates = mapper.map(fss, Federalstate.class);
                    this.countryToFederalstateMap.put(country, federalstates);
                    continue;
                }
                System.err.println(fss);
            }
        }
        return this.countryToFederalstateMap;
    }

    @Override
    public Map<String, List<String>> getCountriesToFederalstatesAsStringMap() {
        return this.countriesService.getCountriesToFederalstatesAsStringMap();
    }

    @Override
    public Map<Country, List<Zipcode>> getCountriesToZipcodesMap() {
        if (this.countryToZipcodeMap == null) {
            this.countryToZipcodeMap = new LinkedHashMap<Country, List<Zipcode>>();
            Map countriesToZipcodesMap = this.countriesService.getCountriesToZipcodesMap();
            for (Map.Entry entry : countriesToZipcodesMap.entrySet()) {
                this.countryToZipcodeMap.put((Country)((CountriesMapper)this.getMapper()).toDomainObject((BaseEntity)entry.getKey()), ((CountriesMapper)this.getMapper()).map((Collection)entry.getValue(), Zipcode.class));
            }
        }
        return this.countryToZipcodeMap;
    }

    @Override
    public Map<String, List<String>> getCountriesToZipcodesAsStringMap() {
        return this.countriesService.getCountriesToZipcodesAsStringMap();
    }

    @Override
    public Map<Country, List<Zipcode>> getGermanCountriesToZipcodesMap() {
        if (this.germanCountryToZipcodeMap == null) {
            this.germanCountryToZipcodeMap = new LinkedHashMap<Country, List<Zipcode>>();
            Map germanCountriesToZipcodesMap = this.countriesService.getGermanCountriesToZipcodesMap();
            for (Map.Entry entry : germanCountriesToZipcodesMap.entrySet()) {
                this.germanCountryToZipcodeMap.put((Country)((CountriesMapper)this.getMapper()).toDomainObject((BaseEntity)entry.getKey()), ((CountriesMapper)this.getMapper()).map((Collection)entry.getValue(), Zipcode.class));
            }
        }
        return this.germanCountryToZipcodeMap;
    }

    @Override
    public Map<String, List<String>> getGermanCountriesToZipcodesAsStringMap() {
        return this.countriesService.getGermanCountriesToZipcodesAsStringMap();
    }

    @Override
    public Map<String, List<String>> getCountriesToZipcodesAndCitiesAsStringMap() {
        return this.countriesService.getCountriesToZipcodesAndCitiesAsStringMap();
    }

    @Override
    public Map<String, List<String>> getGermanCountriesToZipcodesAndCitiesAsStringMap() {
        return this.countriesService.getGermanCountriesToZipcodesAndCitiesAsStringMap();
    }

    @Override
    public List<Country> findAll(String iso3166a2name, String iso3166a3name, String iso3166Number, String name) {
        return ((CountriesMapper)this.getMapper()).toDomainObjects(this.countriesService.findAll(iso3166a2name, iso3166a3name, iso3166Number, name));
    }

    @Override
    public Country find(String iso3166a2name) {
        return (Country)((CountriesMapper)this.getMapper()).toDomainObject((BaseEntity)this.countriesService.find(iso3166a2name));
    }

    @Override
    public Country findByName(String name) {
        return (Country)((CountriesMapper)this.getMapper()).toDomainObject((BaseEntity)this.countriesService.findByName(name));
    }

    @Override
    public String setLocationModel(LocationModel<Address> modelObject, String zc) {
        LocationModel locationModel = (LocationModel)((CountriesMapper)this.getMapper()).map(modelObject, LocationModel.class);
        String result = this.countriesService.setLocationModel(locationModel, zc);
        ObjectExtensions.copyQuietly(modelObject, (Object)locationModel);
        return result;
    }

    public CountriesService getCountriesService() {
        return this.countriesService;
    }

    public void setCountriesService(CountriesService countriesService) {
        this.countriesService = countriesService;
    }
}

