/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.address.book.service;

import de.alpharogroup.address.book.daos.ZipcodesDao;
import de.alpharogroup.address.book.domain.Country;
import de.alpharogroup.address.book.domain.Zipcode;
import de.alpharogroup.address.book.entities.Countries;
import de.alpharogroup.address.book.entities.Zipcodes;
import de.alpharogroup.address.book.mapper.ZipcodesMapper;
import de.alpharogroup.address.book.service.api.ZipcodeService;
import de.alpharogroup.address.book.service.api.ZipcodesService;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.service.domain.AbstractDomainService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="zipcodesDomainService")
public class ZipcodesDomainService
extends AbstractDomainService<Integer, Zipcode, Zipcodes, ZipcodesDao, ZipcodesMapper>
implements ZipcodeService {
    @Autowired
    private ZipcodesService zipcodesService;

    @Override
    public void deleteAllZipcodes() {
        this.zipcodesService.deleteAllZipcodes();
    }

    @Override
    public boolean existsZipcode(String zipcode) {
        return this.zipcodesService.existsZipcode(zipcode);
    }

    @Override
    public List<Zipcode> find(Country country) {
        ArrayList<Zipcode> zcs = new ArrayList<Zipcode>();
        if (country != null) {
            Countries countries = (Countries)((ZipcodesMapper)this.getMapper()).map((Object)country, Countries.class);
            return ((ZipcodesMapper)this.getMapper()).toDomainObjects(this.zipcodesService.find(countries));
        }
        return zcs;
    }

    @Override
    public List<Zipcode> findAll(Country country, String zipcode, String city) {
        Countries c = (Countries)((ZipcodesMapper)this.getMapper()).map((Object)country, Countries.class);
        return ((ZipcodesMapper)this.getMapper()).toDomainObjects(this.zipcodesService.findAll(c, zipcode, city));
    }

    @Override
    public Zipcode findCityFromZipcode(Country country, String zipcode) {
        return (Zipcode)((ZipcodesMapper)this.getMapper()).toDomainObject((BaseEntity)this.zipcodesService.findCityFromZipcode((Countries)((ZipcodesMapper)this.getMapper()).map((Object)country, Countries.class), zipcode));
    }

    @Override
    public List<Zipcode> findZipcodes(String zipcode) {
        return ((ZipcodesMapper)this.getMapper()).toDomainObjects(this.zipcodesService.findZipcodes(zipcode));
    }

    @Override
    public Zipcode getZipcode(String zipcode, String city) {
        return (Zipcode)((ZipcodesMapper)this.getMapper()).toDomainObject((BaseEntity)this.zipcodesService.getZipcode(zipcode, city));
    }

    @Autowired
    public void setZipcodesDao(ZipcodesDao zipcodesDao) {
        this.setDao((EntityManagerDao)zipcodesDao);
    }

    @Autowired
    public void setZipcodesMapper(ZipcodesMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    public ZipcodesService getZipcodesService() {
        return this.zipcodesService;
    }

    public void setZipcodesService(ZipcodesService zipcodesService) {
        this.zipcodesService = zipcodesService;
    }
}

