/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.address.book.service;

import de.alpharogroup.address.book.daos.AddressesDao;
import de.alpharogroup.address.book.domain.Address;
import de.alpharogroup.address.book.domain.Country;
import de.alpharogroup.address.book.domain.Zipcode;
import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.address.book.entities.Countries;
import de.alpharogroup.address.book.entities.Zipcodes;
import de.alpharogroup.address.book.mapper.AddressesMapper;
import de.alpharogroup.address.book.service.api.AddressService;
import de.alpharogroup.address.book.service.api.AddressesService;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.service.domain.AbstractDomainService;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="addressesDomainService")
public class AddressesDomainService
extends AbstractDomainService<Integer, Address, Addresses, AddressesDao, AddressesMapper>
implements AddressService {
    @Autowired
    private AddressesService addressesService;

    @Override
    public Address contains(String latitude, String longitude) {
        return (Address)((AddressesMapper)this.getMapper()).toDomainObject((BaseEntity)this.addressesService.contains(latitude, longitude));
    }

    @Override
    public Address contains(Zipcode zipcode) {
        Zipcodes z = (Zipcodes)((AddressesMapper)this.getMapper()).map((Object)zipcode, Zipcodes.class);
        return (Address)((AddressesMapper)this.getMapper()).toDomainObject((BaseEntity)this.addressesService.contains(z));
    }

    @Override
    public List<Address> find(Country country, String zipcode) {
        Countries c = (Countries)((AddressesMapper)this.getMapper()).map((Object)country, Countries.class);
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.find(c, zipcode));
    }

    @Override
    public List<Address> find(Country country, String zipcode, String city) {
        Countries c = (Countries)((AddressesMapper)this.getMapper()).map((Object)country, Countries.class);
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.find(c, zipcode, city));
    }

    @Override
    public List<Address> find(String geohash) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.geohash like :geohash");
        String hqlString = sb.toString();
        Query query = ((AddressesDao)this.getDao()).getQuery(hqlString);
        query.setParameter("geohash", (Object)(geohash + "%"));
        List entities = query.getResultList();
        List addresses = ((AddressesMapper)this.getMapper()).toDomainObjects(entities);
        return addresses;
    }

    @Override
    public List<Address> find(String latitude, String longitude) {
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.find(latitude, longitude));
    }

    @Override
    public List<Address> find(String geohash, String latitude, String longitude) {
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.find(geohash, latitude, longitude));
    }

    @Override
    public List<Address> find(Zipcode zipcode) {
        Zipcodes z = (Zipcodes)((AddressesMapper)this.getMapper()).map((Object)zipcode, Zipcodes.class);
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.find(z));
    }

    @Override
    public List<Address> findAddressesWithSameCityname(Country country, String city) {
        Countries c = (Countries)((AddressesMapper)this.getMapper()).map((Object)country, Countries.class);
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.findAddressesWithSameCityname(c, city));
    }

    @Override
    public List<Address> findAddressesWithSameZipcode(Country country, String zipcode) {
        Countries c = (Countries)((AddressesMapper)this.getMapper()).map((Object)country, Countries.class);
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.find(c, zipcode));
    }

    @Override
    public List<Address> findAll(Country country) {
        Countries c = (Countries)((AddressesMapper)this.getMapper()).map((Object)country, Countries.class);
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.findAll(c));
    }

    @Override
    public List<Zipcode> findAllAddressesWithCountry(Country country) {
        Countries c = (Countries)((AddressesMapper)this.getMapper()).map((Object)country, Countries.class);
        List zc = this.addressesService.findAllAddressesWithCountry(c);
        return ((AddressesMapper)this.getMapper()).map(zc, Zipcode.class);
    }

    @Override
    public Address findFirst(Country country, String zipcode) {
        Countries c = (Countries)((AddressesMapper)this.getMapper()).map((Object)country, Countries.class);
        return (Address)((AddressesMapper)this.getMapper()).toDomainObject((BaseEntity)this.addressesService.findFirst(c, zipcode));
    }

    @Override
    public List<Address> findFirstAndSecondRingNeighbourhood(String geohash) {
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.findFirstAndSecondRingNeighbourhood(geohash));
    }

    @Override
    public List<Address> findFirstRingNeighbourhood(String geohash) {
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.findFirstRingNeighbourhood(geohash));
    }

    @Override
    public List<Address> findGeohashIsNull() {
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.findGeohashIsNull());
    }

    @Override
    public List<Address> findInvalidAddresses(Country country, String geohash) {
        Countries c = (Countries)((AddressesMapper)this.getMapper()).map((Object)country, Countries.class);
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.findInvalidAddresses(c, geohash));
    }

    @Override
    public List<Address> findInvalidAddresses(Country country, String geohash, boolean not) {
        Countries c = (Countries)((AddressesMapper)this.getMapper()).map((Object)country, Countries.class);
        return ((AddressesMapper)this.getMapper()).toDomainObjects(this.addressesService.findInvalidAddresses(c, geohash, not));
    }

    @Override
    public List<Address> findNeighbourhood(String geohash) {
        List addresses = this.addressesService.findNeighbourhood(geohash);
        return ((AddressesMapper)this.getMapper()).toDomainObjects(addresses);
    }

    @Autowired
    public void setAddressesDao(AddressesDao addressesDao) {
        this.setDao((EntityManagerDao)addressesDao);
    }

    @Autowired
    public void setAddressesMapper(AddressesMapper addressesMapper) {
        this.setMapper((EntityDOMapper)addressesMapper);
    }

    public AddressesService getAddressesService() {
        return this.addressesService;
    }

    public void setAddressesService(AddressesService addressesService) {
        this.addressesService = addressesService;
    }
}

