/*
 * Decompiled with CFR 0.152.
 */
package de.aliceice.humanoid;

import de.aliceice.humanoid.Action;
import de.aliceice.humanoid.Human;
import de.aliceice.humanoid.Response;
import de.aliceice.humanoid.sessions.InvalidUserSession;
import de.aliceice.humanoid.sessions.UserSession;
import de.aliceice.humanoid.sessions.ValidUserSession;
import de.aliceice.paper.Form;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;

public final class TestHuman
implements Human {
    private Boolean greeted = false;
    private Boolean seenOff = false;
    private List<String> receivedInfo = new ArrayList<String>();
    private List<String> receivedErrors = new ArrayList<String>();
    private LinkedList<String> actionsToTake = new LinkedList();
    private List<String> lastActions = new ArrayList<String>();
    private UserSession userSession = new ValidUserSession();
    private Map<String, Response> receivedResponses = new HashMap<String, Response>();
    private Map<String, List<Note>> notesByTitle = new HashMap<String, List<Note>>();

    @Override
    public void greet(String greeting) {
        this.greeted = true;
    }

    @Override
    public void goodbye(String farewell) {
        this.seenOff = true;
    }

    @Override
    public void fyi(String info) {
        this.receivedInfo.add(info);
    }

    @Override
    public void anErrorOccurred(String error) {
        this.receivedErrors.add(error);
    }

    @Override
    public void hereYouGo(Response response) {
        this.receivedResponses.put(response.getName(), response);
    }

    @Override
    public void decideWhatToDo(Action ... actions) {
        this.lastActions = Stream.of(actions).map(Action::getName).collect(Collectors.toList());
        Optional.ofNullable(this.actionsToTake.pollFirst()).ifPresent(actionToTake -> Stream.of(actions).filter(action -> actionToTake.equals(action.getName())).findFirst().ifPresent(action -> action.run(this)));
    }

    @Override
    public void authenticated(Runnable action) {
        this.userSession.ifValidDo(action);
    }

    @Override
    public <T> T authenticated(Supplier<T> supplier) {
        return this.userSession.ifValidGet(supplier);
    }

    @Override
    public void fillOutAndSubmit(Form form) {
        Optional.ofNullable(this.notesByTitle.get(form.getName())).orElseThrow(() -> new RuntimeException("I do not have notes for Form: " + form.getName())).forEach(note -> ((Note)note).copyTo(form));
        form.submit();
    }

    public String toString() {
        return String.format("-----------------------%n|%n| Received Info: %s%n| Received Errors: %s%n| Received Responses: %s%n| Last Actions: %s%n|%n-----------------------%n", this.receivedInfo, this.receivedErrors, this.receivedResponses, this.lastActions);
    }

    public TestHuman wasGreeted() {
        Assertions.assertTrue((boolean)this.greeted, (String)"Human was not greeted.");
        return this;
    }

    public TestHuman wasSeenOff() {
        Assertions.assertTrue((boolean)this.seenOff);
        return this;
    }

    public TestHuman hasInfo(String info) {
        Assertions.assertTrue((boolean)this.receivedInfo.contains(info), (String)String.format("Did not receive info '%s'%n%s", info, this));
        return this;
    }

    public TestHuman hasError(String error) {
        Assertions.assertTrue((boolean)this.receivedErrors.contains(error), (String)String.format("Did not receive error '%s'%n%s", error, this));
        return this;
    }

    public TestHuman hasResponse(String name, String response) {
        Assertions.assertTrue((boolean)this.receivedResponses.containsKey(name), (String)String.format("Did not receive response '%s'%n%s", name, this));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.receivedResponses.get(name).printOn(new PrintStream(out));
        Assertions.assertEquals((Object)response, (Object)out.toString());
        return this;
    }

    public TestHuman ifAskedDo(String ... actionsToTake) {
        this.actionsToTake.addAll(Arrays.asList(actionsToTake));
        return this;
    }

    public TestHuman logOut() {
        this.userSession = new InvalidUserSession();
        return this;
    }

    public void takeNotes(String name, String ... notes) {
        this.notesByTitle.put(name, Stream.of(notes).map(x$0 -> new Note((String)x$0)).collect(Collectors.toList()));
    }

    public TestHuman wasAskedToDecideBetween(String ... actions) {
        Stream.of(actions).forEach(expected -> Assertions.assertTrue((boolean)this.lastActions.stream().anyMatch(expected::equals), (String)String.format("Did not get action '%s'%n%s", expected, this)));
        return this;
    }

    private static final class Note {
        private final String note;

        private void copyTo(Form form) {
            String[] elements = this.note.split(": ");
            String field = elements[0];
            String value = elements.length > 1 ? elements[1] : "";
            form.write(field, value);
        }

        private Note(String note) {
            this.note = note;
        }
    }
}

