/*
 * Decompiled with CFR 0.152.
 */
package de.aliceice.humanoid.media;

import de.aliceice.humanoid.Response;
import de.aliceice.humanoid.media.Media;
import java.util.Collection;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public final class JsonMedia
implements Media<JsonValue> {
    private final JsonObjectBuilder json = Json.createObjectBuilder();

    @Override
    public void print(String name, String value) {
        this.json.add(name, value);
    }

    @Override
    public void print(String name, Integer value) {
        this.json.add(name, value.intValue());
    }

    @Override
    public void print(String name, Float value) {
        this.json.add(name, (double)value.floatValue());
    }

    @Override
    public void print(String name, Double value) {
        this.json.add(name, value.doubleValue());
    }

    @Override
    public void print(String name, Response response) {
        JsonMedia media = new JsonMedia();
        response.printOn(media);
        this.json.add(name, media.getContent());
    }

    @Override
    public void print(String name, Collection<Response> collection) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        collection.forEach(response -> {
            JsonMedia entry = new JsonMedia();
            response.printOn(entry);
            arrayBuilder.add(entry.getContent());
        });
        this.json.add(name, (JsonValue)arrayBuilder.build());
    }

    @Override
    public JsonValue getContent() {
        return this.json.build();
    }
}

