/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.xsd.generator.task;

import de.alexanderwolz.commons.log.Event;
import de.alexanderwolz.commons.log.Logger;
import de.alexanderwolz.xsd.generator.Flags;
import de.alexanderwolz.xsd.generator.instance.XjcJavaGenerator;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010,\u001a\u00020-H\u0007R\u001c\u0010\u0004\u001a\u00020\u00058GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u000b8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00118GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00118GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00118GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R \u0010\u001c\u001a\u0004\u0018\u00010\u00058G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0007\"\u0004\b\u001e\u0010\tR\u001c\u0010\u001f\u001a\u00020 8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R&\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u00118G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0013\"\u0004\b(\u0010\u0015R \u0010)\u001a\u0004\u0018\u00010\u000b8G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\r\"\u0004\b+\u0010\u000f\u00a8\u0006."}, d2={"Lde/alexanderwolz/xsd/generator/task/XsdJavaGeneratorTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "outputDir", "Ljava/io/File;", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "encoding", "", "getEncoding", "()Ljava/lang/String;", "setEncoding", "(Ljava/lang/String;)V", "schemas", "", "getSchemas", "()Ljava/util/Collection;", "setSchemas", "(Ljava/util/Collection;)V", "bindings", "getBindings", "setBindings", "episodes", "getEpisodes", "setEpisodes", "catalog", "getCatalog", "setCatalog", "createEpisode", "", "getCreateEpisode", "()Z", "setCreateEpisode", "(Z)V", "flags", "Lde/alexanderwolz/xsd/generator/Flags;", "getFlags", "setFlags", "packageName", "getPackageName", "setPackageName", "run", "", "xsd-generator"})
public class XsdJavaGeneratorTask
extends DefaultTask {
    public File outputDir;
    @NotNull
    private String encoding;
    public Collection<? extends File> schemas;
    @NotNull
    private Collection<? extends File> bindings;
    @NotNull
    private Collection<? extends File> episodes;
    @Optional
    @Nullable
    private File catalog;
    private boolean createEpisode;
    @Optional
    @Nullable
    private Collection<? extends Flags> flags;
    @Optional
    @Nullable
    private String packageName;

    public XsdJavaGeneratorTask() {
        String string = Charsets.UTF_8.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        this.encoding = string;
        this.bindings = CollectionsKt.emptyList();
        this.episodes = CollectionsKt.emptyList();
    }

    @OutputDirectory
    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        return null;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @Input
    @NotNull
    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.encoding = string;
    }

    @InputFiles
    @NotNull
    public final Collection<File> getSchemas() {
        Collection<File> collection = this.schemas;
        if (collection != null) {
            return collection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"schemas");
        return null;
    }

    public final void setSchemas(@NotNull Collection<? extends File> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.schemas = collection;
    }

    @InputFiles
    @NotNull
    public final Collection<File> getBindings() {
        return this.bindings;
    }

    public final void setBindings(@NotNull Collection<? extends File> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.bindings = collection;
    }

    @InputFiles
    @NotNull
    public final Collection<File> getEpisodes() {
        return this.episodes;
    }

    public final void setEpisodes(@NotNull Collection<? extends File> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.episodes = collection;
    }

    @InputFile
    @Nullable
    public final File getCatalog() {
        return this.catalog;
    }

    public final void setCatalog(@Nullable File file) {
        this.catalog = file;
    }

    @Input
    public final boolean getCreateEpisode() {
        return this.createEpisode;
    }

    public final void setCreateEpisode(boolean bl) {
        this.createEpisode = bl;
    }

    @Input
    @Nullable
    public final Collection<Flags> getFlags() {
        return this.flags;
    }

    public final void setFlags(@Nullable Collection<? extends Flags> collection) {
        this.flags = collection;
    }

    @Input
    @Nullable
    public final String getPackageName() {
        return this.packageName;
    }

    public final void setPackageName(@Nullable String string) {
        this.packageName = string;
    }

    @TaskAction
    public final void run() {
        String string = this.encoding.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        Charset encoding = Charset.forName(string);
        Logger customLogger = new Logger(((Object)((Object)this)).getClass(), arg_0 -> XsdJavaGeneratorTask.run$lambda$0(this, arg_0));
        File file = this.getOutputDir();
        Intrinsics.checkNotNull((Object)encoding);
        XjcJavaGenerator generator = new XjcJavaGenerator(file, encoding, customLogger);
        generator.generate(this.getSchemas(), this.bindings, this.episodes, this.catalog, this.createEpisode, this.flags, this.packageName);
    }

    private static final Unit run$lambda$0(XsdJavaGeneratorTask this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getLogger().lifecycle(it.getMessage());
        return Unit.INSTANCE;
    }
}

