/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public final class Slf4jLogger
implements Serializable,
LocationAwareLogger {
    private final Logger logger;
    private static final String LOGGER_CLASS_NAME = Slf4jLogger.class.getName();
    private static final long serialVersionUID = -8422185592693034532L;
    private static final int ALT_ERROR_INT = Level.ERROR.intValue();
    private static final int ALT_WARN_INT = Level.WARN.intValue();
    private static final int ALT_INFO_INT = Level.INFO.intValue();
    private static final int ALT_DEBUG_INT = Level.DEBUG.intValue();
    private static final int ALT_TRACE_INT = Level.TRACE.intValue();
    private static final MethodHandle MARKER_SETTER;

    public Slf4jLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void log(Marker marker, String fqcn, int levelVal, String fmt, Object[] argArray, Throwable t) {
        Level level;
        switch (levelVal) {
            case 0: {
                level = Level.TRACE;
                break;
            }
            case 10: {
                level = Level.DEBUG;
                break;
            }
            case 20: {
                level = Level.INFO;
                break;
            }
            case 30: {
                level = Level.WARN;
                break;
            }
            case 40: {
                level = Level.ERROR;
                break;
            }
            default: {
                level = Level.DEBUG;
            }
        }
        if (this.logger.isLoggable((java.util.logging.Level)level)) {
            String message = MessageFormatter.arrayFormat(fmt, argArray).getMessage();
            this.log(marker, (java.util.logging.Level)level, fqcn, message, t, argArray);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.TRACE);
    }

    @Override
    public void trace(String msg) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.TRACE, msg, null);
    }

    @Override
    public void trace(String format, Object arg) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(null, (java.util.logging.Level)Level.TRACE, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(null, (java.util.logging.Level)Level.TRACE, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(null, (java.util.logging.Level)Level.TRACE, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.TRACE, msg, t);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    @Override
    public void trace(Marker marker, String msg) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(marker, (java.util.logging.Level)Level.TRACE, msg, null);
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(marker, (java.util.logging.Level)Level.TRACE, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(marker, (java.util.logging.Level)Level.TRACE, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void trace(Marker marker, String format, Object ... arguments) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(marker, (java.util.logging.Level)Level.TRACE, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(marker, (java.util.logging.Level)Level.TRACE, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.DEBUG);
    }

    @Override
    public void debug(String msg) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.DEBUG, msg, null);
    }

    @Override
    public void debug(String format, Object arg) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(null, (java.util.logging.Level)Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(null, (java.util.logging.Level)Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(null, (java.util.logging.Level)Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.DEBUG, msg, t);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    @Override
    public void debug(Marker marker, String msg) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(marker, (java.util.logging.Level)Level.DEBUG, msg, null);
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(marker, (java.util.logging.Level)Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(marker, (java.util.logging.Level)Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(marker, (java.util.logging.Level)Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(marker, (java.util.logging.Level)Level.DEBUG, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.INFO);
    }

    @Override
    public void info(String msg) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.INFO, msg, null);
    }

    @Override
    public void info(String format, Object arg) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(null, (java.util.logging.Level)Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(null, (java.util.logging.Level)Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(null, (java.util.logging.Level)Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.INFO, msg, t);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    @Override
    public void info(Marker marker, String msg) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(marker, (java.util.logging.Level)Level.INFO, msg, null);
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(marker, (java.util.logging.Level)Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(marker, (java.util.logging.Level)Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(marker, (java.util.logging.Level)Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(marker, (java.util.logging.Level)Level.INFO, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.WARN);
    }

    @Override
    public void warn(String msg) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.WARN, msg, null);
    }

    @Override
    public void warn(String format, Object arg) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(null, (java.util.logging.Level)Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(null, (java.util.logging.Level)Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(null, (java.util.logging.Level)Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.WARN, msg, t);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    @Override
    public void warn(Marker marker, String msg) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(marker, (java.util.logging.Level)Level.WARN, msg, null);
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(marker, (java.util.logging.Level)Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(marker, (java.util.logging.Level)Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(marker, (java.util.logging.Level)Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(marker, (java.util.logging.Level)Level.WARN, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.ERROR);
    }

    @Override
    public void error(String msg) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.ERROR, msg, null);
    }

    @Override
    public void error(String format, Object arg) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(null, (java.util.logging.Level)Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(null, (java.util.logging.Level)Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(null, (java.util.logging.Level)Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.ERROR, msg, t);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    @Override
    public void error(Marker marker, String msg) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(marker, (java.util.logging.Level)Level.ERROR, msg, null);
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log(marker, (java.util.logging.Level)Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log(marker, (java.util.logging.Level)Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log(marker, (java.util.logging.Level)Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(null, (java.util.logging.Level)Level.ERROR, msg, t);
    }

    protected Object readResolve() throws ObjectStreamException {
        return this;
    }

    private void log(Marker marker, java.util.logging.Level level, String message, Throwable t) {
        ExtLogRecord rec = new ExtLogRecord(level, message, LOGGER_CLASS_NAME);
        rec.setThrown(t);
        this.setMarker(rec, marker);
        this.logger.logRaw(rec);
    }

    private void log(Marker marker, java.util.logging.Level level, String message, Throwable t, Object ... params) {
        this.log(marker, level, LOGGER_CLASS_NAME, message, t, params);
    }

    private void log(Marker marker, java.util.logging.Level level, String fqcn, String message, Throwable t, Object[] params) {
        ExtLogRecord rec = new ExtLogRecord(level, message, ExtLogRecord.FormatStyle.NO_FORMAT, fqcn);
        rec.setThrown(t);
        rec.setParameters(params);
        this.setMarker(rec, marker);
        this.logger.logRaw(rec);
    }

    private void setMarker(ExtLogRecord rec, Marker marker) {
        if (MARKER_SETTER != null) {
            try {
                MARKER_SETTER.invoke(rec, marker);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        MethodHandle setMarker = null;
        try {
            setMarker = MethodHandles.lookup().findVirtual(ExtLogRecord.class, "setMarker", MethodType.methodType(Void.TYPE, Object.class));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
        }
        finally {
            MARKER_SETTER = setMarker;
        }
    }
}

