/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.keycloak.docker.mapping;

import de.alexanderwolz.keycloak.docker.mapping.AbstractDockerScopeMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.docker.mapper.DockerAuthV2AttributeMapper;
import org.keycloak.representations.docker.DockerResponseToken;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J.\u0010!\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010&\u001a\u00020'H\u0002J.\u0010(\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010)\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%H\u0002J.\u0010*\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002J\u001b\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b,J.\u0010-\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010&\u001a\u00020'H\u0002J/\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060%2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%H\u0000\u00a2\u0006\u0002\b1J\b\u00102\u001a\u00020\u0006H\u0002J\b\u00103\u001a\u00020\u0006H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u00066"}, d2={"Lde/alexanderwolz/keycloak/docker/mapping/KeycloakGroupsAndRolesToDockerScopeMapper;", "Lde/alexanderwolz/keycloak/docker/mapping/AbstractDockerScopeMapper;", "Lorg/keycloak/protocol/docker/mapper/DockerAuthV2AttributeMapper;", "<init>", "()V", "groupPrefix", "", "getGroupPrefix$keycloak_registry_mapper", "()Ljava/lang/String;", "setGroupPrefix$keycloak_registry_mapper", "(Ljava/lang/String;)V", "catalogAudience", "getCatalogAudience$keycloak_registry_mapper", "setCatalogAudience$keycloak_registry_mapper", "namespaceScope", "", "getNamespaceScope$keycloak_registry_mapper", "()Ljava/util/Set;", "setNamespaceScope$keycloak_registry_mapper", "(Ljava/util/Set;)V", "appliesTo", "", "responseToken", "Lorg/keycloak/representations/docker/DockerResponseToken;", "transformDockerResponseToken", "mappingModel", "Lorg/keycloak/models/ProtocolMapperModel;", "session", "Lorg/keycloak/models/KeycloakSession;", "userSession", "Lorg/keycloak/models/UserSessionModel;", "clientSession", "Lorg/keycloak/models/AuthenticatedClientSessionModel;", "handleScopeAccess", "accessItem", "Lde/alexanderwolz/keycloak/docker/mapping/AbstractDockerScopeMapper$DockerScopeAccess;", "clientRoleNames", "", "user", "Lorg/keycloak/models/UserModel;", "handleRegistryAccess", "isAllowedToAccessRegistryCatalogScope", "handleRepositoryAccess", "getUserNamespacesFromGroups", "getUserNamespacesFromGroups$keycloak_registry_mapper", "handleNamespaceRepositoryAccess", "filterAllowedActions", "", "requestedActions", "filterAllowedActions$keycloak_registry_mapper", "getCatalogAudienceFromEnv", "getGroupPrefixFromEnv", "getNamespaceScopeFromEnv", "Companion", "keycloak-registry-mapper"})
@SourceDebugExtension(value={"SMAP\nKeycloakGroupsAndRolesToDockerScopeMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeycloakGroupsAndRolesToDockerScopeMapper.kt\nde/alexanderwolz/keycloak/docker/mapping/KeycloakGroupsAndRolesToDockerScopeMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n1563#2:275\n1634#2,3:276\n1869#2,2:279\n1563#2:281\n1634#2,3:282\n774#2:285\n865#2,2:286\n*S KotlinDebug\n*F\n+ 1 KeycloakGroupsAndRolesToDockerScopeMapper.kt\nde/alexanderwolz/keycloak/docker/mapping/KeycloakGroupsAndRolesToDockerScopeMapper\n*L\n59#1:275\n59#1:276,3\n216#1:279,2\n262#1:281\n262#1:282,3\n262#1:285\n262#1:286,2\n*E\n"})
public final class KeycloakGroupsAndRolesToDockerScopeMapper
extends AbstractDockerScopeMapper
implements DockerAuthV2AttributeMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String groupPrefix = this.getGroupPrefixFromEnv();
    @NotNull
    private String catalogAudience = this.getCatalogAudienceFromEnv();
    @NotNull
    private Set<String> namespaceScope = this.getNamespaceScopeFromEnv();
    @NotNull
    public static final String KEY_REGISTRY_GROUP_PREFIX = "REGISTRY_GROUP_PREFIX";
    @NotNull
    public static final String DEFAULT_REGISTRY_GROUP_PREFIX = "registry-";
    @NotNull
    private static final String ROLE_USER = "user";
    @NotNull
    public static final String ROLE_EDITOR = "editor";
    @NotNull
    public static final String ROLE_ADMIN = "admin";
    @NotNull
    public static final String KEY_REGISTRY_CATALOG_AUDIENCE = "REGISTRY_CATALOG_AUDIENCE";
    @NotNull
    public static final String AUDIENCE_USER = "user";
    @NotNull
    public static final String AUDIENCE_EDITOR = "editor";
    @NotNull
    public static final String AUDIENCE_ADMIN = "admin";
    @NotNull
    public static final String KEY_REGISTRY_NAMESPACE_SCOPE = "REGISTRY_NAMESPACE_SCOPE";
    @NotNull
    public static final String NAMESPACE_SCOPE_USERNAME = "username";
    @NotNull
    public static final String NAMESPACE_SCOPE_GROUP = "group";
    @NotNull
    public static final String NAMESPACE_SCOPE_DOMAIN = "domain";
    @NotNull
    public static final String NAMESPACE_SCOPE_SLD = "sld";
    @NotNull
    private static final Set<String> NAMESPACE_SCOPE_DEFAULT = SetsKt.setOf("group");

    public KeycloakGroupsAndRolesToDockerScopeMapper() {
        super("docker-v2-allow-by-groups-and-roles-mapper", "Allow by Groups and Roles", "Maps Docker v2 scopes by user roles and groups");
    }

    @NotNull
    public final String getGroupPrefix$keycloak_registry_mapper() {
        return this.groupPrefix;
    }

    public final void setGroupPrefix$keycloak_registry_mapper(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.groupPrefix = string;
    }

    @NotNull
    public final String getCatalogAudience$keycloak_registry_mapper() {
        return this.catalogAudience;
    }

    public final void setCatalogAudience$keycloak_registry_mapper(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.catalogAudience = string;
    }

    @NotNull
    public final Set<String> getNamespaceScope$keycloak_registry_mapper() {
        return this.namespaceScope;
    }

    public final void setNamespaceScope$keycloak_registry_mapper(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.namespaceScope = set;
    }

    public boolean appliesTo(@Nullable DockerResponseToken responseToken) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DockerResponseToken transformDockerResponseToken(@NotNull DockerResponseToken responseToken, @NotNull ProtocolMapperModel mappingModel, @NotNull KeycloakSession session, @NotNull UserSessionModel userSession, @NotNull AuthenticatedClientSessionModel clientSession) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(responseToken, "responseToken");
        Intrinsics.checkNotNullParameter(mappingModel, "mappingModel");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(userSession, "userSession");
        Intrinsics.checkNotNullParameter(clientSession, "clientSession");
        Iterable $this$map$iv = this.getScopesFromSession$keycloak_registry_mapper(clientSession);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void scope;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AbstractDockerScopeMapper.DockerScopeAccess dockerScopeAccess = this.parseScopeIntoAccessItem$keycloak_registry_mapper((String)scope);
            if (dockerScopeAccess == null) {
                return responseToken;
            }
            collection.add(dockerScopeAccess);
        }
        List accessItems = (List)destination$iv$iv;
        if (accessItems.isEmpty()) {
            return responseToken;
        }
        if (((AbstractDockerScopeMapper.DockerScopeAccess)((Object)CollectionsKt.first(accessItems))).getActions().isEmpty()) {
            return responseToken;
        }
        UserModel userModel = userSession.getUser();
        Intrinsics.checkNotNullExpressionValue(userModel, "getUser(...)");
        ClientModel clientModel = clientSession.getClient();
        Intrinsics.checkNotNullExpressionValue(clientModel, "getClient(...)");
        Collection<String> clientRoleNames = this.getClientRoleNames$keycloak_registry_mapper(userModel, clientModel);
        AbstractDockerScopeMapper.DockerScopeAccess dockerScopeAccess = (AbstractDockerScopeMapper.DockerScopeAccess)((Object)CollectionsKt.first(accessItems));
        UserModel userModel2 = userSession.getUser();
        Intrinsics.checkNotNullExpressionValue(userModel2, "getUser(...)");
        return this.handleScopeAccess(responseToken, dockerScopeAccess, clientRoleNames, userModel2);
    }

    private final DockerResponseToken handleScopeAccess(DockerResponseToken responseToken, AbstractDockerScopeMapper.DockerScopeAccess accessItem, Collection<String> clientRoleNames, UserModel user) {
        if (clientRoleNames.contains("admin")) {
            return this.allowAll$keycloak_registry_mapper(responseToken, accessItem, user, "User has role 'admin'");
        }
        if (Intrinsics.areEqual(accessItem.getType(), "registry")) {
            return this.handleRegistryAccess(responseToken, clientRoleNames, accessItem, user);
        }
        if (Intrinsics.areEqual(accessItem.getType(), "repository")) {
            return this.handleRepositoryAccess(responseToken, clientRoleNames, accessItem, user);
        }
        if (Intrinsics.areEqual(accessItem.getType(), "repository(plugin)")) {
            return this.handleRepositoryAccess(responseToken, clientRoleNames, accessItem, user);
        }
        return this.deny$keycloak_registry_mapper(responseToken, accessItem, user, "Unsupported access type '" + accessItem.getType() + "'");
    }

    private final DockerResponseToken handleRegistryAccess(DockerResponseToken responseToken, Collection<String> clientRoleNames, AbstractDockerScopeMapper.DockerScopeAccess accessItem, UserModel user) {
        if (Intrinsics.areEqual(accessItem.getName(), "catalog")) {
            if (this.isAllowedToAccessRegistryCatalogScope(clientRoleNames)) {
                String reason = "Allowed by catalog audience '" + this.catalogAudience + "'";
                return this.allowAll$keycloak_registry_mapper(responseToken, accessItem, user, reason);
            }
            String reason = clientRoleNames.contains("editor") ? "Role 'admin' or $REGISTRY_CATALOG_AUDIENCE='editor' needed to access catalog" : "Role 'admin' or $REGISTRY_CATALOG_AUDIENCE='user' needed to access catalog";
            return this.deny$keycloak_registry_mapper(responseToken, accessItem, user, reason);
        }
        String reason = "Role 'admin' needed to access registry scope";
        return this.deny$keycloak_registry_mapper(responseToken, accessItem, user, reason);
    }

    private final boolean isAllowedToAccessRegistryCatalogScope(Collection<String> clientRoleNames) {
        return Intrinsics.areEqual(this.catalogAudience, "user") || Intrinsics.areEqual(this.catalogAudience, "editor") && clientRoleNames.contains("editor");
    }

    private final DockerResponseToken handleRepositoryAccess(DockerResponseToken responseToken, Collection<String> clientRoleNames, AbstractDockerScopeMapper.DockerScopeAccess accessItem, UserModel user) {
        String string = accessItem.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String string2 = this.getNamespaceFromRepositoryName$keycloak_registry_mapper(string);
        if (string2 == null) {
            return this.deny$keycloak_registry_mapper(responseToken, accessItem, user, "Role 'admin' needed to access default namespace repositories");
        }
        String namespace = string2;
        if (this.namespaceScope.contains(NAMESPACE_SCOPE_USERNAME)) {
            String string3 = user.getUsername();
            Intrinsics.checkNotNullExpressionValue(string3, "getUsername(...)");
            if (this.isUsernameRepository$keycloak_registry_mapper(namespace, string3)) {
                List list = accessItem.getActions();
                Intrinsics.checkNotNullExpressionValue(list, "getActions(...)");
                List<String> allowedActions = this.substituteRequestedActions$keycloak_registry_mapper(list);
                return this.allowWithActions$keycloak_registry_mapper(responseToken, accessItem, allowedActions, user, "Accessing user's own namespace");
            }
        }
        if (this.namespaceScope.contains(NAMESPACE_SCOPE_DOMAIN)) {
            String string4 = user.getEmail();
            Intrinsics.checkNotNullExpressionValue(string4, "getEmail(...)");
            if (this.isDomainRepository$keycloak_registry_mapper(namespace, string4)) {
                return this.handleNamespaceRepositoryAccess(responseToken, accessItem, clientRoleNames, user);
            }
        }
        if (this.namespaceScope.contains(NAMESPACE_SCOPE_SLD)) {
            String string5 = user.getEmail();
            Intrinsics.checkNotNullExpressionValue(string5, "getEmail(...)");
            if (this.isSecondLevelDomainRepository$keycloak_registry_mapper(namespace, string5)) {
                return this.handleNamespaceRepositoryAccess(responseToken, accessItem, clientRoleNames, user);
            }
        }
        if (this.namespaceScope.contains(NAMESPACE_SCOPE_GROUP)) {
            Collection<String> collection;
            Collection<String> it = collection = this.getUserNamespacesFromGroups$keycloak_registry_mapper(user);
            boolean bl = false;
            if (it.isEmpty()) {
                String reason = "User does not belong to any namespace - check groups";
                return this.deny$keycloak_registry_mapper(responseToken, accessItem, user, reason);
            }
            Collection<String> namespacesFromGroups = collection;
            if (namespacesFromGroups.contains(namespace)) {
                return this.handleNamespaceRepositoryAccess(responseToken, accessItem, clientRoleNames, user);
            }
            String reason = "Missing namespace group '" + this.groupPrefix + namespace + "' - check groups";
            return this.deny$keycloak_registry_mapper(responseToken, accessItem, user, reason);
        }
        String reason = "User does not belong to namespace '" + namespace + "' either by group nor username nor domain";
        return this.deny$keycloak_registry_mapper(responseToken, accessItem, user, reason);
    }

    @NotNull
    public final Collection<String> getUserNamespacesFromGroups$keycloak_registry_mapper(@NotNull UserModel user) {
        Intrinsics.checkNotNullParameter(user, "user");
        Stream allSubGroups = user.getGroupsStream().flatMap(arg_0 -> KeycloakGroupsAndRolesToDockerScopeMapper.getUserNamespacesFromGroups$lambda$3(KeycloakGroupsAndRolesToDockerScopeMapper::getUserNamespacesFromGroups$lambda$2, arg_0));
        Stream allGroups = Stream.concat(user.getGroupsStream(), allSubGroups);
        Stream<Object> filteredGroups = allGroups.filter(arg_0 -> KeycloakGroupsAndRolesToDockerScopeMapper.getUserNamespacesFromGroups$lambda$5(arg_0 -> KeycloakGroupsAndRolesToDockerScopeMapper.getUserNamespacesFromGroups$lambda$4(this, arg_0), arg_0));
        Stream<String> namespaces = filteredGroups.map(arg_0 -> KeycloakGroupsAndRolesToDockerScopeMapper.getUserNamespacesFromGroups$lambda$7(arg_0 -> KeycloakGroupsAndRolesToDockerScopeMapper.getUserNamespacesFromGroups$lambda$6(this, arg_0), arg_0));
        List<String> list = namespaces.toList();
        Intrinsics.checkNotNullExpressionValue(list, "toList(...)");
        return list;
    }

    private final DockerResponseToken handleNamespaceRepositoryAccess(DockerResponseToken responseToken, AbstractDockerScopeMapper.DockerScopeAccess accessItem, Collection<String> clientRoleNames, UserModel user) {
        List list = accessItem.getActions();
        Intrinsics.checkNotNullExpressionValue(list, "getActions(...)");
        List<String> requestedActions = this.substituteRequestedActions$keycloak_registry_mapper(list);
        List<String> allowedActions = this.filterAllowedActions$keycloak_registry_mapper((Collection<String>)requestedActions, clientRoleNames);
        if (allowedActions.isEmpty()) {
            List list2 = accessItem.getActions();
            Intrinsics.checkNotNullExpressionValue(list2, "getActions(...)");
            String reason = "Missing privileges for actions [" + CollectionsKt.joinToString$default(list2, null, null, null, 0, null, null, 63, null) + "] - check client roles";
            return this.deny$keycloak_registry_mapper(responseToken, accessItem, user, reason);
        }
        if (this.hasAllPrivileges$keycloak_registry_mapper((Collection<String>)allowedActions, (Collection<String>)requestedActions)) {
            String reason = "User has privilege on all actions";
            return this.allowWithActions$keycloak_registry_mapper(responseToken, accessItem, allowedActions, user, reason);
        }
        String reason = "User has privilege only on [" + CollectionsKt.joinToString$default(allowedActions, null, null, null, 0, null, null, 63, null) + "]";
        return this.allowWithActions$keycloak_registry_mapper(responseToken, accessItem, allowedActions, user, reason);
    }

    @NotNull
    public final List<String> filterAllowedActions$keycloak_registry_mapper(@NotNull Collection<String> requestedActions, @NotNull Collection<String> clientRoleNames) {
        Intrinsics.checkNotNullParameter(requestedActions, "requestedActions");
        Intrinsics.checkNotNullParameter(clientRoleNames, "clientRoleNames");
        ArrayList<String> allowedActions = new ArrayList<String>();
        boolean shallAddPrivilegedActions = clientRoleNames.contains("editor") || clientRoleNames.contains("admin");
        Iterable $this$forEach$iv = requestedActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String action = (String)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual("pull", action)) {
                allowedActions.add(action);
            }
            if (Intrinsics.areEqual("push", action) && shallAddPrivilegedActions) {
                allowedActions.add(action);
            }
            if (Intrinsics.areEqual("delete", action) && shallAddPrivilegedActions) {
                allowedActions.add(action);
            }
            if (Intrinsics.areEqual("*", action) && shallAddPrivilegedActions) {
                allowedActions.add(action);
            }
            if (!Intrinsics.areEqual("*", action) || shallAddPrivilegedActions || allowedActions.contains("pull")) continue;
            allowedActions.add("pull");
        }
        return allowedActions;
    }

    private final String getCatalogAudienceFromEnv() {
        String string;
        String string2 = this.getEnvVariable$keycloak_registry_mapper(KEY_REGISTRY_CATALOG_AUDIENCE);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String string3 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            String audienceString = string3;
            string = Intrinsics.areEqual(audienceString, "user") ? "user" : (Intrinsics.areEqual(audienceString, "editor") ? "editor" : "admin");
        } else {
            string = "admin";
        }
        return string;
    }

    private final String getGroupPrefixFromEnv() {
        String string;
        block3: {
            block2: {
                string = this.getEnvVariable$keycloak_registry_mapper(KEY_REGISTRY_GROUP_PREFIX);
                if (string == null) break block2;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                string = string2;
                if (string2 != null) break block3;
            }
            string = DEFAULT_REGISTRY_GROUP_PREFIX;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getNamespaceScopeFromEnv() {
        Object object;
        block7: {
            block6: {
                void $this$filterTo$iv$iv;
                String it;
                Iterable $this$mapTo$iv$iv;
                object = this.getEnvVariable$keycloak_registry_mapper(KEY_REGISTRY_NAMESPACE_SCOPE);
                if (object == null) break block6;
                String scopeString = object;
                boolean bl = false;
                String[] stringArray = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)scopeString, stringArray, false, 0, 6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string2 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                    collection.add(string2);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual(it, NAMESPACE_SCOPE_GROUP) || Intrinsics.areEqual(it, NAMESPACE_SCOPE_USERNAME) || Intrinsics.areEqual(it, NAMESPACE_SCOPE_DOMAIN) || Intrinsics.areEqual(it, NAMESPACE_SCOPE_SLD))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List scopes = (List)destination$iv$iv;
                if (scopes.isEmpty()) {
                    this.getLogger$keycloak_registry_mapper().warn(() -> KeycloakGroupsAndRolesToDockerScopeMapper.getNamespaceScopeFromEnv$lambda$14$lambda$12(scopeString));
                    this.getLogger$keycloak_registry_mapper().warn(KeycloakGroupsAndRolesToDockerScopeMapper::getNamespaceScopeFromEnv$lambda$14$lambda$13);
                }
                Set set = CollectionsKt.toSet(scopes);
                object = set;
                if (set != null) break block7;
            }
            object = NAMESPACE_SCOPE_DEFAULT;
        }
        return object;
    }

    private static final Stream getUserNamespacesFromGroups$lambda$2(GroupModel it) {
        return it.getSubGroupsStream();
    }

    private static final Stream getUserNamespacesFromGroups$lambda$3(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final boolean getUserNamespacesFromGroups$lambda$4(KeycloakGroupsAndRolesToDockerScopeMapper this$0, GroupModel it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return StringsKt.startsWith$default(string2, this$0.groupPrefix, false, 2, null);
    }

    private static final boolean getUserNamespacesFromGroups$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String getUserNamespacesFromGroups$lambda$6(KeycloakGroupsAndRolesToDockerScopeMapper this$0, GroupModel it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return StringsKt.replace$default(string2, this$0.groupPrefix, "", false, 4, null);
    }

    private static final String getUserNamespacesFromGroups$lambda$7(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String getNamespaceScopeFromEnv$lambda$14$lambda$12(String $scopeString) {
        return "Empty or unsupported config values for $REGISTRY_NAMESPACE_SCOPE: " + $scopeString;
    }

    private static final String getNamespaceScopeFromEnv$lambda$14$lambda$13() {
        return "Resetting $REGISTRY_NAMESPACE_SCOPE to default: " + NAMESPACE_SCOPE_DEFAULT;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lde/alexanderwolz/keycloak/docker/mapping/KeycloakGroupsAndRolesToDockerScopeMapper$Companion;", "", "<init>", "()V", "KEY_REGISTRY_GROUP_PREFIX", "", "DEFAULT_REGISTRY_GROUP_PREFIX", "ROLE_USER", "ROLE_EDITOR", "ROLE_ADMIN", "KEY_REGISTRY_CATALOG_AUDIENCE", "AUDIENCE_USER", "AUDIENCE_EDITOR", "AUDIENCE_ADMIN", "KEY_REGISTRY_NAMESPACE_SCOPE", "NAMESPACE_SCOPE_USERNAME", "NAMESPACE_SCOPE_GROUP", "NAMESPACE_SCOPE_DOMAIN", "NAMESPACE_SCOPE_SLD", "NAMESPACE_SCOPE_DEFAULT", "", "getNAMESPACE_SCOPE_DEFAULT$keycloak_registry_mapper", "()Ljava/util/Set;", "keycloak-registry-mapper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getNAMESPACE_SCOPE_DEFAULT$keycloak_registry_mapper() {
            return NAMESPACE_SCOPE_DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

