/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.keycloak.docker.mapping;

import de.alexanderwolz.commons.log.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.docker.mapper.DockerAuthV2ProtocolMapper;
import org.keycloak.representations.docker.DockerAccess;
import org.keycloak.representations.docker.DockerResponseToken;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u0000 F2\u00020\u0001:\u0002FGB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0017J#\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b J\u0017\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\"J\u001d\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b'J\u001d\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b)J\u001d\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b+J)\u0010,\u001a\u00020$2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0000\u00a2\u0006\u0002\b/J)\u00100\u001a\u00020$2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0000\u00a2\u0006\u0002\b1J\u0017\u00102\u001a\u0004\u0018\u00010\u00032\u0006\u00103\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b4J!\u00105\u001a\b\u0012\u0004\u0012\u00020\u0003062\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0000\u00a2\u0006\u0002\b7J-\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b=J;\u0010>\u001a\u0002092\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020\u00152\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u0003062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b@J-\u0010A\u001a\u0002092\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\bBJ\u0017\u0010C\u001a\u0004\u0018\u00010\u00032\u0006\u0010D\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\bER\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006H"}, d2={"Lde/alexanderwolz/keycloak/docker/mapping/AbstractDockerScopeMapper;", "Lorg/keycloak/protocol/docker/mapper/DockerAuthV2ProtocolMapper;", "id", "", "displayType", "helpText", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "logger", "Lde/alexanderwolz/commons/log/Logger;", "getLogger$keycloak_registry_mapper", "()Lde/alexanderwolz/commons/log/Logger;", "getId", "getDisplayType", "getHelpText", "getScopesFromSession", "", "clientSession", "Lorg/keycloak/models/AuthenticatedClientSessionModel;", "getScopesFromSession$keycloak_registry_mapper", "parseScopeIntoAccessItem", "Lde/alexanderwolz/keycloak/docker/mapping/AbstractDockerScopeMapper$DockerScopeAccess;", "scope", "parseScopeIntoAccessItem$keycloak_registry_mapper", "getClientRoleNames", "user", "Lorg/keycloak/models/UserModel;", "client", "Lorg/keycloak/models/ClientModel;", "getClientRoleNames$keycloak_registry_mapper", "getDomainFromEmail", "email", "getDomainFromEmail$keycloak_registry_mapper", "getSecondLevelDomainFromEmail", "getSecondLevelDomainFromEmail$keycloak_registry_mapper", "isUsernameRepository", "", "namespace", "username", "isUsernameRepository$keycloak_registry_mapper", "isDomainRepository", "isDomainRepository$keycloak_registry_mapper", "isSecondLevelDomainRepository", "isSecondLevelDomainRepository$keycloak_registry_mapper", "hasAllPrivileges", "actions", "requestedActions", "hasAllPrivileges$keycloak_registry_mapper", "isSubstituteWithActionAll", "isSubstituteWithActionAll$keycloak_registry_mapper", "getNamespaceFromRepositoryName", "repositoryName", "getNamespaceFromRepositoryName$keycloak_registry_mapper", "substituteRequestedActions", "", "substituteRequestedActions$keycloak_registry_mapper", "allowAll", "Lorg/keycloak/representations/docker/DockerResponseToken;", "responseToken", "accessItem", "reason", "allowAll$keycloak_registry_mapper", "allowWithActions", "allowedActions", "allowWithActions$keycloak_registry_mapper", "deny", "deny$keycloak_registry_mapper", "getEnvVariable", "key", "getEnvVariable$keycloak_registry_mapper", "Companion", "DockerScopeAccess", "keycloak-registry-mapper"})
public abstract class AbstractDockerScopeMapper
extends DockerAuthV2ProtocolMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String displayType;
    @NotNull
    private final String helpText;
    @NotNull
    private final Logger logger;
    @NotNull
    public static final String NAME_CATALOG = "catalog";
    @NotNull
    public static final String ACTION_PULL = "pull";
    @NotNull
    public static final String ACTION_PUSH = "push";
    @NotNull
    public static final String ACTION_DELETE = "delete";
    @NotNull
    public static final String ACTION_ALL = "*";
    @NotNull
    private static final List<String> ACTION_ALL_SUBSTITUTE;
    @NotNull
    public static final String ACCESS_TYPE_REGISTRY = "registry";
    @NotNull
    public static final String ACCESS_TYPE_REPOSITORY = "repository";
    @NotNull
    public static final String ACCESS_TYPE_REPOSITORY_PLUGIN = "repository(plugin)";

    public AbstractDockerScopeMapper(@NotNull String id, @NotNull String displayType, @NotNull String helpText) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(displayType, "displayType");
        Intrinsics.checkNotNullParameter(helpText, "helpText");
        this.id = id;
        this.displayType = displayType;
        this.helpText = helpText;
        this.logger = new Logger(((Object)((Object)this)).getClass(), null, 2, null);
    }

    @NotNull
    public final Logger getLogger$keycloak_registry_mapper() {
        return this.logger;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getDisplayType() {
        return this.displayType;
    }

    @NotNull
    public String getHelpText() {
        return this.helpText;
    }

    @NotNull
    public final Collection<String> getScopesFromSession$keycloak_registry_mapper(@NotNull AuthenticatedClientSessionModel clientSession) {
        String[] stringArray;
        Object object;
        Intrinsics.checkNotNullParameter(clientSession, "clientSession");
        String scopeString = clientSession.getNote("scope");
        if (this.logger.isDebugEnabled() && (scopeString == null || ((CharSequence)scopeString).length() == 0)) {
            this.logger.debug(AbstractDockerScopeMapper::getScopesFromSession$lambda$0);
        }
        return (object = scopeString) != null && (object = StringsKt.split$default((CharSequence)object, stringArray = new String[]{" "}, false, 0, 6, null)) != null ? (Collection)object : (Collection)SetsKt.emptySet();
    }

    @Nullable
    public final DockerScopeAccess parseScopeIntoAccessItem$keycloak_registry_mapper(@NotNull String scope) {
        DockerScopeAccess dockerScopeAccess;
        Intrinsics.checkNotNullParameter(scope, "scope");
        try {
            DockerScopeAccess accessItem = new DockerScopeAccess(scope);
            this.logger.trace(() -> AbstractDockerScopeMapper.parseScopeIntoAccessItem$lambda$1(scope, accessItem));
        }
        catch (Exception e) {
            this.logger.warn(() -> AbstractDockerScopeMapper.parseScopeIntoAccessItem$lambda$2(scope, e));
            dockerScopeAccess = null;
        }
        return dockerScopeAccess;
    }

    @NotNull
    public final Collection<String> getClientRoleNames$keycloak_registry_mapper(@NotNull UserModel user, @NotNull ClientModel client) {
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(client, "client");
        List<String> list = user.getClientRoleMappingsStream(client).map(arg_0 -> AbstractDockerScopeMapper.getClientRoleNames$lambda$4(AbstractDockerScopeMapper::getClientRoleNames$lambda$3, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, "toList(...)");
        return list;
    }

    @Nullable
    public final String getDomainFromEmail$keycloak_registry_mapper(@NotNull String email) {
        String domain;
        Intrinsics.checkNotNullParameter(email, "email");
        String[] stringArray = new String[]{"@"};
        List parts = StringsKt.split$default((CharSequence)email, stringArray, false, 0, 6, null);
        if (parts.size() == 2 && ((CharSequence)(domain = (String)CollectionsKt.last(parts))).length() > 0) {
            return domain;
        }
        return null;
    }

    @Nullable
    public final String getSecondLevelDomainFromEmail$keycloak_registry_mapper(@NotNull String email) {
        String sld;
        Intrinsics.checkNotNullParameter(email, "email");
        String string = this.getDomainFromEmail$keycloak_registry_mapper(email);
        if (string == null) {
            return null;
        }
        String domain = string;
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)domain, stringArray, false, 0, 6, null);
        if (parts.size() > 1 && ((CharSequence)(sld = (String)parts.get(parts.size() - 2))).length() > 0) {
            return sld;
        }
        return null;
    }

    public final boolean isUsernameRepository$keycloak_registry_mapper(@NotNull String namespace, @NotNull String username) {
        Intrinsics.checkNotNullParameter(namespace, "namespace");
        Intrinsics.checkNotNullParameter(username, "username");
        String string = username.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return Intrinsics.areEqual(namespace, string);
    }

    public final boolean isDomainRepository$keycloak_registry_mapper(@NotNull String namespace, @NotNull String email) {
        Intrinsics.checkNotNullParameter(namespace, "namespace");
        Intrinsics.checkNotNullParameter(email, "email");
        return Intrinsics.areEqual(namespace, this.getDomainFromEmail$keycloak_registry_mapper(email));
    }

    public final boolean isSecondLevelDomainRepository$keycloak_registry_mapper(@NotNull String namespace, @NotNull String email) {
        Intrinsics.checkNotNullParameter(namespace, "namespace");
        Intrinsics.checkNotNullParameter(email, "email");
        return Intrinsics.areEqual(namespace, this.getSecondLevelDomainFromEmail$keycloak_registry_mapper(email));
    }

    public final boolean hasAllPrivileges$keycloak_registry_mapper(@NotNull Collection<String> actions, @NotNull Collection<String> requestedActions) {
        Intrinsics.checkNotNullParameter(actions, "actions");
        Intrinsics.checkNotNullParameter(requestedActions, "requestedActions");
        return this.isSubstituteWithActionAll$keycloak_registry_mapper(actions, requestedActions) || actions.containsAll(requestedActions);
    }

    public final boolean isSubstituteWithActionAll$keycloak_registry_mapper(@NotNull Collection<String> actions, @NotNull Collection<String> requestedActions) {
        Intrinsics.checkNotNullParameter(actions, "actions");
        Intrinsics.checkNotNullParameter(requestedActions, "requestedActions");
        return requestedActions.size() == 1 && Intrinsics.areEqual(CollectionsKt.first((Iterable)requestedActions), ACTION_ALL) && actions.containsAll((Collection)ACTION_ALL_SUBSTITUTE);
    }

    @Nullable
    public final String getNamespaceFromRepositoryName$keycloak_registry_mapper(@NotNull String repositoryName) {
        Intrinsics.checkNotNullParameter(repositoryName, "repositoryName");
        String[] stringArray = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)repositoryName, stringArray, false, 0, 6, null);
        if (parts.size() > 1) {
            String string = ((String)parts.get(0)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            return string;
        }
        return null;
    }

    @NotNull
    public final List<String> substituteRequestedActions$keycloak_registry_mapper(@NotNull Collection<String> requestedActions) {
        HashSet<String> hashSet;
        Intrinsics.checkNotNullParameter(requestedActions, "requestedActions");
        HashSet<String> actions = hashSet = new HashSet<String>(requestedActions);
        boolean bl = false;
        if (actions.contains(ACTION_ALL)) {
            actions.remove(ACTION_ALL);
            actions.addAll((Collection<String>)ACTION_ALL_SUBSTITUTE);
        }
        return CollectionsKt.toList((Iterable)hashSet);
    }

    @NotNull
    public final DockerResponseToken allowAll$keycloak_registry_mapper(@NotNull DockerResponseToken responseToken, @NotNull DockerScopeAccess accessItem, @NotNull UserModel user, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(responseToken, "responseToken");
        Intrinsics.checkNotNullParameter((Object)accessItem, "accessItem");
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(reason, "reason");
        this.logger.debug(() -> AbstractDockerScopeMapper.allowAll$lambda$6(user, accessItem, reason));
        responseToken.getAccessItems().add(accessItem);
        return responseToken;
    }

    @NotNull
    public final DockerResponseToken allowWithActions$keycloak_registry_mapper(@NotNull DockerResponseToken responseToken, @NotNull DockerScopeAccess accessItem, @NotNull List<String> allowedActions, @NotNull UserModel user, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(responseToken, "responseToken");
        Intrinsics.checkNotNullParameter((Object)accessItem, "accessItem");
        Intrinsics.checkNotNullParameter(allowedActions, "allowedActions");
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(reason, "reason");
        this.logger.debug(() -> AbstractDockerScopeMapper.allowWithActions$lambda$7(user, accessItem, reason));
        accessItem.setActions(allowedActions);
        responseToken.getAccessItems().add(accessItem);
        return responseToken;
    }

    @NotNull
    public final DockerResponseToken deny$keycloak_registry_mapper(@NotNull DockerResponseToken responseToken, @NotNull DockerScopeAccess accessItem, @NotNull UserModel user, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(responseToken, "responseToken");
        Intrinsics.checkNotNullParameter((Object)accessItem, "accessItem");
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(reason, "reason");
        this.logger.warn(() -> AbstractDockerScopeMapper.deny$lambda$8(user, accessItem, reason));
        return responseToken;
    }

    @Nullable
    public final String getEnvVariable$keycloak_registry_mapper(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter(key, "key");
        try {
            string = System.getenv().get(key);
        }
        catch (Exception e) {
            this.logger.error(e, AbstractDockerScopeMapper::getEnvVariable$lambda$9);
            string = null;
        }
        return string;
    }

    private static final String getScopesFromSession$lambda$0() {
        return "Session does not contain a scope, ignoring further access check";
    }

    private static final String parseScopeIntoAccessItem$lambda$1(String $scope, DockerScopeAccess $accessItem) {
        return "Parsed scope '" + $scope + "' into: " + $accessItem;
    }

    private static final String parseScopeIntoAccessItem$lambda$2(String $scope, Exception $e) {
        return "Could not parse scope '" + $scope + "' into access object: " + $e.getMessage();
    }

    private static final String getClientRoleNames$lambda$3(RoleModel it) {
        return it.getName();
    }

    private static final String getClientRoleNames$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String allowAll$lambda$6(UserModel $user, DockerScopeAccess $accessItem, String $reason) {
        return "Granting access for user '" + $user.getUsername() + "' on scope '" + $accessItem.getScope() + "': " + $reason;
    }

    private static final String allowWithActions$lambda$7(UserModel $user, DockerScopeAccess $accessItem, String $reason) {
        return "Granting access for user '" + $user.getUsername() + "' on scope '" + $accessItem.getScope() + "': " + $reason;
    }

    private static final String deny$lambda$8(UserModel $user, DockerScopeAccess $accessItem, String $reason) {
        return "Access denied for user '" + $user.getUsername() + "' on scope '" + $accessItem.getScope() + "': " + $reason;
    }

    private static final String getEnvVariable$lambda$9() {
        return "Could not access System Environment";
    }

    static {
        String[] stringArray = new String[]{ACTION_PULL, ACTION_PUSH, ACTION_DELETE};
        ACTION_ALL_SUBSTITUTE = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/alexanderwolz/keycloak/docker/mapping/AbstractDockerScopeMapper$Companion;", "", "<init>", "()V", "NAME_CATALOG", "", "ACTION_PULL", "ACTION_PUSH", "ACTION_DELETE", "ACTION_ALL", "ACTION_ALL_SUBSTITUTE", "", "getACTION_ALL_SUBSTITUTE", "()Ljava/util/List;", "ACCESS_TYPE_REGISTRY", "ACCESS_TYPE_REPOSITORY", "ACCESS_TYPE_REPOSITORY_PLUGIN", "keycloak-registry-mapper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getACTION_ALL_SUBSTITUTE() {
            return ACTION_ALL_SUBSTITUTE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/alexanderwolz/keycloak/docker/mapping/AbstractDockerScopeMapper$DockerScopeAccess;", "Lorg/keycloak/representations/docker/DockerAccess;", "scope", "", "<init>", "(Ljava/lang/String;)V", "getScope", "()Ljava/lang/String;", "keycloak-registry-mapper"})
    public static final class DockerScopeAccess
    extends DockerAccess {
        @NotNull
        private final String scope;

        public DockerScopeAccess(@NotNull String scope) {
            Intrinsics.checkNotNullParameter(scope, "scope");
            super(scope);
            this.scope = scope;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }
    }
}

