/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.util.stream;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lde/alexanderwolz/commons/util/stream/StreamUtils;", "", "<init>", "()V", "convertToString", "", "stream", "Ljava/io/InputStream;", "convertToJavaStream", "Ljava/util/stream/Stream;", "commons-util"})
public final class StreamUtils {
    @NotNull
    public static final StreamUtils INSTANCE = new StreamUtils();

    private StreamUtils() {
    }

    @NotNull
    public final String convertToString(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        String string = this.convertToJavaStream(stream).collect(Collectors.joining("\n"));
        Intrinsics.checkNotNullExpressionValue(string, "collect(...)");
        return string;
    }

    @NotNull
    public final Stream<String> convertToJavaStream(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Stream<String> stream2 = new BufferedReader(new InputStreamReader(stream)).lines();
        Intrinsics.checkNotNullExpressionValue(stream2, "lines(...)");
        return stream2;
    }
}

