/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.util.certificate;

import de.alexanderwolz.commons.log.Logger;
import de.alexanderwolz.commons.util.string.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0005J%\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0019\u001a\u00020\u00102\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0016\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0017J\u000e\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J\u001a\u0010(\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0010J$\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140+2\u0006\u0010,\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020.J(\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020.R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lde/alexanderwolz/commons/util/certificate/CertificateUtils;", "", "<init>", "()V", "HEADER_PRIVATE_KEY", "", "FOOTER_PRIVATE_KEY", "HEADER_EC_PRIVATE_KEY", "FOOTER_EC_PRIVATE_KEY", "HEADER_CERTIFICATE", "FOOTER_CERTIFICATE", "logger", "Lde/alexanderwolz/commons/log/Logger;", "readPrivateKey", "Ljava/security/PrivateKey;", "file", "Ljava/io/File;", "pem", "readCertificates", "", "Ljava/security/cert/X509Certificate;", "binaries", "", "", "([[B)Ljava/util/List;", "folder", "fileNames", "(Ljava/io/File;[Ljava/lang/String;)Ljava/util/List;", "addCertificateHeaders", "base64", "addPrivateKeyHeaders", "encodePrivateKeyToPem", "privateKey", "encodePrivateKeyToBase64", "removeHeadersAndFooters", "getPrivateKey", "isEllipticCurve", "", "decodePem", "encoded", "resolveKeyPairFile", "certFolder", "generateNewCertificatePair", "Lkotlin/Pair;", "subjectText", "serial", "Ljava/math/BigInteger;", "writeNewCertPair", "", "keyFile", "certFile", "subject", "commons-util"})
@SourceDebugExtension(value={"SMAP\nCertificateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateUtils.kt\nde/alexanderwolz/commons/util/certificate/CertificateUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n13472#2,2:272\n11228#2:277\n11563#2,3:278\n1878#3,3:274\n1878#3,2:281\n1878#3,3:283\n1880#3:286\n*S KotlinDebug\n*F\n+ 1 CertificateUtils.kt\nde/alexanderwolz/commons/util/certificate/CertificateUtils\n*L\n75#1:272,2\n112#1:277\n112#1:278,3\n86#1:274,3\n115#1:281,2\n127#1:283,3\n115#1:286\n*E\n"})
public final class CertificateUtils {
    @NotNull
    public static final CertificateUtils INSTANCE = new CertificateUtils();
    @NotNull
    private static final String HEADER_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    @NotNull
    private static final String FOOTER_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    @NotNull
    private static final String HEADER_EC_PRIVATE_KEY = "-----BEGIN EC PRIVATE KEY-----";
    @NotNull
    private static final String FOOTER_EC_PRIVATE_KEY = "-----END EC PRIVATE KEY-----";
    @NotNull
    private static final String HEADER_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    @NotNull
    private static final String FOOTER_CERTIFICATE = "-----END CERTIFICATE-----";
    @NotNull
    private static final Logger logger = new Logger(INSTANCE.getClass(), null, 2, null);

    private CertificateUtils() {
    }

    @NotNull
    public final PrivateKey readPrivateKey(@NotNull File file) {
        PrivateKey privateKey;
        Intrinsics.checkNotNullParameter(file, "file");
        PrivateKey it = privateKey = this.getPrivateKey(FilesKt.readText(file, Charsets.UTF_8));
        boolean bl = false;
        logger.debug(() -> CertificateUtils.readPrivateKey$lambda$1$lambda$0(file, it));
        return privateKey;
    }

    @NotNull
    public final PrivateKey readPrivateKey(@NotNull String pem) {
        PrivateKey privateKey;
        Intrinsics.checkNotNullParameter(pem, "pem");
        PrivateKey it = privateKey = this.getPrivateKey(pem);
        boolean bl = false;
        logger.debug(() -> CertificateUtils.readPrivateKey$lambda$3$lambda$2(it));
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<X509Certificate> readCertificates(byte[] ... binaries) {
        Object object;
        Intrinsics.checkNotNullParameter(binaries, "binaries");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        Object[] $this$forEach$iv = (Object[])binaries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] binary = (byte[])element$iv;
            boolean bl = false;
            object = new ByteArrayInputStream(binary);
            Throwable throwable = null;
            try {
                Object it = (ByteArrayInputStream)object;
                boolean bl2 = false;
                while (((ByteArrayInputStream)it).available() > 0) {
                    Certificate certificate = cf.generateCertificate((InputStream)it);
                    Intrinsics.checkNotNull(certificate, "null cannot be cast to non-null type java.security.cert.X509Certificate");
                    X509Certificate certificate2 = (X509Certificate)certificate;
                    certificates.add(certificate2);
                }
                it = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        StringBuilder builder = new StringBuilder("Successfully loaded certificate(s):");
        Iterable $this$forEachIndexed$iv = certificates;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void certificate;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (X509Certificate)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                builder.append("\n  --------------------------------------------------------");
            }
            builder.append("\n  Subject: \t\t" + certificate.getSubjectX500Principal());
            if (!Intrinsics.areEqual(certificate.getSubjectX500Principal(), certificate.getIssuerX500Principal())) {
                builder.append("\n  Issuer: \t\t" + certificate.getIssuerX500Principal());
            }
            builder.append("\n  Type:\t\t\t" + certificate.getType());
            builder.append("\n  Algorithm:\t" + certificate.getSigAlgName());
            builder.append("\n  Valid From: \t" + certificate.getNotBefore());
            builder.append("\n  Valid To: \t" + certificate.getNotAfter());
        }
        logger.debug(() -> CertificateUtils.readCertificates$lambda$7(builder));
        return certificates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<X509Certificate> readCertificates(@NotNull File folder, String ... fileNames) {
        ArrayList arrayList;
        int n;
        List list;
        Intrinsics.checkNotNullParameter(folder, "folder");
        Intrinsics.checkNotNullParameter(fileNames, "fileNames");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList allCertificates = new ArrayList();
        StringBuilder builder = new StringBuilder("Successfully loaded certificate(s):");
        if (fileNames.length == 0) {
            list = CollectionsKt.listOf(folder);
        } else {
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = fileNames;
            boolean $i$f$map = false;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (n = 0; n < n2; ++n) {
                void it;
                void item$iv$iv;
                void var15_19 = item$iv$iv = $this$mapTo$iv$iv[n];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File(folder, (String)it));
            }
            list = (List)destination$iv$iv;
        }
        List files = list;
        Iterable $this$forEachIndexed$iv = files;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void file;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            File file2 = (File)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                builder.append("\n    --------------------------------------------");
            }
            Closeable closeable = new FileInputStream((File)file);
            int n3 = 8192;
            closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n3);
            Throwable throwable = null;
            try {
                BufferedInputStream it = (BufferedInputStream)closeable;
                boolean bl2 = false;
                ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
                builder.append("\n  File: \t\t" + file.getName());
                while (it.available() > 0) {
                    Certificate certificate = cf.generateCertificate(it);
                    Intrinsics.checkNotNull(certificate, "null cannot be cast to non-null type java.security.cert.X509Certificate");
                    X509Certificate certificate2 = (X509Certificate)certificate;
                    certificates.add(certificate2);
                }
                allCertificates.addAll(certificates);
                Iterable $this$forEachIndexed$iv2 = certificates;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    void certificate;
                    int n4;
                    if ((n4 = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    X509Certificate x509Certificate = (X509Certificate)item$iv2;
                    int index2 = n4;
                    boolean bl3 = false;
                    if (index2 > 0) {
                        builder.append("\n  --------------------------------------------------------");
                    }
                    builder.append("\n  Subject: \t\t" + certificate.getSubjectX500Principal());
                    if (!Intrinsics.areEqual(certificate.getSubjectX500Principal(), certificate.getIssuerX500Principal())) {
                        builder.append("\n  Issuer: \t\t" + certificate.getIssuerX500Principal());
                    }
                    builder.append("\n  Type:\t\t\t" + certificate.getType());
                    builder.append("\n  Algorithm:\t" + certificate.getSigAlgName());
                    builder.append("\n  Valid From: \t" + certificate.getNotBefore());
                    builder.append("\n  Valid To: \t" + certificate.getNotAfter());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        ArrayList it = arrayList = allCertificates;
        boolean bl = false;
        logger.trace(() -> CertificateUtils.readCertificates$lambda$13$lambda$12(builder));
        return arrayList;
    }

    @NotNull
    public final String addCertificateHeaders(@NotNull String base64) {
        Intrinsics.checkNotNullParameter(base64, "base64");
        return "-----BEGIN CERTIFICATE-----\n" + base64 + "\n-----END CERTIFICATE-----";
    }

    @NotNull
    public final String addPrivateKeyHeaders(@NotNull String base64) {
        Intrinsics.checkNotNullParameter(base64, "base64");
        return "-----BEGIN PRIVATE KEY-----\n" + base64 + "\n-----END PRIVATE KEY-----";
    }

    @NotNull
    public final String encodePrivateKeyToPem(@NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter(privateKey, "privateKey");
        String base64 = this.encodePrivateKeyToBase64(privateKey);
        return this.addPrivateKeyHeaders(base64);
    }

    @NotNull
    public final String encodePrivateKeyToBase64(@NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter(privateKey, "privateKey");
        byte[] byArray = privateKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue(byArray, "getEncoded(...)");
        return StringUtils.INSTANCE.toBase64(byArray);
    }

    @NotNull
    public final String addPrivateKeyHeaders(@NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter(privateKey, "privateKey");
        return this.addPrivateKeyHeaders(this.encodePrivateKeyToBase64(privateKey));
    }

    @NotNull
    public final String removeHeadersAndFooters(@NotNull String pem) {
        Intrinsics.checkNotNullParameter(pem, "pem");
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue(string, "lineSeparator(...)");
        String string2 = StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(pem, string, "", false, 4, null), "", "", false, 4, null), HEADER_PRIVATE_KEY, "", false, 4, null), FOOTER_PRIVATE_KEY, "", false, 4, null), HEADER_EC_PRIVATE_KEY, "", false, 4, null), FOOTER_EC_PRIVATE_KEY, "", false, 4, null), HEADER_CERTIFICATE, "", false, 4, null), FOOTER_CERTIFICATE, "", false, 4, null);
        String string3 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue(string3, "lineSeparator(...)");
        String plain = StringsKt.replace$default(StringsKt.replace$default(string2, string3, "", false, 4, null), "\n", "", false, 4, null);
        return plain;
    }

    @NotNull
    public final PrivateKey getPrivateKey(@NotNull String pem) {
        Intrinsics.checkNotNullParameter(pem, "pem");
        if (this.isEllipticCurve(pem)) {
            Object parsedPem = new PEMParser((Reader)new StringReader(pem)).readObject();
            if (parsedPem instanceof PEMKeyPair) {
                PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(((PEMKeyPair)parsedPem).getPrivateKeyInfo());
                Intrinsics.checkNotNullExpressionValue(privateKey, "getPrivateKey(...)");
                return privateKey;
            }
            throw new IllegalArgumentException("Unsupported PEM type: " + parsedPem);
        }
        byte[] encoded = Base64.getDecoder().decode(this.removeHeadersAndFooters(pem));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        Intrinsics.checkNotNullExpressionValue(privateKey, "generatePrivate(...)");
        return privateKey;
    }

    public final boolean isEllipticCurve(@NotNull String pem) {
        Intrinsics.checkNotNullParameter(pem, "pem");
        return StringsKt.startsWith$default(pem, HEADER_EC_PRIVATE_KEY, false, 2, null);
    }

    @NotNull
    public final String decodePem(@NotNull byte[] encoded) {
        Intrinsics.checkNotNullParameter(encoded, "encoded");
        byte[] byArray = Base64.getDecoder().decode(encoded);
        Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
        return StringsKt.decodeToString(byArray);
    }

    @NotNull
    public final String decodePem(@NotNull String encoded) {
        Intrinsics.checkNotNullParameter(encoded, "encoded");
        byte[] byArray = Base64.getDecoder().decode(encoded);
        Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
        return StringsKt.decodeToString(byArray);
    }

    @NotNull
    public final File resolveKeyPairFile(@NotNull File file, @Nullable File certFolder) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (file.exists()) {
            return file;
        }
        File file2 = certFolder;
        if (file2 != null) {
            File file3;
            File file4;
            File it = file2;
            boolean bl = false;
            File it2 = file4 = new File(certFolder, file.getPath());
            boolean bl2 = false;
            if (it2.exists()) {
                logger.trace(() -> CertificateUtils.resolveKeyPairFile$lambda$18$lambda$15$lambda$14(it2));
                return it2;
            }
            File root = new File("").getAbsoluteFile();
            File it3 = file3 = new File(root, certFolder.getPath() + "/" + file.getPath());
            boolean bl3 = false;
            if (it3.exists()) {
                logger.trace(() -> CertificateUtils.resolveKeyPairFile$lambda$18$lambda$17$lambda$16(it3));
                return it3;
            }
        }
        throw new NoSuchElementException("Could not resolve file: " + file.getPath());
    }

    public static /* synthetic */ File resolveKeyPairFile$default(CertificateUtils certificateUtils, File file, File file2, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        return certificateUtils.resolveKeyPairFile(file, file2);
    }

    @NotNull
    public final Pair<PrivateKey, X509Certificate> generateNewCertificatePair(@NotNull String subjectText, @NotNull BigInteger serial) {
        Calendar calendar;
        KeyPairGenerator keyPairGenerator;
        Intrinsics.checkNotNullParameter(subjectText, "subjectText");
        Intrinsics.checkNotNullParameter(serial, "serial");
        KeyPairGenerator $this$generateNewCertificatePair_u24lambda_u2419 = keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        boolean bl = false;
        $this$generateNewCertificatePair_u24lambda_u2419.initialize(new RSAKeyGenParameterSpec(2048, BigInteger.valueOf(65537L)));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkNotNull(privateKey, "null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
        RSAPrivateKey privateKey2 = (RSAPrivateKey)privateKey;
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkNotNull(publicKey, "null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        RSAPublicKey publicKey2 = (RSAPublicKey)publicKey;
        X500Name subject = new X500Name(new X500Principal(subjectText).getName());
        Date notBefore = new Date();
        Calendar $this$generateNewCertificatePair_u24lambda_u2420 = calendar = Calendar.getInstance();
        boolean bl2 = false;
        $this$generateNewCertificatePair_u24lambda_u2420.setTime(notBefore);
        $this$generateNewCertificatePair_u24lambda_u2420.add(1, 3);
        Calendar calendar2 = calendar;
        Date notAfter = calendar2.getTime();
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)((AsymmetricKeyParameter)new RSAKeyParameters(false, publicKey2.getModulus(), publicKey2.getPublicExponent())));
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA1withRSA").build((PrivateKey)privateKey2);
        X509CertificateHolder holder = new X509v1CertificateBuilder(subject, serial, notBefore, notAfter, subject, publicKeyInfo).build(contentSigner);
        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(holder);
        return new Pair<PrivateKey, X509Certificate>(privateKey2, certificate);
    }

    public static /* synthetic */ Pair generateNewCertificatePair$default(CertificateUtils certificateUtils, String string, BigInteger bigInteger, int n, Object object) {
        if ((n & 2) != 0) {
            BigInteger bigInteger2 = BigInteger.ZERO;
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "ZERO");
            bigInteger = bigInteger2;
        }
        return certificateUtils.generateNewCertificatePair(string, bigInteger);
    }

    public final void writeNewCertPair(@NotNull File keyFile, @NotNull File certFile, @NotNull String subject, @NotNull BigInteger serial) {
        File file;
        Intrinsics.checkNotNullParameter(keyFile, "keyFile");
        Intrinsics.checkNotNullParameter(certFile, "certFile");
        Intrinsics.checkNotNullParameter(subject, "subject");
        Intrinsics.checkNotNullParameter(serial, "serial");
        Pair<PrivateKey, X509Certificate> pair = this.generateNewCertificatePair(subject, serial);
        File $this$writeNewCertPair_u24lambda_u2421 = file = keyFile;
        boolean bl = false;
        FilesKt.writeText$default($this$writeNewCertPair_u24lambda_u2421, INSTANCE.addPrivateKeyHeaders(pair.getFirst()), null, 2, null);
        File $this$writeNewCertPair_u24lambda_u2422 = file = certFile;
        boolean bl2 = false;
        byte[] byArray = Base64.getEncoder().encode(pair.getSecond().getEncoded());
        Intrinsics.checkNotNullExpressionValue(byArray, "encode(...)");
        String pem = StringsKt.decodeToString(byArray);
        FilesKt.writeText$default($this$writeNewCertPair_u24lambda_u2422, INSTANCE.addCertificateHeaders(pem), null, 2, null);
    }

    public static /* synthetic */ void writeNewCertPair$default(CertificateUtils certificateUtils, File file, File file2, String string, BigInteger bigInteger, int n, Object object) {
        if ((n & 8) != 0) {
            BigInteger bigInteger2 = BigInteger.ZERO;
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "ZERO");
            bigInteger = bigInteger2;
        }
        certificateUtils.writeNewCertPair(file, file2, string, bigInteger);
    }

    private static final String readPrivateKey$lambda$1$lambda$0(File $file, PrivateKey $it) {
        StringBuilder builder = new StringBuilder("Successfully loaded private key:");
        builder.append("\n  File: \t\t" + $file.getName());
        builder.append("\n  Format:\t\t" + $it.getFormat());
        builder.append("\n  Algorithm:\t" + $it.getAlgorithm());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final String readPrivateKey$lambda$3$lambda$2(PrivateKey $it) {
        StringBuilder builder = new StringBuilder("Successfully loaded private key:");
        builder.append("\n  Format:\t\t" + $it.getFormat());
        builder.append("\n  Algorithm:\t" + $it.getAlgorithm());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final String readCertificates$lambda$7(StringBuilder $builder) {
        String string = $builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final String readCertificates$lambda$13$lambda$12(StringBuilder $builder) {
        String string = $builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final String resolveKeyPairFile$lambda$18$lambda$15$lambda$14(File $it) {
        return "Found specified file in certificate folder: " + $it.getPath();
    }

    private static final String resolveKeyPairFile$lambda$18$lambda$17$lambda$16(File $it) {
        return "Found specified file in certificate folder: " + $it.getPath();
    }
}

