/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.log;

import de.alexanderwolz.commons.log.Event;
import de.alexanderwolz.commons.log.Level;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B6\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012%\b\u0002\u0010\u0004\u001a\u001f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fB<\b\u0016\u0012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u0012%\b\u0002\u0010\u0004\u001a\u001f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\u000fB<\b\u0016\u0012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0010\u0012%\b\u0002\u0010\u0004\u001a\u001f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\u0011B8\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0012\u0012%\b\u0002\u0010\u0004\u001a\u001f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\u0013J)\u0010\u0017\u001a\u00020\n2!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005J)\u0010\u0019\u001a\u00020\n2!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005J\b\u0010(\u001a\u00020%H\u0002J\u0014\u0010)\u001a\u00020\n2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+J\u0014\u0010,\u001a\u00020\n2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+J\u0014\u0010-\u001a\u00020\n2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+J\u0014\u0010.\u001a\u00020\n2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+J\u0014\u0010/\u001a\u00020\n2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+J\u000e\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u000201J\u001e\u0010/\u001a\u00020\n2\b\u00100\u001a\u0004\u0018\u0001012\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\u0014\u001aH\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u00050\u0015j#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010 \u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0019\u0010\b\u001a\n !*\u0004\u0018\u00010\u00120\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00062"}, d2={"Lde/alexanderwolz/commons/log/Logger;", "", "logger", "Lorg/slf4j/Logger;", "eventListener", "Lkotlin/Function1;", "Lde/alexanderwolz/commons/log/Event;", "Lkotlin/ParameterName;", "name", "event", "", "<init>", "(Lorg/slf4j/Logger;Lkotlin/jvm/functions/Function1;)V", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function1;)V", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "eventListeners", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addEventListener", "listener", "removeEventListener", "isTraceEnabled", "", "()Z", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "kotlin.jvm.PlatformType", "getName", "()Ljava/lang/String;", "level", "Lde/alexanderwolz/commons/log/Level;", "getLevel", "()Lde/alexanderwolz/commons/log/Level;", "retrieveLevel", "trace", "message", "Lkotlin/Function0;", "debug", "info", "warn", "error", "throwable", "", "commons-log"})
@SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\nde/alexanderwolz/commons/log/Logger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1#2:145\n1869#3,2:146\n1869#3,2:148\n1869#3,2:150\n1869#3,2:152\n1869#3,2:154\n1869#3,2:156\n*S KotlinDebug\n*F\n+ 1 Logger.kt\nde/alexanderwolz/commons/log/Logger\n*L\n64#1:146,2\n77#1:148,2\n90#1:150,2\n104#1:152,2\n117#1:154,2\n136#1:156,2\n*E\n"})
public final class Logger {
    @NotNull
    private final org.slf4j.Logger logger;
    @NotNull
    private final ArrayList<Function1<Event, Unit>> eventListeners;
    private final boolean isTraceEnabled;
    private final boolean isDebugEnabled;
    private final boolean isInfoEnabled;
    private final boolean isWarnEnabled;
    private final boolean isErrorEnabled;
    private final String name;

    /*
     * WARNING - void declaration
     */
    public Logger(@NotNull org.slf4j.Logger logger, @Nullable Function1<? super Event, Unit> eventListener) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.logger = logger;
        ArrayList arrayList2 = arrayList = new ArrayList();
        Logger logger2 = this;
        boolean bl = false;
        Function1<? super Event, Unit> function1 = eventListener;
        if (function1 != null) {
            void $this$eventListeners_u24lambda_u241;
            Function1<? super Event, Unit> it = function1;
            boolean bl2 = false;
            $this$eventListeners_u24lambda_u241.add(it);
        }
        logger2.eventListeners = arrayList;
        this.isTraceEnabled = this.logger.isTraceEnabled();
        this.isDebugEnabled = this.logger.isDebugEnabled();
        this.isInfoEnabled = this.logger.isInfoEnabled();
        this.isWarnEnabled = this.logger.isWarnEnabled();
        this.isErrorEnabled = this.logger.isErrorEnabled();
        this.name = this.logger.getName();
    }

    public /* synthetic */ Logger(org.slf4j.Logger logger, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(logger, (Function1<? super Event, Unit>)function1);
    }

    public Logger(@NotNull Class<?> clazz, @Nullable Function1<? super Event, Unit> eventListener) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        org.slf4j.Logger logger = LoggerFactory.getLogger(clazz);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this(logger, eventListener);
    }

    public /* synthetic */ Logger(Class clazz, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(clazz, (Function1<? super Event, Unit>)function1);
    }

    public Logger(@NotNull KClass<?> clazz, @Nullable Function1<? super Event, Unit> eventListener) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        org.slf4j.Logger logger = LoggerFactory.getLogger(JvmClassMappingKt.getJavaClass(clazz));
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this(logger, eventListener);
    }

    public /* synthetic */ Logger(KClass kClass, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(kClass, (Function1<? super Event, Unit>)function1);
    }

    public Logger(@NotNull String name, @Nullable Function1<? super Event, Unit> eventListener) {
        Intrinsics.checkNotNullParameter(name, "name");
        org.slf4j.Logger logger = LoggerFactory.getLogger(name);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this(logger, eventListener);
    }

    public /* synthetic */ Logger(String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(string, (Function1<? super Event, Unit>)function1);
    }

    public final void addEventListener(@NotNull Function1<? super Event, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.eventListeners.add(listener);
    }

    public final void removeEventListener(@NotNull Function1<? super Event, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.eventListeners.remove(listener);
    }

    public final boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    public final boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public final boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    public final boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    public final boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Level getLevel() {
        return this.retrieveLevel();
    }

    private final Level retrieveLevel() {
        if (this.isTraceEnabled) {
            return Level.TRACE;
        }
        if (this.isDebugEnabled) {
            return Level.DEBUG;
        }
        if (this.isInfoEnabled) {
            return Level.INFO;
        }
        if (this.isWarnEnabled) {
            return Level.WARN;
        }
        if (this.isErrorEnabled) {
            return Level.ERROR;
        }
        return Level.NONE;
    }

    public final void trace(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (!((Collection)this.eventListeners).isEmpty()) {
            StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
            Intrinsics.checkNotNull(caller);
            Event event = new Event(Level.TRACE, message.invoke(), this, caller, null);
            Iterable $this$forEach$iv = this.eventListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke(event);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message.invoke());
        }
    }

    public final void debug(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (!((Collection)this.eventListeners).isEmpty()) {
            StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
            Intrinsics.checkNotNull(caller);
            Event event = new Event(Level.DEBUG, message.invoke(), this, caller, null);
            Iterable $this$forEach$iv = this.eventListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke(event);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message.invoke());
        }
    }

    public final void info(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (!((Collection)this.eventListeners).isEmpty()) {
            StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
            Intrinsics.checkNotNull(caller);
            Event event = new Event(Level.INFO, message.invoke(), this, caller, null);
            Iterable $this$forEach$iv = this.eventListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke(event);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message.invoke());
        }
    }

    public final void warn(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (!((Collection)this.eventListeners).isEmpty()) {
            StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
            Intrinsics.checkNotNull(caller);
            Event event = new Event(Level.WARN, message.invoke(), this, caller, null);
            Iterable $this$forEach$iv = this.eventListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke(event);
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message.invoke());
        }
    }

    public final void error(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (!((Collection)this.eventListeners).isEmpty()) {
            StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
            Intrinsics.checkNotNull(caller);
            Event event = new Event(Level.ERROR, message.invoke(), this, caller, null);
            Iterable $this$forEach$iv = this.eventListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke(event);
            }
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message.invoke());
        }
    }

    public final void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.error(throwable, () -> Logger.error$lambda$7(throwable));
    }

    public final void error(@Nullable Throwable throwable, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (!((Collection)this.eventListeners).isEmpty()) {
            StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
            Intrinsics.checkNotNull(caller);
            Event event = new Event(Level.ERROR, message.invoke(), this, caller, null);
            Iterable $this$forEach$iv = this.eventListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke(event);
            }
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message.invoke(), throwable);
        }
    }

    private static final String error$lambda$7(Throwable $throwable) {
        String string = $throwable.getMessage();
        if (string == null) {
            String string2 = $throwable.getClass().getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        }
        return string;
    }
}

