/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.http.client.model.token;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J3\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lde/alexanderwolz/http/client/model/token/AccessToken;", "", "encodedJWT", "", "type", "expiresInSeconds", "", "issuedScope", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V", "getEncodedJWT", "()Ljava/lang/String;", "getType", "getExpiresInSeconds", "()I", "getIssuedScope", "expiration", "", "getExpiration", "()J", "isExpired", "", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "http-client"})
public final class AccessToken {
    @NotNull
    private final String encodedJWT;
    @NotNull
    private final String type;
    private final int expiresInSeconds;
    @Nullable
    private final String issuedScope;
    private final long expiration;

    public AccessToken(@NotNull String encodedJWT, @NotNull String type, int expiresInSeconds, @Nullable String issuedScope) {
        Intrinsics.checkNotNullParameter((Object)encodedJWT, (String)"encodedJWT");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.encodedJWT = encodedJWT;
        this.type = type;
        this.expiresInSeconds = expiresInSeconds;
        this.issuedScope = issuedScope;
        this.expiration = System.currentTimeMillis() + (long)((this.expiresInSeconds - 20) * 1000);
    }

    @NotNull
    public final String getEncodedJWT() {
        return this.encodedJWT;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final int getExpiresInSeconds() {
        return this.expiresInSeconds;
    }

    @Nullable
    public final String getIssuedScope() {
        return this.issuedScope;
    }

    public final long getExpiration() {
        return this.expiration;
    }

    public final boolean isExpired() {
        return System.currentTimeMillis() >= this.expiration;
    }

    @NotNull
    public final String component1() {
        return this.encodedJWT;
    }

    @NotNull
    public final String component2() {
        return this.type;
    }

    public final int component3() {
        return this.expiresInSeconds;
    }

    @Nullable
    public final String component4() {
        return this.issuedScope;
    }

    @NotNull
    public final AccessToken copy(@NotNull String encodedJWT, @NotNull String type, int expiresInSeconds, @Nullable String issuedScope) {
        Intrinsics.checkNotNullParameter((Object)encodedJWT, (String)"encodedJWT");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new AccessToken(encodedJWT, type, expiresInSeconds, issuedScope);
    }

    public static /* synthetic */ AccessToken copy$default(AccessToken accessToken, String string, String string2, int n, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = accessToken.encodedJWT;
        }
        if ((n2 & 2) != 0) {
            string2 = accessToken.type;
        }
        if ((n2 & 4) != 0) {
            n = accessToken.expiresInSeconds;
        }
        if ((n2 & 8) != 0) {
            string3 = accessToken.issuedScope;
        }
        return accessToken.copy(string, string2, n, string3);
    }

    @NotNull
    public String toString() {
        return "AccessToken(encodedJWT=" + this.encodedJWT + ", type=" + this.type + ", expiresInSeconds=" + this.expiresInSeconds + ", issuedScope=" + this.issuedScope + ")";
    }

    public int hashCode() {
        int result = this.encodedJWT.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + Integer.hashCode(this.expiresInSeconds);
        result = result * 31 + (this.issuedScope == null ? 0 : this.issuedScope.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AccessToken)) {
            return false;
        }
        AccessToken accessToken = (AccessToken)other;
        if (!Intrinsics.areEqual((Object)this.encodedJWT, (Object)accessToken.encodedJWT)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)accessToken.type)) {
            return false;
        }
        if (this.expiresInSeconds != accessToken.expiresInSeconds) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.issuedScope, (Object)accessToken.issuedScope);
    }
}

