/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.http.client.model.payload;

import de.alexanderwolz.commons.log.Logger;
import de.alexanderwolz.http.client.model.content.AbstractContentResolver;
import de.alexanderwolz.http.client.model.content.ContentResolver;
import de.alexanderwolz.http.client.model.content.ContentType;
import de.alexanderwolz.http.client.model.payload.Payload;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001*B%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00028\u0000\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\rJ'\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00028\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014\u00a2\u0006\u0002\u0010\rJ\"\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J+\u0010\"\u001a\u00020!2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00018\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010#J&\u0010$\u001a\u00020\u00022\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\tH\u0004J&\u0010(\u001a\u00020\u00072\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010\f\u001a\u00020\u00022\b\u0010'\u001a\u0004\u0018\u00010\tH\u0004J\b\u0010)\u001a\u00020!H\u0002R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR&\u0010\f\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000@TX\u0096.\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006+"}, d2={"Lde/alexanderwolz/http/client/model/payload/AbstractPayload;", "T", "", "Lde/alexanderwolz/http/client/model/payload/Payload;", "type", "Lde/alexanderwolz/http/client/model/content/ContentType;", "bytes", "", "customResolver", "Lde/alexanderwolz/http/client/model/content/ContentResolver;", "<init>", "(Lde/alexanderwolz/http/client/model/content/ContentType;[BLde/alexanderwolz/http/client/model/content/ContentResolver;)V", "element", "(Lde/alexanderwolz/http/client/model/content/ContentType;Ljava/lang/Object;Lde/alexanderwolz/http/client/model/content/ContentResolver;)V", "logger", "Lde/alexanderwolz/commons/log/Logger;", "getLogger", "()Lde/alexanderwolz/commons/log/Logger;", "value", "getType", "()Lde/alexanderwolz/http/client/model/content/ContentType;", "setType", "(Lde/alexanderwolz/http/client/model/content/ContentType;)V", "getBytes", "()[B", "setBytes", "([B)V", "getElement", "()Ljava/lang/Object;", "setElement", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "initialize", "", "handleSingle", "([BLjava/lang/Object;Lde/alexanderwolz/http/client/model/content/ContentResolver;)V", "deserialize", "clazz", "Lkotlin/reflect/KClass;", "resolver", "serialize", "typeCheck", "DefaultContentResolver", "http-client"})
@SourceDebugExtension(value={"SMAP\nAbstractPayload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPayload.kt\nde/alexanderwolz/http/client/model/payload/AbstractPayload\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public abstract class AbstractPayload<T>
implements Payload<T> {
    @NotNull
    private final Logger logger;
    protected ContentType type;
    protected byte[] bytes;
    protected T element;

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public ContentType getType() {
        ContentType contentType = this.type;
        if (contentType != null) {
            return contentType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        return null;
    }

    protected void setType(@NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"<set-?>");
        this.type = contentType;
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
        return null;
    }

    protected void setBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.bytes = byArray;
    }

    @Override
    @NotNull
    public T getElement() {
        T t = this.element;
        if (t != null) {
            return t;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"element");
        return (T)Unit.INSTANCE;
    }

    protected void setElement(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.element = t;
    }

    public AbstractPayload(@NotNull ContentType type, @NotNull byte[] bytes, @Nullable ContentResolver customResolver) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.logger = new Logger(this.getClass());
        this.initialize(type, bytes, customResolver);
    }

    public /* synthetic */ AbstractPayload(ContentType contentType, byte[] byArray, ContentResolver contentResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            contentResolver = null;
        }
        this(contentType, byArray, contentResolver);
    }

    public AbstractPayload(@NotNull ContentType type, @NotNull T element, @Nullable ContentResolver customResolver) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.logger = new Logger(this.getClass());
        this.initialize(type, element, customResolver);
    }

    public /* synthetic */ AbstractPayload(ContentType contentType, Object object, ContentResolver contentResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            contentResolver = null;
        }
        this(contentType, object, contentResolver);
    }

    protected void initialize(@NotNull ContentType type, @NotNull T element, @Nullable ContentResolver customResolver) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.setType(type);
        this.handleSingle(null, element, customResolver);
        this.typeCheck();
    }

    protected void initialize(@NotNull ContentType type, @NotNull byte[] bytes, @Nullable ContentResolver customResolver) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.setType(type);
        this.handleSingle(bytes, null, customResolver);
        this.typeCheck();
    }

    private final void handleSingle(byte[] bytes, T element, ContentResolver customResolver) {
        if (bytes != null) {
            this.logger.trace(() -> AbstractPayload.handleSingle$lambda$0(bytes));
            this.setBytes(bytes);
            KClass<?> kClass = this.getType().getClazz();
            Intrinsics.checkNotNull(kClass, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
            Object object = this.deserialize(kClass, bytes, customResolver);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of de.alexanderwolz.http.client.model.payload.AbstractPayload");
            this.setElement(object);
        }
        if (element != null) {
            this.logger.trace(() -> AbstractPayload.handleSingle$lambda$1(element));
            this.setElement(element);
            KClass<?> kClass = this.getType().getClazz();
            Intrinsics.checkNotNull(kClass, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
            this.setBytes(this.serialize(kClass, element, customResolver));
        }
    }

    @NotNull
    protected final Object deserialize(@NotNull KClass<?> clazz, @NotNull byte[] bytes, @Nullable ContentResolver resolver) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ContentResolver contentResolver = resolver;
        if (contentResolver != null) {
            ContentResolver it = contentResolver;
            boolean bl = false;
            try {
                this.logger.trace(() -> AbstractPayload.deserialize$lambda$4$lambda$2(it));
                return it.deserialize(clazz, bytes);
            }
            catch (Throwable t) {
                this.logger.trace(() -> AbstractPayload.deserialize$lambda$4$lambda$3(t));
            }
        }
        this.logger.trace(() -> AbstractPayload.deserialize$lambda$6(resolver));
        return new DefaultContentResolver().deserialize(clazz, bytes);
    }

    @NotNull
    protected final byte[] serialize(@NotNull KClass<?> clazz, @NotNull Object element, @Nullable ContentResolver resolver) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ContentResolver contentResolver = resolver;
        if (contentResolver != null) {
            ContentResolver it = contentResolver;
            boolean bl = false;
            try {
                this.logger.trace(() -> AbstractPayload.serialize$lambda$9$lambda$7(it));
                return it.serialize(clazz, element);
            }
            catch (Throwable t) {
                this.logger.trace(() -> AbstractPayload.serialize$lambda$9$lambda$8(t));
            }
        }
        this.logger.trace(() -> AbstractPayload.serialize$lambda$11(resolver));
        return new DefaultContentResolver().serialize(clazz, element);
    }

    private final void typeCheck() {
        if (!JvmClassMappingKt.getJavaClass(this.getType().getClazz()).isAssignableFrom(this.getElement().getClass())) {
            throw new IllegalStateException("Element does not match content-type class: " + this.getElement().getClass() + " -> " + JvmClassMappingKt.getJavaClass(this.getType().getClazz()));
        }
    }

    private static final String handleSingle$lambda$0(byte[] $bytes) {
        return "Creating payload from bytes: " + $bytes.length + " -> " + StringsKt.decodeToString((byte[])$bytes);
    }

    private static final String handleSingle$lambda$1(Object $element) {
        return "Creating payload from element: " + $element;
    }

    private static final String deserialize$lambda$4$lambda$2(ContentResolver $it) {
        return "Using custom resolver for deserialization: " + $it;
    }

    private static final String deserialize$lambda$4$lambda$3(Throwable $t) {
        String string = $t.getMessage();
        if (string == null) {
            string = $t.getClass().getSimpleName();
        }
        return "Resolver threw Exception (" + string;
    }

    private static final String deserialize$lambda$6(ContentResolver $resolver) {
        String string;
        ContentResolver contentResolver = $resolver;
        if (contentResolver != null) {
            ContentResolver it = contentResolver;
            boolean bl = false;
            string = "";
        } else {
            string = ", because custom resolver was null";
        }
        return "Using default resolver for deserialization " + string;
    }

    private static final String serialize$lambda$9$lambda$7(ContentResolver $it) {
        return "Using custom resolver for serialization: " + $it;
    }

    private static final String serialize$lambda$9$lambda$8(Throwable $t) {
        String string = $t.getMessage();
        if (string == null) {
            string = $t.getClass().getSimpleName();
        }
        return "Resolver threw Exception (" + string;
    }

    private static final String serialize$lambda$11(ContentResolver $resolver) {
        String string;
        ContentResolver contentResolver = $resolver;
        if (contentResolver != null) {
            ContentResolver it = contentResolver;
            boolean bl = false;
            string = "";
        } else {
            string = ", because custom resolver was null";
        }
        return "Using default resolver for serialization " + string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u001c\u0010\t\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lde/alexanderwolz/http/client/model/payload/AbstractPayload$DefaultContentResolver;", "Lde/alexanderwolz/http/client/model/content/AbstractContentResolver;", "<init>", "()V", "extract", "", "parentClazz", "Lkotlin/reflect/KClass;", "parent", "wrap", "child", "http-client"})
    protected static final class DefaultContentResolver
    extends AbstractContentResolver {
        @Override
        @NotNull
        public Object extract(@NotNull KClass<?> parentClazz, @NotNull Object parent) {
            Intrinsics.checkNotNullParameter(parentClazz, (String)"parentClazz");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            throw new NoSuchElementException("Please specify custom content resolver to handle " + parentClazz);
        }

        @Override
        @NotNull
        public Object wrap(@NotNull KClass<?> parentClazz, @NotNull Object child) {
            Intrinsics.checkNotNullParameter(parentClazz, (String)"parentClazz");
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            throw new NoSuchElementException("Please specify custom content resolver to handle " + parentClazz);
        }
    }
}

