/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.http.client.model;

import de.alexanderwolz.http.client.model.Request;
import de.alexanderwolz.http.client.model.payload.Payload;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\t\u0012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u001b\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\tH\u00c6\u0003J\r\u0010 \u001a\u0006\u0012\u0002\b\u00030\fH\u00c6\u0003JS\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\t2\f\b\u0002\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0005H\u00d6\u0001J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001b\u00a8\u0006&"}, d2={"Lde/alexanderwolz/http/client/model/Response;", "", "request", "Lde/alexanderwolz/http/client/model/Request;", "code", "", "message", "", "headers", "", "", "body", "Lde/alexanderwolz/http/client/model/payload/Payload;", "<init>", "(Lde/alexanderwolz/http/client/model/Request;ILjava/lang/String;Ljava/util/Map;Lde/alexanderwolz/http/client/model/payload/Payload;)V", "getRequest", "()Lde/alexanderwolz/http/client/model/Request;", "getCode", "()I", "getMessage", "()Ljava/lang/String;", "getHeaders", "()Ljava/util/Map;", "getBody", "()Lde/alexanderwolz/http/client/model/payload/Payload;", "isOK", "", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "http-client"})
public final class Response {
    @NotNull
    private final Request request;
    private final int code;
    @Nullable
    private final String message;
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final Payload<?> body;
    private final boolean isOK;

    public Response(@NotNull Request request, int code, @Nullable String message, @NotNull Map<String, ? extends List<String>> headers, @NotNull Payload<?> body) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.request = request;
        this.code = code;
        this.message = message;
        this.headers = headers;
        this.body = body;
        int n = this.code;
        this.isOK = 200 <= n ? n < 300 : false;
    }

    @NotNull
    public final Request getRequest() {
        return this.request;
    }

    public final int getCode() {
        return this.code;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Payload<?> getBody() {
        return this.body;
    }

    public final boolean isOK() {
        return this.isOK;
    }

    @NotNull
    public final Request component1() {
        return this.request;
    }

    public final int component2() {
        return this.code;
    }

    @Nullable
    public final String component3() {
        return this.message;
    }

    @NotNull
    public final Map<String, List<String>> component4() {
        return this.headers;
    }

    @NotNull
    public final Payload<?> component5() {
        return this.body;
    }

    @NotNull
    public final Response copy(@NotNull Request request, int code, @Nullable String message, @NotNull Map<String, ? extends List<String>> headers, @NotNull Payload<?> body) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Response(request, code, message, headers, body);
    }

    public static /* synthetic */ Response copy$default(Response response, Request request, int n, String string, Map map, Payload payload, int n2, Object object) {
        if ((n2 & 1) != 0) {
            request = response.request;
        }
        if ((n2 & 2) != 0) {
            n = response.code;
        }
        if ((n2 & 4) != 0) {
            string = response.message;
        }
        if ((n2 & 8) != 0) {
            map = response.headers;
        }
        if ((n2 & 0x10) != 0) {
            payload = response.body;
        }
        return response.copy(request, n, string, map, payload);
    }

    @NotNull
    public String toString() {
        return "Response(request=" + this.request + ", code=" + this.code + ", message=" + this.message + ", headers=" + this.headers + ", body=" + this.body + ")";
    }

    public int hashCode() {
        int result = this.request.hashCode();
        result = result * 31 + Integer.hashCode(this.code);
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + ((Object)this.headers).hashCode();
        result = result * 31 + this.body.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Response)) {
            return false;
        }
        Response response = (Response)other;
        if (!Intrinsics.areEqual((Object)this.request, (Object)response.request)) {
            return false;
        }
        if (this.code != response.code) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)response.message)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, response.headers)) {
            return false;
        }
        return Intrinsics.areEqual(this.body, response.body);
    }
}

