/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.http.client.instance;

import de.alexanderwolz.http.client.AbstractHttpClient;
import de.alexanderwolz.http.client.model.HttpMethod;
import de.alexanderwolz.http.client.model.Request;
import de.alexanderwolz.http.client.model.certificate.CertificateBundle;
import de.alexanderwolz.http.client.model.content.ContentResolver;
import de.alexanderwolz.http.client.model.content.ContentType;
import de.alexanderwolz.http.client.model.payload.Payload;
import de.alexanderwolz.http.client.model.token.AccessToken;
import de.alexanderwolz.http.client.socket.SslSocket;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B}\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\r\u0012\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u000f\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0002H\u0014J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0014\u00a8\u0006 "}, d2={"Lde/alexanderwolz/http/client/instance/OkHttpClientWrapper;", "Lde/alexanderwolz/http/client/AbstractHttpClient;", "Lokhttp3/OkHttpClient;", "proxy", "Ljava/net/URI;", "verifyCert", "", "certificates", "Lde/alexanderwolz/http/client/model/certificate/CertificateBundle;", "httpMethod", "Lde/alexanderwolz/http/client/model/HttpMethod;", "endpoint", "headers", "", "", "", "payload", "Lde/alexanderwolz/http/client/model/payload/Payload;", "resolver", "Lde/alexanderwolz/http/client/model/content/ContentResolver;", "acceptTypes", "Lde/alexanderwolz/http/client/model/content/ContentType;", "accessToken", "Lde/alexanderwolz/http/client/model/token/AccessToken;", "<init>", "(Ljava/net/URI;ZLde/alexanderwolz/http/client/model/certificate/CertificateBundle;Lde/alexanderwolz/http/client/model/HttpMethod;Ljava/net/URI;Ljava/util/Map;Lde/alexanderwolz/http/client/model/payload/Payload;Lde/alexanderwolz/http/client/model/content/ContentResolver;Ljava/util/Set;Lde/alexanderwolz/http/client/model/token/AccessToken;)V", "createClient", "execute", "Lde/alexanderwolz/http/client/AbstractHttpClient$RawResponse;", "client", "request", "Lde/alexanderwolz/http/client/model/Request;", "http-client"})
@SourceDebugExtension(value={"SMAP\nOkHttpClientWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpClientWrapper.kt\nde/alexanderwolz/http/client/instance/OkHttpClientWrapper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n216#2,2:74\n1#3:76\n*S KotlinDebug\n*F\n+ 1 OkHttpClientWrapper.kt\nde/alexanderwolz/http/client/instance/OkHttpClientWrapper\n*L\n52#1:74,2\n*E\n"})
public final class OkHttpClientWrapper
extends AbstractHttpClient<OkHttpClient> {
    public OkHttpClientWrapper(@Nullable URI proxy, boolean verifyCert, @Nullable CertificateBundle certificates, @NotNull HttpMethod httpMethod, @NotNull URI endpoint, @NotNull Map<String, ? extends Set<String>> headers, @NotNull Payload<?> payload, @Nullable ContentResolver resolver, @Nullable Set<? extends ContentType> acceptTypes, @Nullable AccessToken accessToken) {
        Intrinsics.checkNotNullParameter((Object)((Object)httpMethod), (String)"httpMethod");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        super(proxy, verifyCert, certificates, httpMethod, endpoint, headers, payload, resolver, acceptTypes, accessToken);
    }

    @Override
    @NotNull
    protected OkHttpClient createClient() {
        OkHttpClient.Builder builder;
        block1: {
            builder = new OkHttpClient.Builder();
            URI uRI = this.getProxy();
            if (uRI != null) {
                URI uri = uRI;
                boolean bl = false;
                String string = uri.getScheme();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                Proxy.Type type = Proxy.Type.valueOf(string2);
                builder.proxy(new Proxy(type, new InetSocketAddress(uri.getHost(), uri.getPort())));
            }
            builder.connectTimeout(10L, TimeUnit.SECONDS);
            builder.readTimeout(10L, TimeUnit.SECONDS);
            SslSocket sslSocket = this.getCustomSslSocket();
            if (sslSocket == null) break block1;
            SslSocket it = sslSocket;
            boolean bl = false;
            builder.sslSocketFactory(it.getSslSocketFactory(), it.getTrustManager());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected AbstractHttpClient.RawResponse execute(@NotNull OkHttpClient client, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Request.Builder builder = new Request.Builder();
        URL uRL = request.getEndpoint().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        Request.Builder okRequestBuilder = builder.url(uRL);
        Map<String, Set<String>> $this$forEach$iv = request.getHeaders();
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<String, Set<String>> element$iv;
            Map.Entry<String, Set<String>> it = element$iv = object.next();
            boolean bl = false;
            okRequestBuilder.header(it.getKey(), CollectionsKt.joinToString$default((Iterable)it.getValue(), null, null, null, (int)0, null, null, (int)63, null));
        }
        RequestBody okRequestBody = this.convertRequestBody(request.getBody());
        okRequestBuilder.method(request.getHttpMethod().name(), okRequestBody);
        okhttp3.Request okRequest = okRequestBuilder.build();
        object = (Closeable)client.newCall(okRequest).execute();
        Throwable throwable = null;
        try {
            byte[] byArray;
            Response okResponse = (Response)object;
            boolean bl = false;
            int n = okResponse.code();
            String string = okResponse.message();
            Map map = okResponse.headers().toMultimap();
            List list = okResponse.headers("content-type");
            ResponseBody responseBody = okResponse.body();
            if (responseBody != null && (responseBody = responseBody.source()) != null) {
                byte[] byArray2;
                Closeable closeable = (Closeable)responseBody;
                List list2 = list;
                Map map2 = map;
                String string2 = string;
                int n2 = n;
                Throwable throwable2 = null;
                try {
                    BufferedSource it = (BufferedSource)closeable;
                    boolean bl2 = false;
                    byArray2 = it.readByteArray();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byte[] byArray3 = byArray2;
                n = n2;
                string = string2;
                map = map2;
                list = list2;
                byArray = byArray3;
            } else {
                byArray = null;
            }
            AbstractHttpClient.RawResponse.Source source = new AbstractHttpClient.RawResponse.Source(okRequest, okResponse);
            byte[] byArray4 = byArray;
            List list3 = list;
            Map map3 = map;
            String string3 = string;
            int n3 = n;
            AbstractHttpClient.RawResponse rawResponse = new AbstractHttpClient.RawResponse(n3, string3, map3, list3, byArray4, source);
            return rawResponse;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }
}

