/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.http.client;

import de.alexanderwolz.commons.util.CertificateUtils;
import de.alexanderwolz.commons.util.StringUtils;
import de.alexanderwolz.http.client.instance.OkHttpClientWrapper;
import de.alexanderwolz.http.client.instance.Settings;
import de.alexanderwolz.http.client.model.HttpMethod;
import de.alexanderwolz.http.client.model.Request;
import de.alexanderwolz.http.client.model.Response;
import de.alexanderwolz.http.client.model.certificate.CertificateBundle;
import de.alexanderwolz.http.client.model.certificate.CertificateReference;
import de.alexanderwolz.http.client.model.content.ContentResolver;
import de.alexanderwolz.http.client.model.content.ContentType;
import de.alexanderwolz.http.client.model.payload.Payload;
import de.alexanderwolz.http.client.model.token.AccessToken;
import java.io.File;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\bJ\b\u0010\u0006\u001a\u00020\u0007H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lde/alexanderwolz/http/client/HttpClient;", "", "request", "Lde/alexanderwolz/http/client/model/Request;", "getRequest", "()Lde/alexanderwolz/http/client/model/Request;", "execute", "Lde/alexanderwolz/http/client/model/Response;", "Builder", "http-client"})
public interface HttpClient {
    @NotNull
    public Request getRequest();

    @NotNull
    public Response execute();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J&\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0016\b\u0002\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010#\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010\u0012J\u0010\u0010#\u001a\u00020\u00002\b\u0010%\u001a\u0004\u0018\u00010\u0014J\u001f\u0010&\u001a\u00020\u00002\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100(\"\u00020\u0010\u00a2\u0006\u0002\u0010)JC\u0010*\u001a\u00020\u000026\u0010+\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0,0(\"\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0,\u00a2\u0006\u0002\u0010-J\u0012\u0010.\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007J\u0006\u00101\u001a\u000202J$\u00103\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0!H\u0002J\u0010\u00104\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tj\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lde/alexanderwolz/http/client/HttpClient$Builder;", "", "<init>", "()V", "httpMethod", "Lde/alexanderwolz/http/client/model/HttpMethod;", "endpoint", "Ljava/net/URI;", "requestHeaders", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "requestBody", "Lde/alexanderwolz/http/client/model/payload/Payload;", "acceptTypes", "Lde/alexanderwolz/http/client/model/content/ContentType;", "certificateBundle", "Lde/alexanderwolz/http/client/model/certificate/CertificateBundle;", "certificateReference", "Lde/alexanderwolz/http/client/model/certificate/CertificateReference;", "certFolder", "Ljava/io/File;", "accessToken", "Lde/alexanderwolz/http/client/model/token/AccessToken;", "proxy", "verifyCert", "", "resolver", "Lde/alexanderwolz/http/client/model/content/ContentResolver;", "userAgent", "method", "params", "", "certificateLookupFolder", "certificates", "bundle", "reference", "accept", "contentTypes", "", "([Lde/alexanderwolz/http/client/model/content/ContentType;)Lde/alexanderwolz/http/client/HttpClient$Builder;", "headers", "pairs", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lde/alexanderwolz/http/client/HttpClient$Builder;", "body", "payload", "token", "build", "Lde/alexanderwolz/http/client/HttpClient;", "resolveEndpoint", "resolveReference", "http-client"})
    @SourceDebugExtension(value={"SMAP\nHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClient.kt\nde/alexanderwolz/http/client/HttpClient$Builder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n13472#2,2:146\n1#3:148\n*S KotlinDebug\n*F\n+ 1 HttpClient.kt\nde/alexanderwolz/http/client/HttpClient$Builder\n*L\n80#1:146,2\n*E\n"})
    public static final class Builder {
        @NotNull
        private HttpMethod httpMethod = HttpMethod.GET;
        @Nullable
        private URI endpoint;
        @NotNull
        private final HashMap<String, Set<String>> requestHeaders = new HashMap();
        @NotNull
        private Payload<?> requestBody = Payload.Companion.getEMPTY();
        @Nullable
        private Set<? extends ContentType> acceptTypes;
        @Nullable
        private CertificateBundle certificateBundle;
        @Nullable
        private CertificateReference certificateReference;
        @Nullable
        private File certFolder;
        @Nullable
        private AccessToken accessToken;
        @Nullable
        private URI proxy;
        private boolean verifyCert = true;
        @Nullable
        private ContentResolver resolver;

        public Builder() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept-Charset", (Object)SetsKt.setOf((Object)"UTF-8")), TuplesKt.to((Object)"Accept-Language", (Object)SetsKt.setOf((Object)"en-US"))};
            this.headers(pairArray);
        }

        @NotNull
        public final Builder userAgent(@NotNull String userAgent) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
            Builder $this$userAgent_u24lambda_u240 = builder = this;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"User-Agent", (Object)SetsKt.setOf((Object)userAgent))};
            $this$userAgent_u24lambda_u240.headers(pairArray);
            return builder;
        }

        @NotNull
        public final Builder verifyCert(boolean verifyCert) {
            Builder builder;
            Builder $this$verifyCert_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$verifyCert_u24lambda_u241.verifyCert = verifyCert;
            return builder;
        }

        @NotNull
        public final Builder method(@NotNull HttpMethod httpMethod) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)httpMethod), (String)"httpMethod");
            Builder $this$method_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$method_u24lambda_u242.httpMethod = httpMethod;
            return builder;
        }

        @NotNull
        public final Builder endpoint(@NotNull URI endpoint, @Nullable Map<String, String> params) {
            Map<String, String> map;
            Builder builder;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                    Builder $this$endpoint_u24lambda_u244 = builder = this;
                    boolean bl = false;
                    Builder builder2 = $this$endpoint_u24lambda_u244;
                    map = params;
                    if (map == null) break block2;
                    Map<String, String> map2 = map;
                    Builder builder3 = builder2;
                    boolean bl2 = false;
                    URI uRI = $this$endpoint_u24lambda_u244.resolveEndpoint(endpoint, params);
                    builder2 = builder3;
                    map = uRI;
                    if (uRI != null) break block3;
                }
                map = endpoint;
            }
            builder2.endpoint = map;
            return builder;
        }

        public static /* synthetic */ Builder endpoint$default(Builder builder, URI uRI, Map map, int n, Object object) {
            if ((n & 2) != 0) {
                map = null;
            }
            return builder.endpoint(uRI, map);
        }

        @NotNull
        public final Builder certificateLookupFolder(@NotNull File certFolder) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)certFolder, (String)"certFolder");
            Builder $this$certificateLookupFolder_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$certificateLookupFolder_u24lambda_u245.certFolder = certFolder;
            return builder;
        }

        @NotNull
        public final Builder certificates(@Nullable CertificateBundle bundle) {
            Builder builder;
            Builder $this$certificates_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$certificates_u24lambda_u246.certificateBundle = bundle;
            return builder;
        }

        @NotNull
        public final Builder certificates(@Nullable CertificateReference reference) {
            Builder builder;
            Builder $this$certificates_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$certificates_u24lambda_u247.certificateReference = reference;
            return builder;
        }

        @NotNull
        public final Builder accept(ContentType ... contentTypes) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)contentTypes, (String)"contentTypes");
            Builder $this$accept_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$accept_u24lambda_u248.acceptTypes = ArraysKt.toSet((Object[])contentTypes);
            return builder;
        }

        @NotNull
        public final Builder headers(Pair<String, ? extends Set<String>> ... pairs) {
            Builder builder;
            Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
            Builder $this$headers_u24lambda_u2410 = builder = this;
            boolean bl = false;
            Pair<String, ? extends Set<String>>[] $this$forEach$iv = pairs;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Pair<String, ? extends Set<String>> element$iv;
                Pair<String, ? extends Set<String>> it = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                ((Map)$this$headers_u24lambda_u2410.requestHeaders).put(it.getFirst(), it.getSecond());
            }
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder body(@NotNull Payload<?> payload) {
            void it;
            Payload<?> payload2;
            Builder builder;
            Intrinsics.checkNotNullParameter(payload, (String)"payload");
            Builder $this$body_u24lambda_u2412 = builder = this;
            boolean bl = false;
            Payload<?> payload3 = payload2 = payload;
            Builder builder2 = $this$body_u24lambda_u2412;
            boolean bl2 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)SetsKt.setOf((Object)it.getType().getMediaType()))};
            $this$body_u24lambda_u2412.headers(pairArray);
            builder2.requestBody = payload2;
            return builder;
        }

        @NotNull
        public final Builder resolver(@NotNull ContentResolver resolver) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Builder $this$resolver_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$resolver_u24lambda_u2413.resolver = resolver;
            return builder;
        }

        @NotNull
        public final Builder accessToken(@NotNull AccessToken token) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Builder $this$accessToken_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$accessToken_u24lambda_u2414.accessToken = token;
            return builder;
        }

        @NotNull
        public final Builder proxy(@Nullable URI proxy) {
            Builder builder;
            Builder $this$proxy_u24lambda_u2415 = builder = this;
            boolean bl = false;
            $this$proxy_u24lambda_u2415.proxy = proxy;
            return builder;
        }

        @NotNull
        public final HttpClient build() {
            Object certificates;
            URI endpoint;
            block7: {
                Object object;
                block6: {
                    if (this.certificateBundle != null && this.certificateReference != null) {
                        throw new IllegalStateException("Either bundle or reference can be specified");
                    }
                    URI uRI = this.endpoint;
                    if (uRI == null) {
                        String string = "Required value was null.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    endpoint = uRI;
                    object = this.certificateReference;
                    if (object == null) break block6;
                    CertificateReference it = object;
                    boolean bl = false;
                    CertificateBundle certificateBundle = this.resolveReference(it);
                    object = certificateBundle;
                    if (certificateBundle != null) break block7;
                }
                object = certificates = this.certificateBundle;
            }
            if (Settings.INSTANCE.getLibrary() == Settings.LibraryType.OK_HTTP) {
                return new OkHttpClientWrapper(this.proxy, this.verifyCert, (CertificateBundle)certificates, this.httpMethod, endpoint, (Map<String, ? extends Set<String>>)this.requestHeaders, this.requestBody, this.resolver, this.acceptTypes, this.accessToken);
            }
            throw new NoSuchElementException("Unknown HTTP library '" + Settings.INSTANCE.getLibrary() + "'");
        }

        private final URI resolveEndpoint(URI endpoint, Map<String, String> params) {
            String string = endpoint.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            URI uRI = URI.create(StringUtils.INSTANCE.resolveVars(string, params));
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
            return uRI;
        }

        private final CertificateBundle resolveReference(CertificateReference reference) {
            Object object;
            List clientCertificates;
            PrivateKey privateKey;
            block6: {
                block5: {
                    File file;
                    File privateKeyFile = CertificateUtils.INSTANCE.resolveKeyPairFile(reference.getKey(), this.certFolder);
                    File publicKeyFile = CertificateUtils.INSTANCE.resolveKeyPairFile(reference.getCert(), this.certFolder);
                    File file2 = reference.getCa();
                    if (file2 != null) {
                        File it = file2;
                        boolean bl = false;
                        file = CertificateUtils.INSTANCE.resolveKeyPairFile(it, this.certFolder);
                    } else {
                        file = null;
                    }
                    File caFile = file;
                    privateKey = CertificateUtils.INSTANCE.readPrivateKey(privateKeyFile);
                    clientCertificates = CertificateUtils.INSTANCE.readCertificates(publicKeyFile, new String[0]);
                    object = caFile;
                    if (object == null) break block5;
                    File it = object;
                    boolean bl = false;
                    List list = CertificateUtils.INSTANCE.readCertificates(it, new String[0]);
                    object = list;
                    if (list != null) break block6;
                }
                object = CollectionsKt.emptyList();
            }
            Object caCertificates = object;
            return new CertificateBundle(privateKey, clientCertificates, (List<? extends Certificate>)caCertificates);
        }
    }
}

