/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.http.client;

import de.alexanderwolz.commons.log.Logger;
import de.alexanderwolz.commons.util.StringUtils;
import de.alexanderwolz.http.client.HttpClient;
import de.alexanderwolz.http.client.exception.HttpExecutionException;
import de.alexanderwolz.http.client.exception.Reason;
import de.alexanderwolz.http.client.model.HttpMethod;
import de.alexanderwolz.http.client.model.Request;
import de.alexanderwolz.http.client.model.Response;
import de.alexanderwolz.http.client.model.certificate.CertificateBundle;
import de.alexanderwolz.http.client.model.content.BasicContentTypes;
import de.alexanderwolz.http.client.model.content.ContentResolver;
import de.alexanderwolz.http.client.model.content.ContentType;
import de.alexanderwolz.http.client.model.payload.Payload;
import de.alexanderwolz.http.client.model.payload.WrappedPayload;
import de.alexanderwolz.http.client.model.token.AccessToken;
import de.alexanderwolz.http.client.socket.SslSocket;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001SB}\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\r\u0012\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u000f\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010)\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020,H\u0016J\u001d\u0010+\u001a\u00020-2\u0006\u0010.\u001a\u00028\u00002\u0006\u0010%\u001a\u00020&H$\u00a2\u0006\u0002\u0010/JZ\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\r2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u000f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u00102\u001a\u0004\u0018\u0001032\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0004J\u0010\u00104\u001a\u0002052\u0006\u0010%\u001a\u00020&H\u0004J\u0010\u00106\u001a\u0002052\u0006\u00107\u001a\u00020,H\u0004J\u0014\u00108\u001a\u0004\u0018\u00010\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011J$\u00109\u001a\u0006\u0012\u0002\b\u00030\u00112\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0;2\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J\u001e\u0010>\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010?\u001a\u00020\u00152\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J\u0018\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J)\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020F0;2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010GJ)\u0010H\u001a\b\u0012\u0004\u0012\u00020I0C2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020F0;2\u0006\u0010J\u001a\u00020KH\u0002\u00a2\u0006\u0002\u0010LJ\u0010\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PH\u0002J\b\u0010Q\u001a\u00020RH\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006T"}, d2={"Lde/alexanderwolz/http/client/AbstractHttpClient;", "T", "Lde/alexanderwolz/http/client/HttpClient;", "proxy", "Ljava/net/URI;", "verifyCert", "", "certificates", "Lde/alexanderwolz/http/client/model/certificate/CertificateBundle;", "httpMethod", "Lde/alexanderwolz/http/client/model/HttpMethod;", "endpoint", "headers", "", "", "", "payload", "Lde/alexanderwolz/http/client/model/payload/Payload;", "resolver", "Lde/alexanderwolz/http/client/model/content/ContentResolver;", "acceptTypes", "Lde/alexanderwolz/http/client/model/content/ContentType;", "accessToken", "Lde/alexanderwolz/http/client/model/token/AccessToken;", "<init>", "(Ljava/net/URI;ZLde/alexanderwolz/http/client/model/certificate/CertificateBundle;Lde/alexanderwolz/http/client/model/HttpMethod;Ljava/net/URI;Ljava/util/Map;Lde/alexanderwolz/http/client/model/payload/Payload;Lde/alexanderwolz/http/client/model/content/ContentResolver;Ljava/util/Set;Lde/alexanderwolz/http/client/model/token/AccessToken;)V", "getProxy", "()Ljava/net/URI;", "logger", "Lde/alexanderwolz/commons/log/Logger;", "getLogger", "()Lde/alexanderwolz/commons/log/Logger;", "customSslSocket", "Lde/alexanderwolz/http/client/socket/SslSocket;", "getCustomSslSocket", "()Lde/alexanderwolz/http/client/socket/SslSocket;", "customResolver", "request", "Lde/alexanderwolz/http/client/model/Request;", "getRequest", "()Lde/alexanderwolz/http/client/model/Request;", "createClient", "()Ljava/lang/Object;", "execute", "Lde/alexanderwolz/http/client/model/Response;", "Lde/alexanderwolz/http/client/AbstractHttpClient$RawResponse;", "client", "(Ljava/lang/Object;Lde/alexanderwolz/http/client/model/Request;)Lde/alexanderwolz/http/client/AbstractHttpClient$RawResponse;", "createRequest", "method", "convertRequestBody", "Lokhttp3/RequestBody;", "logRequest", "", "logResponse", "response", "getBodyString", "convertResponseBody", "mediaTypes", "", "bytes", "", "createResponsePayload", "type", "createCustomSslSocketFactory", "bundle", "createCustomTrustStore", "", "Ljavax/net/ssl/TrustManager;", "caCertificates", "Ljava/security/cert/Certificate;", "(Ljava/util/List;Z)[Ljavax/net/ssl/TrustManager;", "createCustomKeyStore", "Ljavax/net/ssl/KeyManager;", "privateKey", "Ljava/security/PrivateKey;", "(Ljava/util/List;Ljava/security/PrivateKey;)[Ljavax/net/ssl/KeyManager;", "createEmptyKeyStore", "Ljava/security/KeyStore;", "password", "", "createAllowAllTrustManager", "Ljavax/net/ssl/X509TrustManager;", "RawResponse", "http-client"})
@SourceDebugExtension(value={"SMAP\nAbstractHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractHttpClient.kt\nde/alexanderwolz/http/client/AbstractHttpClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,301:1\n1#2:302\n216#3,2:303\n1563#4:305\n1634#4,3:306\n1878#4,3:309\n1878#4,3:312\n1869#4,2:319\n1869#4,2:321\n37#5:315\n36#5,3:316\n*S KotlinDebug\n*F\n+ 1 AbstractHttpClient.kt\nde/alexanderwolz/http/client/AbstractHttpClient\n*L\n83#1:303,2\n97#1:305\n97#1:306,3\n220#1:309,3\n237#1:312,3\n127#1:319,2\n142#1:321,2\n240#1:315\n240#1:316,3\n*E\n"})
public abstract class AbstractHttpClient<T>
implements HttpClient {
    @Nullable
    private final URI proxy;
    @NotNull
    private final Logger logger;
    @Nullable
    private final SslSocket customSslSocket;
    @Nullable
    private final ContentResolver customResolver;
    @NotNull
    private final Request request;

    public AbstractHttpClient(@Nullable URI proxy, boolean verifyCert, @Nullable CertificateBundle certificates, @NotNull HttpMethod httpMethod, @NotNull URI endpoint, @NotNull Map<String, ? extends Set<String>> headers, @NotNull Payload<?> payload, @Nullable ContentResolver resolver, @Nullable Set<? extends ContentType> acceptTypes, @Nullable AccessToken accessToken) {
        SslSocket sslSocket;
        Intrinsics.checkNotNullParameter((Object)((Object)httpMethod), (String)"httpMethod");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        this.proxy = proxy;
        this.logger = new Logger(this.getClass());
        AbstractHttpClient abstractHttpClient = this;
        CertificateBundle certificateBundle = certificates;
        if (certificateBundle != null) {
            CertificateBundle certificateBundle2 = certificateBundle;
            AbstractHttpClient abstractHttpClient2 = abstractHttpClient;
            boolean bl = false;
            sslSocket = this.createCustomSslSocketFactory(certificates, verifyCert);
            abstractHttpClient = abstractHttpClient2;
        } else {
            sslSocket = null;
        }
        abstractHttpClient.customSslSocket = sslSocket;
        this.customResolver = resolver;
        this.request = this.createRequest(httpMethod, endpoint, headers, payload, acceptTypes, accessToken);
    }

    @Nullable
    protected final URI getProxy() {
        return this.proxy;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    protected final SslSocket getCustomSslSocket() {
        return this.customSslSocket;
    }

    @Override
    @NotNull
    public Request getRequest() {
        return this.request;
    }

    protected abstract T createClient();

    @Override
    @NotNull
    public Response execute() {
        T client = this.createClient();
        try {
            Response response;
            RawResponse rawResponse = this.execute(client, this.getRequest());
            Response it = response = new Response(this.getRequest(), rawResponse.getCode(), rawResponse.getMessage(), rawResponse.getHeaders(), this.convertResponseBody(rawResponse.getContentTypes(), rawResponse.getContent()));
            boolean bl = false;
            this.logResponse(it);
            return response;
        }
        catch (IOException e) {
            String code = "client error";
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getSimpleName();
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            Reason reason = new Reason(code, string2);
            throw new HttpExecutionException(this.getRequest(), reason, null, e);
        }
    }

    @NotNull
    protected abstract RawResponse execute(T var1, @NotNull Request var2);

    /*
     * WARNING - void declaration
     */
    private final Request createRequest(HttpMethod method, URI endpoint, Map<String, ? extends Set<String>> headers, Payload<?> payload, Set<? extends ContentType> acceptTypes, AccessToken accessToken) {
        Collection<ContentType> collection;
        Object it;
        Object object = new HashMap<String, Set>();
        HashMap<String, Set> $this$createRequest_u24lambda_u244 = object;
        boolean bl = false;
        Object $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String key;
            Map.Entry<String, ? extends Set<String>> element$iv;
            Map.Entry<String, ? extends Set<String>> it2 = element$iv = iterator.next();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getKey().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (((Map)$this$createRequest_u24lambda_u244).containsKey(it2.getKey())) {
                this.logger.warn(() -> AbstractHttpClient.createRequest$lambda$4$lambda$3$lambda$2(it2, $this$createRequest_u24lambda_u244));
            }
            $this$createRequest_u24lambda_u244.put(key, it2.getValue());
        }
        HashMap<String, Set> requestHeaders = object;
        AccessToken accessToken2 = accessToken;
        if (accessToken2 != null) {
            it = accessToken2;
            boolean bl3 = false;
            requestHeaders.put("authorization", SetsKt.setOf((Object)(StringUtils.INSTANCE.capitalize(((AccessToken)it).getType()) + " " + ((AccessToken)it).getEncodedJWT())));
        }
        if ((collection = acceptTypes) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            $this$forEach$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                ContentType bl2 = (ContentType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl4 = false;
                collection2.add(it3.getMediaType());
            }
            Collection<Object> it4 = $i$f$map = (List)destination$iv$iv;
            boolean bl5 = false;
            collection = !((Collection)it4).isEmpty() ? $i$f$map : null;
            if (collection != null) {
                it4 = collection;
                boolean bl6 = false;
                requestHeaders.put("accept", CollectionsKt.toSet((Iterable)it4));
            }
        }
        it = object = new Request(method, endpoint, (Map<String, ? extends Set<String>>)requestHeaders, payload, acceptTypes);
        boolean bl7 = false;
        this.logRequest((Request)it);
        return object;
    }

    static /* synthetic */ Request createRequest$default(AbstractHttpClient abstractHttpClient, HttpMethod httpMethod, URI uRI, Map map, Payload payload, Set set, AccessToken accessToken, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createRequest");
        }
        if ((n & 0x20) != 0) {
            accessToken = null;
        }
        return abstractHttpClient.createRequest(httpMethod, uRI, map, payload, set, accessToken);
    }

    @Nullable
    protected final RequestBody convertRequestBody(@NotNull Payload<?> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        if (Intrinsics.areEqual(payload, Payload.Companion.getEMPTY())) {
            return null;
        }
        if (payload instanceof WrappedPayload) {
            return RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((WrappedPayload)payload).getParentBytes(), (MediaType)MediaType.Companion.get(((WrappedPayload)payload).getType().getMediaType()), (int)0, (int)0, (int)6, null);
        }
        return RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])payload.getBytes(), (MediaType)MediaType.Companion.get(payload.getType().getMediaType()), (int)0, (int)0, (int)6, null);
    }

    protected final void logRequest(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.trace(() -> AbstractHttpClient.logRequest$lambda$13(request, this));
    }

    protected final void logResponse(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.logger.trace(() -> AbstractHttpClient.logResponse$lambda$19(response, this));
    }

    @Nullable
    public final String getBodyString(@NotNull Payload<?> payload) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        if (Intrinsics.areEqual(payload, Payload.Companion.getEMPTY())) {
            return null;
        }
        StringBuilder $this$getBodyString_u24lambda_u2420 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getBodyString_u24lambda_u2420.append(StringsKt.decodeToString((byte[])payload.getBytes()));
        return stringBuilder.toString();
    }

    private final Payload<?> convertResponseBody(List<String> mediaTypes, byte[] bytes) {
        Object v2;
        block8: {
            Object v1;
            Object object2;
            String normalized;
            block7: {
                if (mediaTypes.isEmpty()) {
                    if (bytes == null || bytes.length == 0) {
                        this.logger.trace(AbstractHttpClient::convertResponseBody$lambda$21);
                        return Payload.Companion.getEMPTY();
                    }
                    this.logger.trace(() -> AbstractHttpClient.convertResponseBody$lambda$22(bytes));
                    return this.createResponsePayload(BasicContentTypes.APPLICATION_OCTET_STREAM, bytes);
                }
                this.logger.trace(() -> AbstractHttpClient.convertResponseBody$lambda$23(mediaTypes));
                this.logger.trace(() -> AbstractHttpClient.convertResponseBody$lambda$24(bytes));
                normalized = (String)CollectionsKt.first(mediaTypes);
                Set set = this.getRequest().getAcceptTypes();
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set acceptTypes = set;
                Iterable iterable = acceptTypes;
                for (Object object2 : iterable) {
                    ContentType it = (ContentType)object2;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it.getMediaType(), (String)normalized, (boolean)false, (int)2, null)) continue;
                    v1 = object2;
                    break block7;
                }
                v1 = null;
            }
            ContentType contentType = v1;
            if (contentType != null) {
                this.logger.trace(() -> AbstractHttpClient.convertResponseBody$lambda$26(contentType));
                return this.createResponsePayload(contentType, bytes);
            }
            this.logger.warn(() -> AbstractHttpClient.convertResponseBody$lambda$27(this));
            Iterable iterable = (Iterable)BasicContentTypes.getEntries();
            object2 = iterable.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                BasicContentTypes it = (BasicContentTypes)e;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it.getMediaType(), (String)normalized, (boolean)false, (int)2, null)) continue;
                v2 = e;
                break block8;
            }
            v2 = null;
        }
        BasicContentTypes basicType = v2;
        if (basicType != null) {
            this.logger.trace(() -> AbstractHttpClient.convertResponseBody$lambda$29(basicType));
            return this.createResponsePayload(basicType, bytes);
        }
        this.logger.warn(AbstractHttpClient::convertResponseBody$lambda$30);
        this.logger.warn(AbstractHttpClient::convertResponseBody$lambda$31);
        throw new NoSuchElementException("Could not determine content-type reference for '" + mediaTypes + "'");
    }

    private final Payload<?> createResponsePayload(ContentType type, byte[] bytes) {
        if (bytes != null) {
            byte[] it = bytes;
            boolean bl = false;
            return Payload.Companion.create(type, bytes, this.customResolver);
        }
        throw new NoSuchElementException("Received empty byte array with content type: " + type);
    }

    private final SslSocket createCustomSslSocketFactory(CertificateBundle bundle, boolean verifyCert) {
        SSLContext sSLContext;
        KeyManager[] keyManagers = this.createCustomKeyStore(bundle.getCertificates(), bundle.getPrivateKey());
        TrustManager[] trustManagers = this.createCustomTrustStore(bundle.getCaCertificates(), verifyCert);
        this.logger.trace(AbstractHttpClient::createCustomSslSocketFactory$lambda$33);
        SSLContext $this$createCustomSslSocketFactory_u24lambda_u2434 = sSLContext = SSLContext.getInstance("TLS");
        boolean bl = false;
        $this$createCustomSslSocketFactory_u24lambda_u2434.init(keyManagers, trustManagers, new SecureRandom());
        SSLSocketFactory socketFactory = sSLContext.getSocketFactory();
        this.logger.trace(AbstractHttpClient::createCustomSslSocketFactory$lambda$35);
        Intrinsics.checkNotNull((Object)socketFactory);
        TrustManager trustManager = trustManagers[0];
        Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        return new SslSocket(socketFactory, (X509TrustManager)trustManager);
    }

    /*
     * WARNING - void declaration
     */
    private final TrustManager[] createCustomTrustStore(List<? extends Certificate> caCertificates, boolean verifyCert) {
        TrustManager[] trustManagerArray;
        if (verifyCert) {
            KeyStore keyStore;
            TrustManagerFactory trustManagerFactory;
            this.logger.trace(AbstractHttpClient::createCustomTrustStore$lambda$36);
            TrustManagerFactory $this$createCustomTrustStore_u24lambda_u2439 = trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            boolean bl = false;
            char[] cArray = "truststore".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            KeyStore $this$createCustomTrustStore_u24lambda_u2439_u24lambda_u2438 = keyStore = this.createEmptyKeyStore(cArray);
            boolean bl2 = false;
            Iterable $this$forEachIndexed$iv = caCertificates;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void certificate;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Certificate certificate2 = (Certificate)item$iv;
                int index = n;
                boolean bl3 = false;
                $this$createCustomTrustStore_u24lambda_u2439_u24lambda_u2438.setCertificateEntry("ca-" + (index + 1), (Certificate)certificate);
            }
            KeyStore trustStore = keyStore;
            $this$createCustomTrustStore_u24lambda_u2439.init(trustStore);
            TrustManager[] trustManagerArray2 = trustManagerFactory.getTrustManagers();
            Intrinsics.checkNotNull((Object)trustManagerArray2);
            trustManagerArray = trustManagerArray2;
        } else {
            this.logger.trace(AbstractHttpClient::createCustomTrustStore$lambda$40);
            TrustManager[] trustManagerArray3 = new TrustManager[]{this.createAllowAllTrustManager()};
            trustManagerArray = trustManagerArray3;
        }
        return trustManagerArray;
    }

    /*
     * WARNING - void declaration
     */
    private final KeyManager[] createCustomKeyStore(List<? extends Certificate> certificates, PrivateKey privateKey) {
        KeyStore keyStore;
        KeyManagerFactory keyManagerFactory;
        KeyManagerFactory $this$createCustomKeyStore_u24lambda_u2444 = keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        boolean bl = false;
        this.logger.trace(AbstractHttpClient::createCustomKeyStore$lambda$44$lambda$41);
        char[] cArray = "keystore".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] passArray = cArray;
        KeyStore $this$createCustomKeyStore_u24lambda_u2444_u24lambda_u2443 = keyStore = this.createEmptyKeyStore(passArray);
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv = certificates;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void certificate;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Certificate certificate2 = (Certificate)item$iv;
            int index = n;
            boolean bl3 = false;
            $this$createCustomKeyStore_u24lambda_u2444_u24lambda_u2443.setCertificateEntry("certificate-" + index, (Certificate)certificate);
        }
        Collection $this$toTypedArray$iv = certificates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$createCustomKeyStore_u24lambda_u2444_u24lambda_u2443.setKeyEntry("private-key", privateKey, passArray, thisCollection$iv.toArray(new Certificate[0]));
        KeyStore keyStore2 = keyStore;
        $this$createCustomKeyStore_u24lambda_u2444.init(keyStore2, passArray);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        Intrinsics.checkNotNullExpressionValue((Object)keyManagerArray, (String)"getKeyManagers(...)");
        return keyManagerArray;
    }

    private final KeyStore createEmptyKeyStore(char[] password) {
        KeyStore keyStore;
        KeyStore $this$createEmptyKeyStore_u24lambda_u2445 = keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        boolean bl = false;
        $this$createEmptyKeyStore_u24lambda_u2445.load(null, password);
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"apply(...)");
        return keyStore2;
    }

    private final X509TrustManager createAllowAllTrustManager() {
        return new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private static final String createRequest$lambda$4$lambda$3$lambda$2(Map.Entry $it, HashMap $this_apply) {
        Object k = $it.getKey();
        Object v = $this_apply.get($it.getKey());
        Collection collection = $this_apply.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return "Header with key=" + k + " already exist in map (" + v + "), overwriting with " + CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, null, (int)63, null);
    }

    /*
     * Unable to fully structure code
     */
    private static final String logRequest$lambda$13(Request $request, AbstractHttpClient this$0) {
        var4_2 = $request.getBody();
        it = var4_2;
        $i$a$-takeIf-AbstractHttpClient$logRequest$1$bodyType$1 = false;
        v0 = var3_6 = Intrinsics.areEqual(it, Payload.Companion.getEMPTY()) == false != false ? var4_2 : null;
        if (var3_6 == null) ** GOTO lbl-1000
        it = var3_6;
        $i$a$-let-AbstractHttpClient$logRequest$1$bodyType$2 = false;
        var4_2 = "ContentType: " + it.getType() + "->" + JvmClassMappingKt.getJavaClass(it.getType().getClazz()).getName();
        if (var4_2 != null) {
            v1 = var4_2;
        } else lbl-1000:
        // 2 sources

        {
            v1 = "No request body";
        }
        bodyType = v1;
        headers = CollectionsKt.joinToString$default((Iterable)$request.getHeaders().entrySet(), null, null, null, (int)0, null, null, (int)63, null);
        builder = new StringBuilder("Executing request at " + new Date() + ":");
        builder.append("\n\tRequest");
        builder.append("\n\t\tMethod:  " + $request.getHttpMethod());
        builder.append("\n\t\tURL:     " + $request.getEndpoint());
        builder.append("\n\t\tHeaders: " + headers);
        builder.append("\n\t\tBody:    " + bodyType);
        v2 = this$0.getBodyString($request.getBody());
        if (v2 != null && (v2 = StringsKt.lines((CharSequence)((CharSequence)v2))) != null) {
            $this$forEach$iv = (Iterable)v2;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                $i$a$-forEach-AbstractHttpClient$logRequest$1$1 = false;
                builder.append("\n\t\t\t" + it);
            }
        }
        v3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toString(...)");
        return v3;
    }

    /*
     * Unable to fully structure code
     */
    private static final String logResponse$lambda$19(Response $response, AbstractHttpClient this$0) {
        var4_2 = $response.getBody();
        it = var4_2;
        $i$a$-takeIf-AbstractHttpClient$logResponse$1$bodyType$1 = false;
        v0 = var3_7 = Intrinsics.areEqual(it, Payload.Companion.getEMPTY()) == false != false ? var4_2 : null;
        if (var3_7 == null) ** GOTO lbl-1000
        it = var3_7;
        $i$a$-let-AbstractHttpClient$logResponse$1$bodyType$2 = false;
        var4_2 = "ContentType: " + it.getType() + "->" + JvmClassMappingKt.getJavaClass(it.getType().getClazz()).getName();
        if (var4_2 != null) {
            v1 = var4_2;
        } else lbl-1000:
        // 2 sources

        {
            v1 = "No response body";
        }
        bodyType = v1;
        builder = new StringBuilder("Received server response at " + new Date() + ":");
        builder.append("\n\tResponse");
        builder.append("\n\t\tStatus:  " + $response.getCode());
        v2 = builder;
        v3 = $response.getMessage();
        if (v3 != null) {
            $i$a$-let-AbstractHttpClient$logResponse$1$bodyType$2 = v3;
            var12_12 = v2;
            $i$a$-let-AbstractHttpClient$logResponse$1$1 = false;
            var9_15 = (CharSequence)it;
            if (var9_15.length() == 0) {
                $i$a$-ifEmpty-AbstractHttpClient$logResponse$1$1$1 = false;
                v4 = "No message";
            } else {
                v4 = var9_15;
            }
            v5 = (String)v4;
            v2 = var12_12;
        } else {
            v5 = "No message";
        }
        v2.append("\n\t\tMessage: " + v5);
        builder.append("\n\t\tHeaders: " + $response.getHeaders());
        builder.append("\n\t\tBody:    " + bodyType);
        v6 = this$0.getBodyString($response.getBody());
        if (v6 != null && (v6 = StringsKt.lines((CharSequence)((CharSequence)v6))) != null) {
            $this$forEach$iv = (Iterable)v6;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                $i$a$-forEach-AbstractHttpClient$logResponse$1$2 = false;
                builder.append("\n\t\t\t" + it);
            }
        }
        v7 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"toString(...)");
        return v7;
    }

    private static final String convertResponseBody$lambda$21() {
        return "Server did not return any content-type nor bytes";
    }

    private static final String convertResponseBody$lambda$22(byte[] $bytes) {
        return "Server did not return a content-type (but content-length=" + $bytes.length;
    }

    private static final String convertResponseBody$lambda$23(List $mediaTypes) {
        return "Server returned content-type: " + CollectionsKt.joinToString$default((Iterable)$mediaTypes, null, null, null, (int)0, null, null, (int)63, null);
    }

    private static final String convertResponseBody$lambda$24(byte[] $bytes) {
        return "UTF decoded bytes:\n" + ($bytes != null ? StringsKt.decodeToString((byte[])$bytes) : null);
    }

    private static final String convertResponseBody$lambda$26(ContentType $contentType) {
        return "Found content type in specified accept types: " + $contentType + " (" + JvmClassMappingKt.getJavaClass($contentType.getClazz()) + ")";
    }

    private static final String convertResponseBody$lambda$27(AbstractHttpClient this$0) {
        Set<ContentType> set = this$0.getRequest().getAcceptTypes();
        return "Could not determine content-type from request accept types (" + (set != null ? CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null) : null) + ")";
    }

    private static final String convertResponseBody$lambda$29(BasicContentTypes $basicType) {
        return "Found basic content type: " + $basicType;
    }

    private static final String convertResponseBody$lambda$30() {
        return "Could not determine content-type from basic types";
    }

    private static final String convertResponseBody$lambda$31() {
        return "Consider setting the appropriate accept type using " + Reflection.getOrCreateKotlinClass(HttpClient.Builder.class);
    }

    private static final String createCustomSslSocketFactory$lambda$33() {
        return "Creating SSL socket factory ..";
    }

    private static final String createCustomSslSocketFactory$lambda$35() {
        return "Done creating SSL socket factory";
    }

    private static final String createCustomTrustStore$lambda$36() {
        return "Creating ca truststore (verify=true)";
    }

    private static final String createCustomTrustStore$lambda$40() {
        return "Creating mock-truststore (verify=false)";
    }

    private static final String createCustomKeyStore$lambda$44$lambda$41() {
        return "Creating keystore";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001:\u0001&BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001b\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010#\u001a\u00020\rH\u00c2\u0003Ja\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/alexanderwolz/http/client/AbstractHttpClient$RawResponse;", "", "code", "", "message", "", "headers", "", "", "contentTypes", "content", "", "source", "Lde/alexanderwolz/http/client/AbstractHttpClient$RawResponse$Source;", "<init>", "(ILjava/lang/String;Ljava/util/Map;Ljava/util/List;[BLde/alexanderwolz/http/client/AbstractHttpClient$RawResponse$Source;)V", "getCode", "()I", "getMessage", "()Ljava/lang/String;", "getHeaders", "()Ljava/util/Map;", "getContentTypes", "()Ljava/util/List;", "getContent", "()[B", "equals", "", "other", "hashCode", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "toString", "Source", "http-client"})
    public static final class RawResponse {
        private final int code;
        @Nullable
        private final String message;
        @NotNull
        private final Map<String, List<String>> headers;
        @NotNull
        private final List<String> contentTypes;
        @Nullable
        private final byte[] content;
        @NotNull
        private final Source source;

        public RawResponse(int code, @Nullable String message, @NotNull Map<String, ? extends List<String>> headers, @NotNull List<String> contentTypes, @Nullable byte[] content, @NotNull Source source) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter(contentTypes, (String)"contentTypes");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.code = code;
            this.message = message;
            this.headers = headers;
            this.contentTypes = contentTypes;
            this.content = content;
            this.source = source;
        }

        public final int getCode() {
            return this.code;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final List<String> getContentTypes() {
            return this.contentTypes;
        }

        @Nullable
        public final byte[] getContent() {
            return this.content;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type de.alexanderwolz.http.client.AbstractHttpClient.RawResponse");
            RawResponse cfr_ignored_0 = (RawResponse)other;
            if (this.code != ((RawResponse)other).code) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)((RawResponse)other).message)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.headers, ((RawResponse)other).headers)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.contentTypes, ((RawResponse)other).contentTypes)) {
                return false;
            }
            if (!Arrays.equals(this.content, ((RawResponse)other).content)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)((RawResponse)other).source);
        }

        public int hashCode() {
            int result = this.code;
            String string = this.message;
            result = 31 * result + (string != null ? string.hashCode() : 0);
            result = 31 * result + ((Object)this.headers).hashCode();
            result = 31 * result + ((Object)this.contentTypes).hashCode();
            result = 31 * result + (this.content != null ? Arrays.hashCode(this.content) : 0);
            result = 31 * result + this.source.hashCode();
            return result;
        }

        public final int component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final Map<String, List<String>> component3() {
            return this.headers;
        }

        @NotNull
        public final List<String> component4() {
            return this.contentTypes;
        }

        @Nullable
        public final byte[] component5() {
            return this.content;
        }

        private final Source component6() {
            return this.source;
        }

        @NotNull
        public final RawResponse copy(int code, @Nullable String message, @NotNull Map<String, ? extends List<String>> headers, @NotNull List<String> contentTypes, @Nullable byte[] content, @NotNull Source source) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter(contentTypes, (String)"contentTypes");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new RawResponse(code, message, headers, contentTypes, content, source);
        }

        public static /* synthetic */ RawResponse copy$default(RawResponse rawResponse, int n, String string, Map map, List list, byte[] byArray, Source source, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = rawResponse.code;
            }
            if ((n2 & 2) != 0) {
                string = rawResponse.message;
            }
            if ((n2 & 4) != 0) {
                map = rawResponse.headers;
            }
            if ((n2 & 8) != 0) {
                list = rawResponse.contentTypes;
            }
            if ((n2 & 0x10) != 0) {
                byArray = rawResponse.content;
            }
            if ((n2 & 0x20) != 0) {
                source = rawResponse.source;
            }
            return rawResponse.copy(n, string, map, list, byArray, source);
        }

        @NotNull
        public String toString() {
            return "RawResponse(code=" + this.code + ", message=" + this.message + ", headers=" + this.headers + ", contentTypes=" + this.contentTypes + ", content=" + Arrays.toString(this.content) + ", source=" + this.source + ")";
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lde/alexanderwolz/http/client/AbstractHttpClient$RawResponse$Source;", "", "request", "response", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getRequest", "()Ljava/lang/Object;", "getResponse", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "http-client"})
        public static final class Source {
            @NotNull
            private final Object request;
            @NotNull
            private final Object response;

            public Source(@NotNull Object request, @NotNull Object response) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.request = request;
                this.response = response;
            }

            @NotNull
            public final Object getRequest() {
                return this.request;
            }

            @NotNull
            public final Object getResponse() {
                return this.response;
            }

            @NotNull
            public final Object component1() {
                return this.request;
            }

            @NotNull
            public final Object component2() {
                return this.response;
            }

            @NotNull
            public final Source copy(@NotNull Object request, @NotNull Object response) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return new Source(request, response);
            }

            public static /* synthetic */ Source copy$default(Source source, Object object, Object object2, int n, Object object3) {
                if ((n & 1) != 0) {
                    object = source.request;
                }
                if ((n & 2) != 0) {
                    object2 = source.response;
                }
                return source.copy(object, object2);
            }

            @NotNull
            public String toString() {
                return "Source(request=" + this.request + ", response=" + this.response + ")";
            }

            public int hashCode() {
                int result = this.request.hashCode();
                result = result * 31 + this.response.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Source)) {
                    return false;
                }
                Source source = (Source)other;
                if (!Intrinsics.areEqual((Object)this.request, (Object)source.request)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.response, (Object)source.response);
            }
        }
    }
}

