/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.http.client.model.converter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import de.alexanderwolz.http.client.model.Form;
import de.alexanderwolz.http.client.model.converter.Converter;
import de.alexanderwolz.http.client.model.token.OAuthTokenResponse;
import de.alexanderwolz.http.client.model.type.ContentType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u0012"}, d2={"Lde/alexanderwolz/http/client/model/converter/BasicConverters;", "", "<init>", "()V", "STRING", "Lde/alexanderwolz/http/client/model/converter/Converter;", "", "getSTRING", "()Lde/alexanderwolz/http/client/model/converter/Converter;", "JSON_ELEMENT", "Lcom/google/gson/JsonElement;", "getJSON_ELEMENT", "OAUTH_TOKEN", "Lde/alexanderwolz/http/client/model/token/OAuthTokenResponse;", "getOAUTH_TOKEN", "FORM", "Lde/alexanderwolz/http/client/model/Form;", "getFORM", "http-client"})
public final class BasicConverters {
    @NotNull
    public static final BasicConverters INSTANCE = new BasicConverters();
    @NotNull
    private static final Converter<String> STRING = new Converter<String>(){

        public byte[] serialize(String element, ContentType type) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            String string = element;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return byArray;
        }

        public String deserialize(byte[] bytes, ContentType type) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return StringsKt.decodeToString((byte[])bytes);
        }
    };
    @NotNull
    private static final Converter<JsonElement> JSON_ELEMENT = new Converter<JsonElement>(){

        public byte[] serialize(JsonElement element, ContentType type) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            String string = new Gson().toJson(element);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return byArray;
        }

        public JsonElement deserialize(byte[] bytes, ContentType type) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            JsonElement jsonElement = new Gson().toJsonTree((Object)StringsKt.decodeToString((byte[])bytes));
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"toJsonTree(...)");
            return jsonElement;
        }
    };
    @NotNull
    private static final Converter<OAuthTokenResponse> OAUTH_TOKEN = new Converter<OAuthTokenResponse>(){

        public byte[] serialize(OAuthTokenResponse element, ContentType type) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            String string = new Gson().toJson((Object)element);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return byArray;
        }

        public OAuthTokenResponse deserialize(byte[] bytes, ContentType type) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Object object = new Gson().fromJson(StringsKt.decodeToString((byte[])bytes), OAuthTokenResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (OAuthTokenResponse)object;
        }
    };
    @NotNull
    private static final Converter<Form> FORM = new Converter<Form>(){

        public byte[] serialize(Form element, ContentType type) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            String string = element.encodeToString();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return byArray;
        }

        public Form deserialize(byte[] bytes, ContentType type) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Form(StringsKt.decodeToString((byte[])bytes));
        }
    };

    private BasicConverters() {
    }

    @NotNull
    public final Converter<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public final Converter<JsonElement> getJSON_ELEMENT() {
        return JSON_ELEMENT;
    }

    @NotNull
    public final Converter<OAuthTokenResponse> getOAUTH_TOKEN() {
        return OAUTH_TOKEN;
    }

    @NotNull
    public final Converter<Form> getFORM() {
        return FORM;
    }
}

