/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.http.client.model;

import de.alexanderwolz.commons.log.Logger;
import de.alexanderwolz.http.client.model.converter.Converter;
import de.alexanderwolz.http.client.model.type.ContentType;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0001H\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0002J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lde/alexanderwolz/http/client/model/Payload;", "", "type", "Lde/alexanderwolz/http/client/model/type/ContentType;", "bytes", "", "<init>", "(Lde/alexanderwolz/http/client/model/type/ContentType;[B)V", "element", "(Lde/alexanderwolz/http/client/model/type/ContentType;Ljava/lang/Object;)V", "logger", "Lde/alexanderwolz/commons/log/Logger;", "getType", "()Lde/alexanderwolz/http/client/model/type/ContentType;", "getBytes", "()[B", "getElement", "()Ljava/lang/Object;", "typeCheck", "", "deserialize", "serialize", "equals", "", "other", "hashCode", "", "http-client"})
public final class Payload {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ContentType type;
    @NotNull
    private final byte[] bytes;
    @NotNull
    private final Object element;

    @NotNull
    public final ContentType getType() {
        return this.type;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    @NotNull
    public final Object getElement() {
        return this.element;
    }

    public Payload(@NotNull ContentType type, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.logger = new Logger(this.getClass());
        this.type = type;
        this.bytes = bytes;
        this.element = this.deserialize();
        this.typeCheck();
    }

    public Payload(@NotNull ContentType type, @NotNull Object element) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.logger = new Logger(this.getClass());
        this.type = type;
        this.element = element;
        this.bytes = this.serialize();
        this.typeCheck();
    }

    private final void typeCheck() {
        if (!JvmClassMappingKt.getJavaClass(this.type.getClazz()).isAssignableFrom(this.element.getClass())) {
            throw new IllegalStateException("Element does not match content-type class: " + this.element.getClass() + " -> " + JvmClassMappingKt.getJavaClass(this.type.getClazz()));
        }
    }

    private final Object deserialize() {
        Object obj;
        Object $this$deserialize_u24lambda_u241 = obj = this.type.getConverter().deserialize(this.bytes, this.type);
        boolean bl = false;
        this.logger.trace(() -> Payload.deserialize$lambda$1$lambda$0(this, $this$deserialize_u24lambda_u241));
        return obj;
    }

    private final byte[] serialize() {
        byte[] byArray;
        Converter<?> converter = this.type.getConverter();
        Intrinsics.checkNotNull(converter, (String)"null cannot be cast to non-null type de.alexanderwolz.http.client.model.converter.Converter<kotlin.Any>");
        Converter<?> converter2 = converter;
        byte[] $this$serialize_u24lambda_u243 = byArray = converter2.serialize(this.element, this.type);
        boolean bl = false;
        this.logger.trace(() -> Payload.serialize$lambda$3$lambda$2(this));
        return byArray;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type de.alexanderwolz.http.client.model.Payload");
        Payload cfr_ignored_0 = (Payload)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)((Payload)other).type)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((Payload)other).bytes);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    private static final String deserialize$lambda$1$lambda$0(Payload this$0, Object $this_apply) {
        return "Deserialized from media type '" + this$0.type.getMediaType() + "' into " + $this_apply.getClass() + " (contentType class=" + JvmClassMappingKt.getJavaClass(this$0.type.getClazz()) + ")";
    }

    private static final String serialize$lambda$3$lambda$2(Payload this$0) {
        return "Serialized from element " + this$0.element.getClass() + " into ByteArray (media type '" + this$0.type.getMediaType() + "', contentType class=" + JvmClassMappingKt.getJavaClass(this$0.type.getClazz()) + ")";
    }
}

