/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.http.client;

import com.google.gson.JsonElement;
import de.alexanderwolz.commons.log.Logger;
import de.alexanderwolz.commons.util.CertificateUtils;
import de.alexanderwolz.commons.util.StringUtils;
import de.alexanderwolz.http.client.exception.HttpExecutionException;
import de.alexanderwolz.http.client.exception.Reason;
import de.alexanderwolz.http.client.model.Form;
import de.alexanderwolz.http.client.model.HttpMethod;
import de.alexanderwolz.http.client.model.Payload;
import de.alexanderwolz.http.client.model.Request;
import de.alexanderwolz.http.client.model.Response;
import de.alexanderwolz.http.client.model.certificate.CertificateBundle;
import de.alexanderwolz.http.client.model.certificate.CertificateReference;
import de.alexanderwolz.http.client.model.token.AccessToken;
import de.alexanderwolz.http.client.model.type.BasicContentTypes;
import de.alexanderwolz.http.client.model.type.ContentType;
import de.alexanderwolz.http.client.socket.SslSocket;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001:B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020 2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J \u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0002J)\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010/J!\u00100\u001a\b\u0012\u0004\u0012\u0002010(2\f\u00102\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000209H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lde/alexanderwolz/http/client/HttpClient;", "", "request", "Lde/alexanderwolz/http/client/model/Request;", "proxy", "Ljava/net/URI;", "verifyCert", "", "accessToken", "Lde/alexanderwolz/http/client/model/token/AccessToken;", "<init>", "(Lde/alexanderwolz/http/client/model/Request;Ljava/net/URI;ZLde/alexanderwolz/http/client/model/token/AccessToken;)V", "getRequest", "()Lde/alexanderwolz/http/client/model/Request;", "logger", "Lde/alexanderwolz/commons/log/Logger;", "execute", "Lde/alexanderwolz/http/client/model/Response;", "convertRequestBody", "Lokhttp3/RequestBody;", "payload", "Lde/alexanderwolz/http/client/model/Payload;", "convertResponseBody", "okResponse", "Lokhttp3/Response;", "logRequest", "", "okRequest", "Lokhttp3/Request;", "logResponse", "response", "getBodyString", "", "createOkHttpClient", "Lokhttp3/OkHttpClient;", "bundle", "Lde/alexanderwolz/http/client/model/certificate/CertificateBundle;", "createCustomSslSocketFactory", "Lde/alexanderwolz/http/client/socket/SslSocket;", "createCustomKeyStore", "", "Ljavax/net/ssl/KeyManager;", "certificates", "", "Ljava/security/cert/Certificate;", "privateKey", "Ljava/security/PrivateKey;", "(Ljava/util/List;Ljava/security/PrivateKey;)[Ljavax/net/ssl/KeyManager;", "createCustomTrustStore", "Ljavax/net/ssl/TrustManager;", "caCertificates", "(Ljava/util/List;)[Ljavax/net/ssl/TrustManager;", "createEmptyKeyStore", "Ljava/security/KeyStore;", "password", "", "createAllowAllTrustManager", "Ljavax/net/ssl/X509TrustManager;", "Builder", "http-client"})
@SourceDebugExtension(value={"SMAP\nHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClient.kt\nde/alexanderwolz/http/client/HttpClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,371:1\n216#2,2:372\n1#3:374\n1869#4,2:375\n1878#4,3:377\n1878#4,3:384\n1869#4,2:387\n1869#4,2:389\n37#5:380\n36#5,3:381\n*S KotlinDebug\n*F\n+ 1 HttpClient.kt\nde/alexanderwolz/http/client/HttpClient\n*L\n50#1:372,2\n95#1:375,2\n225#1:377,3\n240#1:384,3\n156#1:387,2\n171#1:389,2\n228#1:380\n228#1:381,3\n*E\n"})
public final class HttpClient {
    @NotNull
    private final Request request;
    @Nullable
    private final URI proxy;
    private final boolean verifyCert;
    @Nullable
    private final AccessToken accessToken;
    @NotNull
    private final Logger logger;

    private HttpClient(Request request, URI proxy, boolean verifyCert, AccessToken accessToken) {
        this.request = request;
        this.proxy = proxy;
        this.verifyCert = verifyCert;
        this.accessToken = accessToken;
        this.logger = new Logger(this.getClass());
    }

    @NotNull
    public final Request getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Response execute() {
        RequestBody requestBody;
        OkHttpClient okHttpClient = this.createOkHttpClient(this.request.getCertificates(), this.proxy);
        Request.Builder builder = new Request.Builder();
        URL uRL = this.request.getEndpoint().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        Request.Builder okRequestBuilder = builder.url(uRL);
        Map<String, Set<String>> $this$forEach$iv = this.request.getHeaders();
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<String, Set<String>> element$iv;
            Map.Entry<String, Set<String>> it = element$iv = object.next();
            boolean bl = false;
            okRequestBuilder.header(it.getKey(), CollectionsKt.joinToString$default((Iterable)it.getValue(), null, null, null, (int)0, null, null, (int)63, null));
        }
        AccessToken accessToken = this.accessToken;
        if (accessToken != null) {
            AccessToken it = accessToken;
            boolean bl = false;
            okRequestBuilder.header("Authorization", StringUtils.INSTANCE.capitalize(it.getType()) + " " + it.getEncodedJWT());
        }
        Set<ContentType> set = this.request.getAcceptTypes();
        if (set != null) {
            Set<ContentType> types = set;
            boolean bl = false;
            okRequestBuilder.header("Accept", CollectionsKt.joinToString$default((Iterable)types, null, null, null, (int)0, null, HttpClient::execute$lambda$3$lambda$2, (int)31, null));
        }
        Payload payload = this.request.getBody();
        if (payload != null) {
            Payload it = payload;
            boolean bl = false;
            requestBody = this.convertRequestBody(it);
        } else {
            requestBody = null;
        }
        RequestBody okRequestBody = requestBody;
        okRequestBuilder.method(this.request.getHttpMethod().name(), okRequestBody);
        okhttp3.Request okRequest = okRequestBuilder.build();
        this.logRequest(okRequest);
        try {
            object = (Closeable)okHttpClient.newCall(okRequest).execute();
            Throwable it = null;
            try {
                Response response;
                okhttp3.Response okResponse = (okhttp3.Response)object;
                boolean bl = false;
                Response it2 = response = new Response(this.request, okResponse.code(), okResponse.message(), okResponse.headers().toMultimap(), this.convertResponseBody(okResponse), new Response.Source(okRequest, okResponse));
                boolean bl2 = false;
                this.logResponse(it2);
                Response response2 = response;
                return response2;
            }
            catch (Throwable bl) {
                it = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)it);
            }
        }
        catch (IOException e) {
            String code = "client error";
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getSimpleName();
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            Reason reason = new Reason(code, string2);
            throw new HttpExecutionException(this.request, reason, null, e);
        }
    }

    private final RequestBody convertRequestBody(Payload payload) {
        RequestBody requestBody;
        ContentType type = payload.getType();
        Object object = payload.getElement();
        if (object instanceof Form) {
            FormBody.Builder builder = new FormBody.Builder(null, 1, null);
            Iterable $this$forEach$iv = ((Form)payload.getElement()).getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                builder.add((String)entry.getKey(), (String)entry.getValue());
            }
            requestBody = (RequestBody)builder.build();
        } else if (object instanceof String) {
            requestBody = RequestBody.Companion.create((String)payload.getElement(), MediaType.Companion.get(type.getMediaType()));
        } else if (object instanceof JsonElement) {
            String string = ((JsonElement)payload.getElement()).getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            requestBody = RequestBody.Companion.create(string, MediaType.Companion.get(type.getMediaType()));
        } else {
            requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])payload.getBytes(), (MediaType)MediaType.Companion.get(type.getMediaType()), (int)0, (int)0, (int)6, null);
        }
        return requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Payload convertResponseBody(okhttp3.Response okResponse) {
        block14: {
            String[] it;
            ResponseBody responseBody = okResponse.body();
            if (responseBody == null) break block14;
            ResponseBody okBody = responseBody;
            boolean bl = false;
            Closeable closeable = (Closeable)okBody.source();
            Throwable throwable = null;
            try {
                it = (BufferedSource)closeable;
                boolean bl2 = false;
                it = (String[])it.readByteArray();
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object bytes = it;
            String mediaType = okResponse.headers().get("content-type");
            if (mediaType != null) {
                Object v3;
                block13: {
                    Object v2;
                    Object object2;
                    String normalized;
                    block12: {
                        this.logger.trace(() -> HttpClient.convertResponseBody$lambda$18$lambda$9(mediaType));
                        it = new String[]{";"};
                        normalized = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)mediaType, (String[])it, (boolean)false, (int)0, (int)6, null));
                        Set set = this.request.getAcceptTypes();
                        if (set == null) {
                            set = SetsKt.emptySet();
                        }
                        Set acceptTypes = set;
                        Iterable iterable = acceptTypes;
                        for (Object object2 : iterable) {
                            ContentType it2 = (ContentType)object2;
                            boolean bl3 = false;
                            if (!StringsKt.startsWith$default((String)it2.getMediaType(), (String)normalized, (boolean)false, (int)2, null)) continue;
                            v2 = object2;
                            break block12;
                        }
                        v2 = null;
                    }
                    ContentType contentType = v2;
                    if (contentType != null) {
                        this.logger.trace(HttpClient::convertResponseBody$lambda$18$lambda$11);
                        return new Payload(contentType, (byte[])bytes);
                    }
                    this.logger.warn(() -> HttpClient.convertResponseBody$lambda$18$lambda$12(this));
                    Iterable iterable = (Iterable)BasicContentTypes.getEntries();
                    object2 = iterable.iterator();
                    while (object2.hasNext()) {
                        Object e = object2.next();
                        BasicContentTypes it3 = (BasicContentTypes)e;
                        boolean bl4 = false;
                        if (!StringsKt.startsWith$default((String)it3.getMediaType(), (String)normalized, (boolean)false, (int)2, null)) continue;
                        v3 = e;
                        break block13;
                    }
                    v3 = null;
                }
                BasicContentTypes basicType = v3;
                if (basicType != null) {
                    this.logger.trace(() -> HttpClient.convertResponseBody$lambda$18$lambda$14(basicType));
                    return new Payload((ContentType)basicType, (byte[])bytes);
                }
                this.logger.warn(HttpClient::convertResponseBody$lambda$18$lambda$15);
                this.logger.warn(HttpClient::convertResponseBody$lambda$18$lambda$16);
                throw new NoSuchElementException("Could not determine content-type reference for '" + mediaType + "'");
            }
            this.logger.trace(() -> HttpClient.convertResponseBody$lambda$18$lambda$17((byte[])bytes));
        }
        return null;
    }

    private final void logRequest(okhttp3.Request okRequest) {
        this.logger.trace(() -> HttpClient.logRequest$lambda$21(okRequest, this));
    }

    private final void logResponse(Response response) {
        this.logger.trace(() -> HttpClient.logResponse$lambda$26(response, this));
    }

    @NotNull
    public final String getBodyString(@Nullable Payload payload) {
        StringBuilder stringBuilder;
        if (payload == null) {
            return "No body";
        }
        StringBuilder $this$getBodyString_u24lambda_u2427 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getBodyString_u24lambda_u2427.append(StringsKt.decodeToString((byte[])payload.getBytes()));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final OkHttpClient createOkHttpClient(CertificateBundle bundle, URI proxy) {
        OkHttpClient.Builder builder;
        block1: {
            builder = new OkHttpClient.Builder();
            URI uRI = proxy;
            if (uRI != null) {
                URI uri = uRI;
                boolean bl = false;
                String string = uri.getScheme();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                Proxy.Type type = Proxy.Type.valueOf(string2);
                builder.proxy(new Proxy(type, new InetSocketAddress(uri.getHost(), uri.getPort())));
            }
            builder.connectTimeout(10L, TimeUnit.SECONDS);
            builder.readTimeout(10L, TimeUnit.SECONDS);
            CertificateBundle certificateBundle = bundle;
            if (certificateBundle == null) break block1;
            CertificateBundle it = certificateBundle;
            boolean bl = false;
            SslSocket sslSocket = this.createCustomSslSocketFactory(it);
            builder.sslSocketFactory(sslSocket.getSslSocketFactory(), sslSocket.getTrustManager());
        }
        return builder.build();
    }

    static /* synthetic */ OkHttpClient createOkHttpClient$default(HttpClient httpClient, CertificateBundle certificateBundle, URI uRI, int n, Object object) {
        if ((n & 1) != 0) {
            certificateBundle = null;
        }
        if ((n & 2) != 0) {
            uRI = null;
        }
        return httpClient.createOkHttpClient(certificateBundle, uRI);
    }

    private final SslSocket createCustomSslSocketFactory(CertificateBundle bundle) {
        SSLContext sSLContext;
        KeyManager[] keyManagers = this.createCustomKeyStore(bundle.getCertificates(), bundle.getPrivateKey());
        TrustManager[] trustManagers = this.createCustomTrustStore(bundle.getCaCertificates());
        this.logger.trace(HttpClient::createCustomSslSocketFactory$lambda$30);
        SSLContext $this$createCustomSslSocketFactory_u24lambda_u2431 = sSLContext = SSLContext.getInstance("TLS");
        boolean bl = false;
        $this$createCustomSslSocketFactory_u24lambda_u2431.init(keyManagers, trustManagers, new SecureRandom());
        SSLSocketFactory socketFactory = sSLContext.getSocketFactory();
        this.logger.trace(HttpClient::createCustomSslSocketFactory$lambda$32);
        Intrinsics.checkNotNull((Object)socketFactory);
        TrustManager trustManager = trustManagers[0];
        Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        return new SslSocket(socketFactory, (X509TrustManager)trustManager);
    }

    /*
     * WARNING - void declaration
     */
    private final KeyManager[] createCustomKeyStore(List<? extends Certificate> certificates, PrivateKey privateKey) {
        KeyStore keyStore;
        KeyManagerFactory keyManagerFactory;
        KeyManagerFactory $this$createCustomKeyStore_u24lambda_u2436 = keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        boolean bl = false;
        this.logger.trace(HttpClient::createCustomKeyStore$lambda$36$lambda$33);
        char[] cArray = "keystore".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] passArray = cArray;
        KeyStore $this$createCustomKeyStore_u24lambda_u2436_u24lambda_u2435 = keyStore = this.createEmptyKeyStore(passArray);
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv = certificates;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void certificate;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Certificate certificate2 = (Certificate)item$iv;
            int index = n;
            boolean bl3 = false;
            $this$createCustomKeyStore_u24lambda_u2436_u24lambda_u2435.setCertificateEntry("certificate-" + index, (Certificate)certificate);
        }
        Collection $this$toTypedArray$iv = certificates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$createCustomKeyStore_u24lambda_u2436_u24lambda_u2435.setKeyEntry("private-key", privateKey, passArray, thisCollection$iv.toArray(new Certificate[0]));
        KeyStore keyStore2 = keyStore;
        $this$createCustomKeyStore_u24lambda_u2436.init(keyStore2, passArray);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        Intrinsics.checkNotNullExpressionValue((Object)keyManagerArray, (String)"getKeyManagers(...)");
        return keyManagerArray;
    }

    /*
     * WARNING - void declaration
     */
    private final TrustManager[] createCustomTrustStore(List<? extends Certificate> caCertificates) {
        TrustManager[] trustManagerArray;
        if (this.verifyCert) {
            KeyStore keyStore;
            TrustManagerFactory trustManagerFactory;
            this.logger.trace(HttpClient::createCustomTrustStore$lambda$37);
            TrustManagerFactory $this$createCustomTrustStore_u24lambda_u2440 = trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            boolean bl = false;
            char[] cArray = "truststore".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            KeyStore $this$createCustomTrustStore_u24lambda_u2440_u24lambda_u2439 = keyStore = this.createEmptyKeyStore(cArray);
            boolean bl2 = false;
            Iterable $this$forEachIndexed$iv = caCertificates;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void certificate;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Certificate certificate2 = (Certificate)item$iv;
                int index = n;
                boolean bl3 = false;
                $this$createCustomTrustStore_u24lambda_u2440_u24lambda_u2439.setCertificateEntry("ca-" + (index + 1), (Certificate)certificate);
            }
            KeyStore trustStore = keyStore;
            $this$createCustomTrustStore_u24lambda_u2440.init(trustStore);
            TrustManager[] trustManagerArray2 = trustManagerFactory.getTrustManagers();
            Intrinsics.checkNotNull((Object)trustManagerArray2);
            trustManagerArray = trustManagerArray2;
        } else {
            this.logger.trace(HttpClient::createCustomTrustStore$lambda$41);
            TrustManager[] trustManagerArray3 = new TrustManager[]{this.createAllowAllTrustManager()};
            trustManagerArray = trustManagerArray3;
        }
        return trustManagerArray;
    }

    private final KeyStore createEmptyKeyStore(char[] password) {
        KeyStore keyStore;
        KeyStore $this$createEmptyKeyStore_u24lambda_u2442 = keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        boolean bl = false;
        $this$createEmptyKeyStore_u24lambda_u2442.load(null, password);
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"apply(...)");
        return keyStore2;
    }

    private final X509TrustManager createAllowAllTrustManager() {
        return new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private static final CharSequence execute$lambda$3$lambda$2(ContentType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMediaType();
    }

    private static final String convertResponseBody$lambda$18$lambda$9(String $mediaType) {
        return "Server returned content-type: " + $mediaType;
    }

    private static final String convertResponseBody$lambda$18$lambda$11() {
        return "Found content type in specified accept types";
    }

    private static final String convertResponseBody$lambda$18$lambda$12(HttpClient this$0) {
        Set<ContentType> set = this$0.request.getAcceptTypes();
        return "Could not determine content-type from request accept types (" + (set != null ? CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null) : null) + ")";
    }

    private static final String convertResponseBody$lambda$18$lambda$14(BasicContentTypes $basicType) {
        return "Found basic content type: " + $basicType;
    }

    private static final String convertResponseBody$lambda$18$lambda$15() {
        return "Could not determine content-type from basic types";
    }

    private static final String convertResponseBody$lambda$18$lambda$16() {
        return "Consider setting the appropriate accept type using " + Reflection.getOrCreateKotlinClass(Builder.class);
    }

    private static final String convertResponseBody$lambda$18$lambda$17(byte[] $bytes) {
        return "Server did not return any content-type (but content-length=" + $bytes.length;
    }

    /*
     * WARNING - void declaration
     */
    private static final String logRequest$lambda$21(okhttp3.Request $okRequest, HttpClient this$0) {
        Object object;
        StringBuilder stringBuilder;
        StringBuilder builder;
        block6: {
            block5: {
                void it;
                String headers = CollectionsKt.joinToString$default((Iterable)$okRequest.headers().toMultimap().entrySet(), null, null, null, (int)0, null, null, (int)63, null);
                builder = new StringBuilder("Executing request at " + new Date() + ":");
                builder.append("\n\tRequest");
                builder.append("\n\t\tMethod:  " + $okRequest.method());
                builder.append("\n\t\tURL:     " + $okRequest.url());
                builder.append("\n\t\tHeaders: " + headers);
                stringBuilder = builder;
                object = this$0.request.getBody();
                if (object == null) break block5;
                Payload payload = object;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                String string = String.valueOf(JvmClassMappingKt.getJavaClass(it.getType().getClazz()).getName());
                stringBuilder = stringBuilder2;
                object = string;
                if (string != null) break block6;
            }
            object = ": No request body";
        }
        stringBuilder.append("\n\t\tBody:    " + (String)object);
        if (this$0.request.getBody() != null) {
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)this$0.getBodyString(this$0.request.getBody()));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                builder.append("\n\t\t\t" + it);
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String logResponse$lambda$26(Response $response, HttpClient this$0) {
        Object object;
        StringBuilder stringBuilder;
        StringBuilder builder;
        block10: {
            block9: {
                String string;
                Payload it;
                StringBuilder stringBuilder2;
                builder = new StringBuilder("Received server response at " + new Date() + ":");
                builder.append("\n\tResponse");
                builder.append("\n\t\tStatus:  " + $response.getCode());
                StringBuilder stringBuilder3 = builder;
                String string2 = $response.getMessage();
                if (string2 != null) {
                    CharSequence charSequence;
                    String string3 = string2;
                    stringBuilder2 = stringBuilder3;
                    boolean bl = false;
                    CharSequence charSequence2 = (CharSequence)((Object)it);
                    if (charSequence2.length() == 0) {
                        boolean bl2 = false;
                        charSequence = "No message";
                    } else {
                        charSequence = charSequence2;
                    }
                    string = (String)charSequence;
                    stringBuilder3 = stringBuilder2;
                } else {
                    string = "No message";
                }
                stringBuilder3.append("\n\t\tMessage: " + string);
                builder.append("\n\t\tHeaders: " + $response.getHeaders());
                stringBuilder = builder;
                object = $response.getBody();
                if (object == null) break block9;
                it = object;
                stringBuilder2 = stringBuilder;
                boolean bl = false;
                String string4 = String.valueOf(JvmClassMappingKt.getJavaClass(it.getType().getClazz()).getName());
                stringBuilder = stringBuilder2;
                object = string4;
                if (string4 != null) break block10;
            }
            object = ": No response body";
        }
        stringBuilder.append("\n\t\tBody:    " + (String)object);
        if ($response.getBody() != null) {
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)this$0.getBodyString($response.getBody()));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                builder.append("\n\t\t\t" + it);
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String createCustomSslSocketFactory$lambda$30() {
        return "Creating SSL socket factory ..";
    }

    private static final String createCustomSslSocketFactory$lambda$32() {
        return "Done creating SSL socket factory";
    }

    private static final String createCustomKeyStore$lambda$36$lambda$33() {
        return "Creating keystore";
    }

    private static final String createCustomTrustStore$lambda$37() {
        return "Creating ca truststore (verify=true)";
    }

    private static final String createCustomTrustStore$lambda$41() {
        return "Creating mock-truststore (verify=false)";
    }

    public /* synthetic */ HttpClient(Request request, URI proxy, boolean verifyCert, AccessToken accessToken, DefaultConstructorMarker $constructor_marker) {
        this(request, proxy, verifyCert, accessToken);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J&\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u0011J\u0010\u0010 \u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\u0013J\u001f\u0010#\u001a\u00020\u00002\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0%\"\u00020\u000f\u00a2\u0006\u0002\u0010&JC\u0010'\u001a\u00020\u000026\u0010(\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0)0%\"\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0)\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007J\u0006\u0010.\u001a\u00020/J$\u00100\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001eH\u0002J\u0010\u00101\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lde/alexanderwolz/http/client/HttpClient$Builder;", "", "<init>", "()V", "httpMethod", "Lde/alexanderwolz/http/client/model/HttpMethod;", "endpoint", "Ljava/net/URI;", "requestHeaders", "Ljava/util/HashMap;", "", "", "requestBody", "Lde/alexanderwolz/http/client/model/Payload;", "acceptTypes", "Lde/alexanderwolz/http/client/model/type/ContentType;", "certificateBundle", "Lde/alexanderwolz/http/client/model/certificate/CertificateBundle;", "certificateReference", "Lde/alexanderwolz/http/client/model/certificate/CertificateReference;", "certFolder", "Ljava/io/File;", "accessToken", "Lde/alexanderwolz/http/client/model/token/AccessToken;", "proxy", "verifyCert", "", "userAgent", "method", "params", "", "certificateLookupFolder", "certificates", "bundle", "reference", "accept", "contentTypes", "", "([Lde/alexanderwolz/http/client/model/type/ContentType;)Lde/alexanderwolz/http/client/HttpClient$Builder;", "headers", "pairs", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lde/alexanderwolz/http/client/HttpClient$Builder;", "body", "payload", "token", "build", "Lde/alexanderwolz/http/client/HttpClient;", "resolveEndpoint", "resolveReference", "http-client"})
    @SourceDebugExtension(value={"SMAP\nHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClient.kt\nde/alexanderwolz/http/client/HttpClient$Builder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,371:1\n13472#2,2:372\n1#3:374\n*S KotlinDebug\n*F\n+ 1 HttpClient.kt\nde/alexanderwolz/http/client/HttpClient$Builder\n*L\n323#1:372,2\n*E\n"})
    public static final class Builder {
        @NotNull
        private HttpMethod httpMethod = HttpMethod.GET;
        @Nullable
        private URI endpoint;
        @NotNull
        private final HashMap<String, Set<String>> requestHeaders = new HashMap();
        @Nullable
        private Payload requestBody;
        @Nullable
        private Set<? extends ContentType> acceptTypes;
        @Nullable
        private CertificateBundle certificateBundle;
        @Nullable
        private CertificateReference certificateReference;
        @Nullable
        private File certFolder;
        @Nullable
        private AccessToken accessToken;
        @Nullable
        private URI proxy;
        private boolean verifyCert = true;

        public Builder() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept-Charset", (Object)SetsKt.setOf((Object)"UTF-8")), TuplesKt.to((Object)"Accept-Language", (Object)SetsKt.setOf((Object)"en-US"))};
            this.headers(pairArray);
        }

        @NotNull
        public final Builder userAgent(@NotNull String userAgent) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
            Builder $this$userAgent_u24lambda_u240 = builder = this;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"User-Agent", (Object)SetsKt.setOf((Object)userAgent))};
            $this$userAgent_u24lambda_u240.headers(pairArray);
            return builder;
        }

        @NotNull
        public final Builder verifyCert(boolean verifyCert) {
            Builder builder;
            Builder $this$verifyCert_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$verifyCert_u24lambda_u241.verifyCert = verifyCert;
            return builder;
        }

        @NotNull
        public final Builder method(@NotNull HttpMethod httpMethod) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)httpMethod), (String)"httpMethod");
            Builder $this$method_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$method_u24lambda_u242.httpMethod = httpMethod;
            return builder;
        }

        @NotNull
        public final Builder endpoint(@NotNull URI endpoint, @Nullable Map<String, String> params) {
            Map<String, String> map;
            Builder builder;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                    Builder $this$endpoint_u24lambda_u244 = builder = this;
                    boolean bl = false;
                    Builder builder2 = $this$endpoint_u24lambda_u244;
                    map = params;
                    if (map == null) break block2;
                    Map<String, String> map2 = map;
                    Builder builder3 = builder2;
                    boolean bl2 = false;
                    URI uRI = $this$endpoint_u24lambda_u244.resolveEndpoint(endpoint, params);
                    builder2 = builder3;
                    map = uRI;
                    if (uRI != null) break block3;
                }
                map = endpoint;
            }
            builder2.endpoint = map;
            return builder;
        }

        public static /* synthetic */ Builder endpoint$default(Builder builder, URI uRI, Map map, int n, Object object) {
            if ((n & 2) != 0) {
                map = null;
            }
            return builder.endpoint(uRI, map);
        }

        @NotNull
        public final Builder certificateLookupFolder(@NotNull File certFolder) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)certFolder, (String)"certFolder");
            Builder $this$certificateLookupFolder_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$certificateLookupFolder_u24lambda_u245.certFolder = certFolder;
            return builder;
        }

        @NotNull
        public final Builder certificates(@Nullable CertificateBundle bundle) {
            Builder builder;
            Builder $this$certificates_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$certificates_u24lambda_u246.certificateBundle = bundle;
            return builder;
        }

        @NotNull
        public final Builder certificates(@Nullable CertificateReference reference) {
            Builder builder;
            Builder $this$certificates_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$certificates_u24lambda_u247.certificateReference = reference;
            return builder;
        }

        @NotNull
        public final Builder accept(ContentType ... contentTypes) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)contentTypes, (String)"contentTypes");
            Builder $this$accept_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$accept_u24lambda_u248.acceptTypes = ArraysKt.toSet((Object[])contentTypes);
            return builder;
        }

        @NotNull
        public final Builder headers(Pair<String, ? extends Set<String>> ... pairs) {
            Builder builder;
            Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
            Builder $this$headers_u24lambda_u2410 = builder = this;
            boolean bl = false;
            Pair<String, ? extends Set<String>>[] $this$forEach$iv = pairs;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Pair<String, ? extends Set<String>> element$iv;
                Pair<String, ? extends Set<String>> it = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                Map map = $this$headers_u24lambda_u2410.requestHeaders;
                String string = ((String)it.getFirst()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                map.put(string, it.getSecond());
            }
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder body(@NotNull Payload payload) {
            void it;
            Payload payload2;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Builder $this$body_u24lambda_u2412 = builder = this;
            boolean bl = false;
            Payload payload3 = payload2 = payload;
            Builder builder2 = $this$body_u24lambda_u2412;
            boolean bl2 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)SetsKt.setOf((Object)it.getType().getMediaType()))};
            $this$body_u24lambda_u2412.headers(pairArray);
            builder2.requestBody = payload2;
            return builder;
        }

        @NotNull
        public final Builder accessToken(@NotNull AccessToken token) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Builder $this$accessToken_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$accessToken_u24lambda_u2413.accessToken = token;
            return builder;
        }

        @NotNull
        public final Builder proxy(@Nullable URI proxy) {
            Builder builder;
            Builder $this$proxy_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$proxy_u24lambda_u2414.proxy = proxy;
            return builder;
        }

        @NotNull
        public final HttpClient build() {
            Object object;
            URI endpoint;
            block6: {
                block5: {
                    if (this.certificateBundle != null && this.certificateReference != null) {
                        throw new IllegalStateException("Either bundle or reference can be specified");
                    }
                    URI uRI = this.endpoint;
                    if (uRI == null) {
                        String string = "Required value was null.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    endpoint = uRI;
                    object = this.certificateReference;
                    if (object == null) break block5;
                    CertificateReference it = object;
                    boolean bl = false;
                    CertificateBundle certificateBundle = this.resolveReference(it);
                    object = certificateBundle;
                    if (certificateBundle != null) break block6;
                }
                object = this.certificateBundle;
            }
            Object certificates = object;
            Request request = new Request(this.httpMethod, endpoint, (Map<String, ? extends Set<String>>)this.requestHeaders, this.requestBody, this.acceptTypes, (CertificateBundle)certificates);
            return new HttpClient(request, this.proxy, this.verifyCert, this.accessToken, null);
        }

        private final URI resolveEndpoint(URI endpoint, Map<String, String> params) {
            String string = endpoint.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            URI uRI = URI.create(StringUtils.INSTANCE.resolveVars(string, params));
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
            return uRI;
        }

        private final CertificateBundle resolveReference(CertificateReference reference) {
            Object object;
            List clientCertificates;
            PrivateKey privateKey;
            block6: {
                block5: {
                    File file;
                    File privateKeyFile = CertificateUtils.INSTANCE.resolveKeyPairFile(reference.getKey(), this.certFolder);
                    File publicKeyFile = CertificateUtils.INSTANCE.resolveKeyPairFile(reference.getCert(), this.certFolder);
                    File file2 = reference.getCa();
                    if (file2 != null) {
                        File it = file2;
                        boolean bl = false;
                        file = CertificateUtils.INSTANCE.resolveKeyPairFile(it, this.certFolder);
                    } else {
                        file = null;
                    }
                    File caFile = file;
                    privateKey = CertificateUtils.INSTANCE.readPrivateKey(privateKeyFile);
                    clientCertificates = CertificateUtils.INSTANCE.readCertificates(publicKeyFile, new String[0]);
                    object = caFile;
                    if (object == null) break block5;
                    File it = object;
                    boolean bl = false;
                    List list = CertificateUtils.INSTANCE.readCertificates(it, new String[0]);
                    object = list;
                    if (list != null) break block6;
                }
                object = CollectionsKt.emptyList();
            }
            Object caCertificates = object;
            return new CertificateBundle(privateKey, clientCertificates, (List<? extends Certificate>)caCertificates);
        }
    }
}

