/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.util.database;

import de.alexanderwolz.commons.log.Logger;
import de.alexanderwolz.commons.util.database.SchemaGenerator;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0007456789:B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0002J0\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00110\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0002J\"\u0010\u0016\u001a\u00020\u000f2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0014\u0010\u001f\u001a\u00020\u00032\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$*\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u00112\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J,\u0010'\u001a\u0004\u0018\u0001H(\"\n\b\u0000\u0010(\u0018\u0001*\u00020)*\u00020$2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0082\b\u00a2\u0006\u0002\u0010+J\u001a\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u001a\u00100\u001a\u00020\u00032\u0006\u0010-\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u001a\u00101\u001a\u00020\u00032\u0006\u0010-\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\b\u00102\u001a\u00020\u0003H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00032\u0006\u0010.\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lde/alexanderwolz/commons/util/database/SchemaGenerator;", "", "basePackage", "", "outDir", "Ljava/io/File;", "databaseType", "Lde/alexanderwolz/commons/util/database/SchemaGenerator$DatabaseType;", "uuidType", "Lde/alexanderwolz/commons/util/database/SchemaGenerator$UUIDType;", "<init>", "(Ljava/lang/String;Ljava/io/File;Lde/alexanderwolz/commons/util/database/SchemaGenerator$DatabaseType;Lde/alexanderwolz/commons/util/database/SchemaGenerator$UUIDType;)V", "logger", "Lde/alexanderwolz/commons/log/Logger;", "generate", "", "findEntities", "", "Ljava/lang/Class;", "separateBySchema", "", "entities", "generateFiles", "schema", "formatCreateTableSql", "sql", "alignSqlColumns", "lines", "formatPlainSql", "prepareTargetDirectory", "schemaKey", "getTableName", "clazz", "toSnakeCase", "s", "idField", "Ljava/lang/reflect/Field;", "allPersistentFields", "type", "findAnnotationOnFieldOrGetter", "A", "", "owner", "(Ljava/lang/reflect/Field;Ljava/lang/Class;)Ljava/lang/annotation/Annotation;", "sqlType", "field", "col", "Ljakarta/persistence/Column;", "sqlTypePg", "sqlTypeMaria", "uuidDefaultSql", "timestampDefault", "DatabaseType", "UUIDType", "TableSqlGenerator", "ForeignKeyGenerator", "IndexGenerator", "ColumnDef", "EntityScanner", "commons-util"})
@SourceDebugExtension(value={"SMAP\nSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,688:1\n211#1:735\n214#1,2:737\n213#1,9:739\n216#2,2:689\n1869#3:691\n1870#3:693\n1761#3,3:694\n1878#3,3:697\n360#3,7:700\n388#3,7:707\n1563#3:714\n1634#3,3:715\n774#3:718\n865#3,2:719\n1878#3,3:721\n1563#3:724\n1634#3,3:725\n1563#3:728\n1634#3,3:729\n295#3:734\n296#3:748\n1869#3,2:752\n1#4:692\n1#4:736\n13472#5,2:732\n3829#5:749\n4344#5,2:750\n*S KotlinDebug\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator\n*L\n189#1:735\n189#1:737,2\n189#1:739,9\n32#1:689,2\n45#1:691\n45#1:693\n66#1:694,3\n76#1:697,3\n115#1:700,7\n116#1:707,7\n125#1:714\n125#1:715,3\n126#1:718\n126#1:719,2\n129#1:721,3\n141#1:724\n141#1:725,3\n153#1:728\n153#1:729,3\n188#1:734\n188#1:748\n202#1:752,2\n189#1:736\n174#1:732,2\n197#1:749\n197#1:750,2\n*E\n"})
public final class SchemaGenerator {
    @NotNull
    private final String basePackage;
    @NotNull
    private final File outDir;
    @NotNull
    private final DatabaseType databaseType;
    @NotNull
    private final UUIDType uuidType;
    @NotNull
    private final Logger logger;

    public SchemaGenerator(@NotNull String basePackage, @NotNull File outDir, @NotNull DatabaseType databaseType, @NotNull UUIDType uuidType) {
        Intrinsics.checkNotNullParameter((Object)basePackage, (String)"basePackage");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)((Object)uuidType), (String)"uuidType");
        this.basePackage = basePackage;
        this.outDir = outDir;
        this.databaseType = databaseType;
        this.uuidType = uuidType;
        this.logger = new Logger(this.getClass(), null, 2, null);
    }

    public /* synthetic */ SchemaGenerator(String string, File file, DatabaseType databaseType, UUIDType uUIDType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            databaseType = DatabaseType.POSTGRES;
        }
        if ((n & 8) != 0) {
            uUIDType = UUIDType.UUID_V7;
        }
        this(string, file, databaseType, uUIDType);
    }

    public final void generate() {
        this.logger.info(() -> SchemaGenerator.generate$lambda$0(this));
        this.logger.info(() -> SchemaGenerator.generate$lambda$1(this));
        List<Class<?>> entities = new EntityScanner().findEntities();
        Map<String, List<Class<?>>> $this$forEach$iv = this.separateBySchema(entities);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<Class<?>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Class<?>>> element$iv;
            Map.Entry<String, List<Class<?>>> entry = element$iv = iterator.next();
            boolean bl = false;
            String schema = entry.getKey();
            List<Class<?>> list = entry.getValue();
            this.generateFiles(list, schema);
        }
        this.logger.info(SchemaGenerator::generate$lambda$3);
    }

    private final List<Class<?>> findEntities() {
        return new EntityScanner().findEntities();
    }

    private final Map<String, List<Class<?>>> separateBySchema(List<? extends Class<?>> entities) {
        HashMap<Object, List> map = new HashMap<Object, List>();
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Class entity;
            block6: {
                block5: {
                    Object schema;
                    Object object2;
                    entity = (Class)element$iv;
                    boolean bl = false;
                    Object object3 = entity.getAnnotation(Table.class);
                    if (object3 == null || (object3 = object3.schema()) == null) {
                        object3 = "";
                    }
                    Object it = object2 = (schema = object3);
                    boolean bl2 = false;
                    object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object2 : null;
                    if (object == null) break block5;
                    String string = ((String)object).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    object = string;
                    if (string != null) break block6;
                }
                String string = entity.getPackageName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
                String[] stringArray = new String[]{"."};
                object = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
            Object key = object;
            map.computeIfAbsent(key, arg_0 -> SchemaGenerator.separateBySchema$lambda$7$lambda$6(SchemaGenerator::separateBySchema$lambda$7$lambda$5, arg_0)).add(entity);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFiles(List<? extends Class<?>> entities, String schema) {
        List<String> idxList;
        if (entities.isEmpty()) {
            return;
        }
        File target = this.prepareTargetDirectory(schema);
        TableSqlGenerator tableGen = new TableSqlGenerator();
        ForeignKeyGenerator fkGen = new ForeignKeyGenerator();
        IndexGenerator idxGen = new IndexGenerator();
        if (this.databaseType == DatabaseType.POSTGRES && this.uuidType == UUIDType.UUID_V7) {
            boolean usesUuid;
            block10: {
                Iterable $this$any$iv = entities;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Class it = (Class)element$iv;
                        boolean bl = false;
                        if (!(this.idField(it) != null)) continue;
                        v0 = true;
                        break block10;
                    }
                    v0 = usesUuid = false;
                }
            }
            if (usesUuid) {
                File f = new File(target, "V0__setup_uuid_extension.sql");
                String sql = tableGen.generateUuidExtensionSetup();
                FilesKt.writeText$default((File)f, (String)this.formatPlainSql(sql), null, (int)2, null);
                this.logger.info(() -> SchemaGenerator.generateFiles$lambda$9(f));
            }
        }
        Iterable $this$forEachIndexed$iv = entities;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void e;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Class bl = (Class)item$iv;
            int i = n;
            boolean bl2 = false;
            String table = this.getTableName((Class<?>)e);
            File f = new File(target, "V" + (i + 1) + "__create_" + table + "_table.sql");
            String rawSql = tableGen.generateCreateTableSql((Class<?>)e, table);
            String formatted = this.formatCreateTableSql(rawSql);
            FilesKt.writeText$default((File)f, (String)formatted, null, (int)2, null);
            this.logger.info(() -> SchemaGenerator.generateFiles$lambda$11$lambda$10(f));
        }
        List<String> fkList = fkGen.generateAllForeignKeys(entities);
        if (!((Collection)fkList).isEmpty()) {
            File f = new File(target, "V" + (entities.size() + 1) + "__add_foreign_keys.sql");
            String sql = "-- Foreign Keys generated " + LocalDateTime.now() + "\n" + CollectionsKt.joinToString$default((Iterable)fkList, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
            FilesKt.writeText$default((File)f, (String)this.formatPlainSql(sql), null, (int)2, null);
            this.logger.info(() -> SchemaGenerator.generateFiles$lambda$12(f));
        }
        if (!((Collection)(idxList = idxGen.generateAllIndexes(entities))).isEmpty()) {
            File f = new File(target, "V" + (entities.size() + 2) + "__add_indexes.sql");
            String sql = "-- Indexes generated " + LocalDateTime.now() + "\n" + CollectionsKt.joinToString$default((Iterable)idxList, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
            FilesKt.writeText$default((File)f, (String)this.formatPlainSql(sql), null, (int)2, null);
            this.logger.info(() -> SchemaGenerator.generateFiles$lambda$13(f));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String formatCreateTableSql(String sql) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        int endIdx;
        int startIdx;
        List lines;
        block9: {
            int n;
            int n2;
            block8: {
                List $this$indexOfFirst$iv = lines = StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)sql)).toString());
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    String it2 = (String)item$iv;
                    boolean bl = false;
                    if (StringsKt.contains$default((CharSequence)it2, (CharSequence)"(", (boolean)false, (int)2, null)) {
                        n2 = index$iv;
                        break block8;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            startIdx = n2;
            List $this$indexOfLast$iv = lines;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it3 = (String)iterator$iv.previous();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it3)).toString(), (Object)");")) continue;
                n = iterator$iv.nextIndex();
                break block9;
            }
            n = endIdx = -1;
        }
        if (startIdx == -1 || endIdx == -1) {
            return ((Object)StringsKt.trim((CharSequence)sql)).toString() + "\n";
        }
        List header = lines.subList(0, startIdx + 1);
        List body = lines.subList(startIdx + 1, endIdx);
        List footer = lines.subList(endIdx, lines.size());
        Iterable bl = body;
        boolean $i$f$map = false;
        void var11_17 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (CharSequence)","));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl3 = false;
            boolean bl4 = !StringsKt.isBlank((CharSequence)it);
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cleanBody = (List)destination$iv$iv;
        List aligned = CollectionsKt.toMutableList((Collection)this.alignSqlColumns(cleanBody));
        Iterable $this$forEachIndexed$iv = aligned;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String cfr_ignored_0 = (String)item$iv;
            int i = n;
            boolean bl5 = false;
            aligned.set(i, i == CollectionsKt.getLastIndex((List)aligned) ? (String)aligned.get(i) : aligned.get(i) + ",");
        }
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)header, (Iterable)aligned), (Iterable)footer), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))).toString() + "\n";
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> alignSqlColumns(List<String> lines) {
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J.\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"de/alexanderwolz/commons/util/database/SchemaGenerator$alignSqlColumns$Col", "", "name", "", "type", "rest", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getType", "getRest", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lde/alexanderwolz/commons/util/database/SchemaGenerator$alignSqlColumns$Col;", "equals", "", "other", "hashCode", "", "toString", "commons-util"})
        public final class Col {
            private final String name;
            private final String type;
            private final String rest;

            public Col(String name, String type, String rest) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                this.name = name;
                this.type = type;
                this.rest = rest;
            }

            public final String getName() {
                return this.name;
            }

            public final String getType() {
                return this.type;
            }

            public final String getRest() {
                return this.rest;
            }

            public final String component1() {
                return this.name;
            }

            public final String component2() {
                return this.type;
            }

            public final String component3() {
                return this.rest;
            }

            public final Col copy(String name, String type, String rest) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                return new Col(name, type, rest);
            }

            public static /* synthetic */ Col copy$default(Col col, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = col.name;
                }
                if ((n & 2) != 0) {
                    string2 = col.type;
                }
                if ((n & 4) != 0) {
                    string3 = col.rest;
                }
                return col.copy(string, string2, string3);
            }

            public String toString() {
                return "Col(name=" + this.name + ", type=" + this.type + ", rest=" + this.rest + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + this.type.hashCode();
                result = result * 31 + (this.rest == null ? 0 : this.rest.hashCode());
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Col)) {
                    return false;
                }
                Col col = (Col)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)col.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.type, (Object)col.type)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.rest, (Object)col.rest);
            }
        }
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        Iterator $this$mapTo$iv$iv2;
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            String string;
            int n;
            void line;
            Object item$iv$iv = iterator.next();
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Regex regex = new Regex("\\s+");
            object = ((Object)StringsKt.trim((CharSequence)((CharSequence)line))).toString();
            List parts = regex.split((CharSequence)object, n = 3);
            String string3 = (String)CollectionsKt.getOrNull((List)parts, (int)0);
            if (string3 == null) {
                string3 = "";
            }
            if ((string = (String)CollectionsKt.getOrNull((List)parts, (int)1)) == null) {
                string = "";
            }
            collection.add(new Col(string3, string, (String)CollectionsKt.getOrNull((List)parts, (int)2)));
        }
        List parsed = (List)destination$iv$iv;
        $this$mapTo$iv$iv2 = ((Iterable)parsed).iterator();
        if (!$this$mapTo$iv$iv2.hasNext()) {
            throw new NoSuchElementException();
        }
        Col it422 = (Col)$this$mapTo$iv$iv2.next();
        boolean bl = false;
        int it422 = it422.getName().length();
        while ($this$mapTo$iv$iv2.hasNext()) {
            Col it32 = (Col)$this$mapTo$iv$iv2.next();
            $i$a$-maxOf-SchemaGenerator$alignSqlColumns$maxName$1 = false;
            int it32 = it32.getName().length();
            if (it422 >= it32) continue;
            it422 = it32;
        }
        int maxName = it422;
        Iterator it422 = ((Iterable)parsed).iterator();
        if (!it422.hasNext()) {
            throw new NoSuchElementException();
        }
        Col it622 = (Col)it422.next();
        boolean bl2 = false;
        int it622 = it622.getType().length();
        while (it422.hasNext()) {
            Col it52 = (Col)it422.next();
            $i$a$-maxOf-SchemaGenerator$alignSqlColumns$maxType$1 = false;
            int it52 = it52.getType().length();
            if (it622 >= it52) continue;
            it622 = it52;
        }
        int maxType = it622;
        Iterable $this$map$iv2 = parsed;
        boolean $i$f$map2 = false;
        Iterable it622 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void col;
            StringBuilder stringBuilder;
            object = (Col)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            StringBuilder $this$alignSqlColumns_u24lambda_u2423_u24lambda_u2422 = stringBuilder = new StringBuilder();
            boolean bl4 = false;
            $this$alignSqlColumns_u24lambda_u2423_u24lambda_u2422.append("    ");
            $this$alignSqlColumns_u24lambda_u2423_u24lambda_u2422.append(StringsKt.padEnd$default((String)col.getName(), (int)maxName, (char)'\u0000', (int)2, null));
            $this$alignSqlColumns_u24lambda_u2423_u24lambda_u2422.append("    ");
            $this$alignSqlColumns_u24lambda_u2423_u24lambda_u2422.append(StringsKt.padEnd$default((String)col.getType(), (int)maxType, (char)'\u0000', (int)2, null));
            if (col.getRest() != null) {
                $this$alignSqlColumns_u24lambda_u2423_u24lambda_u2422.append(" " + col.getRest());
            }
            collection.add(stringBuilder.toString());
        }
        return (List)destination$iv$iv2;
    }

    private final String formatPlainSql(String sql) {
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)sql)).toString();
        Regex regex = new Regex("\\n{3,}");
        String string = "\n\n";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString() + "\n";
    }

    private final File prepareTargetDirectory(String schemaKey) {
        File dir;
        block1: {
            String string = schemaKey.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            dir = new File(this.outDir, string);
            dir.mkdirs();
            File[] fileArray = dir.listFiles();
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.delete();
            }
        }
        return dir;
    }

    private final String getTableName(Class<?> clazz) {
        Object object;
        block6: {
            block5: {
                CharSequence charSequence;
                object = clazz.getAnnotation(Table.class);
                if (object == null || (object = object.name()) == null) break block5;
                CharSequence charSequence2 = (CharSequence)object;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl = false;
                    String string = clazz.getSimpleName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                    charSequence = this.toSnakeCase(string);
                } else {
                    charSequence = charSequence2;
                }
                if ((object = (String)charSequence) != null) break block6;
            }
            String string = clazz.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            object = this.toSnakeCase(string);
        }
        return object;
    }

    private final String toSnakeCase(String s) {
        CharSequence charSequence = s;
        Regex regex = new Regex("([a-z0-9])([A-Z])");
        String string = "$1_$2";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("([A-Z]+)([A-Z][a-z])");
        string = "$1_$2";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final Field idField(Class<?> $this$idField) {
        Object v8;
        block7: {
            Iterable $this$firstOrNull$iv = this.allPersistentFields($this$idField);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Object object;
                void $this$findAnnotationOnFieldOrGetter$iv;
                Field it = (Field)element$iv;
                boolean bl = false;
                SchemaGenerator schemaGenerator = this;
                Field field = it;
                Class<?> owner$iv = $this$idField;
                boolean $i$f$findAnnotationOnFieldOrGetter = false;
                if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(Id.class) != null) {
                    Id it$iv;
                    $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = '\u0000';
                    object = it$iv;
                } else {
                    String string;
                    String prefix$iv;
                    String string2 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                    String string3 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    String string4 = string3;
                    if (((CharSequence)string4).length() > 0) {
                        void it$iv22;
                        $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = string4.charAt(0);
                        StringBuilder stringBuilder = new StringBuilder();
                        String string5 = string2;
                        boolean bl2 = false;
                        String string6 = String.valueOf((char)it$iv22);
                        Intrinsics.checkNotNull((Object)string6, (String)"null cannot be cast to non-null type java.lang.String");
                        String string7 = string6.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toUpperCase(...)");
                        CharSequence charSequence = string7;
                        string2 = string5;
                        StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                        String it$iv22 = string4;
                        int n = 1;
                        String string8 = it$iv22.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                        string = stringBuilder2.append(string8).toString();
                    } else {
                        string = string4;
                    }
                    String getter$iv = string2 + string;
                    try {
                        string4 = owner$iv.getMethod(getter$iv, new Class[0]).getAnnotation(Id.class);
                    }
                    catch (Exception exception) {
                        string4 = null;
                    }
                    object = string4;
                }
                if (!(object != null)) continue;
                v8 = element$iv;
                break block7;
            }
            v8 = null;
        }
        return v8;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Field> allPersistentFields(Class<?> type) {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (Class<?> c = type; c != null && !Intrinsics.areEqual(c, Object.class); c = c.getSuperclass()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Field[] fieldArray = c.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] objectArray = fieldArray;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!(!Modifier.isStatic(it.getModifiers()) && !it.isSynthetic() && it.getAnnotation(Transient.class) == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Field f = (Field)element$iv;
                boolean bl = false;
                map.putIfAbsent(f.getName(), f);
            }
        }
        Collection collection = map.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ <A extends Annotation> A findAnnotationOnFieldOrGetter(Field $this$findAnnotationOnFieldOrGetter, Class<?> owner) {
        String string;
        String prefix;
        boolean $i$f$findAnnotationOnFieldOrGetter = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"A");
        Annotation annotation = $this$findAnnotationOnFieldOrGetter.getAnnotation(Annotation.class);
        if (annotation != null) {
            Annotation it = annotation;
            boolean bl = false;
            return (A)it;
        }
        String string2 = prefix = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter.getType(), Boolean.class) ? "is" : "get";
        String string3 = $this$findAnnotationOnFieldOrGetter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        Object object = string3;
        if (((CharSequence)object).length() > 0) {
            void it22;
            char bl = ((String)object).charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = string2;
            boolean bl2 = false;
            String string5 = String.valueOf((char)it22);
            Intrinsics.checkNotNull((Object)string5, (String)"null cannot be cast to non-null type java.lang.String");
            String string6 = string5.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
            CharSequence charSequence = string6;
            string2 = string4;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
            Object it22 = object;
            int n = 1;
            String string7 = ((String)it22).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            string = stringBuilder2.append(string7).toString();
        } else {
            string = object;
        }
        String getter = string2 + string;
        try {
            Method method = owner.getMethod(getter, new Class[0]);
            Intrinsics.reifiedOperationMarker((int)4, (String)"A");
            object = method.getAnnotation(Annotation.class);
        }
        catch (Exception exception) {
            object = null;
        }
        return (A)object;
    }

    private final String sqlType(Field field, Column col) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.databaseType.ordinal()]) {
            case 1 -> this.sqlTypePg(field, col);
            case 2 -> this.sqlTypeMaria(field, col);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String sqlTypePg(Field field, Column col) {
        Object object;
        String string;
        String string2;
        if (col != null && (string2 = col.columnDefinition()) != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            String string4 = string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
            if (string != null) {
                return string;
            }
        }
        Column column = col;
        int length = column != null ? column.length() : 255;
        string = field.getType().getSimpleName();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1153828870: {
                    if (!string.equals("LocalDateTime")) break;
                    n = 1;
                    break;
                }
                case -1910456534: {
                    if (!string.equals("JsonNode")) break;
                    n = 2;
                    break;
                }
                case -1808118735: {
                    if (!string.equals("String")) break;
                    n = 3;
                    break;
                }
                case 97526364: {
                    if (!string.equals("float")) break;
                    n = 4;
                    break;
                }
                case 798274969: {
                    if (!string.equals("LocalDate")) break;
                    n = 5;
                    break;
                }
                case 84300: {
                    if (!string.equals("URI")) break;
                    n = 6;
                    break;
                }
                case 3327612: {
                    if (!string.equals("long")) break;
                    n = 7;
                    break;
                }
                case 84303: {
                    if (!string.equals("URL")) break;
                    n = 6;
                    break;
                }
                case -456761901: {
                    if (!string.equals("ZonedDateTime")) break;
                    n = 8;
                    break;
                }
                case 1729365000: {
                    if (!string.equals("Boolean")) break;
                    n = 9;
                    break;
                }
                case 2616251: {
                    if (!string.equals("UUID")) break;
                    n = 10;
                    break;
                }
                case 79860828: {
                    if (!string.equals("Short")) break;
                    n = 11;
                    break;
                }
                case 798759096: {
                    if (!string.equals("LocalTime")) break;
                    n = 12;
                    break;
                }
                case 3039496: {
                    if (!string.equals("byte")) break;
                    n = 13;
                    break;
                }
                case -1325958191: {
                    if (!string.equals("double")) break;
                    n = 14;
                    break;
                }
                case -672743999: {
                    if (!string.equals("Instant")) break;
                    n = 1;
                    break;
                }
                case -1907858975: {
                    if (!string.equals("Period")) break;
                    n = 15;
                    break;
                }
                case -1927368268: {
                    if (!string.equals("Duration")) break;
                    n = 16;
                    break;
                }
                case 2052876273: {
                    if (!string.equals("Double")) break;
                    n = 14;
                    break;
                }
                case 104431: {
                    if (!string.equals("int")) break;
                    n = 17;
                    break;
                }
                case 1438607953: {
                    if (!string.equals("BigDecimal")) break;
                    n = 18;
                    break;
                }
                case -672261858: {
                    if (!string.equals("Integer")) break;
                    n = 17;
                    break;
                }
                case 67973692: {
                    if (!string.equals("Float")) break;
                    n = 4;
                    break;
                }
                case 64711720: {
                    if (!string.equals("boolean")) break;
                    n = 9;
                    break;
                }
                case -1378123410: {
                    if (!string.equals("OffsetDateTime")) break;
                    n = 8;
                    break;
                }
                case 2086184: {
                    if (!string.equals("Byte")) break;
                    n = 13;
                    break;
                }
                case 2374300: {
                    if (!string.equals("Long")) break;
                    n = 7;
                    break;
                }
                case 109413500: {
                    if (!string.equals("short")) break;
                    n = 11;
                    break;
                }
            }
            switch (n) {
                case 3: {
                    object = "VARCHAR(" + length + ")";
                    return object;
                }
                case 1: {
                    return "TIMESTAMP";
                }
                case 5: {
                    return "DATE";
                }
                case 12: {
                    return "TIME";
                }
                case 8: {
                    return "TIMESTAMP WITH TIME ZONE";
                }
                case 16: {
                    return "BIGINT";
                }
                case 15: {
                    return "VARCHAR(50)";
                }
                case 9: {
                    return "BOOLEAN";
                }
                case 13: {
                    return "SMALLINT";
                }
                case 11: {
                    return "SMALLINT";
                }
                case 17: {
                    return "INTEGER";
                }
                case 7: {
                    return "BIGINT";
                }
                case 4: {
                    return "REAL";
                }
                case 14: {
                    return "DOUBLE PRECISION";
                }
                case 18: {
                    Column column2 = col;
                    int p = column2 != null ? column2.precision() : 19;
                    Column column3 = col;
                    int s = column3 != null ? column3.scale() : 2;
                    object = "DECIMAL(" + p + "," + s + ")";
                    return object;
                }
                case 10: {
                    return "UUID";
                }
                case 6: {
                    return "VARCHAR(2048)";
                }
                case 2: {
                    return "JSONB";
                }
            }
        }
        if (field.getType().isEnum()) {
            return "VARCHAR(50)";
        }
        object = "VARCHAR(" + length + ")";
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String sqlTypeMaria(Field field, Column col) {
        Object object;
        String string;
        String string2;
        if (col != null && (string2 = col.columnDefinition()) != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            String string4 = string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
            if (string != null) {
                return string;
            }
        }
        Column column = col;
        int length = column != null ? column.length() : 255;
        string = field.getType().getSimpleName();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1153828870: {
                    if (!string.equals("LocalDateTime")) break;
                    n = 1;
                    break;
                }
                case -1910456534: {
                    if (!string.equals("JsonNode")) break;
                    n = 2;
                    break;
                }
                case -1808118735: {
                    if (!string.equals("String")) break;
                    n = 3;
                    break;
                }
                case 97526364: {
                    if (!string.equals("float")) break;
                    n = 4;
                    break;
                }
                case 798274969: {
                    if (!string.equals("LocalDate")) break;
                    n = 5;
                    break;
                }
                case 84300: {
                    if (!string.equals("URI")) break;
                    n = 6;
                    break;
                }
                case 3327612: {
                    if (!string.equals("long")) break;
                    n = 7;
                    break;
                }
                case 84303: {
                    if (!string.equals("URL")) break;
                    n = 6;
                    break;
                }
                case -456761901: {
                    if (!string.equals("ZonedDateTime")) break;
                    n = 8;
                    break;
                }
                case 1729365000: {
                    if (!string.equals("Boolean")) break;
                    n = 9;
                    break;
                }
                case 2616251: {
                    if (!string.equals("UUID")) break;
                    n = 10;
                    break;
                }
                case 79860828: {
                    if (!string.equals("Short")) break;
                    n = 11;
                    break;
                }
                case 798759096: {
                    if (!string.equals("LocalTime")) break;
                    n = 12;
                    break;
                }
                case 3039496: {
                    if (!string.equals("byte")) break;
                    n = 13;
                    break;
                }
                case -1325958191: {
                    if (!string.equals("double")) break;
                    n = 14;
                    break;
                }
                case -672743999: {
                    if (!string.equals("Instant")) break;
                    n = 1;
                    break;
                }
                case -1907858975: {
                    if (!string.equals("Period")) break;
                    n = 15;
                    break;
                }
                case -1927368268: {
                    if (!string.equals("Duration")) break;
                    n = 16;
                    break;
                }
                case 2052876273: {
                    if (!string.equals("Double")) break;
                    n = 14;
                    break;
                }
                case 104431: {
                    if (!string.equals("int")) break;
                    n = 17;
                    break;
                }
                case 1438607953: {
                    if (!string.equals("BigDecimal")) break;
                    n = 18;
                    break;
                }
                case -672261858: {
                    if (!string.equals("Integer")) break;
                    n = 17;
                    break;
                }
                case 67973692: {
                    if (!string.equals("Float")) break;
                    n = 4;
                    break;
                }
                case 64711720: {
                    if (!string.equals("boolean")) break;
                    n = 9;
                    break;
                }
                case -1378123410: {
                    if (!string.equals("OffsetDateTime")) break;
                    n = 8;
                    break;
                }
                case 2086184: {
                    if (!string.equals("Byte")) break;
                    n = 13;
                    break;
                }
                case 2374300: {
                    if (!string.equals("Long")) break;
                    n = 7;
                    break;
                }
                case 109413500: {
                    if (!string.equals("short")) break;
                    n = 11;
                    break;
                }
            }
            switch (n) {
                case 3: {
                    object = "VARCHAR(" + length + ")";
                    return object;
                }
                case 1: {
                    return "DATETIME";
                }
                case 5: {
                    return "DATE";
                }
                case 12: {
                    return "TIME";
                }
                case 8: {
                    return "DATETIME";
                }
                case 16: {
                    return "BIGINT";
                }
                case 15: {
                    return "VARCHAR(50)";
                }
                case 9: {
                    return "BOOLEAN";
                }
                case 13: {
                    return "TINYINT";
                }
                case 11: {
                    return "SMALLINT";
                }
                case 17: {
                    return "INT";
                }
                case 7: {
                    return "BIGINT";
                }
                case 4: {
                    return "FLOAT";
                }
                case 14: {
                    return "DOUBLE";
                }
                case 18: {
                    Column column2 = col;
                    int p = column2 != null ? column2.precision() : 19;
                    Column column3 = col;
                    int s = column3 != null ? column3.scale() : 2;
                    object = "DECIMAL(" + p + "," + s + ")";
                    return object;
                }
                case 10: {
                    return "CHAR(36)";
                }
                case 6: {
                    return "VARCHAR(2048)";
                }
                case 2: {
                    return "JSON";
                }
            }
        }
        if (field.getType().isEnum()) {
            return "VARCHAR(50)";
        }
        object = "VARCHAR(" + length + ")";
        return object;
    }

    private final String uuidDefaultSql() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.databaseType.ordinal()]) {
            case 1 -> {
                switch (WhenMappings.$EnumSwitchMapping$1[this.uuidType.ordinal()]) {
                    case 1: {
                        yield "DEFAULT public.uuid_generate_v7()";
                    }
                    case 2: {
                        yield "DEFAULT public.uuid_generate_v4()";
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2 -> "DEFAULT (UUID())";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String timestampDefault(String col) {
        return Intrinsics.areEqual((Object)col, (Object)"created_at") || Intrinsics.areEqual((Object)col, (Object)"updated_at") ? "DEFAULT CURRENT_TIMESTAMP" : null;
    }

    private static final String generate$lambda$0(SchemaGenerator this$0) {
        return "Generating SQL migrations from classes within '" + this$0.basePackage + "'";
    }

    private static final String generate$lambda$1(SchemaGenerator this$0) {
        return "Database Type: " + this$0.databaseType + ", UUID Type: " + this$0.uuidType;
    }

    private static final String generate$lambda$3() {
        return "done";
    }

    private static final List separateBySchema$lambda$7$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List separateBySchema$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final String generateFiles$lambda$9(File $f) {
        return "Created: " + $f.getParentFile().getName() + "/" + $f.getName();
    }

    private static final String generateFiles$lambda$11$lambda$10(File $f) {
        return "Created: " + $f.getParentFile().getName() + "/" + $f.getName();
    }

    private static final String generateFiles$lambda$12(File $f) {
        return "Created: " + $f.getParentFile().getName() + "/" + $f.getName();
    }

    private static final String generateFiles$lambda$13(File $f) {
        return "Created: " + $f.getParentFile().getName() + "/" + $f.getName();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lde/alexanderwolz/commons/util/database/SchemaGenerator$ColumnDef;", "", "name", "", "type", "constraints", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getType", "getConstraints", "()Ljava/util/List;", "toSql", "maxName", "", "maxType", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "commons-util"})
    private static final class ColumnDef {
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        @NotNull
        private final List<String> constraints;

        public ColumnDef(@NotNull String name, @NotNull String type, @NotNull List<String> constraints) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
            this.name = name;
            this.type = type;
            this.constraints = constraints;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final List<String> getConstraints() {
            return this.constraints;
        }

        @NotNull
        public final String toSql(int maxName, int maxType) {
            String n = StringsKt.padEnd$default((String)this.name, (int)maxName, (char)'\u0000', (int)2, null);
            String t = StringsKt.padEnd$default((String)this.type, (int)maxType, (char)'\u0000', (int)2, null);
            String c = !((Collection)this.constraints).isEmpty() ? " " + CollectionsKt.joinToString$default((Iterable)this.constraints, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) : "";
            return ((Object)StringsKt.trimEnd((CharSequence)("    " + n + " " + t + c))).toString();
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final List<String> component3() {
            return this.constraints;
        }

        @NotNull
        public final ColumnDef copy(@NotNull String name, @NotNull String type, @NotNull List<String> constraints) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
            return new ColumnDef(name, type, constraints);
        }

        public static /* synthetic */ ColumnDef copy$default(ColumnDef columnDef, String string, String string2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = columnDef.name;
            }
            if ((n & 2) != 0) {
                string2 = columnDef.type;
            }
            if ((n & 4) != 0) {
                list = columnDef.constraints;
            }
            return columnDef.copy(string, string2, list);
        }

        @NotNull
        public String toString() {
            return "ColumnDef(name=" + this.name + ", type=" + this.type + ", constraints=" + this.constraints + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + ((Object)this.constraints).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColumnDef)) {
                return false;
            }
            ColumnDef columnDef = (ColumnDef)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)columnDef.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)columnDef.type)) {
                return false;
            }
            return Intrinsics.areEqual(this.constraints, columnDef.constraints);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lde/alexanderwolz/commons/util/database/SchemaGenerator$DatabaseType;", "", "<init>", "(Ljava/lang/String;I)V", "POSTGRES", "MARIADB", "commons-util"})
    public static final class DatabaseType
    extends Enum<DatabaseType> {
        public static final /* enum */ DatabaseType POSTGRES = new DatabaseType();
        public static final /* enum */ DatabaseType MARIADB = new DatabaseType();
        private static final /* synthetic */ DatabaseType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DatabaseType[] values() {
            return (DatabaseType[])$VALUES.clone();
        }

        public static DatabaseType valueOf(String value) {
            return Enum.valueOf(DatabaseType.class, value);
        }

        @NotNull
        public static EnumEntries<DatabaseType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = databaseTypeArray = new DatabaseType[]{DatabaseType.POSTGRES, DatabaseType.MARIADB};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\fH\u0002\u00a8\u0006\r"}, d2={"Lde/alexanderwolz/commons/util/database/SchemaGenerator$EntityScanner;", "", "<init>", "(Lde/alexanderwolz/commons/util/database/SchemaGenerator;)V", "findEntities", "", "Ljava/lang/Class;", "scanDirectory", "", "dir", "Ljava/io/File;", "out", "", "commons-util"})
    @SourceDebugExtension(value={"SMAP\nSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator$EntityScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,688:1\n1869#2,2:689\n1321#3,2:691\n*S KotlinDebug\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator$EntityScanner\n*L\n651#1:689,2\n661#1:691,2\n*E\n"})
    private final class EntityScanner {
        @NotNull
        public final List<Class<?>> findEntities() {
            List out = new ArrayList();
            String path = StringsKt.replace$default((String)SchemaGenerator.this.basePackage, (char)'.', (char)'/', (boolean)false, (int)4, null);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> enumeration = loader.getResources(path);
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
            ArrayList<URL> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            List urls = arrayList;
            Iterable $this$forEach$iv = urls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                URL url = (URL)element$iv;
                boolean bl = false;
                File dir = new File(url.toURI());
                if (!dir.exists() || !dir.isDirectory()) continue;
                this.scanDirectory(dir, out);
            }
            return out;
        }

        /*
         * WARNING - void declaration
         */
        private final void scanDirectory(File dir, List<Class<?>> out) {
            void $this$forEach$iv;
            Sequence sequence = (Sequence)FilesKt.walkTopDown((File)dir);
            SchemaGenerator schemaGenerator = SchemaGenerator.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"$", (boolean)false, (int)2, null)) continue;
                String abs = file.getAbsolutePath();
                String pkgPath = StringsKt.replace$default((String)schemaGenerator.basePackage, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
                Intrinsics.checkNotNull((Object)abs);
                int start = StringsKt.indexOf$default((CharSequence)abs, (String)pkgPath, (int)0, (boolean)false, (int)6, null);
                if (start == -1) continue;
                String string3 = abs.substring(start);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String classPath = StringsKt.replace$default((String)StringsKt.removeSuffix((String)string3, (CharSequence)".class"), (char)File.separatorChar, (char)'.', (boolean)false, (int)4, null);
                try {
                    Class<?> clazz = Class.forName(classPath);
                    if (!clazz.isAnnotationPresent(Entity.class)) continue;
                    Intrinsics.checkNotNull(clazz);
                    out.add(clazz);
                    schemaGenerator.logger.info(() -> EntityScanner.scanDirectory$lambda$2$lambda$1(clazz));
                }
                catch (Exception exception) {
                }
            }
        }

        private static final String scanDirectory$lambda$2$lambda$1(Class $clazz) {
            return "Found entity: " + $clazz.getName();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0005\u00a8\u0006\t"}, d2={"Lde/alexanderwolz/commons/util/database/SchemaGenerator$ForeignKeyGenerator;", "", "<init>", "(Lde/alexanderwolz/commons/util/database/SchemaGenerator;)V", "generateAllForeignKeys", "", "", "entities", "Ljava/lang/Class;", "commons-util"})
    @SourceDebugExtension(value={"SMAP\nSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator$ForeignKeyGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,688:1\n1869#2:689\n1869#2:690\n1870#2:731\n1870#2:732\n211#3:691\n214#3,2:693\n213#3,9:695\n211#3:704\n214#3,2:706\n213#3,9:708\n211#3:717\n214#3,2:719\n213#3,9:721\n1#4:692\n1#4:705\n1#4:718\n1#4:730\n*S KotlinDebug\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator$ForeignKeyGenerator\n*L\n523#1:689\n526#1:690\n526#1:731\n523#1:732\n528#1:691\n528#1:693,2\n528#1:695,9\n529#1:704\n529#1:706,2\n529#1:708,9\n532#1:717\n532#1:719,2\n532#1:721,9\n528#1:692\n529#1:705\n532#1:718\n*E\n"})
    private final class ForeignKeyGenerator {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> generateAllForeignKeys(@NotNull List<? extends Class<?>> entities) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            List out = new ArrayList();
            Iterable iterable = entities;
            SchemaGenerator schemaGenerator = SchemaGenerator.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Class e = (Class)element$iv;
                boolean bl = false;
                String table = schemaGenerator.getTableName(e);
                Iterable $this$forEach$iv2 = schemaGenerator.allPersistentFields(e);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$generateAllForeignKeys_u24lambda_u244_u24lambda_u243_u24lambda_u242;
                    Object object;
                    String refTable;
                    Object colName;
                    JoinColumn join;
                    CharSequence prefix$iv;
                    block37: {
                        block36: {
                            CharSequence charSequence;
                            Object object2;
                            Field f;
                            block35: {
                                block34: {
                                    CharSequence charSequence2;
                                    Object object3;
                                    Annotation rel;
                                    SchemaGenerator this_$iv;
                                    Object object4;
                                    String getter$iv;
                                    CharSequence charSequence3;
                                    int n;
                                    String string;
                                    StringBuilder stringBuilder;
                                    Object object5;
                                    Object it$iv;
                                    char c2;
                                    Field $this$findAnnotationOnFieldOrGetter$iv;
                                    f = (Field)element$iv2;
                                    boolean bl2 = false;
                                    SchemaGenerator schemaGenerator2 = schemaGenerator;
                                    Field field = f;
                                    Class owner$iv = e;
                                    boolean $i$f$findAnnotationOnFieldOrGetter = false;
                                    if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(ManyToOne.class) != null) {
                                        c2 = '\u0000';
                                        object5 = it$iv;
                                    } else {
                                        Object object6;
                                        String string2 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                                        String string3 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                                        it$iv = string3;
                                        if (((CharSequence)it$iv).length() > 0) {
                                            void it$iv22;
                                            char c2 = ((String)it$iv).charAt(0);
                                            stringBuilder = new StringBuilder();
                                            string = string2;
                                            n = 0;
                                            String string4 = String.valueOf((char)it$iv22);
                                            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
                                            String string5 = string4.toUpperCase(Locale.ROOT);
                                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                                            charSequence3 = string5;
                                            string2 = string;
                                            StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence3);
                                            Object it$iv22 = it$iv;
                                            n = 1;
                                            String string6 = ((String)it$iv22).substring(n);
                                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                                            object6 = stringBuilder2.append(string6).toString();
                                        } else {
                                            object6 = it$iv;
                                        }
                                        getter$iv = string2 + (String)object6;
                                        try {
                                            it$iv = owner$iv.getMethod(getter$iv, new Class[0]).getAnnotation(ManyToOne.class);
                                        }
                                        catch (Exception exception) {
                                            it$iv = null;
                                        }
                                        object5 = it$iv;
                                    }
                                    if (object5 != null) {
                                        object4 = (Annotation)object5;
                                    } else {
                                        this_$iv = schemaGenerator;
                                        $this$findAnnotationOnFieldOrGetter$iv = f;
                                        owner$iv = e;
                                        $i$f$findAnnotationOnFieldOrGetter = false;
                                        OneToOne oneToOne = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(OneToOne.class);
                                        if (oneToOne != null) {
                                            it$iv = oneToOne;
                                            c2 = '\u0000';
                                            object4 = it$iv;
                                        } else {
                                            Object object7;
                                            String string7 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                                            String string8 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getName(...)");
                                            it$iv = string8;
                                            if (((CharSequence)it$iv).length() > 0) {
                                                void it$iv32;
                                                c2 = ((String)it$iv).charAt(0);
                                                stringBuilder = new StringBuilder();
                                                string = string7;
                                                n = 0;
                                                String string9 = String.valueOf((char)it$iv32);
                                                Intrinsics.checkNotNull((Object)string9, (String)"null cannot be cast to non-null type java.lang.String");
                                                String string10 = string9.toUpperCase(Locale.ROOT);
                                                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toUpperCase(...)");
                                                charSequence3 = string10;
                                                string7 = string;
                                                StringBuilder stringBuilder3 = stringBuilder.append((Object)charSequence3);
                                                Object it$iv32 = it$iv;
                                                n = 1;
                                                String string11 = ((String)it$iv32).substring(n);
                                                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"substring(...)");
                                                object7 = stringBuilder3.append(string11).toString();
                                            } else {
                                                object7 = it$iv;
                                            }
                                            getter$iv = string7 + (String)object7;
                                            try {
                                                it$iv = owner$iv.getMethod(getter$iv, new Class[0]).getAnnotation(OneToOne.class);
                                            }
                                            catch (Exception exception) {
                                                it$iv = null;
                                            }
                                            object4 = it$iv;
                                        }
                                    }
                                    if ((rel = object4) == null) continue;
                                    this_$iv = schemaGenerator;
                                    $this$findAnnotationOnFieldOrGetter$iv = f;
                                    owner$iv = e;
                                    $i$f$findAnnotationOnFieldOrGetter = false;
                                    JoinColumn joinColumn = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(JoinColumn.class);
                                    if (joinColumn != null) {
                                        it$iv = joinColumn;
                                        boolean bl3 = false;
                                        object3 = it$iv;
                                    } else {
                                        Object object8;
                                        String string12 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                                        String string13 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getName(...)");
                                        it$iv = string13;
                                        if (((CharSequence)it$iv).length() > 0) {
                                            void it$iv42;
                                            char bl3 = ((String)it$iv).charAt(0);
                                            stringBuilder = new StringBuilder();
                                            string = string12;
                                            n = 0;
                                            String string14 = String.valueOf((char)it$iv42);
                                            Intrinsics.checkNotNull((Object)string14, (String)"null cannot be cast to non-null type java.lang.String");
                                            String string15 = string14.toUpperCase(Locale.ROOT);
                                            Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"toUpperCase(...)");
                                            charSequence3 = string15;
                                            string12 = string;
                                            StringBuilder stringBuilder4 = stringBuilder.append((Object)charSequence3);
                                            Object it$iv42 = it$iv;
                                            int n2 = 1;
                                            String string16 = ((String)it$iv42).substring(n2);
                                            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"substring(...)");
                                            object8 = stringBuilder4.append(string16).toString();
                                        } else {
                                            object8 = it$iv;
                                        }
                                        getter$iv = string12 + (String)object8;
                                        try {
                                            it$iv = owner$iv.getMethod(getter$iv, new Class[0]).getAnnotation(JoinColumn.class);
                                        }
                                        catch (Exception exception) {
                                            it$iv = null;
                                        }
                                        object3 = it$iv;
                                    }
                                    if ((object2 = (join = (JoinColumn)object3)) == null || (object2 = object2.name()) == null) break block34;
                                    CharSequence $i$f$findAnnotationOnFieldOrGetter2 = (CharSequence)object2;
                                    if (StringsKt.isBlank((CharSequence)$i$f$findAnnotationOnFieldOrGetter2)) {
                                        boolean bl4 = false;
                                        charSequence2 = null;
                                    } else {
                                        charSequence2 = $i$f$findAnnotationOnFieldOrGetter2;
                                    }
                                    if ((object2 = (String)charSequence2) != null) break block35;
                                }
                                String string = f.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                object2 = schemaGenerator.toSnakeCase(string) + "_id";
                            }
                            colName = object2;
                            Class<?> clazz = f.getType();
                            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
                            refTable = schemaGenerator.getTableName(clazz);
                            object = join;
                            if (object == null || (object = object.foreignKey()) == null || (object = object.name()) == null) break block36;
                            prefix$iv = (CharSequence)object;
                            if (StringsKt.isBlank((CharSequence)prefix$iv)) {
                                boolean bl5 = false;
                                charSequence = null;
                            } else {
                                charSequence = object = prefix$iv;
                            }
                            if (charSequence != null) break block37;
                        }
                        object = "fk_" + table + "_" + (String)colName;
                    }
                    Object fkName = object;
                    JoinColumn joinColumn = join;
                    boolean nullable = joinColumn != null ? joinColumn.nullable() : true;
                    String deleteRule = nullable ? "SET NULL" : "CASCADE";
                    StringBuilder stringBuilder = new StringBuilder();
                    prefix$iv = stringBuilder;
                    List list = out;
                    boolean bl6 = false;
                    $this$generateAllForeignKeys_u24lambda_u244_u24lambda_u243_u24lambda_u242.append("-- Foreign key: " + table + "." + (String)colName + " -> " + refTable + ".id").append('\n');
                    $this$generateAllForeignKeys_u24lambda_u244_u24lambda_u243_u24lambda_u242.append("ALTER TABLE " + table).append('\n');
                    $this$generateAllForeignKeys_u24lambda_u244_u24lambda_u243_u24lambda_u242.append("    ADD CONSTRAINT " + (String)fkName).append('\n');
                    $this$generateAllForeignKeys_u24lambda_u244_u24lambda_u243_u24lambda_u242.append("    FOREIGN KEY (" + (String)colName + ")").append('\n');
                    $this$generateAllForeignKeys_u24lambda_u244_u24lambda_u243_u24lambda_u242.append("    REFERENCES " + refTable + "(id)").append('\n');
                    $this$generateAllForeignKeys_u24lambda_u244_u24lambda_u243_u24lambda_u242.append("    ON DELETE " + deleteRule + ";").append('\n');
                    list.add(stringBuilder.toString());
                }
            }
            return out;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0005\u00a8\u0006\t"}, d2={"Lde/alexanderwolz/commons/util/database/SchemaGenerator$IndexGenerator;", "", "<init>", "(Lde/alexanderwolz/commons/util/database/SchemaGenerator;)V", "generateAllIndexes", "", "", "entities", "Ljava/lang/Class;", "commons-util"})
    @SourceDebugExtension(value={"SMAP\nSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator$IndexGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,688:1\n1869#2:689\n1869#2:692\n1761#2,3:734\n1870#2:752\n1870#2:753\n1669#2,8:754\n13472#3,2:690\n12637#3:733\n12638#3:737\n211#4:693\n214#4,2:695\n213#4,9:697\n211#4:706\n214#4,2:708\n213#4,9:710\n211#4:719\n214#4,2:721\n213#4,9:723\n211#4:738\n214#4,2:740\n213#4,9:742\n1#5:694\n1#5:707\n1#5:720\n1#5:732\n1#5:739\n1#5:751\n*S KotlinDebug\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator$IndexGenerator\n*L\n564#1:689\n585#1:692\n597#1:734,3\n585#1:752\n564#1:753\n624#1:754,8\n569#1:690,2\n596#1:733\n596#1:737\n589#1:693\n589#1:695,2\n589#1:697,9\n590#1:706\n590#1:708,2\n590#1:710,9\n592#1:719\n592#1:721,2\n592#1:723,9\n611#1:738\n611#1:740,2\n611#1:742,9\n589#1:694\n590#1:707\n592#1:720\n611#1:739\n*E\n"})
    private final class IndexGenerator {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> generateAllIndexes(@NotNull List<? extends Class<?>> entities) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            List out = new ArrayList();
            Iterable iterable = entities;
            SchemaGenerator schemaGenerator = SchemaGenerator.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object idx;
                Index[] tableAnn;
                Class e = (Class)element$iv;
                boolean bl = false;
                String table = schemaGenerator.getTableName(e);
                Index[] indexArray = tableAnn = e.getAnnotation(Table.class);
                if (tableAnn != null && (indexArray = indexArray.indexes()) != null) {
                    Index[] $this$forEach$iv2 = indexArray;
                    boolean $i$f$forEach2 = false;
                    int n = $this$forEach$iv2.length;
                    for (int i = 0; i < n; ++i) {
                        void $this$generateAllIndexes_u24lambda_u2410_u24lambda_u242_u24lambda_u241;
                        StringBuilder stringBuilder2;
                        Object object;
                        Index element$iv2;
                        idx = element$iv2 = $this$forEach$iv2[i];
                        boolean bl2 = false;
                        CharSequence charSequence = idx.name();
                        if (StringsKt.isBlank((CharSequence)charSequence)) {
                            boolean stringBuilder2 = false;
                            object = "idx_" + table + "_" + StringsKt.replace$default((String)StringsKt.replace$default((String)idx.columnList(), (String)",", (String)"_", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null);
                        } else {
                            object = charSequence;
                        }
                        String name = (String)object;
                        String unique = idx.unique() ? "UNIQUE " : "";
                        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
                        List list = out;
                        boolean bl3 = false;
                        $this$generateAllIndexes_u24lambda_u2410_u24lambda_u242_u24lambda_u241.append("-- Index on " + table + "(" + idx.columnList() + ")").append('\n');
                        $this$generateAllIndexes_u24lambda_u2410_u24lambda_u242_u24lambda_u241.append("CREATE ");
                        $this$generateAllIndexes_u24lambda_u2410_u24lambda_u242_u24lambda_u241.append(unique);
                        $this$generateAllIndexes_u24lambda_u2410_u24lambda_u242_u24lambda_u241.append("INDEX " + name + " ON " + table + " (" + idx.columnList() + ");");
                        list.add(stringBuilder2.toString());
                    }
                }
                Iterable $this$forEach$iv3 = schemaGenerator.allPersistentFields(e);
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    void $this$generateAllIndexes_u24lambda_u2410_u24lambda_u249_u24lambda_u248;
                    Object object;
                    Object name;
                    List list;
                    Serializable owner$iv;
                    block56: {
                        Object object2;
                        Field f;
                        block55: {
                            CharSequence charSequence;
                            Column colAnn;
                            Object object3;
                            SchemaGenerator col;
                            String getter$iv;
                            void $this$findAnnotationOnFieldOrGetter$iv;
                            CharSequence charSequence2;
                            block52: {
                                void $this$generateAllIndexes_u24lambda_u2410_u24lambda_u249_u24lambda_u246;
                                boolean custom;
                                boolean bl4;
                                block50: {
                                    Object object4;
                                    block54: {
                                        block53: {
                                            CharSequence charSequence3;
                                            JoinColumn join;
                                            Object object5;
                                            Object getter$iv2;
                                            Object $this$findAnnotationOnFieldOrGetter$iv2;
                                            AnnotatedElement owner$iv2;
                                            block51: {
                                                Object object6;
                                                CharSequence charSequence4;
                                                int n;
                                                Object object7;
                                                Object it$iv;
                                                f = (Field)element$iv3;
                                                boolean bl5 = false;
                                                idx = schemaGenerator;
                                                Field bl2 = f;
                                                owner$iv2 = e;
                                                boolean $i$f$findAnnotationOnFieldOrGetter = false;
                                                if (((Field)$this$findAnnotationOnFieldOrGetter$iv2).getAnnotation(ManyToOne.class) != null) {
                                                    boolean bl6 = false;
                                                    object7 = it$iv;
                                                } else {
                                                    Object object8;
                                                    String prefix$iv;
                                                    String string = prefix$iv = Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv2).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv2).getType(), Boolean.class) ? "is" : "get";
                                                    String string2 = ((Field)$this$findAnnotationOnFieldOrGetter$iv2).getName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                                                    it$iv = string2;
                                                    if (((CharSequence)it$iv).length() > 0) {
                                                        void it$iv22;
                                                        char bl6 = ((String)it$iv).charAt(0);
                                                        StringBuilder bl3 = new StringBuilder();
                                                        charSequence2 = string;
                                                        n = 0;
                                                        String string3 = String.valueOf((char)it$iv22);
                                                        Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
                                                        String string4 = string3.toUpperCase(Locale.ROOT);
                                                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                                                        charSequence4 = string4;
                                                        string = charSequence2;
                                                        StringBuilder stringBuilder = bl3.append((Object)charSequence4);
                                                        Object it$iv22 = it$iv;
                                                        n = 1;
                                                        String string5 = ((String)it$iv22).substring(n);
                                                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                                                        object8 = stringBuilder.append(string5).toString();
                                                    } else {
                                                        object8 = it$iv;
                                                    }
                                                    getter$iv2 = string + (String)object8;
                                                    try {
                                                        it$iv = ((Class)owner$iv2).getMethod((String)getter$iv2, new Class[0]).getAnnotation(ManyToOne.class);
                                                    }
                                                    catch (Exception exception) {
                                                        it$iv = null;
                                                    }
                                                    object7 = it$iv;
                                                }
                                                if (object7 != null) break block51;
                                                SchemaGenerator this_$iv = schemaGenerator;
                                                $this$findAnnotationOnFieldOrGetter$iv2 = f;
                                                owner$iv2 = e;
                                                $i$f$findAnnotationOnFieldOrGetter = false;
                                                OneToOne oneToOne = ((Field)$this$findAnnotationOnFieldOrGetter$iv2).getAnnotation(OneToOne.class);
                                                if (oneToOne != null) {
                                                    it$iv = oneToOne;
                                                    boolean bl7 = false;
                                                    object6 = it$iv;
                                                } else {
                                                    Object object9;
                                                    String prefix$iv;
                                                    String string = prefix$iv = Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv2).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv2).getType(), Boolean.class) ? "is" : "get";
                                                    String string6 = ((Field)$this$findAnnotationOnFieldOrGetter$iv2).getName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                                                    it$iv = string6;
                                                    if (((CharSequence)it$iv).length() > 0) {
                                                        void it$iv32;
                                                        char bl7 = ((String)it$iv).charAt(0);
                                                        StringBuilder bl3 = new StringBuilder();
                                                        charSequence2 = string;
                                                        n = 0;
                                                        String string7 = String.valueOf((char)it$iv32);
                                                        Intrinsics.checkNotNull((Object)string7, (String)"null cannot be cast to non-null type java.lang.String");
                                                        String string8 = string7.toUpperCase(Locale.ROOT);
                                                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toUpperCase(...)");
                                                        charSequence4 = string8;
                                                        string = charSequence2;
                                                        StringBuilder stringBuilder = bl3.append((Object)charSequence4);
                                                        Object it$iv32 = it$iv;
                                                        n = 1;
                                                        String string9 = ((String)it$iv32).substring(n);
                                                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                                                        object9 = stringBuilder.append(string9).toString();
                                                    } else {
                                                        object9 = it$iv;
                                                    }
                                                    getter$iv2 = string + (String)object9;
                                                    try {
                                                        it$iv = ((Class)owner$iv2).getMethod((String)getter$iv2, new Class[0]).getAnnotation(OneToOne.class);
                                                    }
                                                    catch (Exception exception) {
                                                        it$iv = null;
                                                    }
                                                    object6 = it$iv;
                                                }
                                                if (object6 == null) break block52;
                                            }
                                            $this$findAnnotationOnFieldOrGetter$iv2 = schemaGenerator;
                                            owner$iv2 = f;
                                            owner$iv = e;
                                            boolean $i$f$findAnnotationOnFieldOrGetter22 = false;
                                            if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(JoinColumn.class) != null) {
                                                boolean bl8 = false;
                                                object5 = it$iv;
                                            } else {
                                                Object object10;
                                                String prefix$iv;
                                                String string = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                                                String string10 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getName(...)");
                                                it$iv = string10;
                                                if (((CharSequence)it$iv).length() > 0) {
                                                    void it$iv42;
                                                    char bl8 = ((String)it$iv).charAt(0);
                                                    charSequence2 = new StringBuilder();
                                                    String string11 = string;
                                                    int $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv2 = 0;
                                                    String string12 = String.valueOf((char)it$iv42);
                                                    Intrinsics.checkNotNull((Object)string12, (String)"null cannot be cast to non-null type java.lang.String");
                                                    String string13 = string12.toUpperCase(Locale.ROOT);
                                                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toUpperCase(...)");
                                                    getter$iv2 = string13;
                                                    string = string11;
                                                    StringBuilder stringBuilder = ((StringBuilder)charSequence2).append(getter$iv2);
                                                    Object it$iv42 = it$iv;
                                                    $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv2 = 1;
                                                    String string14 = ((String)it$iv42).substring($i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv2);
                                                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"substring(...)");
                                                    object10 = stringBuilder.append(string14).toString();
                                                } else {
                                                    object10 = it$iv;
                                                }
                                                getter$iv = string + (String)object10;
                                                try {
                                                    it$iv = ((Class)owner$iv).getMethod(getter$iv, new Class[0]).getAnnotation(JoinColumn.class);
                                                }
                                                catch (Exception exception) {
                                                    it$iv = null;
                                                }
                                                object5 = it$iv;
                                            }
                                            if ((object4 = (join = object5)) == null || (object4 = object4.name()) == null) break block53;
                                            CharSequence $i$f$findAnnotationOnFieldOrGetter22 = (CharSequence)object4;
                                            if (StringsKt.isBlank((CharSequence)$i$f$findAnnotationOnFieldOrGetter22)) {
                                                boolean bl9 = false;
                                                charSequence3 = null;
                                            } else {
                                                charSequence3 = $i$f$findAnnotationOnFieldOrGetter22;
                                            }
                                            if ((object4 = (String)charSequence3) != null) break block54;
                                        }
                                        String string = f.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                        object4 = schemaGenerator.toSnakeCase(string) + "_id";
                                    }
                                    col = object4;
                                    Index[] indexArray2 = tableAnn;
                                    if (tableAnn != null && (indexArray2 = indexArray2.indexes()) != null) {
                                        Index[] $this$any$iv = indexArray2;
                                        boolean $i$f$any = false;
                                        int n = $this$any$iv.length;
                                        for (int prefix$iv = 0; prefix$iv < n; ++prefix$iv) {
                                            boolean bl10;
                                            block49: {
                                                Index element$iv4;
                                                Index idx2 = element$iv4 = $this$any$iv[prefix$iv];
                                                boolean bl11 = false;
                                                getter$iv = new String[]{","};
                                                Iterable $this$any$iv2 = StringsKt.split$default((CharSequence)idx2.columnList(), (String[])getter$iv, (boolean)false, (int)0, (int)6, null);
                                                boolean $i$f$any2 = false;
                                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                                    bl10 = false;
                                                } else {
                                                    for (Object element$iv5 : $this$any$iv2) {
                                                        String it = (String)element$iv5;
                                                        boolean bl12 = false;
                                                        if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it)).toString(), (Object)col)) continue;
                                                        bl10 = true;
                                                        break block49;
                                                    }
                                                    bl10 = false;
                                                }
                                            }
                                            if (!bl10) continue;
                                            bl4 = true;
                                            break block50;
                                        }
                                        bl4 = false;
                                    } else {
                                        bl4 = false;
                                    }
                                }
                                if (custom = bl4) continue;
                                Serializable $i$f$findAnnotationOnFieldOrGetter22 = owner$iv = new StringBuilder();
                                list = out;
                                boolean bl13 = false;
                                $this$generateAllIndexes_u24lambda_u2410_u24lambda_u249_u24lambda_u246.append("-- Index on foreign key: " + table + "." + (String)((Object)col)).append('\n');
                                $this$generateAllIndexes_u24lambda_u2410_u24lambda_u249_u24lambda_u246.append("CREATE INDEX idx_" + table + "_" + (String)((Object)col) + " ON " + table + " (" + (String)((Object)col) + ");").append('\n');
                                list.add(((StringBuilder)owner$iv).toString());
                                continue;
                            }
                            col = schemaGenerator;
                            Field custom = f;
                            owner$iv = e;
                            boolean $i$f$findAnnotationOnFieldOrGetter32 = false;
                            if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(Column.class) != null) {
                                boolean bl14 = false;
                                object3 = it$iv;
                            } else {
                                Object object11;
                                String prefix$iv;
                                String string = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                                String string15 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"getName(...)");
                                it$iv = string15;
                                if (((CharSequence)it$iv).length() > 0) {
                                    void it$iv52;
                                    char bl14 = ((String)it$iv).charAt(0);
                                    charSequence2 = new StringBuilder();
                                    String string16 = string;
                                    boolean bl15 = false;
                                    String string17 = String.valueOf((char)it$iv52);
                                    Intrinsics.checkNotNull((Object)string17, (String)"null cannot be cast to non-null type java.lang.String");
                                    String string18 = string17.toUpperCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"toUpperCase(...)");
                                    CharSequence charSequence5 = string18;
                                    string = string16;
                                    StringBuilder stringBuilder = ((StringBuilder)charSequence2).append((Object)charSequence5);
                                    Object it$iv52 = it$iv;
                                    int n = 1;
                                    String string19 = ((String)it$iv52).substring(n);
                                    Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"substring(...)");
                                    object11 = stringBuilder.append(string19).toString();
                                } else {
                                    object11 = it$iv;
                                }
                                getter$iv = string + (String)object11;
                                try {
                                    it$iv = ((Class)owner$iv).getMethod(getter$iv, new Class[0]).getAnnotation(Column.class);
                                }
                                catch (Exception exception) {
                                    it$iv = null;
                                }
                                object3 = it$iv;
                            }
                            if ((object2 = (colAnn = object3)) == null || (object2 = object2.name()) == null) break block55;
                            CharSequence $i$f$findAnnotationOnFieldOrGetter32 = (CharSequence)object2;
                            if (StringsKt.isBlank((CharSequence)$i$f$findAnnotationOnFieldOrGetter32)) {
                                boolean bl16 = false;
                                charSequence = null;
                            } else {
                                charSequence = $i$f$findAnnotationOnFieldOrGetter32;
                            }
                            if ((object2 = (String)charSequence) != null) break block56;
                        }
                        String string = f.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        object2 = name = schemaGenerator.toSnakeCase(string);
                    }
                    if (!CollectionsKt.listOf((Object[])(object = new String[]{"email", "username", "subject", "code"})).contains(name)) continue;
                    object = new StringBuilder();
                    owner$iv = object;
                    list = out;
                    boolean bl17 = false;
                    $this$generateAllIndexes_u24lambda_u2410_u24lambda_u249_u24lambda_u248.append("-- Lookup index on " + table + "." + (String)name).append('\n');
                    $this$generateAllIndexes_u24lambda_u2410_u24lambda_u249_u24lambda_u248.append("CREATE INDEX idx_" + table + "_" + (String)name + " ON " + table + " (" + (String)name + ");").append('\n');
                    list.add(((StringBuilder)object).toString());
                }
            }
            Iterable $this$distinctBy$iv = out;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                String it = (String)e$iv;
                boolean bl = false;
                String key$iv = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)it, (String)"CREATE", null, (int)2, null), (String)"(", null, (int)2, null))).toString();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            return list$iv;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0014\u0010\t\u001a\u00020\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lde/alexanderwolz/commons/util/database/SchemaGenerator$TableSqlGenerator;", "", "<init>", "(Lde/alexanderwolz/commons/util/database/SchemaGenerator;)V", "generateCreateTableSql", "", "entity", "Ljava/lang/Class;", "tableName", "getIdType", "entityClass", "generateUuidExtensionSetup", "resolveEmbeddedColumns", "", "Lde/alexanderwolz/commons/util/database/SchemaGenerator$ColumnDef;", "field", "Ljava/lang/reflect/Field;", "commons-util"})
    @SourceDebugExtension(value={"SMAP\nSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator$TableSqlGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,688:1\n1869#2:689\n1870#2:810\n1869#2,2:818\n211#3:690\n214#3,2:692\n213#3,9:694\n211#3:703\n214#3,2:705\n213#3,9:707\n211#3:717\n214#3,2:719\n213#3,9:721\n211#3:730\n214#3,2:732\n213#3,9:734\n211#3:743\n214#3,2:745\n213#3,9:747\n211#3:756\n214#3,2:758\n213#3,9:760\n211#3:770\n214#3,2:772\n213#3,9:774\n211#3:783\n214#3,2:785\n213#3,9:787\n211#3:796\n214#3,2:798\n213#3,9:800\n1#4:691\n1#4:704\n1#4:716\n1#4:718\n1#4:731\n1#4:744\n1#4:757\n1#4:769\n1#4:771\n1#4:784\n1#4:797\n1#4:809\n13472#5,2:811\n13472#5,2:813\n3829#5:815\n4344#5,2:816\n*S KotlinDebug\n*F\n+ 1 SchemaGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator$TableSqlGenerator\n*L\n317#1:689\n317#1:810\n499#1:818,2\n318#1:690\n318#1:692,2\n318#1:694,9\n320#1:703\n320#1:705,2\n320#1:707,9\n323#1:717\n323#1:719,2\n323#1:721,9\n353#1:730\n353#1:732,2\n353#1:734,9\n354#1:743\n354#1:745,2\n354#1:747,9\n357#1:756\n357#1:758,2\n357#1:760,9\n369#1:770\n369#1:772,2\n369#1:774,9\n370#1:783\n370#1:785,2\n370#1:787,9\n373#1:796\n373#1:798,2\n373#1:800,9\n318#1:691\n320#1:704\n323#1:718\n353#1:731\n354#1:744\n357#1:757\n369#1:771\n370#1:784\n373#1:797\n490#1:811,2\n491#1:813,2\n498#1:815\n498#1:816,2\n*E\n"})
    private final class TableSqlGenerator {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String generateCreateTableSql(@NotNull Class<?> entity, @NotNull String tableName) {
            Object object;
            Object object2;
            Object object3;
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            List cols = new ArrayList();
            Iterable iterable = SchemaGenerator.this.allPersistentFields(entity);
            SchemaGenerator schemaGenerator = SchemaGenerator.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object4;
                Column colAnn;
                Field f;
                block105: {
                    block104: {
                        CharSequence charSequence;
                        Object object5;
                        Object object6;
                        CharSequence charSequence2;
                        Object object7;
                        Object name;
                        SchemaGenerator join;
                        Object it$iv;
                        boolean $i$f$findAnnotationOnFieldOrGetter;
                        Object owner$iv;
                        Object getter$iv;
                        CharSequence prefix$iv;
                        Object $this$findAnnotationOnFieldOrGetter$iv;
                        block101: {
                            Object object8;
                            block103: {
                                block102: {
                                    CharSequence charSequence3;
                                    Object object9;
                                    void $this$findAnnotationOnFieldOrGetter$iv2;
                                    Object object10;
                                    Object getter$iv2;
                                    Object object11;
                                    SchemaGenerator $this$findAnnotationOnFieldOrGetter$iv3;
                                    Object type;
                                    SchemaGenerator gen;
                                    Object it$iv42;
                                    Object it$iv5;
                                    block98: {
                                        Object object12;
                                        Object object13;
                                        CharSequence charSequence4;
                                        Object owner$iv2;
                                        block100: {
                                            block99: {
                                                CharSequence charSequence5;
                                                Object object14;
                                                String getter$iv3;
                                                int n;
                                                String string;
                                                StringBuilder stringBuilder;
                                                String prefix$iv2;
                                                Object object15;
                                                char c2;
                                                Object it$iv2;
                                                Field $this$findAnnotationOnFieldOrGetter$iv4;
                                                f = (Field)element$iv;
                                                boolean bl = false;
                                                SchemaGenerator schemaGenerator2 = schemaGenerator;
                                                Field field = f;
                                                owner$iv2 = entity;
                                                boolean $i$f$findAnnotationOnFieldOrGetter2 = false;
                                                Column column = $this$findAnnotationOnFieldOrGetter$iv4.getAnnotation(Column.class);
                                                if (column != null) {
                                                    it$iv2 = column;
                                                    c2 = '\u0000';
                                                    object15 = it$iv2;
                                                } else {
                                                    Object object16;
                                                    String string2 = prefix$iv2 = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv4.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv4.getType(), Boolean.class) ? "is" : "get";
                                                    String string3 = $this$findAnnotationOnFieldOrGetter$iv4.getName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                                                    it$iv2 = string3;
                                                    if (((CharSequence)it$iv2).length() > 0) {
                                                        void it$iv222;
                                                        char c2 = ((String)it$iv2).charAt(0);
                                                        stringBuilder = new StringBuilder();
                                                        string = string2;
                                                        n = 0;
                                                        String string4 = String.valueOf((char)it$iv222);
                                                        Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
                                                        String string5 = string4.toUpperCase(Locale.ROOT);
                                                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                                                        charSequence4 = string5;
                                                        string2 = string;
                                                        StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence4);
                                                        Object it$iv222 = it$iv2;
                                                        n = 1;
                                                        String string6 = ((String)it$iv222).substring(n);
                                                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                                                        object16 = stringBuilder2.append(string6).toString();
                                                    } else {
                                                        object16 = it$iv2;
                                                    }
                                                    getter$iv3 = string2 + (String)object16;
                                                    try {
                                                        it$iv2 = ((Class)owner$iv2).getMethod(getter$iv3, new Class[0]).getAnnotation(Column.class);
                                                    }
                                                    catch (Exception exception) {
                                                        it$iv2 = null;
                                                    }
                                                    object15 = it$iv2;
                                                }
                                                colAnn = object15;
                                                SchemaGenerator this_$iv = schemaGenerator;
                                                $this$findAnnotationOnFieldOrGetter$iv4 = f;
                                                owner$iv2 = entity;
                                                $i$f$findAnnotationOnFieldOrGetter2 = false;
                                                Id id = $this$findAnnotationOnFieldOrGetter$iv4.getAnnotation(Id.class);
                                                if (id != null) {
                                                    it$iv2 = id;
                                                    c2 = '\u0000';
                                                    object14 = it$iv2;
                                                } else {
                                                    Object object17;
                                                    String string7 = prefix$iv2 = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv4.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv4.getType(), Boolean.class) ? "is" : "get";
                                                    String string8 = $this$findAnnotationOnFieldOrGetter$iv4.getName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getName(...)");
                                                    it$iv2 = string8;
                                                    if (((CharSequence)it$iv2).length() > 0) {
                                                        void it$iv32;
                                                        c2 = ((String)it$iv2).charAt(0);
                                                        stringBuilder = new StringBuilder();
                                                        string = string7;
                                                        n = 0;
                                                        String string9 = String.valueOf((char)it$iv32);
                                                        Intrinsics.checkNotNull((Object)string9, (String)"null cannot be cast to non-null type java.lang.String");
                                                        String string10 = string9.toUpperCase(Locale.ROOT);
                                                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toUpperCase(...)");
                                                        charSequence4 = string10;
                                                        string7 = string;
                                                        StringBuilder stringBuilder3 = stringBuilder.append((Object)charSequence4);
                                                        Object it$iv32 = it$iv2;
                                                        n = 1;
                                                        String string11 = ((String)it$iv32).substring(n);
                                                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"substring(...)");
                                                        object17 = stringBuilder3.append(string11).toString();
                                                    } else {
                                                        object17 = it$iv2;
                                                    }
                                                    getter$iv3 = string7 + (String)object17;
                                                    try {
                                                        it$iv2 = ((Class)owner$iv2).getMethod(getter$iv3, new Class[0]).getAnnotation(Id.class);
                                                    }
                                                    catch (Exception exception) {
                                                        it$iv2 = null;
                                                    }
                                                    object14 = it$iv2;
                                                }
                                                if (object14 == null) break block98;
                                                object13 = colAnn;
                                                if (object13 == null || (object13 = object13.name()) == null) break block99;
                                                CharSequence $i$f$findAnnotationOnFieldOrGetter22 = (CharSequence)object13;
                                                if (StringsKt.isBlank((CharSequence)$i$f$findAnnotationOnFieldOrGetter22)) {
                                                    boolean bl2 = false;
                                                    charSequence5 = null;
                                                } else {
                                                    charSequence5 = $i$f$findAnnotationOnFieldOrGetter22;
                                                }
                                                if ((object13 = (String)charSequence5) != null) break block100;
                                            }
                                            String string = f.getName();
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                            object13 = schemaGenerator.toSnakeCase(string);
                                        }
                                        Object colName = object13;
                                        owner$iv2 = schemaGenerator;
                                        Field $i$f$findAnnotationOnFieldOrGetter22 = f;
                                        Object[] owner$iv3 = entity;
                                        boolean $i$f$findAnnotationOnFieldOrGetter3 = false;
                                        if (((Field)$this$findAnnotationOnFieldOrGetter$iv).getAnnotation(GeneratedValue.class) != null) {
                                            boolean bl = false;
                                            object12 = it$iv5;
                                        } else {
                                            Object object18;
                                            prefix$iv = Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.class) ? "is" : "get";
                                            CharSequence charSequence6 = prefix$iv;
                                            String string = ((Field)$this$findAnnotationOnFieldOrGetter$iv).getName();
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                            it$iv5 = string;
                                            if (((CharSequence)it$iv5).length() > 0) {
                                                void it$iv42;
                                                char bl = ((String)it$iv5).charAt(0);
                                                StringBuilder $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv4 = new StringBuilder();
                                                charSequence4 = charSequence6;
                                                int $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv2 = 0;
                                                String string12 = String.valueOf((char)it$iv42);
                                                Intrinsics.checkNotNull((Object)string12, (String)"null cannot be cast to non-null type java.lang.String");
                                                String string13 = string12.toUpperCase(Locale.ROOT);
                                                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toUpperCase(...)");
                                                CharSequence charSequence7 = string13;
                                                charSequence6 = charSequence4;
                                                StringBuilder stringBuilder = $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv4.append((Object)charSequence7);
                                                it$iv42 = it$iv5;
                                                $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv2 = 1;
                                                String string14 = ((String)it$iv42).substring($i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv2);
                                                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"substring(...)");
                                                object18 = stringBuilder.append(string14).toString();
                                            } else {
                                                object18 = it$iv5;
                                            }
                                            getter$iv = charSequence6 + (String)object18;
                                            try {
                                                it$iv5 = owner$iv3.getMethod((String)getter$iv, new Class[0]).getAnnotation(GeneratedValue.class);
                                            }
                                            catch (Exception exception) {
                                                it$iv5 = null;
                                            }
                                            object12 = it$iv5;
                                        }
                                        SchemaGenerator schemaGenerator3 = gen = object12;
                                        Object object19 = schemaGenerator3 != null ? schemaGenerator3.strategy() : null;
                                        type = switch (object19 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[object19.ordinal()]) {
                                            case 1 -> {
                                                switch (WhenMappings.$EnumSwitchMapping$0[schemaGenerator.databaseType.ordinal()]) {
                                                    case 1: {
                                                        yield "UUID";
                                                    }
                                                    case 2: {
                                                        yield "CHAR(36)";
                                                    }
                                                }
                                                throw new NoWhenBranchMatchedException();
                                            }
                                            case 2 -> {
                                                switch (WhenMappings.$EnumSwitchMapping$0[schemaGenerator.databaseType.ordinal()]) {
                                                    case 1: {
                                                        yield "BIGSERIAL";
                                                    }
                                                    case 2: {
                                                        yield "BIGINT";
                                                    }
                                                }
                                                throw new NoWhenBranchMatchedException();
                                            }
                                            default -> schemaGenerator.sqlType(f, colAnn);
                                        };
                                        owner$iv3 = new String[]{"PRIMARY KEY"};
                                        List constraints = CollectionsKt.mutableListOf((Object[])owner$iv3);
                                        SchemaGenerator schemaGenerator4 = gen;
                                        if ((schemaGenerator4 != null ? schemaGenerator4.strategy() : null) == GenerationType.UUID) {
                                            constraints.add(schemaGenerator.uuidDefaultSql());
                                        }
                                        SchemaGenerator schemaGenerator5 = gen;
                                        if ((schemaGenerator5 != null ? schemaGenerator5.strategy() : null) == GenerationType.IDENTITY && schemaGenerator.databaseType == DatabaseType.MARIADB) {
                                            constraints.add("AUTO_INCREMENT");
                                        }
                                        cols.add(new ColumnDef((String)colName, (String)type, constraints));
                                        continue;
                                    }
                                    gen = schemaGenerator;
                                    type = f;
                                    AnnotatedElement owner$iv4 = entity;
                                    boolean $i$f$findAnnotationOnFieldOrGetter4 = false;
                                    if (((Field)((Object)$this$findAnnotationOnFieldOrGetter$iv3)).getAnnotation(ManyToOne.class) != null) {
                                        boolean bl = false;
                                        object11 = it$iv;
                                    } else {
                                        Object object20;
                                        String prefix$iv3;
                                        String string = prefix$iv3 = Intrinsics.areEqual(((Field)((Object)$this$findAnnotationOnFieldOrGetter$iv3)).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)((Object)$this$findAnnotationOnFieldOrGetter$iv3)).getType(), Boolean.class) ? "is" : "get";
                                        String string15 = ((Field)((Object)$this$findAnnotationOnFieldOrGetter$iv3)).getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"getName(...)");
                                        it$iv = string15;
                                        if (((CharSequence)it$iv).length() > 0) {
                                            void it$iv3;
                                            char bl = ((String)it$iv).charAt(0);
                                            prefix$iv = new StringBuilder();
                                            String $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv4 = string;
                                            boolean $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv3 = false;
                                            String string16 = String.valueOf((char)it$iv3);
                                            Intrinsics.checkNotNull((Object)string16, (String)"null cannot be cast to non-null type java.lang.String");
                                            String string17 = string16.toUpperCase(Locale.ROOT);
                                            Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"toUpperCase(...)");
                                            CharSequence $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv2 = string17;
                                            string = $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv4;
                                            StringBuilder stringBuilder = ((StringBuilder)prefix$iv).append((Object)$i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv2);
                                            it$iv5 = it$iv;
                                            int n = 1;
                                            String string18 = ((String)it$iv5).substring(n);
                                            Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"substring(...)");
                                            object20 = stringBuilder.append(string18).toString();
                                        } else {
                                            object20 = it$iv;
                                        }
                                        getter$iv2 = string + (String)object20;
                                        try {
                                            it$iv = ((Class)owner$iv4).getMethod((String)getter$iv2, new Class[0]).getAnnotation(ManyToOne.class);
                                        }
                                        catch (Exception exception) {
                                            it$iv = null;
                                        }
                                        object11 = it$iv;
                                    }
                                    ManyToOne relMany = object11;
                                    $this$findAnnotationOnFieldOrGetter$iv3 = schemaGenerator;
                                    owner$iv4 = f;
                                    owner$iv = entity;
                                    $i$f$findAnnotationOnFieldOrGetter = false;
                                    if (((Field)$this$findAnnotationOnFieldOrGetter$iv).getAnnotation(OneToOne.class) != null) {
                                        boolean bl = false;
                                        object10 = it$iv;
                                    } else {
                                        Object object21;
                                        prefix$iv = Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.class) ? "is" : "get";
                                        String string = prefix$iv;
                                        String string19 = ((Field)$this$findAnnotationOnFieldOrGetter$iv).getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"getName(...)");
                                        it$iv = string19;
                                        if (((CharSequence)it$iv).length() > 0) {
                                            void it$iv6;
                                            char bl = ((String)it$iv).charAt(0);
                                            StringBuilder $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv4 = new StringBuilder();
                                            String string20 = string;
                                            int n = 0;
                                            String string21 = String.valueOf((char)it$iv6);
                                            Intrinsics.checkNotNull((Object)string21, (String)"null cannot be cast to non-null type java.lang.String");
                                            String string22 = string21.toUpperCase(Locale.ROOT);
                                            Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"toUpperCase(...)");
                                            getter$iv2 = string22;
                                            string = string20;
                                            StringBuilder stringBuilder = $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv4.append(getter$iv2);
                                            it$iv42 = it$iv;
                                            n = 1;
                                            String string23 = ((String)it$iv42).substring(n);
                                            Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"substring(...)");
                                            object21 = stringBuilder.append(string23).toString();
                                        } else {
                                            object21 = it$iv;
                                        }
                                        getter$iv = string + (String)object21;
                                        try {
                                            it$iv = ((Class)owner$iv).getMethod((String)getter$iv, new Class[0]).getAnnotation(OneToOne.class);
                                        }
                                        catch (Exception exception) {
                                            it$iv = null;
                                        }
                                        object10 = it$iv;
                                    }
                                    OneToOne relOne = object10;
                                    if (relMany == null && relOne == null) break block101;
                                    $this$findAnnotationOnFieldOrGetter$iv = schemaGenerator;
                                    owner$iv = f;
                                    Object[] owner$iv5 = entity;
                                    boolean $i$f$findAnnotationOnFieldOrGetter32 = false;
                                    if ($this$findAnnotationOnFieldOrGetter$iv2.getAnnotation(JoinColumn.class) != null) {
                                        boolean bl = false;
                                        object9 = it$iv;
                                    } else {
                                        Object object22;
                                        String prefix$iv4;
                                        String string = prefix$iv4 = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv2.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv2.getType(), Boolean.class) ? "is" : "get";
                                        String string24 = $this$findAnnotationOnFieldOrGetter$iv2.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"getName(...)");
                                        it$iv = string24;
                                        if (((CharSequence)it$iv).length() > 0) {
                                            void it$iv62;
                                            char bl = ((String)it$iv).charAt(0);
                                            StringBuilder stringBuilder = new StringBuilder();
                                            String n = string;
                                            boolean $i$a$-replaceFirstCharWithCharSequence-SchemaGenerator$findAnnotationOnFieldOrGetter$getter$1$iv5 = false;
                                            String string25 = String.valueOf((char)it$iv62);
                                            Intrinsics.checkNotNull((Object)string25, (String)"null cannot be cast to non-null type java.lang.String");
                                            String string26 = string25.toUpperCase(Locale.ROOT);
                                            Intrinsics.checkNotNullExpressionValue((Object)string26, (String)"toUpperCase(...)");
                                            getter$iv = string26;
                                            string = n;
                                            StringBuilder stringBuilder4 = stringBuilder.append(getter$iv);
                                            Object it$iv62 = it$iv;
                                            int n2 = 1;
                                            String string27 = ((String)it$iv62).substring(n2);
                                            Intrinsics.checkNotNullExpressionValue((Object)string27, (String)"substring(...)");
                                            object22 = stringBuilder4.append(string27).toString();
                                        } else {
                                            object22 = it$iv;
                                        }
                                        String getter$iv4 = string + (String)object22;
                                        try {
                                            it$iv = owner$iv5.getMethod(getter$iv4, new Class[0]).getAnnotation(JoinColumn.class);
                                        }
                                        catch (Exception exception) {
                                            it$iv = null;
                                        }
                                        object9 = it$iv;
                                    }
                                    if ((object8 = (join = object9)) == null || (object8 = object8.name()) == null) break block102;
                                    CharSequence $i$f$findAnnotationOnFieldOrGetter32 = (CharSequence)object8;
                                    if (StringsKt.isBlank((CharSequence)$i$f$findAnnotationOnFieldOrGetter32)) {
                                        boolean bl = false;
                                        charSequence3 = null;
                                    } else {
                                        charSequence3 = $i$f$findAnnotationOnFieldOrGetter32;
                                    }
                                    if ((object8 = (String)charSequence3) != null) break block103;
                                }
                                String string = f.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                object8 = schemaGenerator.toSnakeCase(string) + "_id";
                            }
                            name = object8;
                            SchemaGenerator schemaGenerator6 = join;
                            boolean nullable = schemaGenerator6 != null ? schemaGenerator6.nullable() : true;
                            Class<?> clazz = f.getType();
                            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
                            String refType = this.getIdType(clazz);
                            List constraints = !nullable ? CollectionsKt.listOf((Object)"NOT NULL") : CollectionsKt.emptyList();
                            cols.add(new ColumnDef((String)name, refType, constraints));
                            continue;
                        }
                        join = schemaGenerator;
                        name = f;
                        owner$iv = entity;
                        $i$f$findAnnotationOnFieldOrGetter = false;
                        OneToMany oneToMany = ((Field)$this$findAnnotationOnFieldOrGetter$iv).getAnnotation(OneToMany.class);
                        if (oneToMany != null) {
                            it$iv = oneToMany;
                            boolean bl = false;
                            object7 = it$iv;
                        } else {
                            Object object23;
                            CharSequence charSequence8 = prefix$iv = Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.class) ? "is" : "get";
                            String string = ((Field)$this$findAnnotationOnFieldOrGetter$iv).getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            it$iv = string;
                            if (((CharSequence)it$iv).length() > 0) {
                                void it$iv72;
                                char bl = ((String)it$iv).charAt(0);
                                StringBuilder stringBuilder = new StringBuilder();
                                CharSequence charSequence9 = charSequence8;
                                int n = 0;
                                String string28 = String.valueOf((char)it$iv72);
                                Intrinsics.checkNotNull((Object)string28, (String)"null cannot be cast to non-null type java.lang.String");
                                String string29 = string28.toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string29, (String)"toUpperCase(...)");
                                charSequence2 = string29;
                                charSequence8 = charSequence9;
                                StringBuilder stringBuilder5 = stringBuilder.append((Object)charSequence2);
                                Object it$iv72 = it$iv;
                                n = 1;
                                String string30 = ((String)it$iv72).substring(n);
                                Intrinsics.checkNotNullExpressionValue((Object)string30, (String)"substring(...)");
                                object23 = stringBuilder5.append(string30).toString();
                            } else {
                                object23 = it$iv;
                            }
                            getter$iv = (String)charSequence8 + (String)object23;
                            try {
                                it$iv = ((Class)owner$iv).getMethod((String)getter$iv, new Class[0]).getAnnotation(OneToMany.class);
                            }
                            catch (Exception exception) {
                                it$iv = null;
                            }
                            object7 = it$iv;
                        }
                        if (object7 != null) continue;
                        SchemaGenerator this_$iv = schemaGenerator;
                        $this$findAnnotationOnFieldOrGetter$iv = f;
                        owner$iv = entity;
                        $i$f$findAnnotationOnFieldOrGetter = false;
                        ManyToMany manyToMany = ((Field)$this$findAnnotationOnFieldOrGetter$iv).getAnnotation(ManyToMany.class);
                        if (manyToMany != null) {
                            it$iv = manyToMany;
                            boolean bl = false;
                            object6 = it$iv;
                        } else {
                            Object object24;
                            CharSequence charSequence10 = prefix$iv = Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.class) ? "is" : "get";
                            String string = ((Field)$this$findAnnotationOnFieldOrGetter$iv).getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            it$iv = string;
                            if (((CharSequence)it$iv).length() > 0) {
                                void it$iv82;
                                char bl = ((String)it$iv).charAt(0);
                                StringBuilder stringBuilder = new StringBuilder();
                                CharSequence charSequence11 = charSequence10;
                                int n = 0;
                                String string31 = String.valueOf((char)it$iv82);
                                Intrinsics.checkNotNull((Object)string31, (String)"null cannot be cast to non-null type java.lang.String");
                                String string32 = string31.toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string32, (String)"toUpperCase(...)");
                                charSequence2 = string32;
                                charSequence10 = charSequence11;
                                StringBuilder stringBuilder6 = stringBuilder.append((Object)charSequence2);
                                Object it$iv82 = it$iv;
                                n = 1;
                                String string33 = ((String)it$iv82).substring(n);
                                Intrinsics.checkNotNullExpressionValue((Object)string33, (String)"substring(...)");
                                object24 = stringBuilder6.append(string33).toString();
                            } else {
                                object24 = it$iv;
                            }
                            getter$iv = (String)charSequence10 + (String)object24;
                            try {
                                it$iv = ((Class)owner$iv).getMethod((String)getter$iv, new Class[0]).getAnnotation(ManyToMany.class);
                            }
                            catch (Exception exception) {
                                it$iv = null;
                            }
                            object6 = it$iv;
                        }
                        if (object6 != null) continue;
                        this_$iv = schemaGenerator;
                        $this$findAnnotationOnFieldOrGetter$iv = f;
                        owner$iv = entity;
                        $i$f$findAnnotationOnFieldOrGetter = false;
                        Embedded embedded = ((Field)$this$findAnnotationOnFieldOrGetter$iv).getAnnotation(Embedded.class);
                        if (embedded != null) {
                            it$iv = embedded;
                            boolean bl = false;
                            object5 = it$iv;
                        } else {
                            Object object25;
                            CharSequence charSequence12 = prefix$iv = Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv).getType(), Boolean.class) ? "is" : "get";
                            String string = ((Field)$this$findAnnotationOnFieldOrGetter$iv).getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            it$iv = string;
                            if (((CharSequence)it$iv).length() > 0) {
                                void it$iv92;
                                char bl = ((String)it$iv).charAt(0);
                                StringBuilder stringBuilder = new StringBuilder();
                                CharSequence charSequence13 = charSequence12;
                                boolean bl3 = false;
                                String string34 = String.valueOf((char)it$iv92);
                                Intrinsics.checkNotNull((Object)string34, (String)"null cannot be cast to non-null type java.lang.String");
                                String string35 = string34.toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string35, (String)"toUpperCase(...)");
                                charSequence2 = string35;
                                charSequence12 = charSequence13;
                                StringBuilder stringBuilder7 = stringBuilder.append((Object)charSequence2);
                                Object it$iv92 = it$iv;
                                int n = 1;
                                String string36 = ((String)it$iv92).substring(n);
                                Intrinsics.checkNotNullExpressionValue((Object)string36, (String)"substring(...)");
                                object25 = stringBuilder7.append(string36).toString();
                            } else {
                                object25 = it$iv;
                            }
                            getter$iv = (String)charSequence12 + (String)object25;
                            try {
                                it$iv = ((Class)owner$iv).getMethod((String)getter$iv, new Class[0]).getAnnotation(Embedded.class);
                            }
                            catch (Exception exception) {
                                it$iv = null;
                            }
                            object5 = it$iv;
                        }
                        if (object5 != null) {
                            cols.addAll((Collection)this.resolveEmbeddedColumns(f));
                            continue;
                        }
                        object4 = colAnn;
                        if (object4 == null || (object4 = object4.name()) == null) break block104;
                        CharSequence charSequence14 = (CharSequence)object4;
                        if (StringsKt.isBlank((CharSequence)charSequence14)) {
                            boolean bl = false;
                            charSequence = null;
                        } else {
                            charSequence = charSequence14;
                        }
                        if ((object4 = (String)charSequence) != null) break block105;
                    }
                    String string = f.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    object4 = schemaGenerator.toSnakeCase(string);
                }
                Object name = object4;
                String type = schemaGenerator.sqlType(f, colAnn);
                List c = new ArrayList();
                Column column = colAnn;
                boolean bl = column != null ? !column.nullable() : false;
                if (bl) {
                    c.add("NOT NULL");
                }
                Column column2 = colAnn;
                boolean bl4 = column2 != null ? column2.unique() : false;
                if (bl4) {
                    c.add("UNIQUE");
                }
                if (schemaGenerator.timestampDefault((String)name) != null) {
                    String it;
                    boolean bl5 = false;
                    v97 = c.add(it);
                } else {
                    v97 = null;
                }
                cols.add(new ColumnDef((String)name, type, c));
            }
            Iterator iterator = ((Iterable)cols).iterator();
            if (!iterator.hasNext()) {
                object3 = null;
            } else {
                ColumnDef it = (ColumnDef)iterator.next();
                boolean bl = false;
                object2 = it.getName().length();
                while (iterator.hasNext()) {
                    Object it2 = (ColumnDef)iterator.next();
                    $i$a$-maxOfOrNull-SchemaGenerator$TableSqlGenerator$generateCreateTableSql$maxName$1 = false;
                    if (object2.compareTo(it2 = (Comparable)Integer.valueOf(((ColumnDef)it2).getName().length())) >= 0) continue;
                    object2 = it2;
                }
                object3 = object2;
            }
            Integer n = (Integer)object3;
            int maxName = n != null ? n : 1;
            object2 = ((Iterable)cols).iterator();
            if (!object2.hasNext()) {
                object = null;
            } else {
                Object it = (ColumnDef)object2.next();
                boolean bl = false;
                it = ((ColumnDef)it).getType().length();
                while (object2.hasNext()) {
                    Object it3 = (ColumnDef)object2.next();
                    $i$a$-maxOfOrNull-SchemaGenerator$TableSqlGenerator$generateCreateTableSql$maxType$1 = false;
                    if (it.compareTo(it3 = (Comparable)Integer.valueOf(((ColumnDef)it3).getType().length())) >= 0) continue;
                    it = it3;
                }
                object = it;
            }
            Integer n3 = (Integer)object;
            int maxType = n3 != null ? n3 : 1;
            String body = CollectionsKt.joinToString$default((Iterable)cols, (CharSequence)",\n", null, null, (int)0, null, arg_0 -> TableSqlGenerator.generateCreateTableSql$lambda$7(maxName, maxType, arg_0), (int)30, null);
            iterator = SchemaGenerator.this;
            Object $this$generateCreateTableSql_u24lambda_u248 = object2 = new StringBuilder();
            boolean bl = false;
            ((StringBuilder)$this$generateCreateTableSql_u24lambda_u248).append("-- create_" + tableName + "_table").append('\n');
            ((StringBuilder)$this$generateCreateTableSql_u24lambda_u248).append("-- Entity: " + entity.getSimpleName() + " [" + entity.getName() + "]").append('\n');
            ((StringBuilder)$this$generateCreateTableSql_u24lambda_u248).append("-- Database: " + ((SchemaGenerator)((Object)iterator)).databaseType).append('\n');
            ((StringBuilder)$this$generateCreateTableSql_u24lambda_u248).append('\n');
            ((StringBuilder)$this$generateCreateTableSql_u24lambda_u248).append("CREATE TABLE " + tableName + " (").append('\n');
            ((StringBuilder)$this$generateCreateTableSql_u24lambda_u248).append(body);
            ((StringBuilder)$this$generateCreateTableSql_u24lambda_u248).append('\n');
            ((StringBuilder)$this$generateCreateTableSql_u24lambda_u248).append(");").append('\n');
            return ((StringBuilder)object2).toString();
        }

        private final String getIdType(Class<?> entityClass) {
            GeneratedValue gen;
            Field field = SchemaGenerator.this.idField(entityClass);
            if (field == null) {
                return switch (WhenMappings.$EnumSwitchMapping$0[SchemaGenerator.this.databaseType.ordinal()]) {
                    case 1 -> "BIGINT";
                    case 2 -> "BIGINT";
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
            Field idField = field;
            Column col = idField.getAnnotation(Column.class);
            GeneratedValue generatedValue = gen = idField.getAnnotation(GeneratedValue.class);
            if ((generatedValue != null ? generatedValue.strategy() : null) == GenerationType.UUID) {
                return switch (WhenMappings.$EnumSwitchMapping$0[SchemaGenerator.this.databaseType.ordinal()]) {
                    case 1 -> "UUID";
                    case 2 -> "CHAR(36)";
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
            GeneratedValue generatedValue2 = gen;
            if ((generatedValue2 != null ? generatedValue2.strategy() : null) == GenerationType.IDENTITY) {
                return switch (WhenMappings.$EnumSwitchMapping$0[SchemaGenerator.this.databaseType.ordinal()]) {
                    case 1 -> "BIGSERIAL";
                    case 2 -> "BIGINT";
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
            if (Intrinsics.areEqual((Object)idField.getType().getSimpleName(), (Object)"UUID")) {
                return switch (WhenMappings.$EnumSwitchMapping$0[SchemaGenerator.this.databaseType.ordinal()]) {
                    case 1 -> "UUID";
                    case 2 -> "CHAR(36)";
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
            return SchemaGenerator.this.sqlType(idField, col);
        }

        @NotNull
        public final String generateUuidExtensionSetup() {
            return switch (WhenMappings.$EnumSwitchMapping$2[SchemaGenerator.this.uuidType.ordinal()]) {
                case 1 -> {
                    StringBuilder var1_1;
                    StringBuilder $this$generateUuidExtensionSetup_u24lambda_u249 = var1_1 = new StringBuilder();
                    boolean $i$a$-buildString-SchemaGenerator$TableSqlGenerator$generateUuidExtensionSetup$1 = false;
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("-- Setup UUID v7 (pgcrypto + idempotent function creation)").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("CREATE EXTENSION IF NOT EXISTS pgcrypto SCHEMA public;").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("DO $$").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("BEGIN").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("    IF NOT EXISTS (").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("        SELECT 1 FROM pg_proc WHERE proname = 'uuid_generate_v7'").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("    ) THEN").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("        CREATE FUNCTION public.uuid_generate_v7()").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("        RETURNS UUID AS $fn$").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("        DECLARE").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("            unix_ts_ms BIGINT;").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("            uuid_bytes BYTEA;").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("        BEGIN").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("            unix_ts_ms := (EXTRACT(EPOCH FROM CLOCK_TIMESTAMP()) * 1000)::BIGINT;").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("            uuid_bytes := public.gen_random_bytes(16);").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("            uuid_bytes := OVERLAY(uuid_bytes PLACING substring(int8send(unix_ts_ms) FROM 3) FROM 1 FOR 6);").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("            uuid_bytes := SET_BYTE(uuid_bytes, 6, (GET_BYTE(uuid_bytes, 6) & 15) | 112);").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("            uuid_bytes := SET_BYTE(uuid_bytes, 8, (GET_BYTE(uuid_bytes, 8) & 63) | 128);").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("            RETURN encode(uuid_bytes, 'hex')::UUID;").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("        END;").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("        $fn$ LANGUAGE plpgsql VOLATILE;").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("    END IF;").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("END").append('\n');
                    $this$generateUuidExtensionSetup_u24lambda_u249.append("$$;").append('\n');
                    yield var1_1.toString();
                }
                case 2 -> {
                    Object[] var1_2 = new String[]{"-- Setup UUID v4", "CREATE EXTENSION IF NOT EXISTS \"uuid-ossp\" SCHEMA public;"};
                    yield CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])var1_2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        /*
         * WARNING - void declaration
         */
        private final List<ColumnDef> resolveEmbeddedColumns(Field field) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$forEach$iv2;
            String string = field.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String prefix = SchemaGenerator.this.toSnakeCase(string) + "_";
            Class<?> type = field.getType();
            if (!type.isAnnotationPresent(Embeddable.class)) {
                return CollectionsKt.emptyList();
            }
            Map overrides = new LinkedHashMap();
            Annotation[] annotationArray = field.getAnnotationsByType(AttributeOverride.class);
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getAnnotationsByType(...)");
            Object[] objectArray = annotationArray;
            boolean $i$f$forEach22 = false;
            for (void element$iv : $this$forEach$iv2) {
                AttributeOverride it = (AttributeOverride)element$iv;
                boolean bl = false;
                overrides.put(it.name(), it.column());
            }
            AttributeOverride[] attributeOverrideArray = field.getAnnotation(AttributeOverrides.class);
            if (attributeOverrideArray != null && (attributeOverrideArray = attributeOverrideArray.value()) != null) {
                AttributeOverride[] $this$forEach$iv3 = attributeOverrideArray;
                boolean $i$f$forEach = false;
                int it = $this$forEach$iv3.length;
                for (int element$iv = 0; element$iv < it; ++element$iv) {
                    AttributeOverride element$iv2;
                    AttributeOverride it2 = element$iv2 = $this$forEach$iv3[element$iv];
                    boolean bl = false;
                    overrides.put(it2.name(), it2.column());
                }
            }
            List out = new ArrayList();
            Field[] fieldArray = type.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] $i$f$forEach22 = fieldArray;
            boolean $i$f$filter = false;
            void $i$f$forEach = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!(!it.isSynthetic() && !Modifier.isStatic(it.getModifiers()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            SchemaGenerator schemaGenerator = SchemaGenerator.this;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                Column colAnn;
                Field ef;
                block15: {
                    Object object2;
                    Object object3;
                    block14: {
                        Object bl;
                        ef = (Field)element$iv;
                        boolean bl2 = false;
                        Column override = (Column)overrides.get(ef.getName());
                        Column column = override;
                        if (column == null) {
                            column = colAnn = ef.getAnnotation(Column.class);
                        }
                        if ((object = override) == null || (object = object.name()) == null) break block14;
                        Object it = bl = object;
                        boolean bl3 = false;
                        object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? bl : null;
                        if (object != null) break block15;
                    }
                    if ((object3 = colAnn) != null && (object3 = object3.name()) != null) {
                        Object object4;
                        Object it = object4 = object3;
                        boolean bl = false;
                        object2 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object4 : null;
                    } else {
                        object2 = object = null;
                    }
                    if (object2 == null) {
                        String string2 = ef.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        object = prefix + schemaGenerator.toSnakeCase(string2);
                    }
                }
                Object colName = object;
                Column column = colAnn;
                boolean nullable = column != null ? column.nullable() : true;
                Intrinsics.checkNotNull((Object)ef);
                String typeStr = schemaGenerator.sqlType(ef, colAnn);
                List cons = !nullable ? CollectionsKt.listOf((Object)"NOT NULL") : CollectionsKt.emptyList();
                out.add(new ColumnDef((String)colName, typeStr, cons));
            }
            return out;
        }

        private static final CharSequence generateCreateTableSql$lambda$7(int $maxName, int $maxType, ColumnDef it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.toSql($maxName, $maxType);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;

            static {
                int[] nArray = new int[DatabaseType.values().length];
                try {
                    nArray[DatabaseType.POSTGRES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DatabaseType.MARIADB.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[GenerationType.values().length];
                try {
                    nArray[GenerationType.UUID.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GenerationType.IDENTITY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[UUIDType.values().length];
                try {
                    nArray[UUIDType.UUID_V7.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UUIDType.UUID_V4.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lde/alexanderwolz/commons/util/database/SchemaGenerator$UUIDType;", "", "<init>", "(Ljava/lang/String;I)V", "UUID_V4", "UUID_V7", "commons-util"})
    public static final class UUIDType
    extends Enum<UUIDType> {
        public static final /* enum */ UUIDType UUID_V4 = new UUIDType();
        public static final /* enum */ UUIDType UUID_V7 = new UUIDType();
        private static final /* synthetic */ UUIDType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UUIDType[] values() {
            return (UUIDType[])$VALUES.clone();
        }

        public static UUIDType valueOf(String value) {
            return Enum.valueOf(UUIDType.class, value);
        }

        @NotNull
        public static EnumEntries<UUIDType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = uUIDTypeArray = new UUIDType[]{UUIDType.UUID_V4, UUIDType.UUID_V7};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.POSTGRES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MARIADB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UUIDType.values().length];
            try {
                nArray[UUIDType.UUID_V7.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UUIDType.UUID_V4.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

