/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.util.database;

import de.alexanderwolz.commons.log.Logger;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0002J\"\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0012H\u0002J0\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r0\u00142\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0002J\"\u0010\u0015\u001a\u00020\u000b2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J,\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\n\b\u0000\u0010\u001a\u0018\u0001*\u00020\u001b*\u00020\u00182\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0082\b\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001e\u001a\u00020\u00032\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u001c\u0010 \u001a\u00020\u00032\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010!\u001a\u00020\u0003H\u0002J(\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0002J(\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010)\u001a\u00020\u0003H\u0002J \u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0002J \u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0002J\u001a\u0010,\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00182\b\b\u0002\u0010-\u001a\u00020&H\u0002J\u0014\u0010.\u001a\u00020\u00032\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0010\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lde/alexanderwolz/commons/util/database/SchemaGenerator;", "", "basePackage", "", "outDir", "Ljava/io/File;", "<init>", "(Ljava/lang/String;Ljava/io/File;)V", "logger", "Lde/alexanderwolz/commons/log/Logger;", "generate", "", "findEntities", "", "Ljava/lang/Class;", "scanDirectory", "directory", "entities", "", "separateBySchema", "", "generateFiles", "type", "allPersistentFields", "Ljava/lang/reflect/Field;", "findAnnotationOnFieldOrGetter", "A", "", "owner", "(Ljava/lang/reflect/Field;Ljava/lang/Class;)Ljava/lang/annotation/Annotation;", "getIdType", "entity", "generateCreateTableSql", "tableName", "formatColumn", "name", "constraints", "maxLength", "", "resolveEmbeddedColumns", "field", "prefix", "generateAllForeignKeys", "generateAllIndexes", "sqlType", "length", "getTableName", "clazz", "toSnakeCase", "s", "commons-util"})
@SourceDebugExtension(value={"SMAP\nFlywayMigrationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywayMigrationGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,400:1\n132#1:421\n134#1:423\n133#1,8:424\n132#1:433\n134#1:435\n133#1,8:436\n132#1:445\n134#1:447\n133#1,8:448\n132#1:456\n134#1:458\n133#1,8:459\n132#1:467\n134#1:469\n133#1,8:470\n132#1:478\n134#1:480\n133#1,8:481\n132#1:489\n134#1:491\n133#1,8:492\n132#1:500\n134#1:502\n133#1,8:503\n132#1:511\n134#1:513\n133#1,8:514\n132#1:522\n134#1:524\n133#1,8:525\n132#1:533\n134#1:535\n133#1,8:536\n132#1:544\n134#1:546\n133#1,8:547\n132#1:570\n134#1:572\n133#1,8:573\n132#1:581\n134#1:583\n133#1,8:584\n132#1:592\n134#1:594\n133#1,8:595\n132#1:609\n134#1:611\n133#1,8:612\n132#1:620\n134#1:622\n133#1,8:623\n132#1:631\n134#1:633\n133#1,8:634\n132#1:647\n134#1:649\n133#1,8:650\n132#1:660\n134#1:662\n133#1,8:663\n216#2,2:401\n1869#3,2:403\n1869#3:407\n1870#3:409\n1878#3,3:412\n1869#3,2:418\n295#3:420\n296#3:432\n1869#3:444\n1870#3:555\n1878#3,3:556\n1869#3,2:566\n1869#3:568\n1869#3:569\n1870#3:603\n1870#3:604\n1869#3:605\n1869#3:608\n1761#3,3:643\n1870#3:658\n1870#3:659\n1321#4,2:405\n1#5:408\n1#5:422\n1#5:434\n1#5:446\n1#5:457\n1#5:468\n1#5:479\n1#5:490\n1#5:501\n1#5:512\n1#5:523\n1#5:534\n1#5:545\n1#5:571\n1#5:582\n1#5:593\n1#5:610\n1#5:621\n1#5:632\n1#5:648\n1#5:661\n13472#6,2:410\n3829#6:415\n4344#6,2:416\n13472#6,2:559\n13472#6,2:561\n3829#6:563\n4344#6,2:564\n13472#6,2:606\n12637#6:642\n12638#6:646\n*S KotlinDebug\n*F\n+ 1 FlywayMigrationGenerator.kt\nde/alexanderwolz/commons/util/database/SchemaGenerator\n*L\n146#1:421\n146#1:423\n146#1:424,8\n149#1:433\n149#1:435\n149#1:436,8\n167#1:445\n167#1:447\n167#1:448,8\n168#1:456\n168#1:458\n168#1:459,8\n170#1:467\n170#1:469\n170#1:470,8\n187#1:478\n187#1:480\n187#1:481,8\n188#1:489\n188#1:491\n188#1:492,8\n189#1:500\n189#1:502\n189#1:503,8\n197#1:511\n197#1:513\n197#1:514,8\n198#1:522\n198#1:524\n198#1:525,8\n202#1:533\n202#1:535\n202#1:536,8\n207#1:544\n207#1:546\n207#1:547,8\n287#1:570\n287#1:572\n287#1:573,8\n288#1:581\n288#1:583\n288#1:584,8\n290#1:592\n290#1:594\n290#1:595,8\n325#1:609\n325#1:611\n325#1:612,8\n326#1:620\n326#1:622\n326#1:623,8\n328#1:631\n328#1:633\n328#1:634,8\n338#1:647\n338#1:649\n338#1:650,8\n374#1:660\n374#1:662\n374#1:663,8\n26#1:401,2\n38#1:403,2\n74#1:407\n74#1:409\n88#1:412,3\n125#1:418,2\n145#1:420\n145#1:432\n165#1:444\n165#1:555\n231#1:556,3\n264#1:566,2\n284#1:568\n286#1:569\n286#1:603\n284#1:604\n314#1:605\n324#1:608\n332#1:643,3\n324#1:658\n314#1:659\n51#1:405,2\n146#1:422\n149#1:434\n167#1:446\n168#1:457\n170#1:468\n187#1:479\n188#1:490\n189#1:501\n197#1:512\n198#1:523\n202#1:534\n207#1:545\n287#1:571\n288#1:582\n290#1:593\n325#1:610\n326#1:621\n328#1:632\n338#1:648\n374#1:661\n86#1:410,2\n122#1:415\n122#1:416,2\n257#1:559,2\n258#1:561,2\n262#1:563\n262#1:564,2\n318#1:606,2\n331#1:642\n331#1:646\n*E\n"})
public final class SchemaGenerator {
    @NotNull
    private final String basePackage;
    @NotNull
    private final File outDir;
    @NotNull
    private final Logger logger;

    public SchemaGenerator(@NotNull String basePackage, @NotNull File outDir) {
        Intrinsics.checkNotNullParameter((Object)basePackage, (String)"basePackage");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        this.basePackage = basePackage;
        this.outDir = outDir;
        this.logger = new Logger(this.getClass(), null, 2, null);
    }

    public final void generate() {
        this.logger.info(() -> SchemaGenerator.generate$lambda$0(this));
        List<Class<?>> entities = this.findEntities();
        Map<String, List<Class<?>>> $this$forEach$iv = this.separateBySchema(entities);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<Class<?>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Class<?>>> element$iv;
            Map.Entry<String, List<Class<?>>> entry = element$iv = iterator.next();
            boolean bl = false;
            String schema = entry.getKey();
            List<Class<?>> list = entry.getValue();
            this.generateFiles(list, schema);
        }
        this.logger.info(SchemaGenerator::generate$lambda$2);
    }

    private final List<Class<?>> findEntities() {
        List entities = new ArrayList();
        String path = StringsKt.replace$default((String)this.basePackage, (char)'.', (char)'/', (boolean)false, (int)4, null);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader.getResources(path);
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
            ArrayList<URL> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            List resources = arrayList;
            Iterable $this$forEach$iv = resources;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                URL url = (URL)element$iv;
                boolean bl = false;
                String string = url.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFile(...)");
                File dir = new File(StringsKt.replace$default((String)string, (String)"%20", (String)" ", (boolean)false, (int)4, null));
                if (!dir.exists() || !dir.isDirectory()) continue;
                this.scanDirectory(dir, entities);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        return entities;
    }

    private final void scanDirectory(File directory, List<Class<?>> entities) {
        Sequence $this$forEach$iv = (Sequence)FilesKt.walkTopDown((File)directory);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"$", (boolean)false, (int)2, null)) continue;
            try {
                String string3 = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
                String string4 = StringsKt.substringAfter$default((String)string3, (String)StringsKt.replace$default((String)this.basePackage, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null), null, (int)2, null);
                String string5 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"separator");
                String relativePath = StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string4, (CharSequence)string5), (CharSequence)".class"), (char)File.separatorChar, (char)'.', (boolean)false, (int)4, null);
                String className = this.basePackage + "." + relativePath;
                Class<?> clazz = Class.forName(className);
                if (!clazz.isAnnotationPresent(Entity.class)) continue;
                Intrinsics.checkNotNull(clazz);
                entities.add(clazz);
                this.logger.info(() -> SchemaGenerator.scanDirectory$lambda$5$lambda$4(clazz));
            }
            catch (Exception exception) {
            }
        }
    }

    private final Map<String, List<Class<?>>> separateBySchema(List<? extends Class<?>> entities) {
        HashMap<Object, List> map = new HashMap<Object, List>();
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Class entity;
            block6: {
                block5: {
                    Object schema;
                    Object object2;
                    entity = (Class)element$iv;
                    boolean bl = false;
                    Object object3 = entity.getAnnotation(Table.class);
                    if (object3 == null || (object3 = object3.schema()) == null) {
                        object3 = "";
                    }
                    Object it = object2 = (schema = object3);
                    boolean bl2 = false;
                    object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object2 : null;
                    if (object == null) break block5;
                    String string = ((String)object).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    object = string;
                    if (string != null) break block6;
                }
                String string = entity.getPackageName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
                String[] stringArray = new String[]{"."};
                object = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
            Object key = object;
            map.computeIfAbsent(key, arg_0 -> SchemaGenerator.separateBySchema$lambda$9$lambda$8(SchemaGenerator::separateBySchema$lambda$9$lambda$7, arg_0)).add(entity);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFiles(List<? extends Class<?>> entities, String type) {
        List<String> indexes;
        Serializable it;
        if (entities.isEmpty()) {
            return;
        }
        String string = type.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        File targetDir = new File(this.outDir, string);
        targetDir.mkdirs();
        File[] fileArray = targetDir.listFiles(SchemaGenerator::generateFiles$lambda$10);
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.delete();
            }
        }
        Iterable $this$forEachIndexed$iv = entities;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entity;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (Class)item$iv;
            int i = n;
            boolean bl = false;
            String table = this.getTableName((Class<?>)entity);
            File file = new File(targetDir, "V" + (i + 1) + "__create_" + table + "_table.sql");
            try {
                FilesKt.writeText$default((File)file, (String)this.generateCreateTableSql((Class<?>)entity, table), null, (int)2, null);
                this.logger.info(() -> SchemaGenerator.generateFiles$lambda$13$lambda$12(file));
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        List<String> fks = this.generateAllForeignKeys(entities);
        if (!((Collection)fks).isEmpty()) {
            FilesKt.writeText$default((File)new File(targetDir, "V" + (entities.size() + 1) + "__add_foreign_keys.sql"), (String)("-- Foreign Keys generated " + LocalDateTime.now() + "\n\n" + CollectionsKt.joinToString$default((Iterable)fks, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null)), null, (int)2, null);
        }
        if (!((Collection)(indexes = this.generateAllIndexes(entities))).isEmpty()) {
            FilesKt.writeText$default((File)new File(targetDir, "V" + (entities.size() + 2) + "__add_indexes.sql"), (String)("-- Indexes generated " + LocalDateTime.now() + "\n\n" + CollectionsKt.joinToString$default((Iterable)indexes, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null)), null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Field> allPersistentFields(Class<?> type) {
        LinkedHashMap<String, Field> ordered = new LinkedHashMap<String, Field>();
        for (Class<?> c = type; c != null && !Intrinsics.areEqual(c, Object.class); c = c.getSuperclass()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Field[] fieldArray = c.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object $this$filter$iv = fieldArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!(!it.isSynthetic() && !Modifier.isStatic(it.getModifiers()) && it.getAnnotation(Transient.class) == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Field f = (Field)element$iv;
                boolean bl = false;
                ordered.putIfAbsent(f.getName(), f);
            }
        }
        Collection collection = ordered.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private final /* synthetic */ <A extends Annotation> A findAnnotationOnFieldOrGetter(Field $this$findAnnotationOnFieldOrGetter, Class<?> owner) {
        Annotation annotation;
        String string;
        String prefix;
        boolean $i$f$findAnnotationOnFieldOrGetter = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"A");
        Annotation annotation2 = $this$findAnnotationOnFieldOrGetter.getAnnotation(Annotation.class);
        if (annotation2 != null) {
            Annotation it = annotation2;
            boolean bl = false;
            return (A)it;
        }
        String string2 = prefix = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter.getType(), Boolean.class) ? "is" : "get";
        String string3 = $this$findAnnotationOnFieldOrGetter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String it = string3;
        if (((CharSequence)it).length() > 0) {
            char it2;
            char bl = it.charAt(0);
            String string4 = string2;
            boolean bl2 = false;
            char c = Character.toUpperCase(it2);
            string2 = string4;
            it2 = c;
            String string5 = it;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string5 = string6;
            string = it2 + string5;
        } else {
            string = it;
        }
        String getterName = string2 + string;
        try {
            Method m = owner.getMethod(getterName, new Class[0]);
            Intrinsics.reifiedOperationMarker((int)4, (String)"A");
            annotation = m.getAnnotation(Annotation.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            annotation = null;
        }
        return (A)annotation;
    }

    /*
     * WARNING - void declaration
     */
    private final String getIdType(Class<?> entity) {
        GeneratedValue generatedValue;
        void $this$findAnnotationOnFieldOrGetter$iv;
        Object v4;
        Object object;
        Object $this$firstOrNull$iv;
        block19: {
            $this$firstOrNull$iv = this.allPersistentFields(entity);
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Id id;
                void $this$findAnnotationOnFieldOrGetter$iv2;
                Object element$iv = iterator.next();
                Field field = (Field)element$iv;
                boolean bl = false;
                SchemaGenerator schemaGenerator = this;
                object = field;
                Class<?> owner$iv = entity;
                boolean $i$f$findAnnotationOnFieldOrGetter = false;
                if ($this$findAnnotationOnFieldOrGetter$iv2.getAnnotation(Id.class) != null) {
                    $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = '\u0000';
                    id = it$iv;
                } else {
                    Method m$iv;
                    Object object2;
                    String prefix$iv;
                    String string = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv2.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv2.getType(), Boolean.class) ? "is" : "get";
                    Intrinsics.checkNotNullExpressionValue((Object)$this$findAnnotationOnFieldOrGetter$iv2.getName(), (String)"getName(...)");
                    if (((CharSequence)it$iv).length() > 0) {
                        char it$iv;
                        $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = ((String)it$iv).charAt(0);
                        String string2 = string;
                        boolean bl2 = false;
                        string = string2;
                        it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                        Object object3 = it$iv;
                        int n = 1;
                        String string3 = ((String)object3).substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        object3 = string3;
                        object2 = it$iv + (String)object3;
                    } else {
                        object2 = it$iv;
                    }
                    String getterName$iv = string + (String)object2;
                    try {
                        m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                        m$iv = m$iv.getAnnotation(Id.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        m$iv = null;
                    }
                    id = m$iv;
                }
                if (!(id != null)) continue;
                v4 = element$iv;
                break block19;
            }
            v4 = null;
        }
        Field field = v4;
        if (field == null) {
            return "BIGINT";
        }
        Field idField = field;
        $this$firstOrNull$iv = this;
        Field $i$f$firstOrNull = idField;
        Class<?> owner$iv = entity;
        boolean $i$f$findAnnotationOnFieldOrGetter = false;
        GeneratedValue generatedValue2 = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(GeneratedValue.class);
        if (generatedValue2 != null) {
            it$iv = generatedValue2;
            $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = '\u0000';
            generatedValue = it$iv;
        } else {
            GeneratedValue generatedValue3;
            Object object4;
            String prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
            Object object5 = prefix$iv;
            String string = $this$findAnnotationOnFieldOrGetter$iv.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            it$iv = string;
            if (((CharSequence)it$iv).length() > 0) {
                char it$iv;
                $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = ((String)it$iv).charAt(0);
                object = object5;
                boolean bl = false;
                object5 = object;
                it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                Object object6 = it$iv;
                int n = 1;
                String string4 = ((String)object6).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                object6 = string4;
                object4 = it$iv + (String)object6;
            } else {
                object4 = it$iv;
            }
            String getterName$iv = (String)object5 + (String)object4;
            try {
                Method m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                generatedValue3 = m$iv.getAnnotation(GeneratedValue.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                generatedValue3 = null;
            }
            generatedValue = generatedValue3;
        }
        GeneratedValue gen = generatedValue;
        if (gen != null) {
            return switch (WhenMappings.$EnumSwitchMapping$0[gen.strategy().ordinal()]) {
                case 1 -> "UUID";
                case 2 -> "BIGINT";
                default -> SchemaGenerator.sqlType$default(this, idField, 0, 2, null);
            };
        }
        return SchemaGenerator.sqlType$default(this, idField, 0, 2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final String generateCreateTableSql(Class<?> entity, String tableName) {
        cols = new ArrayList<E>();
        maxColNameLength = 40;
        $this$forEach$iv = this.allPersistentFields(entity);
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block93: {
                block92: {
                    block91: {
                        block90: {
                            block87: {
                                block89: {
                                    block88: {
                                        block86: {
                                            block85: {
                                                field = (Field)element$iv;
                                                $i$a$-forEach-SchemaGenerator$generateCreateTableSql$1 = false;
                                                var11_14 = this;
                                                var12_15 = field;
                                                owner$iv = entity;
                                                $i$f$findAnnotationOnFieldOrGetter = false;
                                                if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(Id.class) != null) {
                                                    $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = '\u0000';
                                                    v0 = it$iv;
                                                } else {
                                                    v1 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                                                    Intrinsics.checkNotNullExpressionValue((Object)$this$findAnnotationOnFieldOrGetter$iv.getName(), (String)"getName(...)");
                                                    if (((CharSequence)it$iv).length() > 0) {
                                                        $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                                                        var18_67 = v1;
                                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = false;
                                                        v1 = var18_67;
                                                        it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                                                        var20_81 = 1;
                                                        v2 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring(var20_81);
                                                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v2;
                                                        v3 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                                                    } else {
                                                        v3 = it$iv;
                                                    }
                                                    getterName$iv = v1 + (String)v3;
                                                    try {
                                                        m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                                        m$iv = m$iv.getAnnotation(Id.class);
                                                    }
                                                    catch (NoSuchMethodException <unused var>$iv) {
                                                        m$iv = null;
                                                    }
                                                    v0 = m$iv;
                                                }
                                                if (v0 == null) break block85;
                                                owner$iv = this;
                                                $i$f$findAnnotationOnFieldOrGetter = field;
                                                owner$iv = entity;
                                                $i$f$findAnnotationOnFieldOrGetter = false;
                                                if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(Column.class) != null) {
                                                    $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = false;
                                                    v4 = it$iv;
                                                } else {
                                                    v5 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                                                    Intrinsics.checkNotNullExpressionValue((Object)$this$findAnnotationOnFieldOrGetter$iv.getName(), (String)"getName(...)");
                                                    if (((CharSequence)it$iv).length() > 0) {
                                                        $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                                                        var20_82 = v5;
                                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = false;
                                                        v5 = var20_82;
                                                        it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                                                        var22_94 = 1;
                                                        v6 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring(var22_94);
                                                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"substring(...)");
                                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v6;
                                                        v7 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                                                    } else {
                                                        v7 = it$iv;
                                                    }
                                                    getterName$iv = v5 + (String)v7;
                                                    try {
                                                        m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                                        m$iv = m$iv.getAnnotation(Column.class);
                                                    }
                                                    catch (NoSuchMethodException <unused var>$iv) {
                                                        m$iv = null;
                                                    }
                                                    v4 = m$iv;
                                                }
                                                $this$findAnnotationOnFieldOrGetter$iv = v4;
                                                if ($this$findAnnotationOnFieldOrGetter$iv == null || (this_$iv = $this$findAnnotationOnFieldOrGetter$iv.name()) == null) ** GOTO lbl-1000
                                                it = owner$iv = this_$iv;
                                                $i$a$-takeIf-SchemaGenerator$generateCreateTableSql$1$name$1 = false;
                                                v8 /* !! */  = $this$findAnnotationOnFieldOrGetter$iv = !StringsKt.isBlank((CharSequence)((CharSequence)it)) != false ? owner$iv : null;
                                                if ($this$findAnnotationOnFieldOrGetter$iv != null) {
                                                    v9 = $this$findAnnotationOnFieldOrGetter$iv;
                                                } else lbl-1000:
                                                // 2 sources

                                                {
                                                    v10 = field.getName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getName(...)");
                                                    v9 = this.toSnakeCase(v10);
                                                }
                                                name = v9;
                                                this_$iv = this;
                                                $this$findAnnotationOnFieldOrGetter$iv = field;
                                                owner$iv = entity;
                                                $i$f$findAnnotationOnFieldOrGetter = false;
                                                if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(GeneratedValue.class) != null) {
                                                    $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = false;
                                                    v11 = it$iv;
                                                } else {
                                                    v12 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                                                    Intrinsics.checkNotNullExpressionValue((Object)$this$findAnnotationOnFieldOrGetter$iv.getName(), (String)"getName(...)");
                                                    if (((CharSequence)it$iv).length() > 0) {
                                                        $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                                                        var20_83 = v12;
                                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = false;
                                                        v12 = var20_83;
                                                        it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                                                        var22_94 = 1;
                                                        v13 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring(var22_94);
                                                        Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"substring(...)");
                                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v13;
                                                        v14 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                                                    } else {
                                                        v14 = it$iv;
                                                    }
                                                    getterName$iv = v12 + (String)v14;
                                                    try {
                                                        m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                                        m$iv = m$iv.getAnnotation(GeneratedValue.class);
                                                    }
                                                    catch (NoSuchMethodException <unused var>$iv) {
                                                        m$iv = null;
                                                    }
                                                    v11 = m$iv;
                                                }
                                                gen = v11;
                                                if (gen != null) {
                                                    switch (WhenMappings.$EnumSwitchMapping$0[gen.strategy().ordinal()]) {
                                                        case 1: {
                                                            v15 = this.formatColumn((String)name, "UUID", "PRIMARY KEY", maxColNameLength);
                                                            break;
                                                        }
                                                        case 2: {
                                                            v15 = this.formatColumn((String)name, "BIGSERIAL", "PRIMARY KEY", maxColNameLength);
                                                            break;
                                                        }
                                                        default: {
                                                            v15 = this.formatColumn((String)name, SchemaGenerator.sqlType$default(this, field, 0, 2, null), "PRIMARY KEY", maxColNameLength);
                                                            break;
                                                        }
                                                    }
                                                } else {
                                                    v15 = Intrinsics.areEqual((Object)field.getType().getSimpleName(), (Object)"UUID") != false ? this.formatColumn((String)name, "UUID", "PRIMARY KEY", maxColNameLength) : this.formatColumn((String)name, SchemaGenerator.sqlType$default(this, field, 0, 2, null), "PRIMARY KEY", maxColNameLength);
                                                }
                                                def = v15;
                                                v16 /* !! */  = Boolean.valueOf(cols.add(def));
                                                continue;
                                            }
                                            name = this;
                                            gen = field;
                                            owner$iv = entity;
                                            $i$f$findAnnotationOnFieldOrGetter = false;
                                            v17 = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(ManyToOne.class);
                                            if (v17 != null) {
                                                it$iv = v17;
                                                $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = '\u0000';
                                                v18 = it$iv;
                                            } else {
                                                v19 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                                                v20 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                                Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"getName(...)");
                                                it$iv = v20;
                                                if (((CharSequence)it$iv).length() > 0) {
                                                    $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                                                    <unused var>$iv = v19;
                                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = false;
                                                    v19 = <unused var>$iv;
                                                    it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                                                    var20_81 = 1;
                                                    v21 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring(var20_81);
                                                    Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"substring(...)");
                                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v21;
                                                    v22 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                                                } else {
                                                    v22 = it$iv;
                                                }
                                                getterName$iv = v19 + (String)v22;
                                                try {
                                                    m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                                    m$iv = m$iv.getAnnotation(ManyToOne.class);
                                                }
                                                catch (NoSuchMethodException <unused var>$iv) {
                                                    m$iv = null;
                                                }
                                                v18 = m$iv;
                                            }
                                            if (v18 != null) break block86;
                                            this_$iv = this;
                                            $this$findAnnotationOnFieldOrGetter$iv = field;
                                            owner$iv = entity;
                                            $i$f$findAnnotationOnFieldOrGetter = false;
                                            v23 = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(OneToOne.class);
                                            if (v23 != null) {
                                                it$iv = v23;
                                                $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = false;
                                                v24 = it$iv;
                                            } else {
                                                v25 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                                                v26 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                                Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"getName(...)");
                                                it$iv = v26;
                                                if (((CharSequence)it$iv).length() > 0) {
                                                    $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                                                    <unused var>$iv = v25;
                                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = false;
                                                    v25 = <unused var>$iv;
                                                    it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                                                    var20_81 = 1;
                                                    v27 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring(var20_81);
                                                    Intrinsics.checkNotNullExpressionValue((Object)v27, (String)"substring(...)");
                                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v27;
                                                    v28 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                                                } else {
                                                    v28 = it$iv;
                                                }
                                                getterName$iv = v25 + (String)v28;
                                                try {
                                                    m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                                    m$iv = m$iv.getAnnotation(OneToOne.class);
                                                }
                                                catch (NoSuchMethodException <unused var>$iv) {
                                                    m$iv = null;
                                                }
                                                v24 = m$iv;
                                            }
                                            if (v24 == null) break block87;
                                        }
                                        $this$findAnnotationOnFieldOrGetter$iv = this;
                                        owner$iv = field;
                                        owner$iv = entity;
                                        $i$f$findAnnotationOnFieldOrGetter = false;
                                        if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(JoinColumn.class) != null) {
                                            $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = false;
                                            v29 = it$iv;
                                        } else {
                                            prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                                            v30 = prefix$iv;
                                            Intrinsics.checkNotNullExpressionValue((Object)$this$findAnnotationOnFieldOrGetter$iv.getName(), (String)"getName(...)");
                                            if (((CharSequence)it$iv).length() > 0) {
                                                $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                                                $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v30;
                                                $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = 0;
                                                v30 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                                                it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                                                $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                                                getterName$iv = 1;
                                                v31 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring(getterName$iv);
                                                Intrinsics.checkNotNullExpressionValue((Object)v31, (String)"substring(...)");
                                                $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v31;
                                                v32 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                                            } else {
                                                v32 = it$iv;
                                            }
                                            getterName$iv = (String)v30 + (String)v32;
                                            try {
                                                m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                                m$iv = m$iv.getAnnotation(JoinColumn.class);
                                            }
                                            catch (NoSuchMethodException <unused var>$iv) {
                                                m$iv = null;
                                            }
                                            v29 = m$iv;
                                        }
                                        if ((v33 /* !! */  = (joinCol /* !! */  = v29)) == null || (v33 /* !! */  = v33 /* !! */ .name()) == null) break block88;
                                        it /* !! */  = $i$f$findAnnotationOnFieldOrGetter /* !! */  = v33 /* !! */ ;
                                        $i$a$-takeIf-SchemaGenerator$generateCreateTableSql$1$colName$1 = false;
                                        v33 /* !! */  = !StringsKt.isBlank((CharSequence)((CharSequence)it /* !! */ )) != false ? $i$f$findAnnotationOnFieldOrGetter /* !! */  : null;
                                        if (v33 /* !! */  != null) break block89;
                                    }
                                    v34 = field.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)v34, (String)"getName(...)");
                                    v33 /* !! */  = this.toSnakeCase(v34) + "_id";
                                }
                                colName = v33 /* !! */ ;
                                v35 /* !! */  = joinCol /* !! */ ;
                                nullable = v35 /* !! */  != null ? v35 /* !! */ .nullable() : true;
                                v36 = field.getType();
                                Intrinsics.checkNotNullExpressionValue(v36, (String)"getType(...)");
                                fkType = this.getIdType(v36);
                                constraints = nullable == false ? "NOT NULL" : "";
                                v16 /* !! */  = Boolean.valueOf(cols.add(this.formatColumn((String)colName, fkType, constraints, maxColNameLength)));
                                continue;
                            }
                            joinCol /* !! */  = this;
                            colName = field;
                            owner$iv = entity;
                            $i$f$findAnnotationOnFieldOrGetter = false;
                            v37 = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(OneToMany.class);
                            if (v37 != null) {
                                it$iv = v37;
                                $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = false;
                                v38 = it$iv;
                            } else {
                                v39 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                                v40 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)v40, (String)"getName(...)");
                                it$iv = v40;
                                if (((CharSequence)it$iv).length() > 0) {
                                    $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                                    prefix$iv = v39;
                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = false;
                                    v39 = prefix$iv;
                                    it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = 1;
                                    v41 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring($i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv);
                                    Intrinsics.checkNotNullExpressionValue((Object)v41, (String)"substring(...)");
                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v41;
                                    v42 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                                } else {
                                    v42 = it$iv;
                                }
                                getterName$iv = v39 + (String)v42;
                                try {
                                    m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                    m$iv = m$iv.getAnnotation(OneToMany.class);
                                }
                                catch (NoSuchMethodException <unused var>$iv) {
                                    m$iv = null;
                                }
                                v38 = m$iv;
                            }
                            if (v38 != null) break block90;
                            this_$iv = this;
                            $this$findAnnotationOnFieldOrGetter$iv = field;
                            owner$iv = entity;
                            $i$f$findAnnotationOnFieldOrGetter = false;
                            v43 = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(ManyToMany.class);
                            if (v43 != null) {
                                it$iv = v43;
                                $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = false;
                                v44 = it$iv;
                            } else {
                                v45 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                                v46 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)v46, (String)"getName(...)");
                                it$iv = v46;
                                if (((CharSequence)it$iv).length() > 0) {
                                    $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                                    prefix$iv = v45;
                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = false;
                                    v45 = prefix$iv;
                                    it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = 1;
                                    v47 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring($i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv);
                                    Intrinsics.checkNotNullExpressionValue((Object)v47, (String)"substring(...)");
                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v47;
                                    v48 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                                } else {
                                    v48 = it$iv;
                                }
                                getterName$iv = v45 + (String)v48;
                                try {
                                    m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                    m$iv = m$iv.getAnnotation(ManyToMany.class);
                                }
                                catch (NoSuchMethodException <unused var>$iv) {
                                    m$iv = null;
                                }
                                v44 = m$iv;
                            }
                            if (v44 == null) break block91;
                        }
                        v16 /* !! */  = Unit.INSTANCE;
                        continue;
                    }
                    this_$iv = this;
                    $this$findAnnotationOnFieldOrGetter$iv = field;
                    owner$iv = entity;
                    $i$f$findAnnotationOnFieldOrGetter = false;
                    v49 = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(Embedded.class);
                    if (v49 != null) {
                        it$iv = v49;
                        $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = false;
                        v50 = it$iv;
                    } else {
                        v51 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                        v52 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v52, (String)"getName(...)");
                        it$iv = v52;
                        if (((CharSequence)it$iv).length() > 0) {
                            $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                            prefix$iv = v51;
                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = false;
                            v51 = prefix$iv;
                            it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = 1;
                            v53 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring($i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)v53, (String)"substring(...)");
                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v53;
                            v54 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                        } else {
                            v54 = it$iv;
                        }
                        getterName$iv = v51 + (String)v54;
                        try {
                            m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                            m$iv = m$iv.getAnnotation(Embedded.class);
                        }
                        catch (NoSuchMethodException <unused var>$iv) {
                            m$iv = null;
                        }
                        v50 = m$iv;
                    }
                    if (v50 != null) {
                        v16 /* !! */  = Boolean.valueOf(cols.addAll(SchemaGenerator.resolveEmbeddedColumns$default(this, field, maxColNameLength, null, 4, null)));
                        continue;
                    }
                    $this$findAnnotationOnFieldOrGetter$iv = this;
                    owner$iv = field;
                    owner$iv = entity;
                    $i$f$findAnnotationOnFieldOrGetter = false;
                    if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(Column.class) != null) {
                        $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = false;
                        v55 = it$iv;
                    } else {
                        prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) != false || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) != false ? "is" : "get";
                        v56 = prefix$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$findAnnotationOnFieldOrGetter$iv.getName(), (String)"getName(...)");
                        if (((CharSequence)it$iv).length() > 0) {
                            $i$a$-let-SchemaGenerator$findAnnotationOnFieldOrGetter$1$iv = it$iv.charAt(0);
                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v56;
                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = 0;
                            v56 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                            it$iv = Character.valueOf(Character.toUpperCase(it$iv)).charValue();
                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = it$iv;
                            var21_93 = 1;
                            v57 = $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv.substring(var21_93);
                            Intrinsics.checkNotNullExpressionValue((Object)v57, (String)"substring(...)");
                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv = v57;
                            v58 = it$iv + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv;
                        } else {
                            v58 = it$iv;
                        }
                        getterName$iv = (String)v56 + (String)v58;
                        try {
                            m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                            m$iv = m$iv.getAnnotation(Column.class);
                        }
                        catch (NoSuchMethodException <unused var>$iv) {
                            m$iv = null;
                        }
                        v55 = m$iv;
                    }
                    if ((v59 /* !! */  = (col = v55)) == null || (v59 /* !! */  = v59 /* !! */ .name()) == null) break block92;
                    it /* !! */  = $i$f$findAnnotationOnFieldOrGetter /* !! */  = v59 /* !! */ ;
                    $i$a$-takeIf-SchemaGenerator$generateCreateTableSql$1$name$2 = false;
                    v59 /* !! */  = !StringsKt.isBlank((CharSequence)((CharSequence)it /* !! */ )) != false ? $i$f$findAnnotationOnFieldOrGetter /* !! */  : null;
                    if (v59 /* !! */  != null) break block93;
                }
                v60 = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v60, (String)"getName(...)");
                v59 /* !! */  = this.toSnakeCase(v60);
            }
            name /* !! */  = v59 /* !! */ ;
            v61 = col;
            nullable = v61 != null ? v61.nullable() : true;
            v62 = col;
            unique = v62 != null ? v62.unique() : false;
            v63 = col;
            length = v63 != null ? v63.length() : 255;
            type = this.sqlType(field, length);
            $this$generateCreateTableSql_u24lambda_u2423_u24lambda_u2422 = var18_67 = CollectionsKt.createListBuilder();
            $i$a$-buildList-SchemaGenerator$generateCreateTableSql$1$constraints$1 = false;
            if (!nullable) {
                $this$generateCreateTableSql_u24lambda_u2423_u24lambda_u2422.add("NOT NULL");
            }
            if (unique) {
                $this$generateCreateTableSql_u24lambda_u2423_u24lambda_u2422.add("UNIQUE");
            }
            if (Intrinsics.areEqual((Object)name /* !! */ , (Object)"created_at") || Intrinsics.areEqual((Object)name /* !! */ , (Object)"updated_at")) {
                $this$generateCreateTableSql_u24lambda_u2423_u24lambda_u2422.add("DEFAULT CURRENT_TIMESTAMP");
            }
            constraints = CollectionsKt.joinToString$default((Iterable)CollectionsKt.build((List)var18_67), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            v16 /* !! */  = Boolean.valueOf(cols.add(this.formatColumn((String)name /* !! */ , type, constraints, maxColNameLength)));
        }
        $this$generateCreateTableSql_u24lambda_u2425 = var5_5 = new StringBuilder();
        $i$a$-buildString-SchemaGenerator$generateCreateTableSql$2 = false;
        $this$generateCreateTableSql_u24lambda_u2425.append("-- create_" + tableName + "_table").append('\n');
        $this$generateCreateTableSql_u24lambda_u2425.append("-- Entity: " + entity.getSimpleName()).append('\n');
        $this$generateCreateTableSql_u24lambda_u2425.append("-- Generated: " + LocalDateTime.now()).append('\n');
        $this$generateCreateTableSql_u24lambda_u2425.append('\n');
        $this$generateCreateTableSql_u24lambda_u2425.append("CREATE TABLE " + tableName + " (").append('\n');
        $this$forEachIndexed$iv = cols;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (E item$iv : $this$forEachIndexed$iv) {
            if ((var13_19 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            unique = (String)item$iv;
            index = var13_19;
            $i$a$-forEachIndexed-SchemaGenerator$generateCreateTableSql$2$1 = false;
            $this$generateCreateTableSql_u24lambda_u2425.append((String)col);
            v64 = index < cols.size() - 1 ? $this$generateCreateTableSql_u24lambda_u2425.append(",").append('\n') : $this$generateCreateTableSql_u24lambda_u2425.append('\n');
        }
        $this$generateCreateTableSql_u24lambda_u2425.append(");");
        return var5_5.toString();
    }

    private final String formatColumn(String name, String type, String constraints, int maxLength) {
        String paddedName = StringsKt.padEnd$default((String)name, (int)maxLength, (char)'\u0000', (int)2, null);
        String paddedType = StringsKt.padEnd$default((String)type, (int)20, (char)'\u0000', (int)2, null);
        return ((Object)StringsKt.trimEnd((CharSequence)(!StringsKt.isBlank((CharSequence)constraints) ? "    " + paddedName + " " + paddedType + " " + constraints : "    " + paddedName + " " + paddedType))).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> resolveEmbeddedColumns(Field field, int maxLength, String prefix) {
        void $this$filterTo$iv$iv;
        void $this$forEach$iv;
        List cols = new ArrayList();
        Class<?> type = field.getType();
        if (!type.isAnnotationPresent(Embeddable.class)) {
            return CollectionsKt.emptyList();
        }
        Map overrides = new LinkedHashMap();
        Annotation[] annotationArray = field.getAnnotationsByType(AttributeOverride.class);
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getAnnotationsByType(...)");
        Object[] objectArray = annotationArray;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv = $this$forEach$iv[i];
            AttributeOverride it = (AttributeOverride)element$iv;
            boolean bl = false;
            overrides.put(it.name(), it.column());
        }
        AttributeOverride[] attributeOverrideArray = field.getAnnotation(AttributeOverrides.class);
        if (attributeOverrideArray != null && (attributeOverrideArray = attributeOverrideArray.value()) != null) {
            AttributeOverride[] $this$forEach$iv2 = attributeOverrideArray;
            boolean $i$f$forEach2 = false;
            int it = $this$forEach$iv2.length;
            for (int element$iv = 0; element$iv < it; ++element$iv) {
                AttributeOverride element$iv2;
                AttributeOverride it2 = element$iv2 = $this$forEach$iv2[element$iv];
                boolean bl = false;
                overrides.put(it2.name(), it2.column());
            }
        }
        Field[] fieldArray = type.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object $this$filter$iv = fieldArray;
        boolean $i$f$filter = false;
        Object[] $this$forEach$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Field it = (Field)element$iv$iv;
            boolean bl = false;
            if (!(!it.isSynthetic() && !Modifier.isStatic(it.getModifiers()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Field f = (Field)element$iv;
            boolean bl = false;
            Column overrideCol = (Column)overrides.get(f.getName());
            Column column = overrideCol;
            if (column == null) {
                column = f.getAnnotation(Column.class);
            }
            Column columnAnn = column;
            if (overrideCol != null && !StringsKt.isBlank((CharSequence)overrideCol.name())) {
                object = overrideCol.name();
            } else if (columnAnn != null && !StringsKt.isBlank((CharSequence)columnAnn.name())) {
                object = columnAnn.name();
            } else {
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                object = prefix + this.toSnakeCase(string);
            }
            String name = object;
            Column column2 = columnAnn;
            boolean nullable = column2 != null ? column2.nullable() : true;
            Column column3 = columnAnn;
            int length = column3 != null ? column3.length() : 255;
            Intrinsics.checkNotNull((Object)f);
            String sqlType = this.sqlType(f, length);
            String constraints = !nullable ? "NOT NULL" : "";
            cols.add(this.formatColumn(name, sqlType, constraints, maxLength));
        }
        return cols;
    }

    static /* synthetic */ List resolveEmbeddedColumns$default(SchemaGenerator schemaGenerator, Field field, int n, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = "";
        }
        return schemaGenerator.resolveEmbeddedColumns(field, n, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> generateAllForeignKeys(List<? extends Class<?>> entities) {
        List out = new ArrayList();
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class e = (Class)element$iv;
            boolean bl = false;
            String table = this.getTableName(e);
            Iterable $this$forEach$iv2 = this.allPersistentFields(e);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void $this$generateAllForeignKeys_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432;
                Object object;
                String refTable;
                Object col;
                Annotation rel;
                CharSequence prefix$iv;
                block33: {
                    block32: {
                        JoinColumn join;
                        Object object2;
                        String string;
                        Field f;
                        block31: {
                            block30: {
                                Object object3;
                                SchemaGenerator this_$iv;
                                Object object4;
                                Method m$iv;
                                String getterName$iv;
                                int n;
                                Object $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22;
                                ManyToOne manyToOne;
                                Object it$iv;
                                char c2;
                                Field $this$findAnnotationOnFieldOrGetter$iv;
                                f = (Field)element$iv2;
                                boolean bl2 = false;
                                SchemaGenerator schemaGenerator = this;
                                Field field = f;
                                Class owner$iv = e;
                                boolean $i$f$findAnnotationOnFieldOrGetter = false;
                                if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(ManyToOne.class) != null) {
                                    c2 = '\u0000';
                                    manyToOne = it$iv;
                                } else {
                                    Object object5;
                                    String string2 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                                    Intrinsics.checkNotNullExpressionValue((Object)$this$findAnnotationOnFieldOrGetter$iv.getName(), (String)"getName(...)");
                                    if (((CharSequence)it$iv).length() > 0) {
                                        char it$iv2;
                                        char c2 = ((String)it$iv).charAt(0);
                                        string = string2;
                                        boolean $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = false;
                                        string2 = string;
                                        it$iv2 = Character.valueOf(Character.toUpperCase(it$iv2)).charValue();
                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = it$iv;
                                        n = 1;
                                        String string3 = ((String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22).substring(n);
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = string3;
                                        object5 = it$iv2 + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22;
                                    } else {
                                        object5 = it$iv;
                                    }
                                    getterName$iv = string2 + (String)object5;
                                    try {
                                        m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                        m$iv = m$iv.getAnnotation(ManyToOne.class);
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        m$iv = null;
                                    }
                                    manyToOne = m$iv;
                                }
                                if (manyToOne != null) {
                                    object4 = (Annotation)manyToOne;
                                } else {
                                    this_$iv = this;
                                    $this$findAnnotationOnFieldOrGetter$iv = f;
                                    owner$iv = e;
                                    $i$f$findAnnotationOnFieldOrGetter = false;
                                    OneToOne oneToOne = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(OneToOne.class);
                                    if (oneToOne != null) {
                                        it$iv = oneToOne;
                                        c2 = '\u0000';
                                        object4 = it$iv;
                                    } else {
                                        Object object6;
                                        String string4 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                                        String string5 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                                        it$iv = string5;
                                        if (((CharSequence)it$iv).length() > 0) {
                                            char it$iv3;
                                            c2 = ((String)it$iv).charAt(0);
                                            string = string4;
                                            boolean bl3 = false;
                                            string4 = string;
                                            it$iv3 = Character.valueOf(Character.toUpperCase(it$iv3)).charValue();
                                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = it$iv;
                                            n = 1;
                                            String string6 = ((String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22).substring(n);
                                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                                            $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = string6;
                                            object6 = it$iv3 + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22;
                                        } else {
                                            object6 = it$iv;
                                        }
                                        getterName$iv = string4 + (String)object6;
                                        try {
                                            m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                            m$iv = m$iv.getAnnotation(OneToOne.class);
                                        }
                                        catch (NoSuchMethodException noSuchMethodException) {
                                            m$iv = null;
                                        }
                                        object4 = m$iv;
                                    }
                                }
                                if ((rel = object4) == null) continue;
                                this_$iv = this;
                                $this$findAnnotationOnFieldOrGetter$iv = f;
                                owner$iv = e;
                                $i$f$findAnnotationOnFieldOrGetter = false;
                                JoinColumn joinColumn = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(JoinColumn.class);
                                if (joinColumn != null) {
                                    it$iv = joinColumn;
                                    boolean bl4 = false;
                                    object3 = it$iv;
                                } else {
                                    Object object7;
                                    String string7 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                                    String string8 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getName(...)");
                                    it$iv = string8;
                                    if (((CharSequence)it$iv).length() > 0) {
                                        char it$iv4;
                                        char bl4 = ((String)it$iv).charAt(0);
                                        string = string7;
                                        boolean bl5 = false;
                                        string7 = string;
                                        it$iv4 = Character.valueOf(Character.toUpperCase(it$iv4)).charValue();
                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = it$iv;
                                        n = 1;
                                        String string9 = ((String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22).substring(n);
                                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                                        $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = string9;
                                        object7 = it$iv4 + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22;
                                    } else {
                                        object7 = it$iv;
                                    }
                                    getterName$iv = string7 + (String)object7;
                                    try {
                                        m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                        m$iv = m$iv.getAnnotation(JoinColumn.class);
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        m$iv = null;
                                    }
                                    object3 = m$iv;
                                }
                                if ((object2 = (join = (JoinColumn)object3)) == null || (object2 = object2.name()) == null) break block30;
                                Object it = $i$f$findAnnotationOnFieldOrGetter = object2;
                                boolean bl6 = false;
                                object2 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? $i$f$findAnnotationOnFieldOrGetter : null;
                                if (object2 != null) break block31;
                            }
                            String string10 = f.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getName(...)");
                            object2 = this.toSnakeCase(string10) + "_id";
                        }
                        col = object2;
                        Class<?> ref = f.getType();
                        Intrinsics.checkNotNull(ref);
                        refTable = this.getTableName(ref);
                        object = join;
                        if (object == null || (object = object.foreignKey()) == null || (object = object.name()) == null) break block32;
                        String it = string = object;
                        boolean bl7 = false;
                        object = !StringsKt.isBlank((CharSequence)it) ? string : null;
                        if (object != null) break block33;
                    }
                    object = "fk_" + table + "_" + (String)col;
                }
                Object fkName = object;
                String onDelete = rel instanceof OneToOne ? "CASCADE" : "SET NULL";
                StringBuilder stringBuilder = new StringBuilder();
                prefix$iv = stringBuilder;
                List list = out;
                boolean bl8 = false;
                $this$generateAllForeignKeys_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.append("-- Foreign key: " + table + "." + (String)col + " -> " + refTable + ".id").append('\n');
                $this$generateAllForeignKeys_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.append("ALTER TABLE " + table).append('\n');
                $this$generateAllForeignKeys_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.append("    ADD CONSTRAINT " + (String)fkName).append('\n');
                $this$generateAllForeignKeys_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.append("        FOREIGN KEY (" + (String)col + ")").append('\n');
                $this$generateAllForeignKeys_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.append("        REFERENCES " + refTable + "(id)").append('\n');
                $this$generateAllForeignKeys_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.append("        ON DELETE " + onDelete + ";");
                list.add(stringBuilder.toString());
            }
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> generateAllIndexes(List<? extends Class<?>> entities) {
        List out = new ArrayList();
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object idx;
            Index[] tableAnn;
            Class e = (Class)element$iv;
            boolean bl = false;
            String table = this.getTableName(e);
            Index[] indexArray = tableAnn = e.getAnnotation(Table.class);
            if (tableAnn != null && (indexArray = indexArray.indexes()) != null) {
                Index[] $this$forEach$iv2 = indexArray;
                boolean $i$f$forEach2 = false;
                int n = $this$forEach$iv2.length;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Index element$iv2;
                    idx = element$iv2 = $this$forEach$iv2[i];
                    boolean bl2 = false;
                    String unique = idx.unique() ? "UNIQUE " : "";
                    CharSequence charSequence = idx.name();
                    if (StringsKt.isBlank((CharSequence)charSequence)) {
                        boolean bl3 = false;
                        object = "idx_" + table + "_" + StringsKt.replace$default((String)StringsKt.replace$default((String)idx.columnList(), (String)",", (String)"_", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null);
                    } else {
                        object = charSequence;
                    }
                    String name = (String)object;
                    out.add("-- Index on " + table + "(" + idx.columnList() + ")\nCREATE " + unique + "INDEX " + name + " ON " + table + " (" + idx.columnList() + ");");
                }
            }
            Iterable $this$forEach$iv3 = this.allPersistentFields(e);
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                Object[] objectArray;
                Object colName;
                block51: {
                    Object object;
                    Field f;
                    block50: {
                        Column col;
                        Object object2;
                        SchemaGenerator col2;
                        Object it;
                        Method m$iv;
                        boolean $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv32;
                        String prefix$iv3;
                        Object it$iv;
                        void $this$findAnnotationOnFieldOrGetter$iv;
                        Class owner$iv;
                        block47: {
                            boolean alreadyIndexed;
                            boolean bl4;
                            block45: {
                                Object object3;
                                block49: {
                                    block48: {
                                        JoinColumn join;
                                        JoinColumn joinColumn;
                                        Object $this$findAnnotationOnFieldOrGetter$iv2;
                                        AnnotatedElement owner$iv2;
                                        block46: {
                                            Object object4;
                                            Method m$iv2;
                                            String getterName$iv;
                                            int n;
                                            String string;
                                            String prefix$iv2;
                                            ManyToOne manyToOne;
                                            Object it$iv2;
                                            f = (Field)element$iv3;
                                            boolean bl5 = false;
                                            idx = this;
                                            Field bl2 = f;
                                            owner$iv2 = e;
                                            boolean $i$f$findAnnotationOnFieldOrGetter = false;
                                            if (((Field)$this$findAnnotationOnFieldOrGetter$iv2).getAnnotation(ManyToOne.class) != null) {
                                                boolean bl6 = false;
                                                manyToOne = it$iv2;
                                            } else {
                                                Object object5;
                                                String string2 = prefix$iv2 = Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv2).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv2).getType(), Boolean.class) ? "is" : "get";
                                                Intrinsics.checkNotNullExpressionValue((Object)((Field)$this$findAnnotationOnFieldOrGetter$iv2).getName(), (String)"getName(...)");
                                                if (((CharSequence)it$iv2).length() > 0) {
                                                    char it$iv3;
                                                    char bl6 = ((String)it$iv2).charAt(0);
                                                    string = string2;
                                                    boolean $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = false;
                                                    string2 = string;
                                                    it$iv3 = Character.valueOf(Character.toUpperCase(it$iv3)).charValue();
                                                    Object $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = it$iv2;
                                                    n = 1;
                                                    String string3 = ((String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22).substring(n);
                                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                                                    $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22 = string3;
                                                    object5 = it$iv3 + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv22;
                                                } else {
                                                    object5 = it$iv2;
                                                }
                                                getterName$iv = string2 + (String)object5;
                                                try {
                                                    m$iv2 = ((Class)owner$iv2).getMethod(getterName$iv, new Class[0]);
                                                    m$iv2 = m$iv2.getAnnotation(ManyToOne.class);
                                                }
                                                catch (NoSuchMethodException noSuchMethodException) {
                                                    m$iv2 = null;
                                                }
                                                manyToOne = m$iv2;
                                            }
                                            if (manyToOne != null) break block46;
                                            SchemaGenerator this_$iv = this;
                                            $this$findAnnotationOnFieldOrGetter$iv2 = f;
                                            owner$iv2 = e;
                                            $i$f$findAnnotationOnFieldOrGetter = false;
                                            OneToOne oneToOne = ((Field)$this$findAnnotationOnFieldOrGetter$iv2).getAnnotation(OneToOne.class);
                                            if (oneToOne != null) {
                                                it$iv2 = oneToOne;
                                                boolean bl7 = false;
                                                object4 = it$iv2;
                                            } else {
                                                Object object6;
                                                String string4 = prefix$iv2 = Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv2).getType(), Boolean.TYPE) || Intrinsics.areEqual(((Field)$this$findAnnotationOnFieldOrGetter$iv2).getType(), Boolean.class) ? "is" : "get";
                                                String string5 = ((Field)$this$findAnnotationOnFieldOrGetter$iv2).getName();
                                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                                                it$iv2 = string5;
                                                if (((CharSequence)it$iv2).length() > 0) {
                                                    char it$iv4;
                                                    char bl7 = ((String)it$iv2).charAt(0);
                                                    string = string4;
                                                    boolean bl8 = false;
                                                    string4 = string;
                                                    it$iv4 = Character.valueOf(Character.toUpperCase(it$iv4)).charValue();
                                                    Object object7 = it$iv2;
                                                    n = 1;
                                                    String string6 = ((String)object7).substring(n);
                                                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                                                    object7 = string6;
                                                    object6 = it$iv4 + (String)object7;
                                                } else {
                                                    object6 = it$iv2;
                                                }
                                                getterName$iv = string4 + (String)object6;
                                                try {
                                                    m$iv2 = ((Class)owner$iv2).getMethod(getterName$iv, new Class[0]);
                                                    m$iv2 = m$iv2.getAnnotation(OneToOne.class);
                                                }
                                                catch (NoSuchMethodException noSuchMethodException) {
                                                    m$iv2 = null;
                                                }
                                                object4 = m$iv2;
                                            }
                                            if (object4 == null) break block47;
                                        }
                                        $this$findAnnotationOnFieldOrGetter$iv2 = this;
                                        owner$iv2 = f;
                                        owner$iv = e;
                                        boolean $i$f$findAnnotationOnFieldOrGetter = false;
                                        if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(JoinColumn.class) != null) {
                                            boolean bl9 = false;
                                            joinColumn = it$iv;
                                        } else {
                                            Object object8;
                                            String string = prefix$iv3 = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                                            Intrinsics.checkNotNullExpressionValue((Object)$this$findAnnotationOnFieldOrGetter$iv.getName(), (String)"getName(...)");
                                            if (((CharSequence)it$iv).length() > 0) {
                                                char it$iv5;
                                                char bl9 = ((String)it$iv).charAt(0);
                                                String string7 = string;
                                                $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv32 = false;
                                                string = string7;
                                                it$iv5 = Character.valueOf(Character.toUpperCase(it$iv5)).charValue();
                                                Object $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv32 = it$iv;
                                                int getterName$iv = 1;
                                                String string8 = ((String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv32).substring(getterName$iv);
                                                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                                                $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv32 = string8;
                                                object8 = it$iv5 + (String)$i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv32;
                                            } else {
                                                object8 = it$iv;
                                            }
                                            String getterName$iv = string + (String)object8;
                                            try {
                                                m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                                m$iv = m$iv.getAnnotation(JoinColumn.class);
                                            }
                                            catch (NoSuchMethodException noSuchMethodException) {
                                                m$iv = null;
                                            }
                                            joinColumn = m$iv;
                                        }
                                        if ((object3 = (join = joinColumn)) == null || (object3 = object3.name()) == null) break block48;
                                        it = $i$f$findAnnotationOnFieldOrGetter = object3;
                                        boolean bl10 = false;
                                        object3 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? $i$f$findAnnotationOnFieldOrGetter : null;
                                        if (object3 != null) break block49;
                                    }
                                    String string = f.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                    object3 = this.toSnakeCase(string) + "_id";
                                }
                                col2 = object3;
                                Index[] indexArray2 = tableAnn;
                                if (tableAnn != null && (indexArray2 = indexArray2.indexes()) != null) {
                                    Index[] $this$any$iv = indexArray2;
                                    boolean $i$f$any = false;
                                    int n = $this$any$iv.length;
                                    for (int prefix$iv3 = 0; prefix$iv3 < n; ++prefix$iv3) {
                                        boolean bl11;
                                        block44: {
                                            Index element$iv4;
                                            Index it2 = element$iv4 = $this$any$iv[prefix$iv3];
                                            boolean bl12 = false;
                                            String[] stringArray = new String[]{","};
                                            Iterable $this$any$iv2 = StringsKt.split$default((CharSequence)it2.columnList(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                                            boolean $i$f$any2 = false;
                                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                                bl11 = false;
                                            } else {
                                                for (Object element$iv5 : $this$any$iv2) {
                                                    String c = (String)element$iv5;
                                                    boolean bl13 = false;
                                                    if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)c)).toString(), (Object)col2)) continue;
                                                    bl11 = true;
                                                    break block44;
                                                }
                                                bl11 = false;
                                            }
                                        }
                                        if (!bl11) continue;
                                        bl4 = true;
                                        break block45;
                                    }
                                    bl4 = false;
                                } else {
                                    bl4 = false;
                                }
                            }
                            if (alreadyIndexed = bl4) continue;
                            out.add("-- Index on foreign key " + table + "." + (String)((Object)col2) + "\nCREATE INDEX idx_" + table + "_" + (String)((Object)col2) + " ON " + table + " (" + (String)((Object)col2) + ");");
                            continue;
                        }
                        col2 = this;
                        Field alreadyIndexed = f;
                        owner$iv = e;
                        boolean $i$f$findAnnotationOnFieldOrGetter = false;
                        if ($this$findAnnotationOnFieldOrGetter$iv.getAnnotation(Column.class) != null) {
                            boolean bl14 = false;
                            object2 = it$iv;
                        } else {
                            Object object9;
                            String string = prefix$iv3 = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                            Intrinsics.checkNotNullExpressionValue((Object)$this$findAnnotationOnFieldOrGetter$iv.getName(), (String)"getName(...)");
                            if (((CharSequence)it$iv).length() > 0) {
                                char it$iv6;
                                char bl14 = ((String)it$iv).charAt(0);
                                String string9 = string;
                                $i$a$-replaceFirstCharWithChar-SchemaGenerator$findAnnotationOnFieldOrGetter$getterName$1$iv32 = false;
                                string = string9;
                                it$iv6 = Character.valueOf(Character.toUpperCase(it$iv6)).charValue();
                                Object object10 = it$iv;
                                int n = 1;
                                String string10 = ((String)object10).substring(n);
                                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"substring(...)");
                                object10 = string10;
                                object9 = it$iv6 + (String)object10;
                            } else {
                                object9 = it$iv;
                            }
                            String getterName$iv = string + (String)object9;
                            try {
                                m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                                m$iv = m$iv.getAnnotation(Column.class);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                m$iv = null;
                            }
                            object2 = m$iv;
                        }
                        if ((object = (col = (Column)object2)) == null || (object = object.name()) == null) break block50;
                        Object object11 = object;
                        it = object11;
                        boolean bl15 = false;
                        object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object11 : null;
                        if (object != null) break block51;
                    }
                    String string = f.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    object = colName = this.toSnakeCase(string);
                }
                if (!CollectionsKt.listOf((Object[])(objectArray = new String[]{"email", "username", "subject", "code"})).contains(colName)) continue;
                out.add("-- Index on common lookup field\nCREATE INDEX idx_" + table + "_" + (String)colName + " ON " + table + " (" + (String)colName + ");");
            }
        }
        return CollectionsKt.distinct((Iterable)out);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String sqlType(Field field, int length) {
        Object object;
        String string = field.getType().getSimpleName();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1153828870: {
                    if (!string.equals("LocalDateTime")) break;
                    n = 1;
                    break;
                }
                case -1910456534: {
                    if (!string.equals("JsonNode")) break;
                    n = 2;
                    break;
                }
                case -1808118735: {
                    if (!string.equals("String")) break;
                    n = 3;
                    break;
                }
                case 97526364: {
                    if (!string.equals("float")) break;
                    n = 4;
                    break;
                }
                case 798274969: {
                    if (!string.equals("LocalDate")) break;
                    n = 5;
                    break;
                }
                case 84300: {
                    if (!string.equals("URI")) break;
                    n = 6;
                    break;
                }
                case 3327612: {
                    if (!string.equals("long")) break;
                    n = 7;
                    break;
                }
                case 84303: {
                    if (!string.equals("URL")) break;
                    n = 8;
                    break;
                }
                case -456761901: {
                    if (!string.equals("ZonedDateTime")) break;
                    n = 9;
                    break;
                }
                case 1729365000: {
                    if (!string.equals("Boolean")) break;
                    n = 10;
                    break;
                }
                case 2616251: {
                    if (!string.equals("UUID")) break;
                    n = 11;
                    break;
                }
                case 79860828: {
                    if (!string.equals("Short")) break;
                    n = 12;
                    break;
                }
                case 798759096: {
                    if (!string.equals("LocalTime")) break;
                    n = 13;
                    break;
                }
                case 3039496: {
                    if (!string.equals("byte")) break;
                    n = 14;
                    break;
                }
                case -1325958191: {
                    if (!string.equals("double")) break;
                    n = 15;
                    break;
                }
                case -672743999: {
                    if (!string.equals("Instant")) break;
                    n = 1;
                    break;
                }
                case -1907858975: {
                    if (!string.equals("Period")) break;
                    n = 16;
                    break;
                }
                case -1927368268: {
                    if (!string.equals("Duration")) break;
                    n = 17;
                    break;
                }
                case 2052876273: {
                    if (!string.equals("Double")) break;
                    n = 15;
                    break;
                }
                case 104431: {
                    if (!string.equals("int")) break;
                    n = 18;
                    break;
                }
                case 1438607953: {
                    if (!string.equals("BigDecimal")) break;
                    n = 19;
                    break;
                }
                case -672261858: {
                    if (!string.equals("Integer")) break;
                    n = 18;
                    break;
                }
                case -1374008726: {
                    if (!string.equals("byte[]")) break;
                    n = 20;
                    break;
                }
                case 67973692: {
                    if (!string.equals("Float")) break;
                    n = 4;
                    break;
                }
                case 64711720: {
                    if (!string.equals("boolean")) break;
                    n = 10;
                    break;
                }
                case -1378123410: {
                    if (!string.equals("OffsetDateTime")) break;
                    n = 9;
                    break;
                }
                case 2004825738: {
                    if (!string.equals("Byte[]")) break;
                    n = 20;
                    break;
                }
                case 2086184: {
                    if (!string.equals("Byte")) break;
                    n = 14;
                    break;
                }
                case 2374300: {
                    if (!string.equals("Long")) break;
                    n = 7;
                    break;
                }
                case 109413500: {
                    if (!string.equals("short")) break;
                    n = 12;
                    break;
                }
            }
            switch (n) {
                case 3: {
                    object = "VARCHAR(" + length + ")";
                    return object;
                }
                case 1: {
                    return "TIMESTAMP";
                }
                case 5: {
                    return "DATE";
                }
                case 13: {
                    return "TIME";
                }
                case 9: {
                    return "TIMESTAMP WITH TIME ZONE";
                }
                case 17: {
                    return "BIGINT";
                }
                case 16: {
                    return "VARCHAR(50)";
                }
                case 10: {
                    return "BOOLEAN";
                }
                case 14: {
                    return "SMALLINT";
                }
                case 12: {
                    return "SMALLINT";
                }
                case 18: {
                    return "INTEGER";
                }
                case 7: {
                    return "BIGINT";
                }
                case 4: {
                    return "REAL";
                }
                case 15: {
                    return "DOUBLE PRECISION";
                }
                case 19: {
                    Column col;
                    Column column;
                    void $this$findAnnotationOnFieldOrGetter$iv;
                    SchemaGenerator schemaGenerator = this;
                    Field field2 = field;
                    Class<?> clazz = field.getDeclaringClass();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"getDeclaringClass(...)");
                    Class<?> owner$iv = clazz;
                    boolean $i$f$findAnnotationOnFieldOrGetter = false;
                    Column column2 = $this$findAnnotationOnFieldOrGetter$iv.getAnnotation(Column.class);
                    if (column2 != null) {
                        Column it$iv = column2;
                        boolean bl = false;
                        column = it$iv;
                    } else {
                        Column column3;
                        String string2;
                        String prefix$iv;
                        String string3 = prefix$iv = Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.TYPE) || Intrinsics.areEqual($this$findAnnotationOnFieldOrGetter$iv.getType(), Boolean.class) ? "is" : "get";
                        String string4 = $this$findAnnotationOnFieldOrGetter$iv.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                        String it$iv = string4;
                        if (((CharSequence)it$iv).length() > 0) {
                            char it$iv2;
                            char bl = it$iv.charAt(0);
                            String string5 = string3;
                            boolean bl2 = false;
                            string3 = string5;
                            it$iv2 = Character.valueOf(Character.toUpperCase(it$iv2)).charValue();
                            String string6 = it$iv;
                            int n2 = 1;
                            String string7 = string6.substring(n2);
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                            string6 = string7;
                            string2 = it$iv2 + string6;
                        } else {
                            string2 = it$iv;
                        }
                        String getterName$iv = string3 + string2;
                        try {
                            Method m$iv = owner$iv.getMethod(getterName$iv, new Class[0]);
                            column3 = m$iv.getAnnotation(Column.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            column3 = null;
                        }
                        column = column3;
                    }
                    Column column4 = col = column;
                    int precision = column4 != null ? column4.precision() : 19;
                    Column column5 = col;
                    int scale = column5 != null ? column5.scale() : 2;
                    object = "DECIMAL(" + precision + "," + scale + ")";
                    return object;
                }
                case 11: {
                    return "UUID";
                }
                case 20: {
                    return "BYTEA";
                }
                case 8: {
                    return "VARCHAR(2048)";
                }
                case 6: {
                    return "VARCHAR(2048)";
                }
                case 2: {
                    return "JSONB";
                }
            }
        }
        if (field.getType().isEnum()) {
            return "VARCHAR(50)";
        }
        object = "VARCHAR(" + length + ")";
        return object;
    }

    static /* synthetic */ String sqlType$default(SchemaGenerator schemaGenerator, Field field, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 255;
        }
        return schemaGenerator.sqlType(field, n);
    }

    private final String getTableName(Class<?> clazz) {
        Object object;
        block6: {
            block5: {
                CharSequence charSequence;
                object = clazz.getAnnotation(Table.class);
                if (object == null || (object = object.name()) == null) break block5;
                CharSequence charSequence2 = (CharSequence)object;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl = false;
                    String string = clazz.getSimpleName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                    charSequence = this.toSnakeCase(string);
                } else {
                    charSequence = charSequence2;
                }
                if ((object = (String)charSequence) != null) break block6;
            }
            String string = clazz.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            object = this.toSnakeCase(string);
        }
        return object;
    }

    private final String toSnakeCase(String s) {
        CharSequence charSequence = s;
        Regex regex = new Regex("([a-z])([A-Z])");
        String string = "$1_$2";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    private static final String generate$lambda$0(SchemaGenerator this$0) {
        return "Generating SQL migrations from classes within '" + this$0.basePackage + "'";
    }

    private static final String generate$lambda$2() {
        return "done";
    }

    private static final String scanDirectory$lambda$5$lambda$4(Class $clazz) {
        return "Found entity: " + $clazz.getName();
    }

    private static final List separateBySchema$lambda$9$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List separateBySchema$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean generateFiles$lambda$10(File it) {
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"sql");
    }

    private static final String generateFiles$lambda$13$lambda$12(File $file) {
        return "Created: " + $file.getParentFile().getName() + "/" + $file.getName();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GenerationType.values().length];
            try {
                nArray[GenerationType.UUID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GenerationType.IDENTITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

