/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.util.xsd;

import de.alexanderwolz.commons.log.Logger;
import de.alexanderwolz.commons.util.xsd.XsdFileReference;
import de.alexanderwolz.commons.util.xsd.XsdReference;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\tJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00102\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0010J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/alexanderwolz/commons/util/xsd/XsdUtils;", "", "<init>", "()V", "logger", "Lde/alexanderwolz/commons/log/Logger;", "getTargetNamespace", "Ljava/net/URI;", "xsd", "", "getPackageName", "namespace", "getXsdReferences", "", "Lde/alexanderwolz/commons/util/xsd/XsdReference;", "schemaFile", "Ljava/io/File;", "xsdContent", "element", "Lorg/w3c/dom/Element;", "getAllReferencedXsdSchemaFiles", "", "Lde/alexanderwolz/commons/util/xsd/XsdFileReference;", "schema", "schemaFolder", "schemas", "", "commons-util"})
@SourceDebugExtension(value={"SMAP\nXsdUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XsdUtils.kt\nde/alexanderwolz/commons/util/xsd/XsdUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1#2:129\n774#3:130\n865#3,2:131\n1869#3,2:133\n1563#3:135\n1634#3,3:136\n1869#3,2:139\n*S KotlinDebug\n*F\n+ 1 XsdUtils.kt\nde/alexanderwolz/commons/util/xsd/XsdUtils\n*L\n29#1:130\n29#1:131,2\n119#1:133,2\n104#1:135\n104#1:136,3\n111#1:139,2\n*E\n"})
public final class XsdUtils {
    @NotNull
    public static final XsdUtils INSTANCE = new XsdUtils();
    @NotNull
    private static final Logger logger = new Logger(INSTANCE.getClass(), null, 2, null);

    private XsdUtils() {
    }

    @Nullable
    public final URI getTargetNamespace(@NotNull String xsd) {
        Intrinsics.checkNotNullParameter((Object)xsd, (String)"xsd");
        try {
            URI uRI;
            Regex regex = new Regex("targetNamespace\\s*=\\s*[\"'](.*?)[\"']");
            Object object = Regex.find$default((Regex)regex, (CharSequence)xsd, (int)0, (int)2, null);
            if (object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null) {
                Object it = object;
                boolean bl = false;
                uRI = URI.create((String)it);
            } else {
                uRI = null;
            }
            return uRI;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getPackageName(@NotNull URI namespace) {
        void $this$filterTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        String string = namespace.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        char[] cArray = new char[]{'/'};
        String cleanedUrl = StringsKt.trimEnd((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)"http://"), (CharSequence)"https://"), (CharSequence)"www."), (char[])cArray);
        String[] stringArray = new String[]{"/"};
        List splits = StringsKt.split$default((CharSequence)cleanedUrl, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        String[] stringArray2 = new String[]{"."};
        List domainParts = CollectionsKt.reversed((Iterable)StringsKt.split$default((CharSequence)((CharSequence)splits.get(0)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
        Object object2 = (String)CollectionsKt.getOrNull((List)splits, (int)1);
        if (object2 == null || (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(object = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object pathParts = object2;
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)domainParts, (Iterable)((Iterable)pathParts));
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    @NotNull
    public final List<XsdReference> getXsdReferences(@NotNull File schemaFile) {
        DocumentBuilderFactory documentBuilderFactory;
        Intrinsics.checkNotNullParameter((Object)schemaFile, (String)"schemaFile");
        logger.trace(() -> XsdUtils.getXsdReferences$lambda$2(schemaFile));
        DocumentBuilderFactory $this$getXsdReferences_u24lambda_u243 = documentBuilderFactory = DocumentBuilderFactory.newInstance();
        boolean bl = false;
        $this$getXsdReferences_u24lambda_u243.setNamespaceAware(true);
        Element root = documentBuilderFactory.newDocumentBuilder().parse(schemaFile).getDocumentElement();
        Intrinsics.checkNotNull((Object)root);
        return this.getXsdReferences(root);
    }

    @NotNull
    public final List<XsdReference> getXsdReferences(@NotNull String xsdContent) {
        Intrinsics.checkNotNullParameter((Object)xsdContent, (String)"xsdContent");
        Object object = DocumentBuilderFactory.newInstance();
        DocumentBuilderFactory $this$getXsdReferences_u24lambda_u244 = object;
        boolean bl = false;
        $this$getXsdReferences_u24lambda_u244.setNamespaceAware(true);
        DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        object = xsdContent;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Element root = documentBuilder.parse(new ByteArrayInputStream(byArray)).getDocumentElement();
        Intrinsics.checkNotNull((Object)root);
        return this.getXsdReferences(root);
    }

    @NotNull
    public final List<XsdReference> getXsdReferences(@NotNull Element element) {
        String it;
        String string;
        Element element2;
        int i;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String xsdNamespace = "http://www.w3.org/2001/XMLSchema";
        ArrayList<XsdReference> references = new ArrayList<XsdReference>();
        NodeList includes = element.getElementsByTagNameNS(xsdNamespace, "include");
        boolean bl = false;
        int n = includes.getLength();
        for (i = 0; i < n; ++i) {
            Node node = includes.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            element2 = (Element)node;
            it = string = element2.getAttribute("schemaLocation");
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 == null) continue;
            it = string2;
            boolean bl3 = false;
            references.add(new XsdReference(XsdReference.Type.INCLUDE, it, null));
        }
        NodeList imports = element.getElementsByTagNameNS(xsdNamespace, "import");
        boolean bl4 = false;
        n = imports.getLength();
        for (i = 0; i < n; ++i) {
            Node node = imports.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            element2 = (Element)node;
            String schemaLocation = element2.getAttribute("schemaLocation");
            URI namespace = URI.create(element2.getAttribute("namespace"));
            Intrinsics.checkNotNull((Object)schemaLocation);
            if (!(((CharSequence)schemaLocation).length() > 0)) continue;
            references.add(new XsdReference(XsdReference.Type.IMPORT, schemaLocation, namespace));
        }
        NodeList redefines = element.getElementsByTagNameNS(xsdNamespace, "redefine");
        boolean bl5 = false;
        n = redefines.getLength();
        for (i = 0; i < n; ++i) {
            Node node = redefines.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            element2 = (Element)node;
            it = string = element2.getAttribute("schemaLocation");
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)it);
            String string3 = ((CharSequence)it).length() > 0 ? string : null;
            if (string3 == null) continue;
            it = string3;
            boolean bl7 = false;
            references.add(new XsdReference(XsdReference.Type.REDEFINE, it, null));
        }
        return references;
    }

    @NotNull
    public final Set<XsdFileReference> getAllReferencedXsdSchemaFiles(@NotNull File schema, @Nullable File schemaFolder) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return XsdUtils.getAllReferencedXsdSchemaFiles$default(this, CollectionsKt.listOf((Object)schema), null, 2, null);
    }

    public static /* synthetic */ Set getAllReferencedXsdSchemaFiles$default(XsdUtils xsdUtils, File file, File file2, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        return xsdUtils.getAllReferencedXsdSchemaFiles(file, file2);
    }

    @NotNull
    public final Set<XsdFileReference> getAllReferencedXsdSchemaFiles(@NotNull Collection<? extends File> schemas, @Nullable File schemaFolder) {
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        if (schemas.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set resolved = new LinkedHashSet();
        Set visited = new LinkedHashSet();
        File file = schemaFolder;
        if (file == null) {
            file = ((File)CollectionsKt.first((Iterable)schemas)).getParentFile();
        }
        File schemaFolder2 = file;
        logger.trace(() -> XsdUtils.getAllReferencedXsdSchemaFiles$lambda$14(schemaFolder2));
        Iterable $this$forEach$iv = schemas;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            URI namespace = INSTANCE.getTargetNamespace(FilesKt.readText$default((File)it, null, (int)1, null));
            String schemaLocation = it.getName();
            Intrinsics.checkNotNull((Object)schemaLocation);
            XsdFileReference reference = new XsdFileReference(XsdReference.Type.ROOT, schemaLocation, namespace, it, null);
            Intrinsics.checkNotNull((Object)schemaFolder2);
            XsdUtils.getAllReferencedXsdSchemaFiles$resolveRecursive(visited, resolved, schemaFolder2, reference);
        }
        return resolved;
    }

    public static /* synthetic */ Set getAllReferencedXsdSchemaFiles$default(XsdUtils xsdUtils, Collection collection, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return xsdUtils.getAllReferencedXsdSchemaFiles(collection, file);
    }

    private static final String getXsdReferences$lambda$2(File $schemaFile) {
        return "Resolving XSD references for " + $schemaFile.getName() + " ..";
    }

    /*
     * WARNING - void declaration
     */
    private static final void getAllReferencedXsdSchemaFiles$resolveRecursive(Set<File> visited, Set<XsdFileReference> resolved, File schemaFolder, XsdFileReference reference) {
        void $this$mapTo$iv$iv;
        if (visited.contains(reference.getFile())) {
            return;
        }
        visited.add(reference.getFile());
        File schemaFile = new File(schemaFolder, reference.getSchemaLocation());
        if (!schemaFile.exists()) {
            throw new NoSuchElementException("File for location '" + reference.getSchemaLocation() + "' does not exist: " + schemaFile);
        }
        Iterable $this$map$iv = INSTANCE.getXsdReferences(schemaFile);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XsdReference xsdReference = (XsdReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File schemaFile2 = new File(schemaFolder, it.getSchemaLocation());
            collection.add(new XsdFileReference(it.getType(), it.getSchemaLocation(), it.getNamespace(), schemaFile2, reference));
        }
        Set children = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        reference.addChildren(children);
        resolved.add(reference);
        Iterable $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XsdFileReference child = (XsdFileReference)element$iv;
            boolean bl = false;
            XsdUtils.getAllReferencedXsdSchemaFiles$resolveRecursive(visited, resolved, schemaFolder, child);
        }
    }

    private static final String getAllReferencedXsdSchemaFiles$lambda$14(File $schemaFolder) {
        return "Using schema folder: " + $schemaFolder;
    }
}

