/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.util.compression;

import de.alexanderwolz.commons.util.string.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lde/alexanderwolz/commons/util/compression/CompressionUtils;", "", "<init>", "()V", "compressAndEncode", "", "content", "decodeAndDecompress", "compressedString", "commons-util"})
@SourceDebugExtension(value={"SMAP\nCompressionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressionUtils.kt\nde/alexanderwolz/commons/util/compression/CompressionUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,23:1\n1#2:24\n*E\n"})
public final class CompressionUtils {
    @NotNull
    public static final CompressionUtils INSTANCE = new CompressionUtils();

    private CompressionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String compressAndEncode(@NotNull String content) {
        OutputStream it;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (((CharSequence)content).length() == 0) {
            return content;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Closeable closeable = new GZIPOutputStream(stream);
        Throwable throwable = null;
        try {
            it = (GZIPOutputStream)closeable;
            boolean bl = false;
            byte[] byArray = content.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ((FilterOutputStream)it).write(byArray);
            it = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = stream;
        throwable = null;
        try {
            it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            byte[] byArray = ((ByteArrayOutputStream)it).toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            String string = StringUtils.INSTANCE.toBase64(byArray);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String decodeAndDecompress(@NotNull String compressedString) {
        Intrinsics.checkNotNullParameter((Object)compressedString, (String)"compressedString");
        if (((CharSequence)compressedString).length() == 0) {
            return compressedString;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(StringUtils.INSTANCE.fromBase64ToBytes(compressedString));
        Closeable closeable = new GZIPInputStream(stream);
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }
}

