/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.util.string;

import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u0012\u00a8\u0006\u001d"}, d2={"Lde/alexanderwolz/commons/util/string/StringUtils;", "", "<init>", "()V", "resolveVars", "", "input", "variables", "", "containsAll", "", "text", "keywords", "capitalize", "string", "toHexString", "number", "Ljava/lang/Integer;", "", "toBase64", "bytes", "", "content", "fromBase64", "fromBase64ToBytes", "base64", "fillLeading", "prefix", "totalLength", "commons-util"})
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\nde/alexanderwolz/commons/util/string/StringUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1869#2,2:75\n*S KotlinDebug\n*F\n+ 1 StringUtils.kt\nde/alexanderwolz/commons/util/string/StringUtils\n*L\n24#1:75,2\n*E\n"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();

    private StringUtils() {
    }

    @NotNull
    public final String resolveVars(@NotNull String input, @NotNull Map<String, String> variables) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Pattern p = Pattern.compile("\\$\\{(\\w+)}|\\$(\\w+)");
        Matcher m = p.matcher(input);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String envVarName = m.group(1) == null ? m.group(2) : m.group(1);
            String envVarValue = variables.get(envVarName);
            Object object = envVarValue;
            if (object == null) {
                object = "${" + envVarValue + "}";
            }
            m.appendReplacement(sb, Matcher.quoteReplacement((String)object));
        }
        m.appendTail(sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String resolveVars$default(StringUtils stringUtils, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            Map<String, String> map2 = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getenv(...)");
            map = map2;
        }
        return stringUtils.resolveVars(string, map);
    }

    public final boolean containsAll(@NotNull String text, @NotNull String keywords) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)keywords, (String)"keywords");
        String[] stringArray = new String[]{","};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)keywords, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String keyword = (String)element$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)text, (CharSequence)keyword, (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String capitalize(@NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string3 = string;
        if (((CharSequence)string3).length() > 0) {
            String string4;
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isLowerCase((char)it)) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                string4 = CharsKt.titlecase((char)it, (Locale)locale);
            } else {
                string4 = String.valueOf((char)it);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string5 = string3;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string2 = stringBuilder2.append(string6).toString();
        } else {
            string2 = string3;
        }
        return string2;
    }

    @NotNull
    public final String toHexString(@NotNull Integer number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return this.toHexString((int)number);
    }

    @NotNull
    public final String toHexString(int number) {
        String string = Integer.toHexString(number);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        return string;
    }

    @NotNull
    public final String toBase64(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] byArray = Base64.getEncoder().encode(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        return StringsKt.decodeToString((byte[])byArray);
    }

    @NotNull
    public final String toBase64(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = content;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.toBase64(byArray);
    }

    @NotNull
    public final String fromBase64(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] byArray = Base64.getDecoder().decode(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return StringsKt.decodeToString((byte[])byArray);
    }

    @NotNull
    public final byte[] fromBase64ToBytes(@NotNull String base64) {
        Intrinsics.checkNotNullParameter((Object)base64, (String)"base64");
        byte[] byArray = Base64.getDecoder().decode(base64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    @NotNull
    public final String fromBase64(@NotNull String base64) {
        Intrinsics.checkNotNullParameter((Object)base64, (String)"base64");
        return StringsKt.decodeToString((byte[])this.fromBase64ToBytes(base64));
    }

    @NotNull
    public final String fillLeading(@NotNull String string, @NotNull String prefix, int totalLength) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Object prefixes = "";
        for (int i = string.length(); i < totalLength; ++i) {
            prefixes = (String)prefixes + prefix;
        }
        return (String)prefixes + string;
    }

    public static /* synthetic */ String fillLeading$default(StringUtils stringUtils, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 4;
        }
        return stringUtils.fillLeading(string, string2, n);
    }
}

