/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lde/alexanderwolz/commons/util/XsdUtils;", "", "<init>", "()V", "getTargetNamespace", "Ljava/net/URI;", "xsd", "", "getVersionFromFile", "", "", "file", "Ljava/io/File;", "getPackageName", "namespace", "commons-util"})
@SourceDebugExtension(value={"SMAP\nXsdUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XsdUtils.kt\nde/alexanderwolz/commons/util/XsdUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1#2:44\n1869#3,2:45\n774#3:47\n865#3,2:48\n*S KotlinDebug\n*F\n+ 1 XsdUtils.kt\nde/alexanderwolz/commons/util/XsdUtils\n*L\n22#1:45,2\n41#1:47\n41#1:48,2\n*E\n"})
public final class XsdUtils {
    @NotNull
    public static final XsdUtils INSTANCE = new XsdUtils();

    private XsdUtils() {
    }

    @Nullable
    public final URI getTargetNamespace(@NotNull String xsd) {
        Intrinsics.checkNotNullParameter((Object)xsd, (String)"xsd");
        try {
            URI uRI;
            Regex regex = new Regex("targetNamespace\\s*=\\s*[\"'](.*?)[\"']");
            Object object = Regex.find$default((Regex)regex, (CharSequence)xsd, (int)0, (int)2, null);
            if (object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null) {
                Object it = object;
                boolean bl = false;
                uRI = URI.create((String)it);
            } else {
                uRI = null;
            }
            return uRI;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @NotNull
    public final List<Integer> getVersionFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ArrayList<Integer> version = new ArrayList<Integer>();
        String[] stringArray = new String[]{"_"};
        CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)FilesKt.getNameWithoutExtension((File)file), (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(1);
        stringArray = new String[]{"_"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                version.add(Integer.parseInt(StringsKt.replace$default((String)it, (String)"v", (String)"", (boolean)false, (int)4, null)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse version part: " + it, e);
            }
        }
        return version;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getPackageName(@NotNull URI namespace) {
        void $this$filterTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        String string = namespace.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        char[] cArray = new char[]{'/'};
        String cleanedUrl = StringsKt.trimEnd((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)"http://"), (CharSequence)"https://"), (CharSequence)"www."), (char[])cArray);
        String[] stringArray = new String[]{"/"};
        List splits = StringsKt.split$default((CharSequence)cleanedUrl, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        String[] stringArray2 = new String[]{"."};
        List domainParts = CollectionsKt.reversed((Iterable)StringsKt.split$default((CharSequence)((CharSequence)splits.get(0)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
        Object object2 = (String)CollectionsKt.getOrNull((List)splits, (int)1);
        if (object2 == null || (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(object = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object pathParts = object2;
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)domainParts, (Iterable)((Iterable)pathParts));
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }
}

