/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.util;

import de.alexanderwolz.commons.util.StringUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\r"}, d2={"Lde/alexanderwolz/commons/util/FileUtils;", "", "<init>", "()V", "getFile", "Ljava/io/File;", "fileName", "", "appendLine", "", "file", "content", "separator", "commons-util"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    @NotNull
    public final File getFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = new File(StringUtils.resolveVars$default(StringUtils.INSTANCE, fileName, null, 2, null));
        if (file.exists()) {
            return file;
        }
        URL uRL = this.getClass().getClassLoader().getResource(fileName);
        if (uRL != null) {
            URL it = uRL;
            boolean bl = false;
            return new File(it.getFile());
        }
        throw new NoSuchElementException("Missing file '" + fileName + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendLine(@NotNull File file, @NotNull String content, @Nullable String separator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Closeable closeable = new FileOutputStream(file, true);
        Object object = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object = null;
        try {
            BufferedWriter writer2 = (BufferedWriter)closeable;
            boolean bl = false;
            if (file.exists() && !(FilesKt.readBytes((File)file).length == 0)) {
                String string = separator;
                if (string == null) {
                    string = "";
                }
                writer2.append(string);
            }
            writer2.append(content);
            writer2.flush();
            writer = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    public static /* synthetic */ void appendLine$default(FileUtils fileUtils, File file, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = System.lineSeparator();
        }
        fileUtils.appendLine(file, string, string2);
    }
}

