/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwolz.commons.log;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001f\b\u0016\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nB\u001f\b\u0016\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\fB\u001b\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0014\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!J\u0014\u0010\"\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!J\u0014\u0010#\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!J\u0014\u0010$\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!J\u0014\u0010%\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'J\u001e\u0010%\u001a\u00020\u001f2\b\u0010&\u001a\u0004\u0018\u00010'2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0019\u0010\r\u001a\n \u0016*\u0004\u0018\u00010\u000e0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Lde/alexanderwolz/commons/log/Logger;", "", "logger", "Lorg/slf4j/Logger;", "appendToStdOut", "", "<init>", "(Lorg/slf4j/Logger;Z)V", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;Z)V", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;Z)V", "name", "", "(Ljava/lang/String;Z)V", "isTraceEnabled", "()Z", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "kotlin.jvm.PlatformType", "getName", "()Ljava/lang/String;", "level", "Lde/alexanderwolz/commons/log/Logger$LogLevel;", "getLevel", "()Lde/alexanderwolz/commons/log/Logger$LogLevel;", "retrieveLevel", "trace", "", "message", "Lkotlin/Function0;", "debug", "info", "warn", "error", "throwable", "", "LogLevel", "commons-log"})
public final class Logger {
    @NotNull
    private final org.slf4j.Logger logger;
    private final boolean appendToStdOut;
    private final boolean isTraceEnabled;
    private final boolean isDebugEnabled;
    private final boolean isInfoEnabled;
    private final boolean isWarnEnabled;
    private final boolean isErrorEnabled;
    private final String name;

    public Logger(@NotNull org.slf4j.Logger logger, boolean appendToStdOut) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.appendToStdOut = appendToStdOut;
        this.isTraceEnabled = this.logger.isTraceEnabled();
        this.isDebugEnabled = this.logger.isDebugEnabled();
        this.isInfoEnabled = this.logger.isInfoEnabled();
        this.isWarnEnabled = this.logger.isWarnEnabled();
        this.isErrorEnabled = this.logger.isErrorEnabled();
        this.name = this.logger.getName();
    }

    public /* synthetic */ Logger(org.slf4j.Logger logger, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(logger, bl);
    }

    public Logger(@NotNull Class<?> clazz, boolean appendToStdOut) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        org.slf4j.Logger logger = LoggerFactory.getLogger(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this(logger, appendToStdOut);
    }

    public /* synthetic */ Logger(Class clazz, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(clazz, bl);
    }

    public Logger(@NotNull KClass<?> clazz, boolean appendToStdOut) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        org.slf4j.Logger logger = LoggerFactory.getLogger((Class)JvmClassMappingKt.getJavaClass(clazz));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this(logger, appendToStdOut);
    }

    public /* synthetic */ Logger(KClass kClass, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(kClass, bl);
    }

    public Logger(@NotNull String name, boolean appendToStdOut) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        org.slf4j.Logger logger = LoggerFactory.getLogger((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this(logger, appendToStdOut);
    }

    public /* synthetic */ Logger(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    public final boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    public final boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public final boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    public final boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    public final boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    public final String getName() {
        return this.name;
    }

    @NotNull
    public final LogLevel getLevel() {
        return this.retrieveLevel();
    }

    private final LogLevel retrieveLevel() {
        if (this.isTraceEnabled) {
            return LogLevel.TRACE;
        }
        if (this.isDebugEnabled) {
            return LogLevel.DEBUG;
        }
        if (this.isInfoEnabled) {
            return LogLevel.INFO;
        }
        if (this.isWarnEnabled) {
            return LogLevel.WARN;
        }
        if (this.isErrorEnabled) {
            return LogLevel.ERROR;
        }
        return LogLevel.OFF;
    }

    public final void trace(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.logger.isTraceEnabled()) {
            String message2 = (String)message.invoke();
            if (this.appendToStdOut) {
                System.out.println((Object)("[TRACE] " + message2));
            }
            this.logger.trace(message2);
        }
    }

    public final void debug(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.logger.isDebugEnabled()) {
            String message2 = (String)message.invoke();
            if (this.appendToStdOut) {
                System.out.println((Object)("[DEBUG] " + message2));
            }
            this.logger.debug(message2);
        }
    }

    public final void info(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.logger.isInfoEnabled()) {
            String message2 = (String)message.invoke();
            if (this.appendToStdOut) {
                System.out.println((Object)("[INFO] " + message2));
            }
            this.logger.info(message2);
        }
    }

    public final void warn(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.logger.isWarnEnabled()) {
            String message2 = (String)message.invoke();
            if (this.appendToStdOut) {
                System.out.println((Object)("[WARN] " + message2));
            }
            this.logger.warn(message2);
        }
    }

    public final void error(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.logger.isErrorEnabled()) {
            String message2 = (String)message.invoke();
            if (this.appendToStdOut) {
                System.out.println((Object)("[ERROR] " + message2));
            }
            this.logger.error((String)message.invoke());
        }
    }

    public final void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.error(throwable, (Function0<String>)((Function0)() -> Logger.error$lambda$0(throwable)));
    }

    public final void error(@Nullable Throwable throwable, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.logger.isErrorEnabled()) {
            String message2 = (String)message.invoke();
            if (this.appendToStdOut) {
                System.out.println((Object)("[ERROR] " + message2));
                Throwable throwable2 = throwable;
                if (throwable2 != null) {
                    throwable2.printStackTrace();
                }
            }
            this.logger.error((String)message.invoke(), throwable);
        }
    }

    private static final String error$lambda$0(Throwable $throwable) {
        String string = $throwable.getMessage();
        if (string == null) {
            String string2 = $throwable.getClass().getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lde/alexanderwolz/commons/log/Logger$LogLevel;", "", "<init>", "(Ljava/lang/String;I)V", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "OFF", "commons-log"})
    public static final class LogLevel
    extends Enum<LogLevel> {
        public static final /* enum */ LogLevel TRACE = new LogLevel();
        public static final /* enum */ LogLevel DEBUG = new LogLevel();
        public static final /* enum */ LogLevel INFO = new LogLevel();
        public static final /* enum */ LogLevel WARN = new LogLevel();
        public static final /* enum */ LogLevel ERROR = new LogLevel();
        public static final /* enum */ LogLevel OFF = new LogLevel();
        private static final /* synthetic */ LogLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LogLevel[] values() {
            return (LogLevel[])$VALUES.clone();
        }

        public static LogLevel valueOf(String value) {
            return Enum.valueOf(LogLevel.class, value);
        }

        @NotNull
        public static EnumEntries<LogLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = logLevelArray = new LogLevel[]{LogLevel.TRACE, LogLevel.DEBUG, LogLevel.INFO, LogLevel.WARN, LogLevel.ERROR, LogLevel.OFF};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

