/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwodarz.code.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import org.json.JSONObject;

public class ClientThread
extends Thread {
    private final Client client;
    private WebResource.Builder resource;
    private RequestMethod method;
    private String response;
    private JSONObject body;
    private ClientResponse clientResponse;
    private HashMap<String, String> headers = new HashMap();
    private int status;
    private String type = "application/json";
    private String rawBody;
    private boolean isRaw = false;
    private boolean isForm = false;
    private boolean isMultiForm = false;
    private Form form;
    private FormDataMultiPart multiPart;
    private MultiPart part;

    public ClientThread(String url, RequestMethod method) {
        this(url, method, (ClientConfig)new DefaultClientConfig());
    }

    public ClientThread(String url, RequestMethod method, ClientConfig config) {
        this(url, method, config, 5000);
    }

    public ClientThread(String url, RequestMethod method, ClientConfig config, int readTimeOut) {
        this.method = method;
        if (config != null) {
            config.getClasses().add(MultiPartWriter.class);
            this.client = Client.create((ClientConfig)config);
        } else {
            this.client = Client.create();
        }
        this.client.setConnectTimeout(Integer.valueOf(1500));
        this.client.setReadTimeout(Integer.valueOf(readTimeOut));
        this.resource = this.client.resource(url).getRequestBuilder();
    }

    public static SSLContext getKeyStore(String path, String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(path), password.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, password.toCharArray());
            TrustManager[] managers = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(kmf.getKeyManagers(), managers, null);
            return sc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addCookie(String name, String value, String path, String domain) {
        Cookie cookie = new Cookie(name, value, path, domain);
        this.resource = (WebResource.Builder)this.resource.cookie(cookie);
    }

    public void addCookie(String name, String value) {
        this.addCookie(name, value, null, null);
    }

    public void rerun(String url, RequestMethod method) {
        this.resource = this.client.resource(url).getRequestBuilder();
        this.method = method;
        this.run();
    }

    public ClientResponse getClientResponse() {
        return this.clientResponse;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setHeaders(HashMap<String, String> headers) {
        this.headers = headers;
    }

    public void setBodyRaw(String body) {
        this.isRaw = true;
        this.rawBody = body;
    }

    public void setMediaType(String type) {
        this.type = type;
    }

    public void setBody(JSONObject body) {
        this.body = body;
    }

    public void addForm(String key, String value) {
        this.isForm = true;
        if (this.form == null) {
            this.form = new Form();
        }
        this.setMediaType("application/x-www-form-urlencoded");
        this.form.putSingle(key, value);
    }

    public void addMultiPart(String key, String value) {
        this.isMultiForm = true;
        if (this.multiPart == null) {
            this.multiPart = new FormDataMultiPart();
        }
        this.multiPart = this.multiPart.field(key, (Object)value, MediaType.TEXT_PLAIN_TYPE);
        this.part = this.multiPart;
        this.part.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
        this.setMediaType("multipart/form-data");
    }

    @Override
    public void run() {
        switch (this.method) {
            case GET: {
                ClientResponse response;
                WebResource.Builder builder = (WebResource.Builder)this.resource.type(this.type);
                for (Map.Entry<String, String> stringStringEntry : this.headers.entrySet()) {
                    builder = (WebResource.Builder)builder.header(stringStringEntry.getKey(), (Object)stringStringEntry.getValue());
                }
                this.clientResponse = response = (ClientResponse)builder.get(ClientResponse.class);
                this.setStatus(response.getStatus());
                if (this.getStatus() == 204) {
                    this.setResponse("{}");
                    break;
                }
                this.setResponse((String)response.getEntity(String.class));
                break;
            }
            case POST: {
                WebResource.Builder builder = (WebResource.Builder)this.resource.type(this.type);
                for (Map.Entry<String, String> stringStringEntry : this.headers.entrySet()) {
                    builder = (WebResource.Builder)builder.header(stringStringEntry.getKey(), (Object)stringStringEntry.getValue());
                }
                ClientResponse response = this.isMultiForm ? (ClientResponse)builder.post(ClientResponse.class, this.part != null ? this.part : "") : (this.isForm ? (ClientResponse)builder.post(ClientResponse.class, this.form != null ? this.form : "") : (!this.isRaw ? (ClientResponse)builder.post(ClientResponse.class, (Object)(this.body != null ? this.body.toString() : "")) : (ClientResponse)builder.post(ClientResponse.class, (Object)(this.rawBody != null ? this.rawBody.toString() : ""))));
                this.clientResponse = response;
                this.setStatus(response.getStatus());
                if (this.getStatus() == 204) {
                    this.setResponse("{}");
                    break;
                }
                this.setResponse((String)response.getEntity(String.class));
                break;
            }
            case PUT: {
                WebResource.Builder builder = (WebResource.Builder)this.resource.type(this.type);
                for (Map.Entry<String, String> stringStringEntry : this.headers.entrySet()) {
                    builder = (WebResource.Builder)builder.header(stringStringEntry.getKey(), (Object)stringStringEntry.getValue());
                }
                ClientResponse response = this.isMultiForm ? (ClientResponse)builder.post(ClientResponse.class, this.part != null ? this.part : "") : (this.isForm ? (ClientResponse)builder.put(ClientResponse.class, this.form != null ? this.form : "") : (!this.isRaw ? (ClientResponse)builder.put(ClientResponse.class, (Object)(this.body != null ? this.body.toString() : "")) : (ClientResponse)builder.put(ClientResponse.class, (Object)(this.rawBody != null ? this.rawBody.toString() : ""))));
                this.setResponse((String)response.getEntity(String.class));
                this.setStatus(response.getStatus());
                break;
            }
            case DELETE: {
                WebResource.Builder builder = (WebResource.Builder)this.resource.type(this.type);
                for (Map.Entry<String, String> stringStringEntry : this.headers.entrySet()) {
                    builder = (WebResource.Builder)builder.header(stringStringEntry.getKey(), (Object)stringStringEntry.getValue());
                }
                ClientResponse response = this.isMultiForm ? (ClientResponse)builder.post(ClientResponse.class, this.part != null ? this.part : "") : (this.isForm ? (ClientResponse)builder.delete(ClientResponse.class, this.form != null ? this.form : "") : (!this.isRaw ? (ClientResponse)builder.delete(ClientResponse.class, (Object)(this.body != null ? this.body.toString() : "")) : (ClientResponse)builder.delete(ClientResponse.class, (Object)(this.rawBody != null ? this.rawBody.toString() : ""))));
                this.setResponse((String)response.getEntity(String.class));
                this.setStatus(response.getStatus());
                break;
            }
        }
    }

    public static enum RequestMethod {
        DELETE,
        GET,
        POST,
        PUT;

    }
}

