/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwodarz.code.log;

import de.alexanderwodarz.code.log.ModStreamListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;

public class ModOutputStream
extends PrintStream {
    private ModStreamListener listener;

    public ModOutputStream(ModStreamListener listener, OutputStream stream) {
        super(stream);
        this.listener = listener;
    }

    public ModOutputStream(ModStreamListener listener) {
        super(new ByteArrayOutputStream());
        this.listener = listener;
    }

    @Override
    public void print(boolean b) {
        this.print(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.print(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.print(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.print(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.print(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.print(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.print(s);
    }

    @Override
    public void print(String s) {
        for (String msg : s.split("\n")) {
            for (String msg2 : msg.split("\r")) {
                this.listener.onMessage(msg2);
            }
        }
    }

    @Override
    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.print("\n");
    }

    @Override
    public void println(boolean x) {
        this.println("" + x);
    }

    @Override
    public void println(char x) {
        this.println("" + x);
    }

    @Override
    public void println(int x) {
        this.println("" + x);
    }

    @Override
    public void println(long x) {
        this.println("" + x);
    }

    @Override
    public void println(float x) {
        this.println(x);
    }

    @Override
    public void println(double x) {
        this.println("" + x);
    }

    @Override
    public void println(char[] x) {
        this.println("" + x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String x) {
        ModOutputStream modOutputStream = this;
        synchronized (modOutputStream) {
            this.print(x + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object x) {
        String s = "" + x;
        ModOutputStream modOutputStream = this;
        synchronized (modOutputStream) {
            this.print(s + "\n");
        }
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    @Override
    public PrintStream append(CharSequence csq) {
        if (csq == null) {
            this.print("null");
        } else {
            this.print(csq.toString());
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.print(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }
}

