/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwodarz.code;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeCore {
    private Date date;
    private TimeZone zone;

    public TimeCore(String format, String timestamp) {
        this.date = new SimpleDateFormat(format).parse(timestamp);
        this.zone = TimeZone.getTimeZone("Europe/Berlin");
    }

    public TimeCore() {
        this(System.currentTimeMillis());
    }

    public TimeCore(long timestamp) {
        this(timestamp, "Europe/Berlin");
    }

    public TimeCore(long timestamp, String timezone) {
        this.date = new Date(timestamp);
        this.zone = TimeZone.getTimeZone(timezone);
    }

    public TimeCore(Date date) {
        this(date, "Europe/Berlin");
    }

    public TimeCore(Date date, String timezone) {
        this.date = date;
        this.zone = TimeZone.getTimeZone(timezone);
    }

    public Date getDate() {
        return this.date;
    }

    public String addYear(int year) {
        return this.modify(true, year, 1);
    }

    public String addMonth(int month) {
        return this.modify(true, month, 2);
    }

    public String addWeek(int week) {
        return this.modify(true, week * 7, 5);
    }

    public String addDay(int day) {
        return this.modify(true, day, 5);
    }

    public String addHour(int hour) {
        return this.modify(true, hour, 10);
    }

    public String addMinute(int minute) {
        return this.modify(true, minute, 12);
    }

    public String addSecond(int second) {
        return this.modify(true, second, 13);
    }

    public String removeYear(int year) {
        return this.modify(false, year, 1);
    }

    public String removeMonth(int month) {
        return this.modify(false, month, 2);
    }

    public String removeWeek(int week) {
        return this.modify(false, week * 7, 5);
    }

    public String removeDay(int day) {
        return this.modify(false, day, 5);
    }

    public String removeHour(int hour) {
        return this.modify(false, hour, 10);
    }

    public String removeMinute(int minute) {
        return this.modify(false, minute, 12);
    }

    public String removeSecond(int second) {
        return this.modify(false, second, 13);
    }

    public void setSecond(int second) {
        this.date.setSeconds(second);
    }

    public void setMinute(int minute) {
        this.date.setMinutes(minute);
    }

    public void setHour(int hour) {
        this.date.setHours(hour);
    }

    public String getLocalString() {
        Calendar calendar = Calendar.getInstance(this.zone);
        calendar.setTime(this.date);
        return calendar.getTime().toLocaleString();
    }

    private String modify(boolean add, int value, int type) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        if (add) {
            calendar.add(type, value);
        } else {
            calendar.add(type, value / -1);
        }
        this.date = calendar.getTime();
        return calendar.getTime().toLocaleString();
    }
}

