/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwodarz.code.web;

import de.alexanderwodarz.code.log.Color;
import de.alexanderwodarz.code.log.Log;
import de.alexanderwodarz.code.model.varible.Varible;
import de.alexanderwodarz.code.model.varible.VaribleMap;
import de.alexanderwodarz.code.web.AbstractWebServer;
import de.alexanderwodarz.code.web.WebServer;
import de.alexanderwodarz.code.web.WebServerType;
import de.alexanderwodarz.code.web.rest.RestHandler;
import de.alexanderwodarz.code.web.rest.RestWebRequest;
import de.alexanderwodarz.code.web.rest.annotation.RestApplication;
import de.alexanderwodarz.code.web.rest.annotation.RestController;
import de.alexanderwodarz.code.web.rest.annotation.RestRequest;
import de.alexanderwodarz.code.web.rest.authentication.AuthenticationFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class WebCore {
    private static Color[] colors = new Color[]{Color.BRIGHT_BLACK, Color.BRIGHT_RED, Color.BRIGHT_GREEN, Color.BRIGHT_YELLOW, Color.BRIGHT_BLUE, Color.BRIGHT_PURPLE, Color.BRIGHT_CYAN, Color.BLACK, Color.RED, Color.GREEN, Color.YELLOW, Color.BLUE, Color.PURPLE, Color.CYAN};
    private static ArrayList<RestWebRequest> requests = new ArrayList();
    private static Class<? extends AuthenticationFilter> filter;

    public static void addWebServer(AbstractWebServer abstractServer) throws FileNotFoundException {
        File notFound;
        if (!abstractServer.getClass().isAnnotationPresent(WebServer.class)) {
            return;
        }
        WebServer webServer = abstractServer.getWebServer();
        if (webServer.type() == WebServerType.WEB && !(notFound = new File(webServer.path() + webServer.notFound())).exists()) {
            throw new FileNotFoundException("Die 404 Seite wurde nicht gefunden(" + notFound.getAbsolutePath() + ")");
        }
        Thread thread = new Thread(abstractServer);
        thread.start();
        abstractServer.setColor(colors[new Random().nextInt(colors.length)].toString());
        Log.log((Object)"Server successfully started", (String)(abstractServer.getColor() + "www-" + webServer.name()), (boolean)false);
    }

    public static Class<? extends AuthenticationFilter> getFilter() {
        return filter;
    }

    public static void start(Class clazz) throws Exception {
        WebCore.start(clazz, new VaribleMap().put().setKey("port").setValue((Object)8080).build());
    }

    public static void start(Class clazz, VaribleMap map) throws Exception {
        if (!clazz.isAnnotationPresent(RestApplication.class)) {
            throw new Exception("RestApplication Annotation not found");
        }
        String packageName = clazz.getPackage().getName();
        if (packageName.length() == 0) {
            throw new Exception("Create a package or move class to a package");
        }
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        filter = reflections.getSubTypesOf(AuthenticationFilter.class).stream().findFirst().orElse(null);
        for (Class aClass : reflections.getTypesAnnotatedWith(RestController.class)) {
            for (Method declaredMethod : aClass.getDeclaredMethods()) {
                if (!declaredMethod.isAnnotationPresent(RestRequest.class)) continue;
                RestWebRequest request = new RestWebRequest();
                request.setRequest(declaredMethod.getAnnotation(RestRequest.class));
                request.setController(aClass.getAnnotation(RestController.class));
                request.setMethod(declaredMethod);
                requests.add(request);
            }
        }
        ServerSocket serverSocket = WebCore.getSocket(map);
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        RestHandler handler = new RestHandler(serverSocket.accept());
                        Thread t = new Thread(handler);
                        t.start();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        thread.start();
    }

    private static ServerSocket getSocket(VaribleMap map) throws IOException {
        AtomicInteger port = new AtomicInteger(8080);
        map.getVaribles().stream().filter(v -> v.getKey().equals("port")).findFirst().ifPresent(v -> port.set(Integer.parseInt(v.getValue().toString())));
        AtomicBoolean https = new AtomicBoolean(false);
        map.getVaribles().stream().filter(v -> v.getKey().equals("https")).findFirst().ifPresent(b -> https.set(Boolean.parseBoolean(b.getValue().toString())));
        Varible location = map.getVaribles().stream().filter(v -> v.getKey().equals("location")).findFirst().orElse(null);
        Varible password = map.getVaribles().stream().filter(v -> v.getKey().equals("password")).findFirst().orElse(null);
        if (https.get() && location != null && password != null) {
            try {
                return WebCore.getServerSocket(port.get(), location.getValue().toString(), password.getValue().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ServerSocket(port.get());
    }

    private static ServerSocket getServerSocket(int port, String location, String password) throws Exception {
        Path keyStorePath = Path.of(location, new String[0]);
        char[] keyStorePassword = password.toCharArray();
        ServerSocket serverSocket = WebCore.getSslContext(keyStorePath, keyStorePassword).getServerSocketFactory().createServerSocket(port);
        Arrays.fill(keyStorePassword, '0');
        return serverSocket;
    }

    private static SSLContext getSslContext(Path keyStorePath, char[] keyStorePass) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(new FileInputStream(keyStorePath.toFile()), keyStorePass);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, keyStorePass);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
        return sslContext;
    }

    public static ArrayList<RestWebRequest> getRequests() {
        return requests;
    }
}

