/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwodarz.code.web;

import de.alexanderwodarz.code.log.Log;
import de.alexanderwodarz.code.web.HttpConnection;
import de.alexanderwodarz.code.web.WebServer;
import de.alexanderwodarz.code.web.WebServerListener;
import de.alexanderwodarz.code.web.WebServerType;
import java.io.FileInputStream;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

@WebServer(port=80, name="default", path="./web", verbose=false)
public abstract class AbstractWebServer
extends Thread
implements WebServerListener {
    private String color;

    public WebServer getWebServer() {
        return this.getClass().getAnnotation(WebServer.class);
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public void run() {
        WebServer server = this.getClass().getAnnotation(WebServer.class);
        try {
            ServerSocket serverSocket = server.https() ? this.getServerSocket(server.port(), server.keyStoreLocation(), server.keyStorePassword()) : new ServerSocket(server.port());
            while (true) {
                HttpConnection connection = new HttpConnection(serverSocket.accept(), server.path(), server.verbose(), this);
                Thread thread = new Thread(connection);
                thread.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private ServerSocket getServerSocket(int port, String location, String password) throws Exception {
        Path keyStorePath = Path.of(location, new String[0]);
        char[] keyStorePassword = password.toCharArray();
        ServerSocket serverSocket = this.getSslContext(keyStorePath, keyStorePassword).getServerSocketFactory().createServerSocket(port);
        Arrays.fill(keyStorePassword, '0');
        return serverSocket;
    }

    private SSLContext getSslContext(Path keyStorePath, char[] keyStorePass) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(new FileInputStream(keyStorePath.toFile()), keyStorePass);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, keyStorePass);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
        return sslContext;
    }

    public void log(Object log) {
        this.log(log, false);
    }

    public void log(Object log, boolean error) {
        Log.log((Object)log, (String)(this.getColor() + "www-" + this.getWebServer().name()), (boolean)error);
    }

    public String applyRule(String requested) {
        if (this.getWebServer().type() == WebServerType.REST) {
            return requested;
        }
        if (requested.endsWith("/")) {
            return requested + "index.html";
        }
        return requested;
    }
}

