/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwodarz.code.web.rest;

import de.alexanderwodarz.code.log.Level;
import de.alexanderwodarz.code.log.Log;
import de.alexanderwodarz.code.web.WebCore;
import de.alexanderwodarz.code.web.rest.FindPathResponse;
import de.alexanderwodarz.code.web.rest.RequestData;
import de.alexanderwodarz.code.web.rest.ResponseData;
import de.alexanderwodarz.code.web.rest.RestWebRequest;
import de.alexanderwodarz.code.web.rest.annotation.PathVariable;
import de.alexanderwodarz.code.web.rest.annotation.QueryParam;
import de.alexanderwodarz.code.web.rest.annotation.RequestBody;
import de.alexanderwodarz.code.web.rest.authentication.AuthenticationFilterResponse;
import de.alexanderwodarz.code.web.rest.authentication.AuthenticationManager;
import de.alexanderwodarz.code.web.rest.authentication.CorsResponse;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RestHandler
extends Thread {
    private Socket connect;

    public RestHandler(Socket connect) {
        this.connect = connect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PrintWriter out = null;
        FilterOutputStream dataOut = null;
        String fileRequested = null;
        RequestData data = new RequestData();
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.connect.getInputStream()));
            String line = br.readLine();
            boolean first = true;
            while (line.length() != 0) {
                if (first) {
                    data.setMethod(line.split(" ")[0]);
                    data.setPath(line.split(" ")[1]);
                    data.setScheme(line.split(" ")[2]);
                    first = false;
                }
                if (line.contains(":")) {
                    headers.put(line.split(":")[0].toLowerCase(Locale.ROOT), line.split(":")[1].trim());
                }
                line = br.readLine();
            }
            Object body = "";
            while (br.ready()) {
                body = (String)body + (char)br.read();
            }
            if (headers.size() == 0) {
                return;
            }
            data.setHeaders(headers);
            data.setBody((String)body);
            data.setSocket(this.connect);
            if (data.getPath().contains("?")) {
                String queryString = data.getPath().split("\\?")[1];
                for (String query : queryString.split("&")) {
                    String[] split = query.split("=");
                    String key = split[0];
                    String value = split.length > 1 ? split[1] : "";
                    data.getQueries().put(key, value);
                }
                data.setPath(data.getPath().split("\\?")[0]);
            }
            out = new PrintWriter(this.connect.getOutputStream(), true, StandardCharsets.UTF_8);
            dataOut = new BufferedOutputStream(this.connect.getOutputStream());
            List<String> responseHeaders = new ArrayList<String>();
            RestWebRequest req = this.findRequest(data);
            if (WebCore.getFilter() != null) {
                AuthenticationFilterResponse response;
                Method method;
                if (data.getMethod().equalsIgnoreCase("options") && (method = (Method)Arrays.stream(WebCore.getFilter().getMethods()).filter(m -> m.getName().equalsIgnoreCase("doCors")).findFirst().orElse(null)) != null) {
                    CorsResponse response2 = (CorsResponse)method.invoke(null, data);
                    this.print("", "", (BufferedOutputStream)dataOut, out, 200, response2.getHeaders());
                    return;
                }
                data.setLevel(req.getRequest().level());
                data.setOriginalPath(req.getRequest().path());
                method = Arrays.stream(WebCore.getFilter().getMethods()).filter(m -> m.getName().equalsIgnoreCase("doFilter")).findFirst().orElse(null);
                if (method != null && !(response = (AuthenticationFilterResponse)method.invoke(null, data)).isAccess()) {
                    this.print(response.getError().toString(), "application/json", (BufferedOutputStream)dataOut, out, response.getCode());
                    return;
                }
                Method cors = Arrays.stream(WebCore.getFilter().getMethods()).filter(m -> m.getName().equalsIgnoreCase("doCors")).findFirst().orElse(null);
                if (cors != null) {
                    CorsResponse response3 = (CorsResponse)cors.invoke(null, data);
                    responseHeaders = response3.getHeaders();
                }
            }
            if (req == null) {
                this.print("{\"error\":\"not found\"}", "application/json", (BufferedOutputStream)dataOut, out, 404);
            } else {
                Object[] o = new Object[req.getMethod().getParameterCount()];
                for (int i = 0; i < req.getMethod().getParameters().length; ++i) {
                    Parameter parameter = req.getMethod().getParameters()[i];
                    if (parameter.isAnnotationPresent(PathVariable.class)) {
                        PathVariable variable = parameter.getAnnotation(PathVariable.class);
                        String var = req.getFindPathResponse().getVariables().get("{" + variable.value() + "}");
                        o[i] = parameter.getType().equals(Optional.class) ? Optional.of(var) : var;
                    }
                    if (parameter.isAnnotationPresent(QueryParam.class)) {
                        QueryParam param = parameter.getAnnotation(QueryParam.class);
                        String value = req.getFindPathResponse().getQueries().get(param.value());
                        o[i] = value == null ? Optional.empty() : Optional.of(value);
                    }
                    if (parameter.isAnnotationPresent(RequestBody.class)) {
                        Class<?> type = parameter.getType();
                        o[i] = type.equals(JSONObject.class) ? new JSONObject((String)body) : (type.equals(JSONArray.class) ? new JSONArray((String)body) : (type.equals(Integer.class) ? Integer.valueOf(Integer.parseInt((String)body)) : (type.equals(Double.class) ? Double.valueOf(Double.parseDouble((String)body)) : (type.equals(Long.class) ? Long.valueOf(Long.parseLong((String)body)) : body))));
                    }
                    if (parameter.getType() != RequestData.class) continue;
                    o[i] = data;
                }
                ResponseData response = req.getMethod().getParameterCount() > 0 ? (ResponseData)req.getMethod().invoke(null, o) : (ResponseData)req.getMethod().invoke(null, new Object[0]);
                AuthenticationManager.setAuthentication(null);
                if (response.getFile() == null) {
                    this.print(response.getBody(), req.getProduces(), (BufferedOutputStream)dataOut, out, response.getCode(), responseHeaders);
                } else {
                    this.printFile(response.getFile(), req.getProduces(), (BufferedOutputStream)dataOut, out, response.getCode(), responseHeaders);
                }
            }
        }
        catch (IllegalArgumentException | JSONException e) {
            this.print("{\"error\":\"invalid argument\"}", "application/json", (BufferedOutputStream)dataOut, out, 400);
        }
        catch (InvocationTargetException e) {
            ResponseData response;
            Log.log((Object)e.getMessage(), (Level)Level.ERROR);
            data.setMethod("GET");
            data.setPath("/error/500");
            RestWebRequest req = this.findRequest(data);
            String body = "{\"error\":\"internal server error\"}";
            int code = 500;
            if (req != null && (response = this.trigger(req, data)) != null) {
                body = response.getBody();
                code = response.getCode();
            }
            this.print(body, "application/json", (BufferedOutputStream)dataOut, out, code);
        }
        catch (FileNotFoundException fnfe) {
            try {
                this.fileNotFound((BufferedOutputStream)dataOut, out, fileRequested, "");
            }
            catch (IOException ioe) {
                fnfe.printStackTrace();
            }
        }
        catch (IllegalAccessException | NullPointerException e) {
        }
        catch (IOException ioe) {
            System.err.println("Server error : " + ioe);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (dataOut != null) {
                    dataOut.close();
                }
                this.connect.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ResponseData trigger(RestWebRequest req, RequestData data) {
        Object[] o = new Object[req.getMethod().getParameterCount()];
        for (int i = 0; i < req.getMethod().getParameters().length; ++i) {
            Parameter parameter = req.getMethod().getParameters()[i];
            if (parameter.isAnnotationPresent(PathVariable.class)) {
                PathVariable variable = parameter.getAnnotation(PathVariable.class);
                o[i] = req.getFindPathResponse().getVariables().get("{" + variable.value() + "}");
            }
            if (parameter.getType() != RequestData.class) continue;
            o[i] = data;
        }
        try {
            return (ResponseData)req.getMethod().invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NullPointerException | InvocationTargetException ex) {
            return null;
        }
    }

    public RestWebRequest findRequest(RequestData data) {
        RestWebRequest req = null;
        Object requestedPath = data.getPath();
        if (!((String)requestedPath).endsWith("/")) {
            requestedPath = (String)requestedPath + "/";
        }
        for (RestWebRequest request : WebCore.getRequests()) {
            String path;
            FindPathResponse findPathResponse;
            if (!request.getRequest().method().equalsIgnoreCase(data.getMethod()) || !(findPathResponse = this.testPath((String)requestedPath, path = this.formatPath(request))).isFound()) continue;
            findPathResponse.setQueries(data.getQueries());
            req = request;
            req.setFindPathResponse(findPathResponse);
            if (!findPathResponse.isExactMatch()) continue;
            break;
        }
        return req;
    }

    public FindPathResponse testPath(String requested, String toTest) {
        int i;
        FindPathResponse response = new FindPathResponse();
        if (requested.split("/").length != toTest.split("/").length) {
            return response;
        }
        String withRegex = toTest.replaceAll("\\{.*?\\}", "(.*)");
        if (!requested.matches(withRegex)) {
            return response;
        }
        HashMap<Integer, String> variables = new HashMap<Integer, String>();
        HashMap<String, String> entries = new HashMap<String, String>();
        for (i = 0; i < toTest.split("/").length; ++i) {
            if (!toTest.split("/")[i].matches("\\{.*\\}")) continue;
            variables.put(i, toTest.split("/")[i]);
        }
        for (i = 0; i < requested.split("/").length; ++i) {
            if (!variables.containsKey(i)) continue;
            entries.put((String)variables.get(i), requested.split("/")[i]);
        }
        response.setFound(true);
        response.setVariables(entries);
        if (entries.size() == 0) {
            response.setExactMatch(true);
        }
        return response;
    }

    private void print(String content, String contentType, BufferedOutputStream dataOut, PrintWriter out, int status) {
        this.print(content, contentType, dataOut, out, status, null);
    }

    private void print(String content, String contentType, BufferedOutputStream dataOut, PrintWriter out, int status, List<String> headers) {
        int fileLength = 0;
        byte[] fileData = null;
        boolean image = false;
        if (((String)contentType).contains("html") || ((String)contentType).contains("javascript")) {
            fileData = content.getBytes(StandardCharsets.UTF_8);
            fileLength = content.getBytes().length;
        } else if (((String)contentType).equals("image/png")) {
            image = true;
        } else {
            fileData = content.getBytes(StandardCharsets.UTF_8);
            fileLength = fileData.length;
        }
        if (!((String)contentType).toLowerCase().endsWith("; charset=utf-8")) {
            contentType = (String)contentType + "; charset=UTF-8";
        }
        out.println("HTTP/1.1 " + status);
        out.println("Server: java-webcore");
        out.println("Date: " + new Date());
        out.println("Content-type: " + (String)contentType);
        out.println("Content-Length: " + fileLength);
        out.println("Connection: Keep-Alive");
        if (headers != null && headers.size() > 0) {
            for (String header : headers) {
                out.println(header);
            }
        }
        out.println();
        out.flush();
        try {
            dataOut.write(fileData, 0, fileLength);
            dataOut.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printFile(File file, String contentType, BufferedOutputStream dataOut, PrintWriter out, int status, List<String> headers) {
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        out.println("HTTP/1.1 " + status);
        out.println("Server: java-webcore");
        out.println("Date: " + new Date());
        out.println("Content-type: " + contentType);
        out.println("Content-Length: " + bytes.length);
        out.println("Connection: Keep-Alive");
        if (headers != null && headers.size() > 0) {
            for (String header : headers) {
                out.println(header);
            }
        }
        out.println();
        out.flush();
        dataOut.write(bytes);
        dataOut.write("\r\n\r\n".getBytes());
        dataOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFileData(File file, int fileLength) throws IOException {
        byte[] fileData = new byte[fileLength];
        try (FileInputStream fileIn = null;){
            fileIn = new FileInputStream(file);
            fileIn.read(fileData);
        }
        return fileData;
    }

    private String getContentType(String fileRequested) {
        String what;
        String result = "text/plain";
        switch (what = fileRequested.split("\\.")[fileRequested.split("\\.").length - 1]) {
            case "html": {
                result = "text/html; charset=UTF-8";
                break;
            }
            case "js": {
                result = "text/javascript; charset=UTF-8";
                break;
            }
            case "css": {
                result = "text/css; charset=UTF-8";
                break;
            }
            case "png": {
                result = "image/png";
                break;
            }
            case "ico": {
                result = "image/vnd.microsoft.icon; charset=UTF-8";
            }
        }
        return result;
    }

    private String formatPath(RestWebRequest request) {
        Object result = "";
        if (request.getController().path().length() > 0) {
            if (!request.getController().path().startsWith("/")) {
                result = "/";
            }
            result = (String)result + request.getController().path();
        }
        if (request.getRequest().path().length() > 0) {
            if (((String)result).endsWith("/") && request.getRequest().path().startsWith("/")) {
                result = ((String)result).substring(0, ((String)result).length() - 1);
            }
            result = (String)result + request.getRequest().path();
        }
        if (!((String)result).endsWith("/")) {
            result = (String)result + "/";
        }
        return result;
    }

    private void fileNotFound(BufferedOutputStream dataOut, PrintWriter out, String fileRequested, String method) throws IOException {
        String file = "404 Not found";
        String content = "text/html";
        this.print(file, content, dataOut, out, 404);
    }

    private void locked(Socket socket, String path, String method, BufferedOutputStream dataOut, PrintWriter out) {
        this.print("Security issue detected, request denied", "text/html", dataOut, out, 423);
    }
}

