/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwodarz.code.web;

import de.alexanderwodarz.code.web.AbstractWebServer;
import de.alexanderwodarz.code.web.WebServerType;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.imageio.ImageIO;

public class HttpConnection
implements Runnable {
    private File WEB_ROOT;
    private boolean verbose;
    private Socket connect;
    private AbstractWebServer webServer;

    public HttpConnection(Socket c, String root, boolean verbose, AbstractWebServer webServer) {
        this.connect = c;
        this.WEB_ROOT = new File(root);
        this.verbose = verbose;
        this.webServer = webServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader in = null;
        PrintWriter out = null;
        FilterOutputStream dataOut = null;
        String fileRequested = null;
        try {
            in = new BufferedReader(new InputStreamReader(this.connect.getInputStream()));
            out = new PrintWriter(this.connect.getOutputStream(), true, StandardCharsets.UTF_8);
            dataOut = new BufferedOutputStream(this.connect.getOutputStream());
            String input = in.readLine();
            if (input == null) {
                return;
            }
            String method = input.split(" ")[0];
            fileRequested = this.webServer.applyRule(input.split(" ")[1]);
            System.out.println(fileRequested);
            this.webServer.request(this.connect, fileRequested, method);
            if (fileRequested.contains("..")) {
                this.locked(this.connect, fileRequested, method, (BufferedOutputStream)dataOut, out);
                return;
            }
            if (this.webServer.getWebServer().type().equals((Object)WebServerType.WEB)) {
                if (this.isAsset(fileRequested)) {
                    this.showAsset(fileRequested, method, (BufferedOutputStream)dataOut, out);
                } else {
                    this.fileNotFound(this.connect, (BufferedOutputStream)dataOut, out, fileRequested, method);
                }
            } else {
                System.out.println(fileRequested);
            }
        }
        catch (FileNotFoundException fnfe) {
            try {
                this.fileNotFound(this.connect, (BufferedOutputStream)dataOut, out, fileRequested, "");
            }
            catch (IOException ioe) {
                this.webServer.gotException(ioe);
            }
        }
        catch (IOException ioe) {
            System.err.println("Server error : " + ioe);
        }
        finally {
            try {
                in.close();
                out.close();
                dataOut.close();
                this.connect.close();
            }
            catch (Exception e) {
                this.webServer.gotException(e);
            }
            if (this.verbose) {
                System.out.println("Connection closed.\n");
            }
        }
    }

    private void showAsset(String path, String method, BufferedOutputStream dataOut, PrintWriter out) throws IOException {
        File file = new File(this.WEB_ROOT, path);
        String content = this.getContentType(path);
        if (method.equals("GET")) {
            this.print(file, new String(this.readFileData(file, (int)file.length())), content, dataOut, out, 200);
        }
        if (this.verbose) {
            System.out.println("File " + path + " of type " + content + " returned");
        }
    }

    private void print(File file, String content, String contentType, BufferedOutputStream dataOut, PrintWriter out, int status) {
        int fileLength = 0;
        byte[] fileData = null;
        boolean image = false;
        if (contentType.contains("html") || contentType.contains("javascript")) {
            fileData = content.getBytes(StandardCharsets.UTF_8);
            fileLength = content.getBytes().length;
        } else if (contentType.equals("image/png")) {
            image = true;
        } else {
            fileData = content.getBytes(StandardCharsets.ISO_8859_1);
            fileLength = fileData.length;
        }
        out.println("HTTP/1.1 " + status);
        out.println("Server: Java HTTP von Alex lol");
        out.println("Date: " + new Date());
        out.println("Content-type: " + contentType);
        out.println("Connection: Keep-Alive");
        out.println();
        out.flush();
        if (image) {
            BufferedImage img = ImageIO.read(file);
            ImageIO.write((RenderedImage)img, contentType.split("/")[1], dataOut);
            return;
        }
        try {
            dataOut.write(fileData, 0, fileLength);
            dataOut.flush();
        }
        catch (Exception e) {
            this.webServer.gotException(e);
        }
    }

    private boolean isAsset(String path) {
        File file = new File(this.WEB_ROOT + path);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFileData(File file, int fileLength) throws IOException {
        byte[] fileData = new byte[fileLength];
        try (FileInputStream fileIn = null;){
            fileIn = new FileInputStream(file);
            fileIn.read(fileData);
        }
        return fileData;
    }

    private String getContentType(String fileRequested) {
        String what;
        String result = "text/plain";
        switch (what = fileRequested.split("\\.")[fileRequested.split("\\.").length - 1]) {
            case "html": {
                result = "text/html; charset=UTF-8";
                break;
            }
            case "js": {
                result = "text/javascript; charset=UTF-8";
                break;
            }
            case "css": {
                result = "text/css; charset=UTF-8";
                break;
            }
            case "png": {
                result = "image/png";
                break;
            }
            case "ico": {
                result = "image/vnd.microsoft.icon; charset=UTF-8";
            }
        }
        return result;
    }

    private void fileNotFound(Socket connect, BufferedOutputStream dataOut, PrintWriter out, String fileRequested, String method) throws IOException {
        this.webServer.notFound(connect, fileRequested, method);
        File file = new File(this.WEB_ROOT + this.webServer.getWebServer().notFound());
        String content = "text/html";
        this.print(file, new String(this.readFileData(file, (int)file.length())), content, dataOut, out, 404);
    }

    private void locked(Socket socket, String path, String method, BufferedOutputStream dataOut, PrintWriter out) {
        this.webServer.securityIssue(socket, path, method, 423);
        this.print(null, "Security issue detected, request denied", "text/html", dataOut, out, 423);
    }
}

