/*
 * Decompiled with CFR 0.152.
 */
package de.alexanderwodarz.code.cloudflare.zone.dns;

import de.alexanderwodarz.code.cloudflare.zone.Zone;
import org.json.JSONObject;

public class DnsRecord {
    private Zone zone;
    private JSONObject obj;

    public String getId() {
        return this.getObj().getString("id");
    }

    public String getZoneID() {
        return this.getObj().getString("zone_id");
    }

    public String getZoneName() {
        return this.getObj().getString("zone_name");
    }

    public String getName() {
        return this.getObj().getString("name");
    }

    public String getType() {
        return this.getObj().getString("type");
    }

    public String getContent() {
        return this.getObj().getString("content");
    }

    public boolean isProxiable() {
        return this.getObj().getBoolean("proxiable");
    }

    public boolean isProxied() {
        return this.getObj().getBoolean("proxied");
    }

    public int getTtl() {
        return this.getObj().getInt("ttl");
    }

    public boolean isLocked() {
        return this.getObj().getBoolean("locked");
    }

    public boolean isAutoAdded() {
        return this.getObj().getJSONObject("meta").getBoolean("auto_added");
    }

    public boolean isManagedByApps() {
        return this.getObj().getJSONObject("meta").getBoolean("managed_by_apps");
    }

    public boolean isManagedByArgoTunnel() {
        return this.getObj().getJSONObject("meta").getBoolean("managed_by_argo_tunnel");
    }

    public String getSource() {
        return this.getObj().getJSONObject("meta").getString("soure");
    }

    public String getCreated() {
        return this.getObj().getString("created_on");
    }

    public String getModified() {
        return this.getObj().getString("modified_on");
    }

    public void delete() {
        this.zone.deleteRecord(this.getId());
    }

    public DnsRecord(Zone zone, JSONObject obj) {
        this.zone = zone;
        this.obj = obj;
    }

    public Zone getZone() {
        return this.zone;
    }

    public JSONObject getObj() {
        return this.obj;
    }
}

